
<?php $__env->startSection('title'); ?> Allocataires <?php $__env->stopSection(); ?>
<?php $__env->startSection('title_card'); ?> Allocataires sans Aides sociales à l'enfant - avec enfants pouvant en bénéficier <?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="card">
        <?php if(Session::has('message')): ?>
            <div class="alert alert-warning"><?php echo Session::get('message'); ?></div>
        <?php endif; ?>

        <?php if($errors): ?>
            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class='bg-danger alert'><?php echo $error; ?></div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <?php endif; ?>

        <?php if(Session::has('success')): ?>
            <div class="alert alert-success"><?php echo \Session::get('success'); ?></div>
        <?php endif; ?>

        <?php echo e(html()->form('POST', url('/set_statut_aae'))->open()); ?> 
            <input type="hidden" name="list_check" id='list_check' value="">


        <div class="card-header bg-info">
            <h2 class="card-title"><?php echo e($title); ?></h2>
        </div>
        <div class="card-body">
            <table id="_table" style="background-color:white;width:100%" class="table table-bordered table-hover">
                <thead>
                    <tr>
                        <th width="1px" nowrap>Sel.
                            <input id="box_all" class="form-control" name="sel" type="checkbox" value="1" onchange='select_all();'>
                        </th>
                        <th width='1px'>Id</th>
                        <th width='1px'>Dossier<br/>Famille</th>
                        <th width='1px'>CPSWF</th>
                        <th >Nom</th>
                        <th >Enfants bénéficiaires</th>
                        <th width='1px'>Date de naissance</th>
                        <th >Conjoint</th>
                        <th width='1px'>NbEnfants<br/>Tot/AideEnf.</th>
                        <th width='1px'>Aides</th>
                    </tr>
                </thead>

                <tbody>
                    <?php $__currentLoopData = $allocataires; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $allocataire): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td style='margin:0px'>
                                <input id="box_<?php echo $allocataire->id; ?>" class="form-control" name="box_<?php echo $allocataire->id; ?>" type="checkbox" value="1" onchange='calcul_select();'>
                            </td>
                            <td  >
                                <a class="btn bg-secondary" href="<?php echo url('allocataires/'.$allocataire->id); ?>"><?php echo $allocataire->IdPAD; ?></a>
                            </td>
                            <td>
                                <?php if($allocataire->id_famille): ?>
                                    <a class="btn bg-primary" href="<?php echo url('familles/'.$allocataire->id_famille); ?>"><?php echo $allocataire->IdPADFamille; ?></a>
                                <?php else: ?>
                                    <span class="badge badge-info right"> Aucun</span>
                                <?php endif; ?>
                            </td>
                            <td><?php echo $allocataire->IdCPSWFPAD; ?></td>
                            <td><?php echo $allocataire->nom_complet2; ?>

                                <?php if($allocataire->statut_dossier!="ACT"): ?>
                                    <span class="right badge badge-danger">Inactif</span>    
                                <?php endif; ?>
                            </td>
                            <td><?php echo $allocataire->getEnfantsListe(); ?></td>
                            <td align="center"><?php echo $allocataire->date_naissance; ?></td>
                            <td><?php echo $allocataire->NomConjoint; ?></td>
                            <td align="center"><?php echo $allocataire->NbEnfants."/".$allocataire->NbEnfantsAAE; ?></td>
                            <td align="center"><?php echo $allocataire->types_aides; ?></td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
        <div class="card-footer">
            <?php if(count($t_lignes)>0): ?>
                <div class='form-group row'>
                    <div class="col-md-12">
                        <button type="submit" class="btn btn-success"
                            onclick='if(!confirm("Voulez-vous vraiment mettre à jour le statut des Allocataires selectionnés ?")) return false;'>Mrettre à jour le statut</a>
                    </div>
                </div>
            <?php endif; ?>
        </div>
        <?php echo e(html()->form()->close()); ?>

    </div>
<?php $__env->stopSection(); ?>


<?php $__env->startSection('scripts'); ?>

    <script>
        function select_all() {
            var lst="";
            var t_lignes=<?php echo json_encode($t_lignes); ?>;
            var check=$('#box_all').prop('checked');
            if(check) check="checked";
            for(var i=0;i<t_lignes.length;i++) {
                $('#box_'+t_lignes[i]).prop("checked",check);
                var checkbox=$('#box_'+t_lignes[i]).prop('checked');
                if(checkbox) {
                    lst+=((lst=="")?"":";")+t_lignes[i];
                }
            }
            set_list(lst);
        }

        function calcul_select() {
            var t_lignes=<?php echo json_encode($t_lignes); ?>;
            var lst="";
            for(var i=0;i<t_lignes.length;i++) {
                var check=$('#box_'+t_lignes[i]).prop('checked');
                if(check) {
                    lst+=((lst=="")?"":";")+t_lignes[i];
                }
            }
            set_list(lst);
        }

        function set_list(lst="") {
            $('#list_check').val(lst);

            var nt_lst=lst.split(";");
            var nb = nt_lst.length;
        }

        function init_list() {
            var lst=$('#list_check').val();
            var nt_lst=lst.split(";");
            for(var i=0;i<nt_lst.length;i++) {
                $('#box_'+nt_lst[i]).prop('checked',true);
            }
            set_list(lst);
        }

        init_list();
    </script>

<script>
    $(function () {
            var table =$('#_table').dataTable( {
                bAutoWidth: false,bPaginate: false,bInfo: true,
                bFilter: true,deferRender:    false,
                scrollCollapse: false,scroller:false,iDisplayLength:10,
                oLanguage: {
                    "sZeroRecords": "Aucune ligne",
                    "sInfo": "Affichage de _START_ &agrave; _END_ sur _TOTAL_ lignes",
                    "sInfoEmpty": "Showing 0 to 0 of 0 records",
                    "sInfoFiltered": "(sur un total de _MAX_ lignes)",
                    "oPaginate": {"sPrevious": "Pr&eacute;c&eacute;dente","sNext": "Suivante"
                        ,"sFirst": "Premi&egrave;re","sLast": "Derni&egrave;re"},
                        "sSearch":"Chercher ",
                    buttons: {
                        colvis: 'Colonnes',
                        copy: 'Copier',
                        copyTitle: 'Ajouté au presse-papiers',
                        copyKeys: 'Appuyez sur <i>ctrl</i> ou <i>\u2318</i> + <i>C</i> pour copier les données du tableau à votre presse-papiers. <br><br>Pour annuler, cliquez sur ce message ou appuyez sur Echap.',
                        copySuccess: {
                            _: '%d lignes copiées',
                            1: '1 ligne copiée'
                            }
                        }
                    },
                dom: "<'row'<'col-sm-1 text-left'f><'col-sm-4'><'col-sm-6 text-right'>>" +
                    "<'row'<'col-sm-12't>>B" +"<'row'<'col-sm-5'i><'col-sm-7'p>>",
                    
                "buttons": ["copy", "excel", "colvis"],
                "columnDefs": [
                    { "targets": [ 0], "orderable": false,"searchable": false, "visible": true},
                ]

            });
    });
  </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.dash', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/sigal/resources/views/aides/index_set_statut.blade.php ENDPATH**/ ?>