luc.launay@gmail.com



<?php $__env->startSection('title'); ?> Allocataires <?php $__env->stopSection(); ?>
<?php $__env->startSection('title_card'); ?> Allocataires <?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <?php if(Session::has('message')): ?>
        <div class="alert alert-warning"><?php echo Session::get('message'); ?></div>
    <?php endif; ?>

    <?php if($errors): ?>
        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class='bg-danger alert'><?php echo $error; ?></div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    <?php endif; ?>

    <?php if(Session::has('success')): ?>
        <div class="alert alert-success"><?php echo \Session::get('success'); ?></div>
    <?php endif; ?>


    <div class="card">
        <div class="card-header bg-info">
            <h2 class="card-title"><?php echo e($title); ?></h2>
        </div>
        <div class="card-body">
            <div class="row" style="padding-bottom:30px">
                <div class='col-md-2'>
                    <?php echo html()->label('Ile','select_ile'); ?>

                    <?php echo html()->select('select_ile',App\Models\MyApp::ILES,isset($ile)?$ile:"")->placeholder('Toutes')
                        ->attributes(['class' => 'form-control','id' => 'select_ile']); ?>

                </div>
                <div class='col-md-4'>
                    <?php echo html()->label('Aide','select_aide'); ?>

                    <?php echo html()->select('select_aide',App\Models\MyApp::TYPES_AIDES,isset($aide)?$aide:"")->placeholder('Toutes')
                        ->attributes(['class' => 'form-control','id' => 'select_aide']); ?>

                </div>
                <div class='col-md-4'>
                    <?php echo html()->label('Activité','select_actif'); ?>

                    <?php echo html()->select('select_actif',["ACT"=>"Actifs","INA"=>"Inactifs"],isset($activite)?$activite:"")->placeholder('Toutes')
                        ->attributes(['class' => 'form-control','id' => 'select_actif']); ?>

                </div>
                <?php if($user->can("ALO_AJO") || $user->HasRole("ADMINISTRATEUR")): ?>
                    <div class="col-2">
                        <?php echo html()->label( '&nbsp;',''); ?><br/>
                        <?php echo html()->a(url('allocataires/create'),"Ajouter un allocataire")->attributes(['class' => 'btn btn-success']); ?>

                    </div>
                <?php endif; ?>
            </div>  
            <table id="_table" style="background-color:white;width:100%" class="table table-bordered table-hover">
                <thead>
                    <tr>
                        <th width='1px'>Id</th>
                        <th width='1px'>Famille</th>
                        <th width='1px'>CPSWF</th>
                        <th >Nom</th>
                        <th width='1px'>Naissance</th>
                        <th width='1px'>Village</th>
                        <th>Conjoint</th>
                        <th>Enfants</th>
                        <th width='1px'>NbEnfants</th>
                        <th width='1px'>Ressources</th>
                        <th width='1px'>Statut</th>
                        <th width='1px'>Mise à jour</th>

                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $allocataires; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $allocataire): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td  >
                                <a class="btn btn-sm bg-secondary" href="<?php echo url('allocataires/'.$allocataire->id); ?>"><?php echo $allocataire->IdPAD; ?></a>
                                <?php if($allocataire->controle): ?><br\>
                                    <span title="A Contrôler" class="right badge badge-danger">CTL</span>
                                <?php endif; ?>

                            </td>
                            <td align="center">
                                <?php if($allocataire->id_famille): ?>
                                    <a class="btn btn-sm bg-primary" href="<?php echo url('familles/'.$allocataire->id_famille); ?>"><?php echo $allocataire->IdPADFamille; ?></a>
                                <?php else: ?>
                                    <span class="badge badge-info right"> Aucun</span>
                                <?php endif; ?>
                                <?php if($allocataire->hasAide('AAE')&&(!$allocataire->IsTitulaire)): ?>
                                <span class="badge badge-danger right">Non titulaire avec<br/>Aide à l'enfant</span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <?php echo $allocataire->IdCPSWFPAD; ?>

                            </td>
                            <td><?php echo $allocataire->nom_complet2; ?>

                                <?php if($allocataire->statut_dossier!="ACT"): ?>
                                    <span class="right badge badge-danger">Inactif</span>    
                                <?php endif; ?>
                            </td>
                            <td align="center"><?php echo $allocataire->date_naissance; ?></td>
                            <td><?php echo $allocataire->VillageNom."-".$allocataire->Ile; ?></td>
                            <td><?php echo $allocataire->ConjointNomComplet; ?></td>
                            <td><?php echo $allocataire->getEnfantsListe(); ?></td>
                            <td align="center"><?php echo $allocataire->getNbEnfantsLESS(); ?></td>
                            <td align="center"><?php echo $allocataire->MontantRessources; ?></td>
                            <td align="center"><?php echo $allocataire->statut; ?></td>
                            <td align="center" title="Création le <?php echo $allocataire->CreatedAt; ?>"><?php echo $allocataire->UpdatedAt; ?></td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
    </div>
<?php $__env->stopSection(); ?>


<?php $__env->startSection('scripts'); ?>
<script>
    $(function () {
        $('#select_aide').change(function() {select_filtre();});
        $('#select_ile').change(function() {select_filtre();});
        $('#select_actif').change(function() {select_filtre();});
        
        function select_filtre() {
            var aide=$('#select_aide').val();
            if(aide=="") aide=0;
            var ile=$('#select_ile').val();
            if(ile=="") ile=0;
            var actif=$('#select_actif').val();
            if(actif=="") actif=0;
            var url="<?php echo url('allocataires_filtre'); ?>"+"/"+ile+"/"+aide+"/"+actif;
            location.href=url;
        }
    });
</script>


<script>
  $(function () {
    $("#_table").DataTable({
      "paging": true,
      "lengthChange": false,
      "searching": true,
      "ordering": true,
      "info": true,
      "responsive": false,
      "autoWidth": true,
      "fixedHeader": true,
       oLanguage: {
            "sZeroRecords": "Aucune ligne",
            "sInfo": "Affichage de _START_ &agrave; _END_ sur _TOTAL_ lignes",
            "sInfoEmpty": "Showing 0 to 0 of 0 records",
            "sInfoFiltered": "(sur un total de _MAX_ lignes)",
            "oPaginate": {"sPrevious": "Pr&eacute;c&eacute;dente","sNext": "Suivante"
                ,"sFirst": "Premi&egrave;re","sLast": "Derni&egrave;re"},
                "sSearch":"Chercher",
            buttons: {
                colvis: 'Colonnes à afficher',
                copy: 'Copier',print: 'Imprimer',
                copyTitle: 'Ajouté au presse-papiers',
                copyKeys: 'Appuyez sur <i>ctrl</i> ou <i>\u2318</i> + <i>C</i> pour copier les données du tableau à votre presse-papiers. <br><br>Pour annuler, cliquez sur ce message ou appuyez sur Echap.',
                copySuccess: {
                    _: '%d lignes copiées',
                    1: '1 ligne copiée'
                    }
                }

        },
        dom: "<'row'<'col-sm-6'l><'col-sm-6'f>>" + "<'row'<'col-sm-12't>>" + "<'row'<'col-sm-4'i><'col-sm-4'B><'col-sm-4'p>>",
        "columnDefs": 
            [
                { "targets": [11], "orderable": true,"searchable": false, "visible": false},
            ],
        "buttons": ["copy", "excel", "colvis"] //"print", "pdf", "csv",
    })
    .buttons().container().appendTo('#_table_wrapper .col-md-6:eq(0)');

  });
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.dash', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/sigal_test/resources/views/tiers/allocataires/index.blade.php ENDPATH**/ ?>