
<?php $__env->startSection('title'); ?> Allocataires <?php $__env->stopSection(); ?>
<?php $__env->startSection('title_card'); ?> Allocataires <?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <?php if(Session::has('message')): ?>
        <div class="alert alert-warning"><?php echo Session::get('message'); ?></div>
    <?php endif; ?>

    <?php if($errors): ?>
        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class='bg-danger alert'><?php echo $error; ?></div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    <?php endif; ?>

    <?php if(Session::has('success')): ?>
        <div class="alert alert-success"><?php echo \Session::get('success'); ?></div>
    <?php endif; ?>


    <div class="card">
        <div class="card-header bg-info">
            <h2 class="card-title"><?php echo e($title); ?></h2>
        </div>
        <div class="card-body">
            <div class="row">
                <div class='col-md-2'>
                    <?php echo html()->label('Ile','select_ile'); ?>

                    <?php echo html()->select('select_ile',App\Models\MyApp::ILES,isset($ile)?$ile:"")->placeholder('Toutes')
                        ->attributes(['class' => 'form-control','id' => 'select_ile']); ?>

                </div>
                <div class='col-md-4'>
                    <?php echo html()->label('Aide','select_aide'); ?>

                    <?php echo html()->select('select_aide',App\Models\MyApp::TYPES_AIDES,isset($aide)?$aide:"")->placeholder('Toutes')
                        ->attributes(['class' => 'form-control','id' => 'select_aide']); ?>

                </div>
                <?php if($user->can("ALO_AJO") || $user->HasRole("ADMINISTRATEUR")): ?>
                        <div class="col-4">
                            <?php echo html()->label( '&nbsp;',''); ?><br/>
                            <?php echo html()->a(url('allocataires/create'),"Ajouter un allocataire")->attributes(['class' => 'btn btn-success']); ?>

                        </div>
                <?php endif; ?>
            </div>  
            <table id="_table" style="background-color:white;width:100%" class="table table-bordered table-hover">
                <thead>
                    <tr>
                        <th width='1px'>Id</th>
                        <th width='1px'>Dossier<br/>Famille</th>
                        <th width='1px'>CPSWF</th>
                        <th >Nom</th>
                        <th width='1px'>Date de naissance</th>
                        <th>Conjoint</th>
                        <th>Enfants</th>
                        <th width='1px'>NbEnfants<br/>Tot/Soc</th>
                        <th width='1px'>Ressources</th>
                        <th width='1px'>Statut</th>
                        <th width='1px'>Mise à jour</th>

                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $allocataires; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $allocataire): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td  >
                                <a class="btn bg-secondary" href="<?php echo url('allocataires/'.$allocataire->id); ?>"><?php echo $allocataire->IdPAD; ?></a>
                            </td>
                            <td>
                                <?php if($allocataire->id_famille): ?>
                                    <a class="btn bg-primary" href="<?php echo url('familles/'.$allocataire->id_famille); ?>"><?php echo $allocataire->IdPADFamille; ?></a>
                                <?php else: ?>
                                    <span class="badge badge-info right"> Aucun</span>
                                <?php endif; ?>
                                <?php if($allocataire->hasAide('AAE')&&(!$allocataire->IsTitulaire)): ?>
                                <span class="badge badge-danger right"> Non titulaire avec une Aide à l'enfant</span>
                                <?php endif; ?>
                            </td>
                            <td><?php echo $allocataire->IdCPSWFPAD; ?></td>
                            <td><?php echo $allocataire->nom_complet2; ?>

                                <?php if($allocataire->statut_dossier!="ACT"): ?>
                                    <span class="right badge badge-danger">Inactif</span>    
                                <?php endif; ?>
                            </td>
                            <td align="center"><?php echo $allocataire->date_naissance; ?></td>
                            <td><?php echo $allocataire->NomCompletConjoint; ?></td>
                            <td><?php echo $allocataire->getEnfantsListe(); ?></td>
                            <td align="center"><?php echo $allocataire->NbEnfants."/".$allocataire->NbEnfantsAAE; ?></td>
                            <td align="center"><?php echo $allocataire->MontantRessources; ?></td>
                            <td align="center"><?php echo $allocataire->statut; ?></td>
                            <td align="center" title="Création le <?php echo $allocataire->CreatedAt; ?>"><?php echo $allocataire->UpdatedAt; ?></td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
    </div>
<?php $__env->stopSection(); ?>


<?php $__env->startSection('scripts'); ?>
<script>
    $(function () {
        $('#select_aide').change(function() {select_filtre();});
        $('#select_ile').change(function() {select_filtre();});

        function select_filtre() {
            var aide=$('#select_aide').val();
            if(aide=="") aide=0;
            var ile=$('#select_ile').val();
            if(ile=="") ile=0;
            var url="<?php echo url('allocataires_filtre'); ?>"+"/"+ile+"/"+aide;
            location.href=url;
        }
    });
</script>
    <?php echo $__env->make("forms.scripts_datatable_btn", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.dash', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/sigal/resources/views/tiers/allocataires/index.blade.php ENDPATH**/ ?>