
<?php $__env->startSection('title'); ?> Dossiers Familles <?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <?php if(Session::has('message')): ?>
        <div class="alert alert-warning"><?php echo Session::get('message'); ?></div>
    <?php endif; ?>

    <?php if($errors): ?>
        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class='bg-danger alert'><?php echo $error; ?></div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    <?php endif; ?>

    <?php if(Session::has('success')): ?>
        <div class="alert alert-success"><?php echo \Session::get('success'); ?></div>
    <?php endif; ?>

    <div class="card">
        <div class="card-header bg-primary">
            <h3 class="card-title">Liste des Familles</h3>
        </div>
        <div class="card-body">
            <div class="row">
                <div class='col-md-2'>
                    <?php echo html()->label('Ile','select_ile'); ?>

                    <?php echo html()->select('select_ile',App\Models\MyApp::ILES,isset($ile)?$ile:"")->placeholder('Toutes')->attributes(['class' => 'form-control','id' => 'select_ile']); ?>

                </div>
                <div class='col-md-4'>
                    <?php echo html()->label('Aide','select_aide'); ?>

                    <?php echo html()->select('select_aide',App\Models\MyApp::TYPES_AIDES,isset($aide)?$aide:"")->placeholder('Toutes')->attributes(['class' => 'form-control','id' => 'select_aide']); ?>

                </div>
            </div>
            <div class="row">
                <table id="_table" style="background-color:white;width:100%" class="table table-bordered table-hover" >
                    <thead>
                        <tr>
                            <th width='1px'>Id</th>
                            <th width='40%'>Parents</th>
                            <th width='40%'>Enfants</th>
                            <th width='1px'>NbEnfants<br/>Tot/Soc</th>
                            <th width='20%'>Membres</th>
                            <th width='20%'>Membres<br/>Sans Statut</th>
                            <th width='1px'>Village</th>
                            <th width='1px'>Statut<br/>Titulaire</th>
                            <th width='1px'>Aides</th>
                        </tr>
                    </thead>

                    <tbody>
                        <?php $__currentLoopData = $familles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $famille): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><a class="btn bg-secondary " href="<?php echo e(url('familles/'.$famille->id)); ?>" ><?php echo $famille->IdPAD; ?></a></td>
                                <td><?php echo $famille->getParentsListe(); ?></td>
                                <td><?php echo $famille->getEnfantsListe(); ?></td>
                                <td align="center"><?php echo $famille->NbEnfants."/".$famille->NbEnfantsAAE; ?></td>
                                <td><?php echo $famille->getMembresListe(); ?></td>
                                <td><?php echo $famille->getAutresMembresListe(); ?></td>
                                <td><?php echo $famille->VillageNomComplet; ?></td>
                                <td><?php echo $famille->StatutTitulaire; ?></td>
                                <td><?php echo $famille->getAides(); ?></td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>


<?php $__env->startSection('scripts'); ?>
    <?php echo $__env->make("forms.scripts_datatable_btn", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <script>
        $(function () {
            $('#select_aide').change(function() {select_filtre();});
            $('#select_ile').change(function() {select_filtre();});

            function select_filtre() {
                var aide=$('#select_aide').val();
                if(aide=="") aide=0;
                var ile=$('#select_ile').val();
                if(ile=="") ile=0;
                var url="<?php echo url('familles_filtre'); ?>"+"/"+ile+"/"+aide;
                location.href=url;
            }
        });
    </script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.dash', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/sigal/resources/views/familles/index.blade.php ENDPATH**/ ?>