
<?php echo html()->hidden('id_allocataire', isset($allocataire_id)?$allocataire_id:null)->attributes(['id' => 'id_allocataire']); ?>

<?php if(!$mode_frame): ?>
    <div class="form-group row">
        <div class="col-md-6">
            <?php echo html()->label( 'Allocataire','id_allocataire'); ?>

            <div class="input-group ">
                <div class="input-group-prepend">
                    <span class="input-group-text"  name="allocataire_addon" id='allocataire_addon'><?php echo isset($ressource->id_allocataire)?str_pad($ressource->id_allocataire, 6, "0", STR_PAD_LEFT):''; ?></span>
                </div>
                <?php echo html()->text('allocataire', isset($ressource->id_allocataire)?$ressource->NomCompletAllocataire:'')
                    ->attributes([($mode=="show"?'disabled':''), 'id'=>'allocataire','class' => 'form-control']); ?>

            </div>
        </div>
    </div>
<?php endif; ?>

<div class="form-group row">
    <div class="col-md-6">
        <?php echo html()->label( 'Type de ressource','type_ressource'); ?>

        <?php echo html()->select('type_ressource',$types_ressources,null)->placeholder('A définir')
            ->attributes([($mode=="show"?'disabled':''),'class' => 'form-control']); ?>

    </div>
    <div class="col-md-4">
        <?php echo html()->label( 'Source','source'); ?>

        <?php echo html()->text('source', null)->attributes([($mode=="show"?'disabled':''), 'class' => 'form-control']); ?>

    </div>
</div>

<div class="form-group row">
    <div class="col-md-3">
        <?php echo html()->label( 'Montant','montant'); ?>

        <?php echo html()->text('montant', null)->attributes([($mode=="show"?'disabled':''), 'class' => 'form-control']); ?>

    </div>
</div>

<div class="form-group row">
    <div class="col-md-3">
        <?php echo html()->label( 'Date de fin','date_fin'); ?>

        <div class='input-group date' id='datepicker_date_fin'>
            <?php echo html()->text('date_fin', null)
                ->placeholder('')
                ->attributes([($mode=="show"?'disabled':''),'class' => 'form-control']); ?>

            <span class='input-group-addon'><span class='glyphicon glyphicon-calendar'></span></span>
        </div>
    </div>
</div>

<div class="form-group row">
    <div class='col-md-12'>
        <?php echo html()->label( 'Observations','observations'); ?>

        <?php echo html()->textarea('observations', null)
            ->placeholder('')
            ->attributes([($mode=="show"?'disabled':''), 'class' => 'form-control', 'rows'=>'2']); ?>

    </div>
</div>


<div class='form-group'>
    <?php if($mode=="show"): ?>
        <?php if($user->hasRole("ADMINISTRATEUR") || $user->can("RES_MAJ")): ?>
            <?php if($mode_frame): ?> 
                <a class="btn btn-primary" href="<?php echo url('/allocataires_maj_ressources_pop/'.$ressource->id); ?>">Modifier</a> 
            <?php else: ?> 
                <a class="btn btn-primary" href="<?php echo url('/ressources/'.$ressource->id.'/edit'); ?>">Modifier</a> 
            <?php endif; ?>
        <?php endif; ?>
        <?php if($ressource->IsSupprimable): ?>
            <?php if($mode_frame): ?> 
                <a class="btn btn-danger" href="<?php echo url('/allocataires_delete_ressources_pop/'.$ressource->id); ?>">Supprimer</a> 
            <?php else: ?>
                <?php echo e(html()->form('DELETE', url('/ressources/'. $ressource->id))->open()); ?>

                    <button class="btn btn-danger" onclick="if(!confirm('Voulez-vous vraiment supprimer cette Ressource ?')) return false;">Supprimer</button>
                <?php echo e(html()->form()->close()); ?>

            <?php endif; ?>
        <?php endif; ?>

    <?php else: ?>
        <?php echo html()->button('Enregistrer')->value('Enregistrer')->type('submit')->attributes(['class' => 'btn btn-primary']); ?>

    <?php endif; ?>
    <?php if(!$mode_frame): ?> 
    <a class="btn btn-warning"  href="<?php echo url('ressources'); ?>">Retour</a>
    <?php endif; ?>
</div>


<?php /**PATH /var/www/html/sigal/resources/views/ressources/content.blade.php ENDPATH**/ ?>