<?php namespace App\Http\Controllers;

use Auth\AuthController;
use App\Models\GrandLivre;
use App\Models\Journal;
use App\Models\PlanComptable;
use App\Models\Employeur;
use App\Models\MyApp;
use App\Http\Requests\TransactionRequest;
use App\Http\Requests\EcritureRequest;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Auth;
use Illuminate\Http\Request;
use View;
use DB;



class BalanceController extends Controller {
 
    private $menu='ecritures';
    private $submenu='balance';
    private $menu_home='comptabilite';


    public function __construct()
    {
        //$this->beforeFilter('auth');

    }
 
    public function index($jnx="",$date_deb="",$date_fin="")
    {
        $user = Auth::user();
        if(!$user) return Redirect::route( 'login' );


        //Période 
        if(!MyApp::isValidDate($date_deb)) $date_deb="";

        if($date_deb=="") $date_deb=MyApp::getSessionValue($date_deb,'date_deb');
        $date_debFR=date('d/m/Y', strtotime($date_deb));

        if(!MyApp::isValidDate($date_fin)) $date_fin="";
        if($date_fin=="") $date_fin=MyApp::getSessionValue($date_fin,'date_fin');
        $date_finFR=date('d/m/Y', strtotime($date_fin));


        //Selection vue - cookie en cours ou defaut
        $jnx=MyApp::getSessionValue($jnx,'jnx');
        if($jnx=="0") $jnx="";

        /*
        $transactions=[];
        $transactions=GrandLivre::select('compte',db::raw('SUM(debit) as debit'),db::raw('SUM(credit) as credit'))
            ->WhereBetween('date_ref', [$date_deb, $date_fin]);
        if($jnx!="") $transactions=$transactions->where('journal','=',$jnx);
        $transactions=$transactions->distinct()->groupby('compte')->orderby('compte','ASC')->get(); 
        */

        $plancomptables=PlanComptable::orderby('compte','ASC')->get(); 
        $t_plan=[];

        foreach($plancomptables as $plancomptable) {
            $debit=$plancomptable->getDebit($date_deb,$date_fin,$jnx);
            $credit=$plancomptable->getCredit($date_deb,$date_fin,$jnx);
            if(($debit!=0)||($credit!=0)) {
                $t_plan[]=['id_compte'=>$plancomptable->id,'compte'=>$plancomptable->compte,'compte_libelle'=>$plancomptable->libelle,
                    'debit'=>$debit,
                    'credit'=>$credit,
                    'solde'=>($debit-$credit),
                ];
            }
        }

        $liste_journaux=Journal::select('nom_court',db::raw("CONCAT(nom,' - ',nom_court) as nom"))
            ->pluck('nom','nom_court')->toArray();//MyApp::JOURNAUX;


        return View::make('comptabilite.balance.index', 
            [
                'user' => $user,'menu' => $this->menu,'submenu' => $this->submenu,'menu_home' => $this->menu_home,
                'liste_journaux'=>$liste_journaux,'t_plan'=>$t_plan,'jnx'=>$jnx,
                'date_deb'=>$date_debFR,"date_fin" =>$date_finFR,
                'date_debUS'=>$date_deb,"date_finUS" =>$date_fin,
            ]);

    }
 



}



