<?php namespace App\Http\Controllers;

use Auth\AuthController;
use App\Models\Banque;
use App\Models\Beneficiaire;
use App\Models\User;
use App\Models\Role2;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Redirect;
use View;
use DB;

use App\Http\Requests\BanqueRequest;
use App\Http\Requests\AutoResponsableRequest;
use Request;
use Response;


class BanquesController extends Controller {
 
    private $menu='tiers';
    private $submenu='banques';
    private $menu_home='comptabilite';


    public function index($param="")
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if(!$user->hasRole('ADMINISTRATEUR')) if(!$user->can("BQE_VISU")) return redirect('home');

        $banques = Banque::all();
        return View::make('tiers.banques.index', [
            'user' => $user,'menu' => $this->menu,'submenu' => $this->submenu,'menu_home' => $this->menu_home,
            'banques' => $banques
        ]);
    }
 
    /**
     * Show the form for creating a new user.
     *
     * @return Response
     */
    public function create()
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );

        return View::make('tiers.banques.create', [
            'user' => $user,'menu' => $this->menu,'submenu' => $this->submenu,'menu_home' => $this->menu_home,"mode"=>"create",
        ]);
    }
 
    /**
     * Store a newly created user in storage.
     *
     * @return Response
     */
    public function store(BanqueRequest $request)
    {

        $banque = $this->setData($request);
        $msg="La Banque ".$banque->nom." a été créée";
        Session::flash('message', $msg);
        return Redirect::to('banques');
    }

    public function edit($id,$mode="edit")
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );

        $ile="";
        $banque = Banque::find($id);
        return View::make('tiers.banques.'.$mode, [ 
            'user' => $user,'menu' => $this->menu,'submenu' => $this->submenu,'menu_home' => $this->menu_home,"mode"=>$mode,
            'banque'=> $banque
        ]);
    }
 

    public function show($id)
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );

        return $this->edit($id,"show");
    }

    public function update($id,BanqueRequest $request)
    {

        $banque = $this->setData($request,$request->id);
        $msg="La Banque ".$banque->nom." a été mise à jour";
        Session::flash('message', $msg);
        return Redirect::to('banques');
    }
 
    /**
     * Remove the specified user from storage.
     */
    public function destroy($id)
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        $bq=Banque::find($id);

        if( (!$user->hasRole("ADMINISTRATEUR") && !$user->can("BQE_SUP")) || !$bq->canDelete) {
            $msg="Suppression interdite";
            Session::flash('message', $msg);
            return Redirect::back()->with('msg', $msg);
        }
         //LOG de la transaction
        $bq=Banque::find($id);
        $bq->log_transaction('','D');

        Banque::destroy($id);
        return Redirect::to('banques');
    }



    public function setData($request,$id="")
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );

        if($id=="") $banque =  new Banque;
        else $banque = Banque::find($id);
        $banque->nom = $request->nom;
        $banque->adresse = $request->adresse;
        $banque->cp = $request->cp;
        $banque->ville = $request->ville;
        $banque->tel = $request->tel;
        $banque->fax = $request->fax;
        $banque->email = $request->email;
        $banque->contact = $request->contact;
        $banque->agence = $request->agence;
        $banque->bic = $request->bic;
        $banque->contact2 = $request->contact2;
        $banque->tel2 = $request->tel2;        
        $banque->active = ($request->active)?1:0;
        $banque->save();

        return $banque;
    }



    public function autocomplete_banque(Request $request)
    {       
        $param = trim($request->input('term'));
        $associate = array();
        $sql="select id as id,CONCAT(id,' ',TRIM(nom)) as value from banques
            where nom like ('%{$param}%') or id like ('%{$param}%') ";
        $search = DB::select($sql);
        foreach ($search as $result) {
            $associate[] = $result;
        }

        return json_encode($associate);
        
    }

}