<?php namespace App\Http\Controllers;

use Auth\AuthController;
use Illuminate\Support\Facades\Auth;

use App\Models\Beneficiaire;
use App\Models\BeneficiaireBanque;
use App\Models\User;
use App\Models\Role2;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Redirect;
use View;
use DB;

use App\Http\Requests\BeneficiaireRequest;
use App\Http\Requests\BeneficiaireAutoRequest;
use App\Http\Requests\BeneficiaireListeRequest;
use App\Http\Requests\AutoResponsableRequest;
use Request;
use Response;
use App\Models\Beneftype;
use App\Models\Benefstatut;
use App\Models\Employeur;
use App\Models\Enfant;
use App\Models\Salaire;
use App\Models\Versement;
use App\Models\Parametre;
use App\Http\Controllers\Logs;


class BeneficiairesController extends Controller {

    private $menu='tiers';
    private $submenu='beneficiaires';
    private $menu_home="allocations";


    public function __construct()
    {
        
    }

    /**
     * Display a listing of the user.
     *
     * @return Response
     */
    public function index($benef_type="A",$select_benef_type="")
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if($benef_type=="S") $this->menu_home="aides_sociales";
        if($benef_type=="R") $this->menu_home="retraites";
        if($benef_type=="V") $this->menu_home="recouvrement";
        if($select_benef_type=="") {
            if($benef_type=="V") { //pour les recouvrements on garde le dernier choix
                $select_benef_type=Session::get("select_beneficiaires_recouvrement");
                if($select_benef_type=="") $select_benef_type="A";
            }
            else $select_benef_type=$benef_type;
        } else {
            if($benef_type=="V") Session::put("select_beneficiaires_recouvrement",$select_benef_type); //Mise en session le dernier choix recouvrement
        }
        $csr=false;

        $liste_beneftype=Beneftype::orderby('libelle')->select("libelle", "ref")->get()->pluck("libelle", "ref")->toArray();
        $liste_beneftype["*"]="Tous";

        $titre2=substr($liste_beneftype[$select_benef_type],0,strpos($liste_beneftype[$select_benef_type],' ('));
        $filtre=Beneftype::where('ref','=',$select_benef_type)->value('statuts');

        $t_filtre=explode(';',$filtre);
        if($select_benef_type=="*") {
                $beneficiaires = Beneficiaire::orderBy('nom')->orderBy('prenom')->get();
        } else {
            if(count($t_filtre)>0) {
                $beneficiaires = Beneficiaire::whereIn('statut', $t_filtre)->orderBy('nom','ASC')->orderBy('prenom','ASC')->get();

            } else {
                $titre2.=" Tous";
                $beneficiaires = Beneficiaire::where('id', '<>', 'null')
                    ->orderBy('nom')->orderBy('prenom')->get();
            }
        }


        return View::make('tiers.beneficiaires.index', [
            'user' => $user,'menu' => $this->menu,'submenu' => $this->submenu,'menu_home' => $this->menu_home,
            'beneficiaires' => $beneficiaires,
            "liste_beneftype" =>  $liste_beneftype,
            'titre2' => $titre2,
            'benef_type' => $benef_type,'select_benef_type' => $select_benef_type
        ]);
    }

    public function create($benef_type="")
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );

        if($benef_type=="S") $this->menu_home="aides_sociales";
        if($benef_type=="R") $this->menu_home="retraites";
        if($benef_type=="V") $this->menu_home="recouvrement";

        $nom_conjoint="";
        $liste_benefstatut=Benefstatut::orderby('libelle')->get()->pluck("libelle", "ref")->toArray();
        $liste_employeur=array(""=>"");
        $mode="create";

        $onglet_actif="o_general";
        return View::make('tiers.beneficiaires.create', [
            'user' => $user,'menu' => $this->menu,'submenu' => $this->submenu,'menu_home' => $this->menu_home,'mode' => $mode,
            'liste_employeur'=>$liste_employeur,
            'liste_benefstatut'=>$liste_benefstatut,'onglet_actif' => $onglet_actif,
            'benef_type' => $benef_type]);
    }

    public function store(BeneficiaireRequest $request)
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        $nom  = strtoupper($request->nom);
        $date=$request->datenaiss;
        $date = ($date!="")?date('Y-m-d', strtotime(str_replace('/', '-', $date))):"" ;

        $benef_exist=Beneficiaire::where('nom','=',$nom)->where('datenaiss','=',$date)->first();
        $t_error=array();
        if( ($benef_exist) && (!$user->can("BEN_DBL")) ) {
            $t_error['doublon']="Ce bénéficiaire existe déjà sous le numéro :".$benef_exist->id;
        }
        if (count($t_error)>0) {
            //Session::flash('nom_compte2', $plan2->nomcpt);
            return redirect()->back()
                ->withInput()
                ->withErrors($t_error);
        }

        $beneficiaire = $this->setData($request);

        if($request->benef_type!="")  return Redirect::to('beneficiaires_liste/'.$request->benef_type);
        return Redirect::to('/tiers/beneficiaires');
    }


    public function edit($id,$benef_type="",$onglet_actif="",$mode="edit")
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if($benef_type=="S") $this->menu_home="aides_sociales";
        if($benef_type=="R") $this->menu_home="retraites";
        if($benef_type=="V") $this->menu_home="recouvrement";

        $enfants=array();
        $salaires=array();
        $versements=array();
        $liste_benefstatut=array();
        $liste_employeur=array(""=>"");
        $nom_conjoint="";
        $beneficiaire = Beneficiaire::find($id);

        $liste_benefstatut=Benefstatut::orderby('libelle')->get()->pluck("libelle", "ref")->toArray();
        $employeurs=Employeur::orderby('nom')->get()->pluck("nom", "id")->toArray();

        foreach($employeurs as $employeur_id=>$nom) $liste_employeur[$employeur_id]=$nom;

        $enfants = Enfant::Where('parents1','=',$beneficiaire->id)
            ->orWhere('parents2','=',$beneficiaire->id)
            ->orderby('datenais','DESC')->get();

        if(!isset($enfants)) $enfants=array();
        $salaires = Salaire::where('benum','=',$id)->orderBy('annee','DESC')->get();

        $versements = Versement::where('benum','=',$id)->orderBy('date','DESC')->get();
        //Banque
        $beneficiaire_banque=$beneficiaire->getLastCompte();

        if(!$onglet_actif) $onglet_actif=Session::get("onglet_beneficiaire");
        else Session::put("onglet_beneficiaire",$onglet_actif);
        if(!$onglet_actif) $onglet_actif="o_general";

        return View::make('tiers.beneficiaires.'.$mode, [
            'user' => $user,'menu' => $this->menu,'submenu' => $this->submenu,'menu_home' => $this->menu_home,'mode' => $mode,
            'benef_type' => $benef_type,'onglet_actif' => $onglet_actif,
            'enfants'=>$enfants,
            'liste_employeur'=>$liste_employeur,
            'liste_benefstatut'=>$liste_benefstatut,
            'beneficiaire' => $beneficiaire ,
            'nom_conjoint' => $nom_conjoint,
            'salaires' => $salaires,'versements' => $versements,
            'beneficiaire_banque' => $beneficiaire_banque
            ]);
    }

    public function edit_s($id,$benef_type,$onglet_actif="")
    {
        return $this->edit($id,$benef_type,$onglet_actif);
    }


    public function update($id,BeneficiaireRequest $request)
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        $beneficiaire = $this->setData($request,$id);
        return Redirect::to('beneficiaires_liste/'.$request->benef_type);
    }

    /**
     * Ouvre la liste filtrée
     */
    public function show($id,$benef_type="",$onglet_actif="")
    {
        Session::put("onglet_beneficiaire","");
        return $this->edit($id,$benef_type,$onglet_actif,"show");
    }

    public function destroy($id,$benef_type="")
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );

        $beneficiaire=Beneficiaire::find($id);

        if( (!$user->hasRole("ADMINISTRATEUR") && !$user->can("CRE_SUP")) || !$beneficiaire->IsSupprimable) {
            $msg="Suppression interdite";
            Session::flash('message', $msg);
            return Redirect::back()->with('msg', $msg);
        }

        //REcupère le type de liste
        if(($benef_type=="") && isset($_GET["benef_type"])) $benef_type=$_GET["benef_type"];
         //LOG de la transaction
        $beneficiaire=Beneficiaire::find($id);
        $beneficiaire->log_transaction('','D');
        Beneficiaire::destroy($id);

        return Redirect::to('beneficiaires_liste/'.$benef_type);
    }

    public function setData($request,$id="")
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );

        if($id=="") $beneficiaire =  new Beneficiaire;
        else $beneficiaire = Beneficiaire::find($id);

        $beneficiaire->nom  = strtoupper($request->nom);
        $beneficiaire->prenom  = ($request->prenom);
        if($request->employeur_nom=="") $beneficiaire->sonum=0;
        else $beneficiaire->sonum = $request->sonum;


        $beneficiaire->n_all = $request->n_all;
        $date=$request->datenaiss;
        $beneficiaire->datenaiss = ($date!="")?date('Y-m-d', strtotime(str_replace('/', '-', $date))):null ;
        $date=$request->date_deces;
        $beneficiaire->date_deces = ($date!="")?date('Y-m-d', strtotime(str_replace('/', '-', $date))):null ;

        $beneficiaire->lieunaiss = $request->lieunaiss;
        $beneficiaire->adresse = $request->adresse;
        $beneficiaire->district = $request->district;
        $beneficiaire->ile = $request->ile;
        $beneficiaire->tel = $request->tel;
        $beneficiaire->fax = $request->fax;
        $beneficiaire->email = $request->email;
        $beneficiaire->nb_enf = $request->nb_enf;
        $beneficiaire->nb_enf_tot = $request->nb_enf_tot;
        $beneficiaire->obs = $request->obs;

        $beneficiaire->mt_allloc = $request->mt_allloc;
        $beneficiaire->mt_calc = $request->mt_calc;
        $beneficiaire->statut = $request->statut;
        $beneficiaire->verrou = ($request->verrou=='')?0:1;

        $beneficiaire->rappel = $request->rappel;
        if( $user->HasRole('ADMINISTRATEUR')|| $user->can('RET_VISU')|| $user->can('RET_MAJ') ) { // Retraite que si authorise
            $beneficiaire->ret_numdec = $request->ret_numdec;
            $date=$request->ret_dateed;
            $beneficiaire->ret_dateed = ($date!="")?date('Y-m-d', strtotime(str_replace('/', '-', $date))):null ;
            $beneficiaire->ret_type = $request->ret_type;
            $beneficiaire->ret_montant = $request->ret_montant;
            $beneficiaire->ret_rappel = $request->ret_rappel;
            $beneficiaire->csr_montant=$request->csr_montant;
            $beneficiaire->csr_rappel=$request->csr_rappel;
        }
        $beneficiaire->conjoint = $request->conjoint;
        
        $date=$request->date_pi;
        $beneficiaire->date_pi = ($date!="")?date('Y-m-d', strtotime(str_replace('/', '-', $date))):null ;
        $beneficiaire->civilite = $request->civilite;
        $beneficiaire->code_postal = $request->code_postal;
        $beneficiaire->obs_vers = $request->obs_vers;
        //Si décédé alors on enlève les rappels
        if($beneficiaire->statut=="D") {
            $beneficiaire->rappel = 0;
            $beneficiaire->ret_rappel = 0;
            $beneficiaire->csr_rappel=0;
        }
        $beneficiaire->save();

        //LOG de la transaction
        $beneficiaire->log_transaction($request->url(),'U');

        /* *** Gestion du RIB *** */
        $change="";$change="";
        $t_compte_champs=["banque_id","IBAN_pays","IBAN_cle","IBAN_banque","IBAN_guichet","IBAN_compte","IBAN_clerib"];
        //Si il a changé && pas de création de beneficiaire
        if($id!="") {
            $beneficiaire_banque=$beneficiaire->getLastCompte();
            if($beneficiaire && $beneficiaire_banque) {
                foreach($t_compte_champs as $champ) {
                    if($beneficiaire_banque->{$champ}!=($request->{$champ})) $change.="1";
                    else $change.="0";
                }
                $change="0".$change;
                $change = dechex(bindec($change));
            }

            if( intVal($change)!=0) { //Si il y a eu un changement
                //On desactive le compte en cours
                $beneficiaire_banque->actif='0';
                $beneficiaire_banque->save();
                $beneficiaire_banque->log_transaction($request->url(),'U',"desactive");
            }
        }
        //

        if( (hexdec($change)!=0) || ($change=="")) { //SI changement ou pas de banque
            $do_save=true;
            //création du nouveau compte
            if($change=="") $change="00";
            $beneficiaire_banque = new BeneficiaireBanque;
            foreach($t_compte_champs as $champ) $beneficiaire_banque->{$champ} = $request->{$champ};
            $beneficiaire_banque->id_benef=$beneficiaire->id;
            $beneficiaire_banque->infomodif=$change;
            $beneficiaire_banque->actif='1';
            $beneficiaire_banque->id_user=$user->id;
            $beneficiaire_banque->date=date('Y-m-j h:i:s');

            if(($change=="00")&&($beneficiaire_banque->banque_id==null)) $do_save=false; //Si banque pas saisie en creation on ne sauve pas
            if($do_save) {
                $beneficiaire_banque->save();
                $beneficiaire_banque->log_transaction($request->url(),'I');
            }
        }
        /* *** Fin de Gestion du RIB *** */

        return $beneficiaire;
    }

    public function autocomplete_conjoint(BeneficiaireAutoRequest $request)
    {
        //return json_encode(array('aa','bb'));
        $param = $request->term;
        $associate = array();
        $search    = DB::select(
            "select id ,CONCAT(TRIM(nom) ,
                    '  ',
                    TRIM(prenom),
                    '  (',
                    DATE_FORMAT(datenaiss, '%d/%m/%Y')
                    ,')'
                ) as value
                from beneficiaires
                where nom like ('{$param}%') or id='{$param}%'
            "
        );
        foreach ($search as $result) {
            $associate[] = $result;
        }
        $associate[]=["id"=>'',"value"=>'Aucun'];
        return json_encode($associate);
    }



}
