<?php namespace App\Http\Controllers\Compta_old;

use App\Http\Controllers\Controller;
use Auth\AuthController;
use Illuminate\Support\Facades\Auth;
use App\Models\Plan;
use App\Models\Journal;
use App\Models\User;
use App\Models\Parametre;
use App\library\Numbers_Words_fr;

use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Redirect;
use View;
use DB;

use Codedge\Fpdf\Fpdf\Fpdf;
use Illuminate\Http\Request;

class PDF_plan extends FPDF
{
    var $Titre="";
    var $param_EDI_CLR="";
    var $user="";

    function setParam_EDI_CLR($param_EDI_CLR) { $this->param_EDI_CLR=$param_EDI_CLR;}
    function set_titre($titre) { $this->titre=$titre;}
    function set_user($user) { $this->user=$user;}

    public function setParametres()
    {
        
        
    }


    function Footer()
    {
        //Titre
        $this->SetFont("Arial",'',7);
        $this->SetY(285);
        $this->SetX(2);
        //$fpdf->Line(1,100,1,180);
        $this->Cell(60,7,utf8_decode("Edité par ".$this->user->nom),"T",0,'L');
        $this->Cell(100,7,"CPSWF - BP 125 MATA UTU - 98600 WALLIS - TEL : 72.01.20","T",0,'C');
        $this->Cell(40,7,$this->PageNo(),"T",0,'R');        
    }



    function Header()
    {
        $depX=10;
        $this->SetX($depX);
        $img_x=10;
        $img_y=10;

        //echo url('/img/logo_cpswf_imp.png');exit();
        //$f = fopen(url('/img/logo_cpswf_imp.png'),'r');
        //echo "a";exit();
        $this->Image(url('/img/logo_cpswf_imp.png'),$img_x,$img_y,40);
        $this->SetFont('Arial','',10);

        $depX=10;$depY=25;$l=60;$h=4;
        $this->SetXY(170,$depY);
        $this->SetFont('Arial','',10);
        $this->Cell(30,$h,date('d/m/Y'),0,0,'R');
        $this->SetFont('Arial','',9);
        
        $this->SetXY($depX,$depY);
        $this->MultiCell($l,$h,utf8_decode($this->param_EDI_CLR),"",'L');  

        $depX=20;$depY=$this->GetY()+10;
        $this->SetXY($depX,$depY);
        $img_x=105-35;
        $img_y=$depY-3;
        //$this->Image(url('img/bloc_adresse2.png'),$img_x,$img_y,75,13);
        $this->SetFont('Arial','B',14);
        $this->SetFillColor(153 , 204, 255);
        $this->Cell(175,$h+3,utf8_decode($this->titre),0,1,'C');
        $this->ln();

    }  
}


/* ************* Editions *************** */
class EditionPlan extends Controller {

    public function Edition_plan($categ,$exercice="") //Request $request,
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );

        if($categ!="*") $plans=Plan::where('categ','=',$categ)->orderby('numcpt','ASC')->get();
        else $plans=Plan::where('id','>','0')->orderby('numcpt','ASC')->get();
    
        $exercice_encours=Parametre::where('ref','=','CPT_EXERCICE')->first()->value;
        if($exercice=="") $exercice=$exercice_encours;
        $Param_EDI_CLR=Parametre::where('ref','=','EDI_CLR_ATT_RET')->first()->value;

        $titre="PLAN COMPTABLE ".$exercice." (".$categ.")";
        $total=0;
        $total_debit=0;
        $total_credit=0;
        $nb=0;


        $fpdf = new PDF_plan();
        $fpdf->SetParametres();
        $fpdf->setParam_EDI_CLR($Param_EDI_CLR);
        $fpdf->set_titre($titre);
        $fpdf->set_user($user);
        $fpdf->AddPage();


        $depX=10;$depY=$fpdf->GetY();$h=7;
        $fpdf->SetXY($depX,$depY);
        

        $h=7;
        $fpdf->SetFont('Arial','B',8);
        if($exercice==$exercice_encours) {
            $t_cols=['N°COMPTE','LIBELLE','CATEG','POSTE','BUDJET','DEBIT CFP','CREDIT CFP','SOLDE CFP'];
            $w=[17,70,11,11,20,20,20,20];
        } else {
            $t_cols=['N°COMPTE','LIBELLE','CATEG','POSTE','DEBIT CFP','CREDIT CFP','SOLDE CFP'];
            $w=[17,70,11,11,20,20,20];           
        }
        $fpdf->SetFillColor(153 , 204, 255);
        for($k=0;$k<count($w);$k++) $fpdf->Cell($w[$k],$h,utf8_decode($t_cols[$k]),1,0,'C',1);
        $fpdf->ln();

        $txt_size=6;
        $fpdf->SetFont('Arial','',$txt_size);
        $total=0;
        $total_debit=0;
        $total_credit=0;
        $k=0;$j=0;
        $lgmax=40;
        foreach($plans as $plan) { 
            $k++;$j++;
            if($j>26) {
                $j=0;
                $fpdf->AddPage();
                $depX=$fpdf->GetX();;
                $depY=$fpdf->GetY();;
                $fpdf->SetXY($depX,$depY-$h);
                $fpdf->Cell(10,$h,"(suite)",0,1,'L');
                $fpdf->SetFont('Arial','B',$txt_size);
                for($k=0;$k<count($w);$k++) $fpdf->Cell($w[$k],$h,utf8_decode($t_cols[$k]),1,0,'C',1);
                $fpdf->SetFont('Arial','',$txt_size);
                $fpdf->ln();
            }
            $debit=$plan->getDebitCalc($exercice);
            $credit=$plan->getCreditCalc($exercice);
            $montant=$credit-$debit;
            $libelle=$plan->nomcpt;
            if(strlen($libelle)>$lgmax) $libelle=substr($plan->nomcpt,0,$lgmax);
            $jj=0;
            $fpdf->Cell($w[$jj++],$h,$plan->numcpt,1,0,'C');
            $fpdf->Cell($w[$jj++],$h,utf8_decode($libelle),1,0,'L');
            $fpdf->Cell($w[$jj++],$h,$plan->categ,1,0,'C');
            $fpdf->Cell($w[$jj++],$h,$plan->poste,1,0,'C');
            if($exercice==$exercice_encours) {
                $fpdf->Cell($w[$jj++],$h,number_format($plan->budget,0,","," "),1,0,'R');
            }
            $fpdf->Cell($w[$jj++],$h,number_format($debit,0,","," "),1,0,'R');
            $fpdf->Cell($w[$jj++],$h,number_format($credit,0,","," "),1,0,'R');
            $fpdf->Cell($w[$jj++],$h,number_format($montant,0,","," "),1,0,'R');
            $fpdf->ln();
            $total+=$montant;
            $total_debit+=number_format($plan->getDebitCalc($exercice),0,",","") ;
            //intVal($plan->debit);
            $total_credit+=number_format($plan->getCreditCalc($exercice),0,",","");
            //intVal($plan->credit);

            if( ($fpdf->GetY()>=250) && (($nb-$k)>2) ) {
                $fpdf->AddPage();
                $fpdf->SetY(75);
                $fpdf->Cell(65,$h,utf8_decode("(suite)"),0,1,'L');
                $fpdf->ln();
            }
        }
        $fpdf->SetFont('Arial','BU',8);
        $fpdf->Cell($w[0]+$w[1]+$w[2]+$w[3]+$w[4],$h,"Total :",0,0,'R');
        if($exercice==$exercice_encours) $fpdf->SetFont('Arial','',$txt_size);
        $fpdf->Cell($w[4],$h,number_format($total_debit,0,","," "),1,0,'R');
        $fpdf->Cell($w[5],$h,number_format($total_credit,0,","," "),1,0,'R');
        $fpdf->Cell($w[6],$h,number_format($total,0,","," "),1,0,'R');
        $fpdf->ln();




        $fpdf->ln(10);
        $fpdf->SetFont('Arial','',9);
        $fpdf->SetX($depX);
        $fpdf->Cell(180,$h,utf8_decode("Fait à Mata-Utu, le ").date('d/m/Y'),"",0,'R');

                
        $nom_fichier="plan_".$exercice.".pdf";
        $fpdf->Output($nom_fichier.".pdf","I");
        exit();
    }



}



