<?php namespace App\Http\Compta_old;

use Auth\AuthController;
use Illuminate\Support\Facades\Auth;
use App\Http\Controllers\Controller;
use App\Models\User;
use App\Models\Plan;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Redirect;
use View;
use DB;


class TableauAmortissementController extends Controller {

    public function index($categ="R")
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        $exercice=date('Y')-1;

        $plans=Plan::all();
        $plans_categ=Plan::where("categ","=",$categ)->
            where("numcpt","not like","281%")->
            where("numcpt","not like","6%")->
            where("numcpt","not like","7%")->get();
        $t_bilan_actif=array();
        $t_bilan_passif=array();

        foreach($plans_categ as $plan_categ) {
            $brut=$plan_categ->getSoldeCalc($exercice);
            //ACTIF
            if($brut>0) {
                //$brut=-$brut;
                $amort_prec=0;$amort=0;
                $amortissement=$plan_categ->amort;
                $plan_amortissement=Plan::where("numcpt","=",$amortissement)->first();

                // Precedante
                if($plan_amortissement) $amort_prec=$plan_amortissement->getSoldeCalc($exercice-1);
                $netprec=(-$plan_categ->getSoldeCalc($exercice-1))-$amort_prec;

                // En cours
                if($plan_amortissement) $amort=$plan_amortissement->getSoldeCalc($exercice);
                $net=$brut-$amort;

                $value=$plan_categ->numcpt.";";
                $value.=$plan_categ->nomcpt.";";
                $value.=$netprec.";";
                $value.=$brut.";";
                $value.=$amort.";";
                $value.=$brut-$amort.";";
                $t_bilan_actif[$plan_categ->numcpt]=$value;


            } 
            //PASSIF
            if($brut<0) {
                // Precedante
                $netprec=($plan_categ->getSoldeCalc($exercice-1));
                // En cours
                $net=($plan_categ->getSoldeCalc($exercice));
                $value=$plan_categ->numcpt.";";
                $value.=$plan_categ->nomcpt.";";
                $value.=$netprec.";";
                $value.=$net.";";
                $t_bilan_passif[$plan_categ->numcpt]=$value;
            }
            
        }


        return View::make('compta_old.bilan.index', [ 
            'user'=>$user,
            'exercice'=>$exercice,
            'plans'=>$plans,
            't_bilan_actif'=>$t_bilan_actif,
            't_bilan_passif'=>$t_bilan_passif,
            'categ'=>$categ
        ]);
    }


 
}