<?php namespace App\Http\Controllers;

use Illuminate\Support\Facades\Auth;
use Auth\AuthController;
use App\Models\Employeur;
use App\Models\Beneficiaire;
use App\Models\Controle;
use App\Models\User;
use App\Models\Role2;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Redirect;
use View;
use DB;
use App\Http\Requests\ControleRequest;
use App\Http\Requests\AutoResponsableRequest;
use Request;
use Response;


class ControlesController extends Controller {
  
    private $menu='suivi';
    private $submenu='controles';
    private $menu_home='recouvrement';
 
    /**
     * Liste des controles
     */
    public function index($employeur_id=0)
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );

        $liste_employeur=Employeur::distinct()->select('nom','id')->orderBy('nom')->pluck("nom", "id")->toArray();

        $liste_employes="";
        $controles = array();
        if($employeur_id) {
            $controles = Controle::where('sonum','=',$employeur_id)->orderBy('id','DESC')->get();
        }

        $liste_employeur2=array();
        foreach($liste_employeur as $id=>$nom) {
             $liste_employeur2[$id]=htmlentities(str_replace('"','',$nom));
        }
        return View::make('recouvrement.controles.index', [ 
            'user' => $user,'menu' => $this->menu,'submenu' => $this->submenu,'menu_home' => $this->menu_home,
            'controles' => $controles,
            'employeur_id'=>$employeur_id,
            'liste_employeur' => $liste_employeur2
        ]);
    }


    /**
     * Liste des controles depuis la fiche Employeur
     */
    public function index_employeur($employeur_id="")
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );

        $liste_employeur=Employeur::distinct()->select('nom','id')->orderBy('nom')->pluck("nom", "id")->toArray();

        $liste_employes="";
        $controles = array();
        if($employeur_id) {
            $employeur=Employeur::find($employeur_id);
            $controles = Controle::where('sonum','=',$employeur_id)->orderBy('id','DESC')->get();
        }
        return View::make('recouvrement.controles.index_employeur', [
            'user' => $user,'menu' => $this->menu,'submenu' => $this->submenu,'menu_home' => $this->menu_home,
            'employeur' => $employeur, 
            'controles' => $controles,
            ]);
    }
 

    public function create($employeur_id="")
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );

        $liste_employeur = Employeur::orderBy('nom','ASC')->pluck("nom", "id")->toArray();

        $via_employeur=($employeur_id!="");
        $mode='create';$form_pop=false;
        return View::make('recouvrement.controles.'.$mode, 
            [
                'user' => $user,'menu' => $this->menu,'submenu' => $this->submenu,'menu_home' => $this->menu_home,'mode' => $mode,'form_pop' => $form_pop,
                'employeur_id' => $employeur_id,
                'liste_employeur' => $liste_employeur,
            ]);
    }
 
    public function store(ControleRequest $request)
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );

        $controle = $this->setData($request);
        return Redirect::to('controle_annee/'.$controle->sonum);
    }
 
    public function edit($id,$mode='edit')
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );

        $controle=Controle::find($id);
        $liste_employeur = Employeur::orderBy('nom','ASC')->pluck("nom", "id")->toArray();

        $page=$mode;$form_pop=false;
        if($page=="show_box") {$mode="show";$form_pop=true;}
        return View::make('recouvrement.controles.'.$mode, 
        [
            'user' => $user,'menu' => $this->menu,'submenu' => $this->submenu,'menu_home' => $this->menu_home,'mode' => $mode,'form_pop' => $form_pop,
            'liste_employeur' => $liste_employeur,
            'controle' => $controle,
        ]);
    }

    public function show($id)
    {
        return $this->edit($id,'show');
    }

    public function show_box($id)
    {
        return $this->edit($id,'show_box');
    }
 
    public function update($id,ControleRequest $request)
    {
        $controle = $this->setData($request,$id);
        return Redirect::to('controle_annee/'.$controle->sonum);
    }

    public function destroy($id)
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if(!$user->can("COT_SUP") && !$user->HasRole("ADMINISTRATEUR")) return Redirect::to('controles');

        $controle=Controle::find($id);  
        $employeur_id=$controle->sonum;
        Controle::destroy($id);
        return Redirect::to('controle_annee/'.$employeur_id);
    }

    public function setData($request,$id="")
    {
        if($id) $controle = Controle::find($id);
        else $controle = new Controle;

        $controle->sonum = $request->sonum;
        $date = $request->date_cont;
        $controle->date_cont = ($date!="")?date('Y-m-d', strtotime(str_replace('/', '-', $date))):"" ;
        $controle->agent1 = $request->agent1;
        $controle->agent2 = $request->agent2;
        $date = $request->date_valid;
        $controle->date_valid = ($date!="")?date('Y-m-d', strtotime(str_replace('/', '-', $date))):"" ;
        $controle->observations = $request->observations;
        $controle->save();
        return $controle;
    }

 
    public function add_piece($id)
    {
        $controle = Controle::find($id);
        return View::make('recouvrement.controles.add_piece', 
            [ 'controle'=> $controle]);
    }
}