<?php namespace App\Http\Controllers;

use Auth\AuthController;
use App\Models\User;
use App\Models\Role2;
use App\Models\Creancier;
use App\Models\Imputation;
use App\Models\Mandat;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Redirect;
use View;
use DB;
use Illuminate\Support\Facades\Auth;
use App\Http\Requests\CreancierRequest;
use Response;
use App\Models\Parametre;
use Illuminate\Http\Request;
use App\Http\Requests\BeneficiaireAutoRequest;
class CreanciersController extends Controller {


    private $menu='tiers';
    private $submenu='creanciers';
    private $menu_home='comptabilite';


    public function index($exercice="",$origine="")
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if(!$user->hasRole('ADMINISTRATEUR')) if(!$user->can("CRE_VISU")) return redirect('home');

        $exercices = $this->getListeExercicesBi();

        if($origine=="M") $this->menu_home='mandatement';

        if($exercice!="*") {
            if($exercice=="") $exercice=intval(date('Y'))."-".(intval(date('Y'))-1);
            if(!isset($exercices[$exercice])) $exercice=(intval(date('Y'))-1)."-".intval(date('Y'));

            $list_exercice="";
            if(isset($exercices[$exercice]))  $list_exercice=explode('-',$exercice);
            if($list_exercice!='')
                    $obj_mandats = Mandat::wherein('exercice',$list_exercice);
            else  $obj_mandats = Mandat::where('id','<>','');
            $mandats=$obj_mandats->orderby('id','DESC')->pluck('id')->toArray();

            $creanciers=Creancier::orderby('nom')->orderby('prenom')->whereIn('idmandat',$mandats)->get();
        } else {
            $creanciers=Creancier::orderby('nom')->orderby('prenom')->get();
        }

        return View::make('tiers.creanciers.index', [
            'user' => $user,'menu' => $this->menu,'submenu' => $this->submenu,'menu_home' => $this->menu_home,
            'creanciers' => $creanciers,
            'exercice' => $exercice,
            'exercices' => $exercices,
            'origine' => $origine
        ]);
    }

    public function index_mandat($exercice="")
    {
        return $this->index($exercice,"M");
    }



    public function create($frame=false,$origine='')
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if(!$user->hasRole('ADMINISTRATEUR')) if(!$user->can("CRE_AJO")) return redirect('home');

        if($origine=="M") $this->menu_home='mandatement';
        $mode="create";
        return View::make('tiers.creanciers.create',
            [
                'user' => $user,'menu' => $this->menu,'submenu' => $this->submenu,'menu_home' => $this->menu_home,"mode"=>$mode,
                'frame' => $frame,
                'origine' => $origine
            ]);
    }

    public function create_avec_mandat($mandat_id="",$frame=true)
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if(!$user->hasRole('ADMINISTRATEUR')) if(!$user->can("CRE_AJO")) return redirect('home');

        $mandat=Mandat::find($mandat_id);
        $imputations=Imputation::where('idmandat','=',$mandat_id)
            ->select('id',db::raw("CONCAT(id,' ',designation) as libelle"))
            ->pluck("libelle", "id")->toArray();

        $imputation="";
        foreach($imputations as $id=>$libelle) {$imputation=$id;break;}

        $mode='create';
        return View::make('tiers.creanciers.create', [
            'user' => $user,'menu' => $this->menu,'submenu' => $this->submenu,'menu_home' => $this->menu_home,"mode"=>$mode,
            'frame' => $frame,
            'mandat' => $mandat
            , "imputations" => $imputations, "imputation" => $imputation]);
    }


    public function store(CreancierRequest $request)
    {
        $mode_frame=$request->mode_frame;

        $creancier = $this->setData($request);
        if($mode_frame) {
            $msg="Le créancier a été créée";
            Session::flash('message', $msg);
            return Redirect::back()->with('msg', $msg);
        }
        return Redirect::to('creanciers/');
     }


    public function edit($id,$mode="edit",$frame=false,$origine='')
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if(!$user->hasRole('ADMINISTRATEUR')) {
            if(($mode=="edit") && !$user->can("CRE_MAJ")) return redirect('home');
            else if(!$user->can("CRE_VISU")) return redirect('home');
        }

        if($origine=="M") $this->menu_home='mandatement';
        $creancier=Creancier::find($id);
        $imputations=Imputation::where('idmandat','=',$creancier->idmandat)
            ->select('id',db::raw("CONCAT(id,' ',designation) as libelle"))
            ->pluck("libelle", "id")->toArray();

        return View::make('tiers.creanciers.edit',
            [
            'user' => $user,'menu' => $this->menu,'submenu' => $this->submenu,'menu_home' => $this->menu_home,"mode"=>$mode,
            'creancier' => $creancier,
            'frame' => $frame,
            "imputations" => $imputations,
            'origine' => $origine
            ]);

    }

    public function edit_mandat($id)
    {
        return $this->edit($id,"edit",false,"M");
    }

    public function edit_avec_mandat($id,$id_mandat="",$mode="edit",$frame=false)
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if(!$user->hasRole('ADMINISTRATEUR')) {
            if(($mode=="edit") && !$user->can("CRE_MAJ")) return redirect('home');
            else if(!$user->can("CRE_VISU")) return redirect('home');
        }
        $mandat="";
        if($id_mandat) $mandat=Mandat::find($id_mandat);
        if($mandat) $frame=true;

        $creancier=Creancier::find($id);
        $imputations=Imputation::where('idmandat','=',$id_mandat)
            ->select('id',db::raw("CONCAT(id,' ',designation) as libelle"))
            ->pluck("libelle", "id")->toArray();

        return View::make('tiers.creanciers.'.$mode, [
            'user' => $user,'menu' => $this->menu,'submenu' => $this->submenu,'menu_home' => $this->menu_home,"mode"=>$mode,
            'creancier' => $creancier,
            'frame' => $frame,
            'mandat' => $mandat, "imputations" => $imputations
        ]);
    }


    public function show($id,$id_mandat="",$frame=false)
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );

        return $this->edit_avec_mandat($id,$id_mandat,"show",$frame);
    }

    public function show_mandat($id)
    {

        return $this->edit($id,"show",false,"M");
    }

    public function show_frame($id,$id_mandat)
    {
        return $this->show($id,$id_mandat,true);
    }

    public function update($id,CreancierRequest $request)
    {
        $mode_frame=$request->mode_frame;

        $creancier = $this->setData($request,$request->id);
        if($mode_frame) {
            $msg="Le créancier a été modifié";
            Session::flash('message', $msg);
            return Redirect::back()->with('msg', $msg);
        }
        return Redirect::to('creanciers/');
    }

    public function delete_form($id)
    {
        return $this->destroy($id, true);
    }

    public function destroy($id,$form=false)
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if(!$user->hasRole('ADMINISTRATEUR')) if(!$user->can("CRE_SUP")) return redirect('home');

        $creancier=Creancier::find($id);
        if(!$creancier) return Redirect::back()->with('msg', 'Créancier introuvable');

        $nom=$creancier->NomComplet;
        $id_mandat=$creancier->idmandat;
        $msg="Le créancier ".$nom." a été supprimé";
        $res=Creancier::destroy($id);
        Session::flash('message', $msg);
        if($form) return Redirect::back()->with('msg', $msg);
        return Redirect::to('creanciers/');
    }

    public function setData($request,$id="")
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );

        if($id=="") {
            $creancier =  new Creancier;
            $origine=$request->origine;
            if($origine<>'EMP') {
                $creancier->prenom = $request->prenom;
                $date = $request->datenaiss;
                $creancier->datenaiss = ($date!="")?date('Y-m-d', strtotime(str_replace('/', '-', $date))):null ;
            } else {
                $creancier->prenom=null;
                $creancier->datenaiss=null;
            }
        } else {
            $creancier = Creancier::find($id);
            $creancier->prenom = $request->prenom;
            $date = $request->datenaiss;
            $creancier->datenaiss = ($date!="")?date('Y-m-d', strtotime(str_replace('/', '-', $date))):null ;
        }

        $creancier->nom = $request->nom;
        $creancier->num_creancier = $request->num_creancier;
        $creancier->bqcle_creancier = $request->bqcle_creancier;
        $creancier->compte = $request->compte;
        $creancier->montant = $request->montant;
        $creancier->idmandat = $request->idmandat;
        $creancier->obs = $request->obs;
        $creancier->typepmt = $request->typepmt;
        $creancier->idimp_mdt = $request->idimp_mdt;
        //dd($request->idimp_mdt);
        $creancier->save();

        return $creancier;
    }


    /**
     * Listes des exercices
     */
    public function getListeExercices()
    {
        $exercices = DB::table('mandats')->select('exercice')->distinct('exercice')->pluck('exercice')->toArray();

        return $exercices;
    }

    /**
     * Listes des exercices sur 2 ans
     */
    public function getListeExercicesBi()
    {
        $exercices = $this->getListeExercices();
        $nb_exercices=count($exercices );
        $k=0;$t=array();
        foreach($exercices as $exercice) {
            $k++;
            $exercice_min=intval($exercice)-1;
            $exercice_max=intval($exercice)+1;
            if($k%2==0) {
                $t[$exercice_min."-".$exercice]=$exercice_min." - ".$exercice;
                if($k<$nb_exercices) $t[$exercice."-".$exercice_max]=$exercice." - ".$exercice_max;
            }
        }
        arsort($t);
        $t['*']='Tous';
        return $t;
    }


    public function autocomplete_creancier_beneficiaire(Request $request)
    {
        $param = $request->term;
        //$param = "JA";
        $associate = array();

        $search    = DB::select("select beneficiaires.id as id,
                CONCAT( beneficiaires.id,' ',TRIM(beneficiaires.nom),' ',TRIM(beneficiaires.prenom) ) as value,
                beneficiaires.id as beneficiaire_id,
                TRIM(beneficiaires.nom) as beneficiaire_nom,
                TRIM(prenom) as prenom,
                datenaiss as datenaiss,
                CONCAT(IBAN_banque,IBAN_guichet,IBAN_compte,IBAN_clerib) as compte,
                banque_id as banque_id,
                CONCAT(banque_id,' ',TRIM(banques.nom)) as banque_nom
                from beneficiaires
                left outer join beneficiaires_banques on beneficiaires_banques.id_benef=beneficiaires.id
                AND beneficiaires_banques.actif=1
                left outer join banques on banques.id=beneficiaires_banques.id
                where beneficiaires.nom like ('{$param}%')
                or beneficiaires.id like ('{$param}%')
                order by beneficiaires.nom
            "
        );

        foreach ($search as $result) {
            $associate[] = $result;
        }
        return json_encode($associate);
    }


public function autocomplete_creancier_employeur(Request $request)
    {
        $param = $request->term;
        $associate = array();
        $search    = DB::select(
            "select employeurs.id as id,
            CONCAT( employeurs.id,' ',TRIM(employeurs.nom)) as value,
            employeurs.id as employeur_id,
            TRIM(employeurs.nom) as employeur_nom,
            compte as compte,
            banque_id as banque_id,
            CONCAT(banque_id,' ',TRIM(banques.nom)) as banque_nom

            from employeurs
            left outer join banques on banques.id=banque_id
            where employeurs.nom like ('{$param}%')
            or employeurs.id like ('{$param}%')
            order by employeurs.nom
            "
        );
        foreach ($search as $result) {
            $associate[] = $result;
        }
        return json_encode($associate);
    }


    public function autocomplete_creancier_creancier(Request $request)
    {
        $param = $request->term;
        $associate = array();
        $search    = DB::select(
            "select distinct creanciers.num_creancier as id,
            CONCAT( creanciers.num_creancier,' ',TRIM(creanciers.nom),' ',TRIM(creanciers.prenom),' ',compte ) as value,
            creanciers.num_creancier as creancier_id,
            TRIM(creanciers.nom) as creancier_nom,
            TRIM(prenom) as prenom,
            datenaiss as datenaiss,
            compte as compte,
            bqcle_creancier as banque_id,
            CONCAT(bqcle_creancier,' ',TRIM(banques.nom)) as banque_nom

            from creanciers
            left outer join banques on banques.id=bqcle_creancier
            where creanciers.nom like ('{$param}%')
            or creanciers.id like ('{$param}%')
            order by creanciers.nom
            "
        );
        foreach ($search as $result) {
            $associate[] = $result;
        }
        return json_encode($associate);
    }

}
