<?php namespace App\Http\Controllers\Editions;

use Auth\AuthController;
use Illuminate\Support\Facades\Auth;
use App\Http\Controllers\Controller;
use App\Models\Beneficiaire;
use App\Models\Banque;
use App\Models\User;
use App\Models\Role2;
use App\Models\Cotisation;
use App\Models\Parametre;
use App\Models\Employeur;

use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Redirect;
use View;
use DB;

use Codedge\Fpdf\Fpdf\Fpdf;



class PDF10 extends FPDF
{
   var $user="";
    var $exercice="";
    var $bdx_id="";
    var $titre="";
    var $semaine="";
    var $t_reglement=array(""=>"","E"=>0,"B"=>0,"T"=>0,"V"=>0,"A"=>0,"€"=>0,"N"=>0,"P"=>0);
    var $t_libelle_reglement=array(""=>"SANS TYPE","E"=>"ESPECES","B"=>"CHEQUES B.W.F."
            ,"T"=>"CHEQUES TRESOR","V"=>"VIREMENTS"
            ,"A"=>"AUTRES","€"=>"EUROS","N"=>"NUL","P"=>"PRELEVEMENT AUTOMATIQUE");


    function set_exercice($exercice) { $this->exercice=$exercice;}
    function set_bdx_id($bdx_id) { $this->bdx_id=$bdx_id;}
    function set_titre($titre) { $this->titre=$titre;}
    function set_semaine($semaine) { $this->semaine=$semaine;}
    function set_user($user) { $this->user=$user;}

    function Footer()
    {
        //Titre
        $this->SetFont("Arial",'',7);
        $this->SetY(285);
        $this->SetX(2);
        //$fpdf->Line(1,100,1,180);
        $this->Cell(60,7,utf8_decode("Edité par ".$this->user->nom),"T",0,'L');
        $this->Cell(100,7,"CPSWF - BP 125 MATA UTU - 98600 WALLIS - TEL : 72.01.20","T",0,'C');
        $this->Cell(40,7,$this->PageNo(),"T",0,'R'); 

    }


    function Header()
    {
        $depX=20;$depY=10;
        $this->SetXY($depX,$depY);
        $this->SetFont('Arial','B',14);
        $this->SetFillColor(153 , 204, 255);
        $this->MultiCell(175,7,utf8_decode($this->titre),0,'C',1);
        $this->SetFont('Arial','I',10);
        //$this->Cell(175,6,"      Semaine : ".$this->semaine,0,1,'C');
        $this->Ln(5);  
    }  
}

class BordereauEtatRecapitulatif extends Controller {
 
    /**
     * Impressions des attestations
     */
    public function impression_bordereau($bdx_id,$type,$exercice)
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        //Numéros privée
        if($type=="PR") {
            $cotisations = Cotisation::where('bdx_prive','=',$bdx_id)
                ->where('exercice','=',$exercice)
                ->orderby("sonum")->get();
        }
        else {
               $cotisations = Cotisation::where('bdx','=',$bdx_id)
                ->where('exercice','=',$exercice)
                ->orderby("sonum")->get();         
        }

        //recherche date mini --- un epu n'importe quoi comme date
        $date_semaine=$exercice."-12-31";
        foreach($cotisations as $cotisation) {
            if($cotisation->MoisUS<$date_semaine) $date_semaine=$cotisation->MoisUS;
        }
        $date_semaine=strtotime ($date_semaine);

        $semaine="";// date('W',$date_semaine);
        $fpdf = new PDF10();
        $fpdf->set_exercice($exercice);
        $fpdf->set_user($user);
        $fpdf->set_bdx_id($bdx_id);
        $fpdf->set_titre("Etat Récapitulatif du Bordereau N°".$fpdf->bdx_id." \nExercice ".$fpdf->exercice);
        $fpdf->set_semaine($semaine);
        $fpdf->AddPage();

       //Tableau
        $font="Arial";
        $font_size=8;
        $depX=10;
        $h=5;
        $fpdf->SetX($depX);
        $fpdf->SetFont($font,'B',$font_size);
        $w=array(15,65,16,16,16,16,16,16,16);
        $col_def=array('N°'=> $w[0],'SOCIETE' => $w[1],'MOIS DEP.' => $w[2],
            'RATTACH.' => $w[2],'OPER.' => $w[2],'CLR' => $w[3]
                ,'CCPF' =>$w[4],'DEBIT' =>$w[5],'CREDIT' =>$w[6]);
        $fpdf->SetFillColor(135,206,250);
        foreach($col_def as $name=>$l) $fpdf->Cell($l,$h,utf8_decode($name),"LRTB",0,'C',1);
        $k=0;            
        $fpdf->SetFont($font,'',$font_size);
        $nb=count($cotisations);
        $montant_total=0;
        $bordure="TBLR";
        $t_total=array("clr"=>0,"ccpf"=>0,"debit"=>0,"credit"=>0,""=>0);
        $t_total_majoration=array("clr"=>0,"ccpf"=>0,"total"=>0);
        foreach($cotisations as $cotisation) {
            $employeur=Employeur::find($cotisation->sonum);
            $fpdf->ln($h);
            $k++;
            if($k>38) {
                $k=0;
                $fpdf->AddPage();
                $fpdf->SetX($depX);
                $fpdf->SetFont($font,'I',$font_size);
                $fpdf->Cell(175,10,"(suite)",0,'C');
                $fpdf->ln($h*2);
                foreach($col_def as $name=>$l) $fpdf->Cell($l,$h,utf8_decode($name),"LRTB",0,'C',1);
                $fpdf->ln($h);
                $fpdf->SetFont($font,'',$font_size);
            }
            $fpdf->SetX($depX);
            //if($nb==$k) $bordure="BLR";
            //else $bordure="LR";
            $bordure="TBLR";
            $fpdf->Cell($w[0],$h,$cotisation->sonum,$bordure,0,'C');
            $fpdf->Cell($w[1],$h,utf8_decode($employeur->getNomCourtVar(36)),$bordure,0,'L');
            $fpdf->Cell($w[2],$h,$cotisation->mois,$bordure,0,'L');
            $fpdf->Cell($w[2],$h,$cotisation->AnneeRatachement,$bordure,0,'C');
            $fpdf->Cell($w[2],$h,$cotisation->type_ope,$bordure,0,'C');
            $fpdf->Cell($w[3],$h,number_format($cotisation->clr,0,","," "),$bordure,0,'R');
            $fpdf->Cell($w[4],$h,number_format($cotisation->ccpf,0,","," "),$bordure,0,'R');
            $fpdf->Cell($w[5],$h,number_format($cotisation->debit,0,","," "),$bordure,0,'R');
            $fpdf->Cell($w[6],$h,number_format($cotisation->credit,0,","," "),$bordure,0,'R');
            $t_total["clr"]+=$cotisation->clr;
            $t_total["ccpf"]+=$cotisation->ccpf;
            $t_total["debit"]+=$cotisation->debit;
            $t_total["credit"]+=$cotisation->credit;
            if($cotisation->type_ope=="MAJ") {
                $t_total_majoration["clr"]+=$cotisation->clr;
                $t_total_majoration["ccpf"]+=$cotisation->ccpf;
                $t_total_majoration["total"]+=$cotisation->ccpf+$cotisation->clr;
            }

            if($fpdf->t_reglement[$cotisation->typepmt]=="") $fpdf->t_reglement[$cotisation->typepmt]=0;
            $fpdf->t_reglement[$cotisation->typepmt]+=$cotisation->credit; 
        }

        $fpdf->ln($h);
        $fpdf->SetFont($font,'B',$font_size);
        $fpdf->Cell($w[0],$h,"",0,0,'C');
        $fpdf->Cell($w[1]+$w[2]+$w[2]+$w[3],$h,"Totaux:","",0,'R');
        $fpdf->Cell($w[4],$h,number_format($t_total["clr"],0,","," "),$bordure,0,'R',1);
        $fpdf->Cell($w[5],$h,number_format($t_total["ccpf"],0,","," "),$bordure,0,'R',1);
        $fpdf->Cell($w[6],$h,number_format($t_total["debit"],0,","," "),$bordure,0,'R',1);
        $fpdf->Cell($w[7],$h,number_format($t_total["credit"],0,","," "),$bordure,0,'R',1);
 
        $posY=$fpdf->GetY();
        //if($k>28) {
        if($posY>80) {
            $fpdf->AddPage();
        }
        //Recapitulatif
        $nb_reg=0;
        $t=array();
        foreach($fpdf->t_reglement as $type=>$montant) {
            $t[$fpdf->t_libelle_reglement[$type]]=$montant;
            if($montant>0) $nb_reg++;
        }
        ksort($t);
        //$fpdf->t_reglement=$t;
        

        $fpdf->SetX($depX);
        $fpdf->ln(10);
        $fpdf->Cell(50,$h,utf8_decode(""),"RB",0,'C',0);
        $fpdf->Cell(20,$h,utf8_decode("CLR"),"LRTB",0,'C',1);
        $fpdf->Cell(20,$h,utf8_decode("CCPF"),"LRTB",0,'C',1);
        $fpdf->Cell(20,$h,utf8_decode("CLR+CCPF"),"LRTB",1,'C',1);

        $total_clr=$t_total["clr"]-$t_total_majoration["clr"];
        $total_ccpf=$t_total["ccpf"]-$t_total_majoration["ccpf"];
        $fpdf->Cell(50,$h,utf8_decode("Cotisations"),"LRTB",0,'C',1);
        $fpdf->Cell(20,$h,number_format($total_clr,0,","," "),"LRTB",0,'C',0);
        $fpdf->Cell(20,$h,number_format($total_ccpf,0,","," "),"LRTB",0,'C',0);
        $fpdf->Cell(20,$h,number_format($total_clr+$total_ccpf,0,","," "),"LRTB",1,'C',0);

        $fpdf->Cell(50,$h,utf8_decode("Majorations"),"LRTB",0,'C',1);
        $fpdf->Cell(20,$h,number_format($t_total_majoration["clr"],0,","," "),"LRTB",0,'C',0);
        $fpdf->Cell(20,$h,number_format($t_total_majoration["ccpf"],0,","," "),"LRTB",0,'C',0);
        $fpdf->Cell(20,$h,number_format($t_total_majoration["total"],0,","," "),"LRTB",1,'C',0);

        $fpdf->Cell(50,$h,utf8_decode(""),"RT",0,'C',0);
        $fpdf->Cell(20,$h,number_format($t_total["clr"],0,","," "),"LRTB",0,'C',0);
        $fpdf->Cell(20,$h,number_format($t_total["ccpf"],0,","," "),"LRTB",0,'C',0);
        $fpdf->Cell(20,$h,number_format($t_total["clr"]+$t_total["ccpf"],0,","," "),"LRTB",1,'C',0);

 

        //Majoration
            $fpdf->SetX($depX);
            $fpdf->ln(10);
            $fpdf->Cell(50,$h,utf8_decode("Règlement"),"LRTB",0,'C',1);
            $fpdf->Cell(50,$h,utf8_decode("Montant"),"LRTB",1,'C',1);
            
            foreach($t as $type=>$montant){
                if($montant>0) {
                    $fpdf->SetX($depX);
                    $fpdf->Cell(50,$h,utf8_decode($type),"1",0,'L');
                    $fpdf->Cell(50,$h,number_format($montant,0,","," "),"1",1,'R');
                }
            }

        $fpdf->ln(10);
        $d=$h+6;$lrg=40;$lrg2=90;

        $posY=$fpdf->GetY();
        $fpdf->MultiCell($lrg,4,utf8_decode("\nVISA\nChef d'équipe de la gestion des comptes cotisants\n\nDate"),"LRTB",'C');
        $fpdf->SetY($posY);
        $fpdf->SetX($lrg+10);
        $fpdf->MultiCell($lrg2,4,utf8_decode("\n\n\n\n\n\n"),"LRTB",'C');


        $posY=$fpdf->GetY();
        $fpdf->MultiCell($lrg,4,utf8_decode("\nVISA\nTechnicienne référent de la saisie des salaires\n\nDate"),"LRTB",'C');
        $fpdf->SetY($posY);
        $fpdf->SetX($lrg+10);
        $fpdf->MultiCell($lrg2,4,utf8_decode("\n\n\n\n\n\n"),"LRTB",'C');


        $posY=$fpdf->GetY();
        $fpdf->MultiCell($lrg,4,utf8_decode("\nVISA\nAgent comptable\n\nDate\n\n"),"LRTB",'C');
        $fpdf->SetY($posY);
        $fpdf->SetX($lrg+10);
        $fpdf->MultiCell($lrg2,4,utf8_decode("\n\n\n\n\n\n"),"LRTB",'C');

        $posY=$fpdf->GetY();
        $fpdf->MultiCell($lrg,4,utf8_decode("\nVISA\nService Contentieux\n\nDate\n\n"),"LRTB",'C');
        $fpdf->SetY($posY);
        $fpdf->SetX($lrg+10);
        $fpdf->MultiCell($lrg2,4,utf8_decode("\n\n\n\n\n\n"),"LRTB",'C');


        $posY=$fpdf->GetY();
        $fpdf->MultiCell($lrg,4,utf8_decode("\nVISA\nDirecteur\n\nDate\n\n"),"LRTB",'C');
        $fpdf->SetY($posY);
        $fpdf->SetX($lrg+10);
        $fpdf->MultiCell($lrg2,4,utf8_decode("\n\n\n\n\n\n"),"LRTB",'C');

        /*
        $fpdf->Cell($lrg,$d,"VISA Agent comptable","LRT",0,'C');
        $fpdf->Cell($lrg2,$d,"","LRT",1,'C');
        $fpdf->Cell($lrg,$d,"Date","RLB",0,'C');
        $fpdf->Cell($lrg2,$d,"","RLB",1,'C');

        $fpdf->Cell($lrg,$d,"VISA Directeur","LRT",0,'C');
        $fpdf->Cell($lrg2,$d,"","LRT",1,'C');
        $fpdf->Cell($lrg,$d,"Date","RLB",0,'C');
        $fpdf->Cell($lrg2,$d,"","RLB",1,'C');
        */


        foreach($fpdf->t_reglement as $type=>$montant){
            if($montant>0) $this->page_BWF($fpdf,$cotisations,$type);
                    $fpdf->ln(5);
        }
  
/*
        $fpdf->ln(10);
        $fpdf->SetFont('Arial','',$font_size);
        $fpdf->SetX($depX);
        $fpdf->Cell(180,$h,utf8_decode("Fait à Mata-Utu, le ").date('d/m/Y'),"",0,'R');
*/

        $fpdf->Output("Etat_cotisations_".$type."_".$exercice."_".$bdx_id."pdf","I");
        exit();
        exit();
    }



    function page_BWF($fpdf,$cotisations,$type)
    {
        //BWF
        $font="Arial";
        $font_size=8;
        $fpdf->set_titre("TRESOR PUBLIC\n"."Exercice ".$fpdf->exercice."\nBORDEREAU DES ".$fpdf->t_libelle_reglement[$type]." N°".$fpdf->bdx_id);
        $fpdf->AddPage();
        $depX=10;
        $h=7;
        $fpdf->SetX($depX);
        $fpdf->SetFont($font,'B',$font_size);
        $w=array(20,90,20,25,35);

        $col_def=array('N°SOCIETE'=> $w[0],'NOM' => $w[1],'MOIS DEP.' => $w[2],'CREDIT' => $w[3],'COMPTE' =>$w[4]);
        $fpdf->SetFillColor(135,206,250);
        foreach($col_def as $name=>$l) {
            if(($type!="E")||($name!='COMPTE')) $fpdf->Cell($l,$h,utf8_decode($name),"LRTB",0,'C',1);
        }
        $total_credit=0;$k=0;
        $fpdf->SetFont($font,'',$font_size);
        foreach($cotisations as $cotisation) {
            if($cotisation->typepmt==$type) {
                $employeur=Employeur::find($cotisation->sonum);
                $fpdf->ln($h);
                $k++;
                $fpdf->SetX($depX);
                $bordure="TBLR";
                $fpdf->Cell($w[0],$h,str_pad($cotisation->sonum,"0",6),$bordure,0,'C');
                $fpdf->Cell($w[1],$h,$employeur->getNomCourtVar(36),$bordure,0,'L');
                $fpdf->Cell($w[2],$h,$cotisation->mois,$bordure,0,'L');
                $fpdf->Cell($w[3],$h,number_format($cotisation->credit,0,","," "),$bordure,0,'R');
                if($type!="E") $fpdf->Cell($w[4],$h,$cotisation->compte,$bordure,0,'L');
                $total_credit+=$cotisation->credit;
            }
        }
        $fpdf->ln($h);
        $fpdf->SetX($depX);
        $fpdf->SetFont($font,'',$font_size);
        $fpdf->Cell($w[0],$h,"Nombre de lignes :".$k,'T',0,'L');
        $fpdf->SetFont($font,'B',$font_size);
        $fpdf->Cell($w[1]+$w[2],$h,"Totaux:",'T',0,'R');
        $fpdf->Cell($w[3],$h,number_format($total_credit,0,","," "),"TBLR",0,"R");
    }


}



