<?php namespace App\Http\Controllers\Editions;

use App\Http\Controllers\Controller;
use Auth\AuthController;
use Illuminate\Support\Facades\Auth;
use App\Models\Mandat;
use App\Models\Creancier;
use App\Models\Imputation;
use App\Models\Banque;
use App\Models\User;
use App\Models\Role2;
use App\Models\Parametre;
use App\library\Numbers_Words_fr;

use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Redirect;
use View;
use DB;

use Codedge\Fpdf\Fpdf\Fpdf;



class PDF2 extends FPDF
{
    var $Titre="";
    var $user_nom="";
    var $banque_nom="";
    var $num_bordereau="";
    var $suite="";
    var $param_EDI_CLR="";
    var $param_EDI_LIEU="";
    var $param_EDI_SIGNATAIRE="";
    var $nom_directeur="";
    var $civilite_directeur=""; 
    var $modele="";
    var $exercice="";
     var $compte_CLR="";

    function setModele($modele) { $this->modele=$modele;}
    function setCompte_CLR($compte_CLR) { $this->compte_CLR=$compte_CLR;}
    function setExercice($exercice) { $this->exercice=$exercice;}
    function setTitre($titre) { $this->Titre=$titre;}
    function setIdentifiant($identifiant) { $this->identifiant=$identifiant;}
    function setUserNom($user_nom) { $this->user_nom=$user_nom;}
    function setBanqueNom($banque_nom) { $this->banque_nom=$banque_nom;}
    function setNumBordereau($num_bordereau) { $this->num_bordereau=$num_bordereau;}
    function setSuite($suite) { $this->suite=$suite;}
    function setParam_EDI_CLR($param_EDI_CLR) { $this->param_EDI_CLR=$param_EDI_CLR;}
    function setParam_EDI_LIEU($param_EDI_LIEU) { $this->param_EDI_LIEU=$param_EDI_LIEU;}
    function setParam_EDI_SIGNATAIRE($param_EDI_SIGNATAIRE) { $this->param_EDI_SIGNATAIRE=$param_EDI_SIGNATAIRE;}
    function setNom_directeur($nom_directeur) { $this->nom_directeur=$nom_directeur;}
    function setCivilite_directeur($civilite_directeur) { $this->civilite_directeur=$civilite_directeur;}


    public function setParametres()
    {
        //Paramètres
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        $this->setUserNom($user->FullName);
        $this->setNom_directeur(Parametre::where('ref','=','EDI_NOM_DIRECTEUR')->value('value'));
        $this->setCivilite_directeur(Parametre::where('ref','=','EDI_CIVILITE_DIRECTEUR')->value('value'));
        $this->setParam_EDI_LIEU(Parametre::where('ref','=','EDI_LIEU')->value('value'));
        $this->setParam_EDI_SIGNATAIRE(Parametre::where('ref','=','EDI_SIGNATAIRE')->value('value'));
        $this->setParam_EDI_CLR(Parametre::where('ref','=','EDI_CLR')->value('value'));
    }


    function Footer()
    {
        $this->SetFont('Arial','BU',12);
        $depX=7;$depY=143;$l=93;$h=7;$h2=23;
        $this->SetXY($depX,$depY);
        $this->SetFont('Arial','',8);
        //$this->Cell($l,$h,utf8_decode("Désignation du créancier"),"TLR",2,'L');
        
    }


    function Adress()
    {

    }


    function Header()
    {
            $this->SetFont('Arial','',10);
            $depX=15;$depY=7;$h=10;
            $w=[28,25,22,29,45,15,20,20,20,24,20];
            $wA=$w[0]+$w[1]+$w[2]+$w[3]+$w[4];
            $wB=$w[5]+$w[6]+$w[7]+$w[8]+$w[9]+$w[10];
            $this->SetXY($depX,$depY);
            for($i=0;$i<count($w);$i++) $this->Cell($w[$i],$h,"","LRT",(($i+1==count($w))?1:0),'C');
            $this->SetX($depX);
            for($i=0;$i<count($w);$i++) $this->Cell($w[$i],$h-2,"","LRTB",(($i+1==count($w))?1:0),'C');
            $this->SetX($depX);
            $this->Cell($wA,$h,"","LRB",0,'C');
            $this->Cell($wB,$h,"","LR",1,'C');
            $this->SetX($depX);
            $this->Cell($wA,$h*2,"","LRB",0,'C');
            $this->Cell($wB,$h*2,"","LRB",1,'C');  
            $this->SetX($depX);
            $this->Cell($wA,$h*4,"","LRB",0,'C');
            $this->Cell($wB,$h*4,"","LRB",1,'C');  
            $this->SetX($depX);$depY=$this->GetY();
            $this->Cell($wA,$h*2.5,"","LRB",0,'C');
            $this->Cell($wB,$h*3,"","LRB",1,'L');
            $this->SetXY($depX,$depY+$h*2.5);$depY=$this->GetY();
            $this->Cell($wA,$h*3,"","LRB",0,'C');
            $this->Cell($wB,$h*2,"","LRB",2,'C'); 
            $this->Cell($wB,$h*1,"","LRB",1,'C'); 
            $this->SetXY($depX,$depY+$h*2.5);
            $this->SetX($depX);
            $this->Cell($wA,$h*2,"","LRB",0,'C');
            $this->Cell($wB,$h*2,"","LR",2,'C');   
            $this->SetX($depX);
            $this->Cell($wA,$h*4,"","LRB",0,'C');
            $this->Cell($wB,$h*4,"","BLR",2,'C'); 
            //$this->Cell($wB,$h*1.2,"","LRB",1,'C');      
    }  


}


/* ************* Editions *************** */
class EditionMandatOrdrePmtImputation extends Controller {



    public function mandat_ordre_pmt_imp_nom($mandat_id,$beneficiaire="")
    {
        return $this->mandat_ordre_pmt($mandat_id,"","",$beneficiaire);
    }

    public function mandat_ordre_pmt_imp($mandat_id,$imputation_id="",$creancier_id="")
    {
        return $this->mandat_ordre_pmt($mandat_id,$imputation_id,$creancier_id);
    }

    public function mandat_ordre_pmt($mandat_id,$imputation_id="",$creancier_id="",$beneficiaire="")
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        $date=date('d/m/Y');      

        $mandat=Mandat::find($mandat_id);

        $imputation=array();
        $creanciers=array();
        $destinataire="";

        $montant_total=0;
        $type_imp="";
        $lieu="";
        if($imputation_id!="") {
            $imputations=Imputation::where('id','=',$imputation_id)->get();
            if($creancier_id!="") {
                $creancier=Creancier::find($creancier_id);
                $beneficiaire=$creancier->nom_complet;
                $destinataire=$creancier->banque;   
            }
        } else {
            $imputations=Imputation::where('idmandat','=',$mandat_id)->get();
            $t=explode('@@',$beneficiaire);
            $beneficiaire=$t[0];
            $destinataire=$t[1];
        }


        $montant=0;
        foreach($imputations as $imputation) {
            $type_imp=trim($imputation->type_imp);
            $montant+=$imputation->montant;
        }
        //$imputation=Imputation::find($imputation_id);
        //$mandat=Mandat::find($imputation->idmandat);

        /*
        if($creancier_id!="") {
            $creancier=Creancier::find($creancier_id);
            $beneficiaire=$creancier->nom_complet;
            $destinataire=$creancier->banque;
        }
        */
        $font="Arial";
        //Document
        $titre="ORDRE DE PAIEMENT";
        $nom_fichier="ordre_pmt_".$mandat->id."_".$imputation->id;
        if($imputation_id!="") $nom_fichier.=$imputation->id;

        if($type_imp=="CLS") $type_imp="CLR";
        $Param_EDI_CLR=Parametre::where('ref','=','DIV_TITRE_'.$type_imp)->first()->value;
        $compte_CLR=Parametre::where('ref','=','DIV_COMPTE_'.$type_imp)->first()->value;

        //Total en lettre
        $nw = new Numbers_Words_fr();
        $montant_lettre=ucfirst($nw->toWordsDec($montant,"CFP"));
        
        //Création de la page
        $fpdf = new PDF2();
        
        //Zone Entete adresse
        $fpdf->SetParametres();
        $fpdf->setModele("mandat_ordre_pmt_imp");
        $fpdf->setExercice($mandat->exercice);
        
        $fpdf->setParam_EDI_CLR($Param_EDI_CLR);
        $fpdf->setCompte_CLR($compte_CLR);
        $fpdf->setTitre($titre);
        $fpdf->AddPage('L');
        $fpdf->SetAutoPageBreak(false,5);

        $fpdf->SetFont('Arial','',9);
        $depX=15;$depY=7;$h=10;
        $w=[28,25,22,29,45,15,20,20,20,24,20];
        $wA=$w[0]+$w[1]+$w[2]+$w[3]+$w[4];
        $wB=$w[5]+$w[6]+$w[7]+$w[8]+$w[9]+$w[10];
        $fpdf->SetXY($depX+$w[0],$depY);
        $fpdf->Cell($w[1],$h,$mandat->id,"",0,'C');
        $fpdf->SetX($depX+$w[1]+$w[2]+$w[3]+$w[4]);
        $fpdf->Cell($w[1],$h,$mandat->id,"",0,'C');
        $fpdf->Cell($w[5],$h,"9300","",0,'C');
        $fpdf->Cell($w[6],$h,$mandat->exercice,"",0,'C');
        $fpdf->Cell($w[7],$h,date('Y'),"",0,'C');
        $fpdf->Cell($w[7],$h,$imputation->cpt_imp,"",1,'C');

        $fpdf->SetX($depX);
        $fpdf->Cell($w[0],$h,utf8_decode("Service payeur"),"",0,'C');
        $fpdf->Cell($w[1],$h,utf8_decode("N°Bordereau"),"",0,'C');
        $fpdf->Cell($w[2],$h,utf8_decode("N°Remise"),"",0,'C');
        $fpdf->Cell($w[3],$h,utf8_decode("Chèque"),"",0,'C');
        $fpdf->Cell($w[4],$h,utf8_decode("Date du chèque ou écriture"),"",0,'C');
        $fpdf->Cell($w[5],$h,utf8_decode(""),"",0,'C');
        $fpdf->Cell($w[6],$h,utf8_decode("Ordonateur"),"",0,'C');
        $fpdf->Cell($w[7],$h,utf8_decode("Ex Origine"),"",0,'C');
        $fpdf->Cell($w[8],$h,utf8_decode("Ex d'Emis."),"",0,'C');
        $fpdf->Cell($w[9],$h,utf8_decode("Imputation"),"",0,'C');
        $fpdf->Cell($w[10],$h,utf8_decode("Numéro"),"",1,'C');
        $depY=$fpdf->GetY()-2;
        $fpdf->SetXY($depX,$depY);
        $fpdf->SetFont('Arial','B',12);
        $fpdf->Cell($wA,$h,utf8_decode($titre),"",0,'C');
        $fpdf->SetFont('Arial','B',9);
        $fpdf->Cell($wB,$h,utf8_decode("DEPARTEMENT D"),"",1,'L');
        $depY=$fpdf->GetY()-2;
        $fpdf->SetXY($depX,$depY);
        $fpdf->Cell($wA,$h,utf8_decode("COMPTABLE PAYEUR"),"",0,'L');
        $fpdf->SetFont('Arial','BI',10);
        $fpdf->Cell($wB,$h-4,utf8_decode($Param_EDI_CLR),"",2,'C');
        $fpdf->Cell($wB,$h-4,utf8_decode($compte_CLR),"",2,'C');
        $fpdf->SetFont('Arial','I',7);
        $depY=$fpdf->GetY()-2;
        $fpdf->SetXY($depX,$depY);
        $fpdf->Cell($w[0],$h,utf8_decode("Désignation :"),"",0,'L');
        $fpdf->SetFont('Arial','BI',10);
        $fpdf->Cell($w[1],$h,utf8_decode("M.le Directeur des Finances Publiques"),"",1,'L');
        $depY=$fpdf->GetY()+2;
        $fpdf->SetXY($depX,$depY);
        $fpdf->SetFont('Arial','B',10);
        $fpdf->Cell($wA,$h,utf8_decode("CREANCIER"),"",0,'L');
        $fpdf->SetFont('Arial','',10);
        $fpdf->Cell($w[5]+$w[6]+$w[7],$h-3,utf8_decode("OBJET DE LA DEPENSE :"),"",0,'L');
        $fpdf->SetFont('Arial','',8);
        $fpdf->Cell(30,$h-3,utf8_decode("MONTANT BRUT :"),"1",0,'L');
        $fpdf->SetFont('Arial','B',10);
        $fpdf->Cell(34,$h-3,number_format($montant,0,","," ")." CFP","B",2,'C');
        $fpdf->SetFont('Arial','',7);
        $depY=$fpdf->GetY()-2;
        $fpdf->SetXY($depX,$depY);
        $fpdf->Cell($w[0],$h,utf8_decode("Bénéficiaire :"),"",0,'L');
        $fpdf->SetFont('Arial','B',10);
        $fpdf->Cell($w[0],$h,utf8_decode($beneficiaire),"",2,'L');
        $fpdf->SetFont('Arial','',7);
        $fpdf->SetX($depX);
        $fpdf->Cell($w[0],$h,utf8_decode("à :"),"",0,'L');
        $fpdf->SetFont('Arial','B',10);
        $fpdf->Cell($w[0],$h,utf8_decode($destinataire),"",2,'L');
        $fpdf->SetFont('Arial','',7);
        $fpdf->SetX($depX);$hmini=3;
        $depY=$fpdf->GetY()-8;
        $fpdf->Cell($w[0],$hmini,utf8_decode("Compte Courant N° :"),"",2,'L');
        $fpdf->Cell($w[0],$hmini,utf8_decode("Centre de chèques Postaux"),"",2,'L');
        $fpdf->Cell($w[0],$hmini,utf8_decode("ou Etablissement Bancaire"),"",2,'L');
        $fpdf->Cell($w[0],$hmini,utf8_decode("Agence d"),"",0,'L');

        $fpdf->SetXY($depX+$wA+85,$depY-10);
        $fpdf->SetFont('Arial','BI',10);
        $fpdf->Cell(34,33,"","LRBT",2,'L');
        $fpdf->SetXY($depX+$wA,$depY);
        $fpdf->SetXY($depX+$wA,$depY);
        $fpdf->SetFont('Arial','BI',10);
        $fpdf->MultiCell(85,7,utf8_decode($imputation->designation),"",'L');
        $fpdf->SetXY($depX+$wA,$depY+25);
        $fpdf->SetFont('Arial','',10);
        $fpdf->Cell($w[5]+$w[6]+$w[7],$h-3,utf8_decode("PIECES JUSTIFICATIVES DE LA DEPENSE:"),"",1,'L');
        $fpdf->SetXY($depX+$wA,$depY+46);
        $fpdf->SetFont('Arial','',8);
        $fpdf->Cell($wB,$h-3,utf8_decode("JOINT AU MANDAT N°".$mandat->id." du ".$mandat->date_sai." Exercice ".$mandat->exercice),"",2,'L');
        $fpdf->SetFont('Arial','',10);
        $fpdf->Cell(85,$h+5,utf8_decode("A PRECOMPTER"),"R",2,'L');
        $fpdf->SetXY($depX+$wA,$fpdf->GetY());
        $fpdf->Cell(85,$h,utf8_decode("SOMME NETTE A PAYER OU A VIRER(A)"),"R",0,'L');
        $fpdf->SetFont('Arial','B',10);
        $fpdf->Cell(34,$h,number_format($montant,0,","," ")." CFP","B",2,'C');
        $fpdf->SetXY($depX+$wA,$fpdf->GetY());
        $fpdf->SetFont('Arial','',10.5);
        $fpdf->Cell(85+34,$h,utf8_decode("ARRETER LE PRESENT MANDAT DE PAIEMENT A LA SOMME DE:"),"",2,'');
        $fpdf->MultiCell(85+34,$h,"  ".number_format($montant,0,","," ")." CFP ".utf8_decode(" soit: ".$montant_lettre),"R",'');
        $fpdf->SetXY($depX+$wA,$fpdf->GetY()+5);
        $fpdf->SetFont('Arial','',9);
        $fpdf->Cell(85+34,3,utf8_decode("A Mata-utu, le ").date("d/m/Y"),"",2,'L');
        $fpdf->Cell(85+34,3,utf8_decode("Signature et cachet"),"",2,'C');

         $fpdf->SetXY($depX,152);
         $fpdf->Cell($wA,3,utf8_decode("VU BON A PAYER OU A VIRER POUR LA SOMME DE (A) : F"),"",2,'L');
         $fpdf->SetXY($depX,164);
         $fpdf->Cell($wA,10,utf8_decode("POUR ACQUIT DE LA SOMME INDIQUEE CI-DESSOUS (A) :"),"",2,'L');
         $fpdf->Cell($wA,7,utf8_decode("          A ________________ , le ______________________"),"",2,'L');

        $fpdf->Output("paiement_imputation.pdf","I");
        exit();
    }




}



