<?php namespace App\Http\Controllers\Editions;

use App\Http\Controllers\Controller;
use Auth\AuthController;
use Illuminate\Support\Facades\Auth;
use App\Models\Beneficiaire;
use App\Models\Salaire;
use App\Models\Banque;
use App\Models\User;
use App\Models\Role2;
use App\Models\Parametre;
use App\Models\Employeur;
use App\library\Numbers_Words_fr;

use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Redirect;
use View;
use DB;

use Codedge\Fpdf\Fpdf\Fpdf;
use Illuminate\Http\Request;

class PDF_liquidation extends FPDF
{
    var $Titre="";
    var $param_EDI_CLR="";
    var $beneficiaire="";
    var $user="";

    function setParam_EDI_CLR($param_EDI_CLR) { $this->param_EDI_CLR=$param_EDI_CLR;}
    function set_titre($titre) { $this->titre=$titre;}
    function set_beneficiaire($beneficiaire) { $this->beneficiaire=$beneficiaire;}
    function set_user($user) { $this->user=$user;}

    public function setParametres()
    {
        
    }


    function Footer()
    {
        //Titre
        $this->SetFont("Arial",'',7);
        $this->SetY(285);
        $this->SetX(2);
        //$fpdf->Line(1,100,1,180);
        $this->Cell(60,7,utf8_decode("Edité par ".$this->user->nom),"T",0,'L');
        $this->Cell(100,7,"CPSWF - BP 125 MATA UTU - 98600 WALLIS - TEL : 72.01.20","T",0,'C');
        $this->Cell(40,7,$this->PageNo(),"T",0,'R');  
    }



    function Header()
    {
        $depX=5;$depY=5;$l=60;$h=5;
        $this->SetXY(260,$depY);
        $this->SetFont('Arial','',10);
        $this->Cell(30,$h,date('d/m/Y'),0,0,'R');
        $this->SetFont('Arial','',9);
        
        $this->SetXY($depX,$depY);
        $this->MultiCell($l,$h,utf8_decode($this->param_EDI_CLR),"",'C');  

        $depX=20;$depY=$this->GetY()+10;
        $this->SetXY($depX,$depY);
        $this->SetFont('Arial','B',14);
        $this->SetFillColor(153 , 204, 255);
        $this->Cell(165,$h,utf8_decode($this->titre),0,0,'C',1);

        $this->ln(10);
        $this->SetFont('Arial','BU',10);
        $this->Cell(25,$h,utf8_decode("Bénéficiaire :"),0,0,'L');
        $this->SetFont('Arial','BI',10);
        $this->Cell(50,$h,utf8_decode($this->beneficiaire->id." - ".$this->beneficiaire->nom_complet),0,1,'L');
        $this->SetFont('Arial','',10);
        $this->Cell(25,$h,utf8_decode("Né(e) le :"),0,0,'L');
        $this->SetFont('Arial','BI',10);
        $this->Cell(50,$h,utf8_decode($this->beneficiaire->datenaiss),0,0,'L');
        $this->SetFont('Arial','',10);
        $this->Cell(35,$h,utf8_decode("Immatriculation le :"),0,0,'L');
        $this->SetFont('Arial','BI',10);
        $this->Cell(50,$h,utf8_decode($this->beneficiaire->date_pi),0,0,'L'); 
    }  
}


/* ************* Editions *************** */
class EditionSalaires extends Controller {

    public function liquidation($beneficiaire_id) //Request $request,
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        $avec_nom_employeur=false;
        $orientation=($avec_nom_employeur)?'L':'';

        $nb_meilleurs=Parametre::where('ref','=','CAL_PRET_NBMOIS')->first()->value;
        $taux_1=Parametre::where('ref','=','CAL_PRC_RET1')->first()->value;
        $taux_2=Parametre::where('ref','=','CAL_PRC_RET2')->first()->value;
        $plafond=Parametre::where('ref','=','CAL_PFD_RET')->first()->value;; /* ¨Plafond retraite max */


        $beneficiaire=Beneficiaire::find($beneficiaire_id);
        if(!$beneficiaire) return;
        $Param_EDI_CLR=Parametre::where('ref','=','EDI_CLR_ATT_RET')->first()->value;
        $titre="FEUILLE DE LIQUIDATION SALAIRES";
        $texte="La pension annuelle de la retraite est égale à un pourcentage du salaire moyen des 15 meilleures années précédent la mise en retraite.";
        $texte.="\n"."Ce pourcentage est de ".$taux_1."% pour chacune des quinze premières années de cotisations auprès de la Caisse Locale de Retraites et de ".$taux_2."% par année supplémentaire, sans pour autant excéder 65%.";
        $salaires=Salaire::where('benum','=',$beneficiaire_id)
            //->where('annee','<=',$last_annee)
            ->orderby('annee')
            ->get();    


        //$t_salaires_id=$beneficiaire->getIdMeilleursSalaires($nb_meilleurs);
        $t_salaires_ref=$beneficiaire->getRefMeilleursSalaires($nb_meilleurs);

        $moysalaire=$beneficiaire->MoyenneMeilleursSalaires;
        
        $t=explode('~',$moysalaire);
        $nbmois=$t[1];
        $salaire_moyen=$t[0];
        $masse_salariale=$t[2];
        $pension_nette=$t[3];
        $tot_mois=$t[4];
        $retraite_calculee=$t[5];


        //Total en lettre
        $nw = new Numbers_Words_fr();
        $pension_nette_lettre=ucfirst($nw->toWordsDec($pension_nette,"CFP"));

        $fpdf = new PDF_liquidation();
        $fpdf->SetParametres();
        $fpdf->set_user($user);
        $fpdf->setParam_EDI_CLR($Param_EDI_CLR);
        $fpdf->set_titre($titre);
        $fpdf->set_beneficiaire($beneficiaire);
        $fpdf->AddPage($orientation);
        $fpdf->SetAutoPageBreak(false);


        $depX=10;$depY=70;
        $fpdf->SetXY($depX,$depY);
        $fpdf->SetFont('Arial','',8);
        $fpdf->MultiCell(190,4,utf8_decode($texte),0,'L');
        $fpdf->ln();
        $t_mois=[0=>'ANNEE',1=>'EMP.',2=>"JAN",3=>"FEV",4=>"MAR",5=>"AVR",6=>"MAI",
            7=>"JUN",8=>"JUI",9=>"AOU",10=>"SEP",11=>"OCT",12=>"NOV",13=>"DEC",14=>"TOTAL"];

        $fpdf->SetFillColor(153 , 204, 255);
        $k=0;$h=5;
        if($avec_nom_employeur) {
            $l=17;$l1=10;$l2=50;
        } else {
            $l=13;$l1=10;$l2=10;
        }
        
        $fpdf->Cell($l1,$h,$t_mois[$k],0,0,'C',1);
        $fpdf->Cell($l2,$h,$t_mois[$k+1],0,0,'C',1);
        for($k=2;$k<=13;$k++) $fpdf->Cell($l,$h,$t_mois[$k],0,0,'C',1);
            $fpdf->Cell($l+3,$h,$t_mois[$k],0,0,'C',1);
        $fpdf->ln();
        $total=0;$nb=0;$max_car=25;
        $fpdf->SetFillColor(205 , 255, 204);
        foreach($salaires as $salaire) { 
            $nom_employeur=$salaire->EmployeurNom;
            if(strlen($nom_employeur)>$max_car) $nom_employeur=substr($nom_employeur,0,$max_car);

            $style='1';
            $class_jan=isset($t_salaires_ref[$salaire->annee.'-01'])?$style:'';
            $class_fev=isset($t_salaires_ref[$salaire->annee.'-02'])?$style:'';
            $class_mar=isset($t_salaires_ref[$salaire->annee.'-03'])?$style:'';
            $class_avr=isset($t_salaires_ref[$salaire->annee.'-04'])?$style:'';
            $class_mai=isset($t_salaires_ref[$salaire->annee.'-05'])?$style:'';
            $class_jun=isset($t_salaires_ref[$salaire->annee.'-06'])?$style:'';
            $class_jui=isset($t_salaires_ref[$salaire->annee.'-07'])?$style:'';
            $class_aou=isset($t_salaires_ref[$salaire->annee.'-08'])?$style:'';
            $class_sep=isset($t_salaires_ref[$salaire->annee.'-09'])?$style:'';
            $class_oct=isset($t_salaires_ref[$salaire->annee.'-10'])?$style:'';
            $class_nov=isset($t_salaires_ref[$salaire->annee.'-11'])?$style:'';
            $class_dec=isset($t_salaires_ref[$salaire->annee.'-12'])?$style:'';

            $fpdf->Cell($l1,$h,$salaire->annee,1,0,'C');
            if($avec_nom_employeur) $fpdf->Cell($l2,$h,$nom_employeur,1,0,'L');
            else $fpdf->Cell($l2,$h,$salaire->sonum,1,0,'L');
            $fpdf->Cell($l,$h,number_format($salaire->jan,0,","," "),1,0,'R',$class_jan);
            $fpdf->Cell($l,$h,number_format($salaire->fev,0,","," "),1,0,'R',$class_fev);
            $fpdf->Cell($l,$h,number_format($salaire->mar,0,","," "),1,0,'R',$class_mar);
            $fpdf->Cell($l,$h,number_format($salaire->avr,0,","," "),1,0,'R',$class_avr);
            $fpdf->Cell($l,$h,number_format($salaire->mai,0,","," "),1,0,'R',$class_mai);
            $fpdf->Cell($l,$h,number_format($salaire->jun,0,","," "),1,0,'R',$class_jun);
            $fpdf->Cell($l,$h,number_format($salaire->jui,0,","," "),1,0,'R',$class_jui);
            $fpdf->Cell($l,$h,number_format($salaire->aou,0,","," "),1,0,'R',$class_aou);
            $fpdf->Cell($l,$h,number_format($salaire->sep,0,","," "),1,0,'R',$class_sep);
            $fpdf->Cell($l,$h,number_format($salaire->oct,0,","," "),1,0,'R',$class_oct);
            $fpdf->Cell($l,$h,number_format($salaire->nov,0,","," "),1,0,'R',$class_nov);
            $fpdf->Cell($l,$h,number_format($salaire->dec,0,","," "),1,0,'R',$class_dec);
            $fpdf->Cell($l+3,$h,number_format($salaire->total_annee,0,","," "),1,0,'R');
            $fpdf->ln();
            $total+=$salaire->total_annee;
            $nb++;
            if( (($nb>15)&&($orientation=='L')) || (($nb>25)&&($orientation!='L')) ) {
                $fpdf->AddPage($orientation);
                $fpdf->SetY(65);
                $fpdf->Cell(65,$h,utf8_decode("(suite)"),0,1,'L');
                $fpdf->ln(); 
                $nb=0;
            }
        }


        $fpdf->SetFont('Arial','BU',10);
        $fpdf->Cell($l*12+$l1+$l2,$h,"Total :",0,0,'R');
        $fpdf->SetFont('Arial','B',7);
        $fpdf->Cell($l+3,$h,number_format($total,0,","," "),1,0,'R');
        $fpdf->ln();

        if( (($fpdf->GetY()>=170)&&($orientation=='L')) || (($fpdf->GetY()>=250)&&($orientation!='L')) ) {
            $fpdf->AddPage($orientation);
            $fpdf->SetY(75);
            $fpdf->SetFont('Arial','I',10);
            $fpdf->Cell(65,$h,utf8_decode("(suite)"),0,1,'L');
            $fpdf->ln();
        }

        $depX=10;$depY=70;
        $fpdf->SetX($depX);
        $fpdf->SetFont('Arial','',9);


        $fpdf->Cell(65,$h,utf8_decode("Masse salariale pour les ".$nb_meilleurs." meilleurs mois :"),0,0,'L');
        $fpdf->Cell($l+3,$h,number_format($masse_salariale,0,","," ")." CFP",0,1,'L');
        
        $fpdf->Cell(65,$h,utf8_decode("Salaire moyen pour les ".$nb_meilleurs." meilleurs mois :"),0,0,'L');
        $fpdf->Cell($l+3,$h,number_format($salaire_moyen,0,","," ")." CFP",0,1,'L');

        $fpdf->Cell(65,$h,utf8_decode("Nombre de mois déclarés  :"),0,0,'L');
        $fpdf->Cell($l+3,$h,$tot_mois,0,1,'L');


        /*
        $ret_calc=($salaire_moyen*$taux_1/100*$nb_meilleurs/12);
        if($nb_meilleurs<$tot_mois) $ret_calc+=($salaire_moyen*$taux_2/100*($tot_mois-$nb_meilleurs)/12);     
        $ret_plafonnee=$salaire_moyen*$plafond;
        $ret_calc=($ret_calc>$ret_plafonnee)?$ret_plafonnee:$ret_calc;
        $ret_calc=round($ret_calc,0);
        */

        $fpdf->Cell(65,$h,utf8_decode("Retraite calculée  :"),0,0,'L');
        $fpdf->Cell($l+3,$h,number_format($retraite_calculee,0,","," ")." CFP",0,1,'L');

        /*
        $fpdf->Cell(65,$h,utf8_decode("Nombre de mois de cotisation : "),0,0,'L');
        $fpdf->Cell($l+3,$h,$tot_mois,0,1,'L');

        $fpdf->Cell(65,$h,utf8_decode("Pension nette mensuelle :"),0,0,'L');
        $fpdf->Cell($l+3,$h,number_format($pension_nette,0,","," ")." CFP",0,1,'L');


        $fpdf->SetFont('Arial','B',9);
        $fpdf->Cell(65,$h,utf8_decode("Vu et vérifié arrété à la somme de  :"),0,0,'L');
        $fpdf->MultiCell(120,$h,$pension_nette_lettre,0,'L');
        */

        $fpdf->ln(10);
        $fpdf->SetFont('Arial','',9);
        $fpdf->SetX($depX);
        $fpdf->Cell(190,$h,utf8_decode("Fait à Mata-Utu, le ").date('d/m/Y'),"",0,'R');

        
        
        $nom_fichier="feuille_liquidation_".$beneficiaire_id.".pdf";
        $fpdf->Output($nom_fichier.".pdf","I");
        exit();
    }




    public function imprime_salaires($beneficiaire_id) //Request $request,
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        $avec_nom_employeur=false;
        $orientation=($avec_nom_employeur)?'L':'';
        $beneficiaire=Beneficiaire::find($beneficiaire_id);
        $Param_EDI_CLR=Parametre::where('ref','=','EDI_CLR_ATT_RET')->first()->value;
        $titre="SALAIRES";
         $salaires=Salaire::where('benum','=',$beneficiaire_id)
            //->where('annee','<=',$last_annee)
            ->orderby('annee')
            ->get();    

        $fpdf = new PDF_liquidation();
        $fpdf->SetParametres();
        $fpdf->set_user($user);
        $fpdf->setParam_EDI_CLR($Param_EDI_CLR);
        $fpdf->set_titre($titre);
        $fpdf->set_beneficiaire($beneficiaire);
        $fpdf->AddPage($orientation);
        $fpdf->SetAutoPageBreak(false);


        $depX=10;$depY=70;
        $fpdf->SetXY($depX,$depY);
        $fpdf->SetFont('Arial','',8);
        $fpdf->ln();
        $t_mois=[0=>'ANNEE',1=>'EMP.',2=>"JAN",3=>"FEV",4=>"MAR",5=>"AVR",6=>"MAI",
            7=>"JUN",8=>"JUI",9=>"AOU",10=>"SEP",11=>"OCT",12=>"NOV",13=>"DEC",14=>"TOTAL"];

        $fpdf->SetFillColor(153 , 204, 255);
        $k=0;$h=5;
        if($avec_nom_employeur) {
            $l=17;$l1=10;$l2=50;
        } else {
            $l=13;$l1=10;$l2=10;
        }
        
        $fpdf->Cell($l1,$h,$t_mois[$k],0,0,'C',1);
        $fpdf->Cell($l2,$h,$t_mois[$k+1],0,0,'C',1);
        for($k=2;$k<=13;$k++) $fpdf->Cell($l,$h,$t_mois[$k],0,0,'C',1);
            $fpdf->Cell($l+3,$h,$t_mois[$k],0,0,'C',1);
        $fpdf->ln();
        $total=0;$nb=0;$max_car=25;
        $fpdf->SetFillColor(205 , 255, 204);

        foreach($salaires as $salaire) { 
            $nom_employeur=$salaire->EmployeurNom;
            if(strlen($nom_employeur)>$max_car) $nom_employeur=substr($nom_employeur,0,$max_car);

            $style='1';

            $fpdf->Cell($l1,$h,$salaire->annee,1,0,'C');
            if($avec_nom_employeur) $fpdf->Cell($l2,$h,$nom_employeur,1,0,'L');
            else $fpdf->Cell($l2,$h,$salaire->sonum,1,0,'L');
            $fpdf->Cell($l,$h,number_format($salaire->jan,0,","," "),1,0,'R',"");
            $fpdf->Cell($l,$h,number_format($salaire->fev,0,","," "),1,0,'R',"");
            $fpdf->Cell($l,$h,number_format($salaire->mar,0,","," "),1,0,'R',"");
            $fpdf->Cell($l,$h,number_format($salaire->avr,0,","," "),1,0,'R',"");
            $fpdf->Cell($l,$h,number_format($salaire->mai,0,","," "),1,0,'R',"");
            $fpdf->Cell($l,$h,number_format($salaire->jun,0,","," "),1,0,'R',"");
            $fpdf->Cell($l,$h,number_format($salaire->jui,0,","," "),1,0,'R',"");
            $fpdf->Cell($l,$h,number_format($salaire->aou,0,","," "),1,0,'R',"");
            $fpdf->Cell($l,$h,number_format($salaire->sep,0,","," "),1,0,'R',"");
            $fpdf->Cell($l,$h,number_format($salaire->oct,0,","," "),1,0,'R',"");
            $fpdf->Cell($l,$h,number_format($salaire->nov,0,","," "),1,0,'R',"");
            $fpdf->Cell($l,$h,number_format($salaire->dec,0,","," "),1,0,'R',"");
            $fpdf->Cell($l+3,$h,number_format($salaire->total_annee,0,","," "),1,0,'R');
            $fpdf->ln();
            $total+=$salaire->total_annee;
            $nb++;
            if( (($nb>15)&&($orientation=='L')) || (($nb>25)&&($orientation!='L')) ) {
                $fpdf->AddPage($orientation);
                $fpdf->SetY(65);
                $fpdf->Cell(65,$h,utf8_decode("(suite)"),0,1,'L');
                $fpdf->ln(); 
                $nb=0;
            }
        }


        $fpdf->SetFont('Arial','BU',10);
        $fpdf->Cell($l*12+$l1+$l2,$h,"Total :",0,0,'R');
        $fpdf->SetFont('Arial','',7);
        $fpdf->Cell($l+3,$h,number_format($total,0,","," "),1,0,'R');
        $fpdf->ln();

        if( (($fpdf->GetY()>=170)&&($orientation=='L')) || (($fpdf->GetY()>=250)&&($orientation!='L')) ) {
            $fpdf->AddPage($orientation);
            $fpdf->SetY(75);
            $fpdf->SetFont('Arial','I',10);
            $fpdf->Cell(65,$h,utf8_decode("(suite)"),0,1,'L');
            $fpdf->ln();
        }

        $depX=10;$depY=70;

        $fpdf->ln(10);
        $fpdf->SetFont('Arial','',9);
        $fpdf->SetX($depX);
        $fpdf->Cell(190,$h,utf8_decode("Fait à Mata-Utu, le ").date('d/m/Y'),"",0,'R');

        
        
        $nom_fichier="salaires_".$beneficiaire_id.".pdf";
        $fpdf->Output($nom_fichier.".pdf","I");
        exit();
    }

}



