<?php namespace App\Http\Controllers\Editions;

use App\Http\Controllers\Controller;
use Auth\AuthController;
use Illuminate\Support\Facades\Auth;
use App\Models\Secteur;
use App\Models\Employeur;
use App\Models\Salaire;
use App\Models\User;
use App\Models\Parametre;
use App\library\Numbers_Words_fr;

use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Redirect;
use View;
use DB;

use Codedge\Fpdf\Fpdf\Fpdf;
use Illuminate\Http\Request;

class PDF_secteur extends FPDF
{
    var $Titre="";
    var $param_EDI_CLR="";
    var $user="";

    function setParam_EDI_CLR($param_EDI_CLR) { $this->param_EDI_CLR=$param_EDI_CLR;}
    function set_titre($titre) { $this->titre=$titre;}
    function set_user($user) { $this->user=$user;}

    public function setParametres()
    {
        
        
    }


    function Footer()
    {
        //Titre
        $this->SetFont("Arial",'',7);
        $this->SetY(200);
        $this->SetX(2);
        //$fpdf->Line(1,100,1,180);
        $this->Cell(100,7,utf8_decode("Edité par ".$this->user->nom),"T",0,'L');
        $this->Cell(100,7,"CPSWF - BP 125 MATA UTU - 98600 WALLIS - TEL : 72.01.20","T",0,'C');
        $this->Cell(90,7,$this->PageNo(),"T",0,'R');        
    }



    function Header()
    {
        $depX=10;
        $this->SetX($depX);
        $img_x=10;
        $img_y=10;
        $this->Image(url('img/logo_cpswf_imp.png'),$img_x,$img_y,40);
        $this->SetFont('Arial','',10);

        $depX=10;$depY=15;$l=60;$h=4;
        $this->SetXY(260,$depY);
        $this->SetFont('Arial','',9);
        $this->Cell(30,$h,date('d/m/Y'),0,0,'R');
        $this->SetFont('Arial','',9);
        $depY=25;
        $this->SetXY($depX,$depY);
        $this->MultiCell($l,$h,utf8_decode($this->param_EDI_CLR),"",'L');  

        $depX=40;$depY=$this->GetY()+10;
        $this->SetXY($depX,$depY);        
        $this->SetFont('Arial','B',12);
        $this->SetFillColor(153 , 204, 255);
        $this->Cell(225,$h+3,utf8_decode($this->titre),1,1,'C');
        $this->ln();

    }  
}


/* ************* Editions *************** */
class EditionSecteur extends Controller {

    public function secteur_entreprise($annee="",$sec_id="") //Request $request,
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );

        $secteurs=Secteur::all();
        $exercice_encours=Parametre::where('ref','=','CPT_EXERCICE')->first()->value;
        if($annee=="") $annee=$exercice_encours-1;
        $Param_EDI_CLR=Parametre::where('ref','=','EDI_CLR_ATT_RET')->first()->value;

        $titre="LISTE DES ENTREPRISES DU SECTEUR ";
        $total=0;
        $total_debit=0;
        $total_credit=0;
        $nb=0;

        $fpdf = new PDF_secteur();
        $fpdf->SetParametres();
        $fpdf->setParam_EDI_CLR($Param_EDI_CLR);   
        $fpdf->set_user($user);

        $depX=10;$h=5;
        $t_cols=['N°SOCIETE','NOM','JAN','FEV','MAR','AVR','MAI','JUN','JUI','AOU','SEP','OCT','NOV','DEC','MASSE SALARIALE'];
        $w=[20,90,11,11,11,11,11,11,11,11,11,11,11,11,35]; 
        $fpdf->SetFillColor(153 , 204, 255);
        $fpdf->SetFont('Arial','',9);
        foreach($secteurs as $secteur) {
            $employeurs=Employeur::where('sec_id','=',$secteur->id)
                ->where('statut','=','ACT')
                ->orderby('id')
                ->get();

            if($employeurs->count()>0) {
                $fpdf->set_titre($titre." ".$secteur->nom." pour ".$annee);
                $fpdf->AddPage('L');
                $depY=$fpdf->GetY();
                foreach($employeurs as $employeur) {
                    $nb_salaires=Salaire::where('sonum','=',$employeur->id)
                        ->where('annee','=',$annee)
                        ->count();
                }
                /* titre colonne */
                $fpdf->SetFont('Arial','B',9);
                $fpdf->SetFillColor(153 , 204, 255);
                for($k=0;$k<count($w);$k++) $fpdf->Cell($w[$k],$h,utf8_decode($t_cols[$k]),1,0,'C',1);
                $fpdf->SetFont('Arial','',9);
                $fpdf->ln();
                /* ** */
                $t_total_mois_value=[1=>0,2=>0,3=>0,4=>0,5=>0,6=>0,7=>0,8=>0,9=>0,10=>0,11=>0,12=>0];
                $total_masse=0;$masse=0;$n=0;
                foreach($employeurs as $employeur) {
                    if($n++>14) {
                        $n=0;
                        $fpdf->set_titre($titre." ".$secteur->nom." pour ".$annee." (suite)");
                        $fpdf->AddPage('L');
                        $depY=$fpdf->GetY();
                        /* titre colonne */
                        $fpdf->SetFont('Arial','B',9);
                        $fpdf->SetFillColor(153 , 204, 255);
                        for($k=0;$k<count($w);$k++) $fpdf->Cell($w[$k],$h,utf8_decode($t_cols[$k]),1,0,'C',1);
                        $fpdf->SetFont('Arial','',9);
                        $fpdf->ln();
                        /* ** */
                    }
                    $t_mois_value=$employeur->getMasseSalairesAnnee($annee);
                    $fpdf->Cell($w[0],$h,$employeur->id,1,0,'C');
                    $fpdf->Cell($w[1],$h,utf8_decode($employeur->NomCourt),1,0,'L');
                    for($k=0;$k<12;$k++) {
                        $fpdf->Cell($w[$k+2],$h,$t_mois_value[$k+1],1,0,'C');
                        $t_total_mois_value[$k+1]+=$t_mois_value[$k+1];
                    }
                    $masse=$employeur->getMasseSalairesActifs($annee);
                    $total_masse+=$masse;
                    $fpdf->Cell($w[14],$h,number_format($masse,0,","," "),1,0,'R');
                    $fpdf->ln();

                }
                $fpdf->SetFont('Arial','B',9);
                $fpdf->SetFillColor(210 , 210, 210);
                $fpdf->Cell($w[0]+$w[1],$h,"TOTAL",0,0,'R');
                for($k=0;$k<12;$k++) {
                    $fpdf->Cell($w[$k+2],$h,number_format($t_total_mois_value[$k+1],0,","," "),1,0,'C',1);
                }
                $fpdf->Cell($w[14],$h,number_format($total_masse,0,","," "),1,0,'R',1);
            }
        }





        $depX=10;$depY=$fpdf->GetY();$h=7;
        $fpdf->SetXY($depX,$depY);
    
        $h=7;
        $fpdf->SetFont('Arial','B',8);



                
        $nom_fichier="secteurs_".$annee.".pdf";
        $fpdf->Output($nom_fichier.".pdf","I");
        exit();
    }



}



