<?php namespace App\Http\Controllers\Editions;

use App\Http\Controllers\Controller;
use Auth\AuthController;
use Illuminate\Support\Facades\Auth;
use App\Models\Beneficiaire;
use App\Models\User;
use App\Models\Role2;
use App\Models\Enfant;
use App\Models\Salaire;
use App\Models\Versement;
use App\Models\Versement_b;
use App\Models\Versement_hg;
use App\Models\Parametre;
use App\Models\Cotisation;
use App\Models\Employeur;

use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Redirect;
use View;
use DB;

use Codedge\Fpdf\Fpdf\Fpdf;



class PDF_attestations_benef extends FPDF
{
    var $Beneficiaire="";
    var $Directeur="";
    var $CiviDir="";
    var $Titre="";
    var $Service="";
    var $Annee="";
    var $param_EDI_CLR,$param_EDI_LIEU,$param_EDI_SIGNATAIRE="";
    var $mois = array(1=>'janvier', 'février', 'mars', 'avril', 'mai', 'juin', 'juillet', 'août', 'septembre', 'octobre', 'novembre', 'décembre');
    var $date = "";
    var $user="";

    function set_Titre($titre) { $this->Titre=$titre;}
    function set_Annee($annee) { $this->Annee=$annee;}
    function set_Service($service) { $this->Service=$service;}
    function set_Beneficiaire($beneficiaire) { $this->beneficiaire=Beneficiaire::find($beneficiaire);}
    function set_user($user) { $this->user=$user;}

    public function setParametres()
    {
        //Paramètres
        $this->param_EDI_CLR=Parametre::where('ref','=','EDI_CLR')->first()->value;
        $this->param_EDI_LIEU=Parametre::where('ref','=','EDI_LIEU')->first()->value;
        $this->param_EDI_SIGNATAIRE=Parametre::where('ref','=','EDI_SIGNATAIRE')->first()->value;
        $this->CiviDir=Parametre::where('ref','=','EDI_CIVILITE_DIRECTEUR')->first()->value;
        $this->Directeur=Parametre::where('ref','=','EDI_NOM_DIRECTEUR')->first()->value;
        $this->date = date('d/m/Y');
    }


    function Footer()
    {
        //Titre
        $this->SetFont("Arial",'',7);
        $this->SetY(285);
        $this->SetX(2);
        //$fpdf->Line(1,100,1,180);
        $this->Cell(60,7,utf8_decode("Edité par ".$this->user->nom),"T",0,'L');
        $this->Cell(100,7,"CPSWF - BP 125 MATA UTU - 98600 WALLIS - TEL : 72.01.20","T",0,'C');
        $this->Cell(40,7,$this->PageNo(),"T",0,'R');
    }



    function Header()
    {

        $depX=10;
        $this->SetX($depX);
        $img_x=10;
        $img_y=10;
        $this->Image(url('img/logo_cpswf_imp.png'),$img_x,$img_y,40);
        $this->SetFont('Arial','',10);

        $img_x=130;
        $img_y=28;
        $this->Image(url('img/bloc_adresse2.png'),$img_x,$img_y,60,18);

        $h=4;
        $cadre=0;
        $depX=10;
        $depY=25;
        $this->SetXY($depX,$depY);
        $this->MultiCell(82,$h,$this->param_EDI_CLR,'','L');
        //Titre Service
        $depX=130;$depY=30;
        $this->SetXY($depX,$depY);
        $this->SetFont('Arial','',11);
        $this->MultiCell(60,7,$this->Service,'','C');
        //Titre
        $this->SetFont('Arial','',14);
        $this->ln(20);
        $this->Cell(200,$h,$this->Titre,0,0,'C');



    }
}

class EditionsAttestationsController extends Controller {


     public function imprime($beneficiaire_id,$statut,$modele,$annee="")
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        $beneficiaire = Beneficiaire::find($beneficiaire_id);
        if(!$beneficiaire) exit();
        if($annee=="") $annee=date('Y');

        $fpdf = new PDF_attestations_benef();
        $fpdf->setParametres();
        $fpdf->set_Beneficiaire($beneficiaire_id);
        $fpdf->set_Annee($annee);
        $service=$this->getService($statut);
        $fpdf->set_Service($service);
        $fpdf->set_user($user);
        $avec_liste_enfant=true;


        if($modele=="att_revenu") {
            $nom_corps = 'EDI_CORPS_ATTREV';
            $titre = 'ATTESTATION DE DECLARATION';
            $nom_fichier = 'ATTREV';
            $avec_liste_enfant=false;
        }


        if($modele=="att_pmt") {
            $nom_corps = 'EDI_CORPS_ATTPMT';
            $titre = 'ATTESTATION DE PAIEMENT';
            $nom_fichier = 'ATTPMT';

        }

        if($modele=="att_last_pmt") {
            $nom_corps = 'EDI_CORPS_ATTLASTPMT';
            $titre = 'ATTESTATION DE DERNIER PAIEMENT';
            $nom_fichier = 'ATTDERPMT';
        }

        if($modele=="att_cess_pmt") {
            $nom_corps = 'EDI_CORPS_ATTCESSPMT';
            $titre = 'ATTESTATION DE CESSATION DE PAIEMENT';
            $nom_fichier = 'ATTCESSPMT';
        }

        if($modele=="att_no_pmt") {
            $nom_corps = 'EDI_CORPS_ATTNOPMT';
            $titre = 'ATTESTATION DE NON PAIEMENT';
            $nom_fichier = 'ATTNOPMT';
        }


        if($modele=="att_ret_mens") {
            $nom_corps = 'EDI_CORPS_ATTRETMENS';
            $titre = 'ATTESTATION DE RETRAITE MENSUELLE';
            $nom_fichier = 'ATTRETMENS';
            $avec_liste_enfant=false;
        }

        if($modele=="att_ret_an") {
            $nom_corps = 'EDI_CORPS_ATTRETANN';
            $titre = 'ATTESTATION DE RETRAITE ANNUELLE';
            $nom_fichier = 'ATTRETANN';
            $avec_liste_enfant=false;
        }


        if($modele=="att_alloc_vieil") {
            $nom_corps = 'EDI_CORPS_ATTALLVIEIL';
            $titre = "ATTESTATION D'ALLOCATION VIEILLESSE";
            $nom_fichier = 'ATTALVI';
            $avec_liste_enfant=false;
        }



        $fpdf->set_Titre($titre);
        //Mise en forme du corps
        $corps=$this->setCorps_1($fpdf,$statut,$nom_corps);
        $fpdf->AddPage();
        $this->corps($fpdf,$corps);



        if($avec_liste_enfant) $this->liste_enfants($fpdf);
        $this->signature($fpdf);
        $fpdf->Output($nom_fichier." N°".$fpdf->beneficiaire->id.".pdf","I");
        exit();
    }




    /* Renvoi le Service pour titrre zone adresse */
    public function getService($statut)
    {
        $titre="";
        if($statut=="A") $titre="SERVICE DES PRESTATIONS FAMILIALES";
        if($statut=="S") $titre="SERVICE DE L'AIDE SOCIALE"."\n"."A L'ENFANT";
        if($statut=="R") $titre="BUREAU DES\nRETRAITES";
        if($statut=="E") $titre="SERVICE DU\nRECOUVREMENT";
        if($titre=="") $titre="SERVICE DES PRESTATIONS FAMILIALES";

        return $titre;
    }




    /**
     * Mise en forme du corps avec infos bénéf
     */
    public function setCorps_1($fpdf,$statut,$nom_corps)
    {
        $nom_allocation="";
        if($statut=="S") $nom_allocation="l'Aide sociale à l'enfant";
        if($statut=="A") $nom_allocation="les Prestations Familiales";
        if($statut=="R") $nom_allocation="les Prestations Familiales";
        if($statut=="E") $nom_allocation="les Prestations Familiales";

        //Dernier versement
        $mois = array('01'=>'Janvier', '02'=>'Février',
            '03'=>'Mars', '04'=>'Avril', '05'=>'Mai', '06'=>'Juin', '07'=>'Juillet',
            '08'=>'Août', '09'=>'Septembre', '10'=>'Octobre', '11'=>'Novembre', '12'=>'Décembre');
        //Enfants
        $t_enfants1=Enfant::where('parents1','=',$fpdf->beneficiaire->id)->wherein('certif',array('1','2','3'))->pluck('id')->toArray();
        $t_enfants2=Enfant::where('parents2','=',$fpdf->beneficiaire->id)->wherein('certif',array('1','2','3'))->pluck('id')->toArray();
        if(isset($t_enfants1)) $t_enfants=$t_enfants1;
        else {
            if(isset($t_enfants2)&&isset($t_enfants1)) $t_enfants=$t_enfants1+$t_enfants2;
            else $t_enfants=$t_enfants2;
        }
        $enfants=Enfant::wherein('id',$t_enfants)->get();
        $nb_enfants=count($enfants);

        $montant_versement="";
        $montant_versement_par_enfant="";
        $mois_versement="";$annee_versement="";
        $obj_versement=Versement::where('benum','=',$fpdf->beneficiaire->id);
        if($statut=="A") $obj_versement=$obj_versement->where('type','=','ALL');
        if($statut=="S") $obj_versement=$obj_versement->where('type','=','SOC');
        if($statut=="R") {
            if($nom_corps=='EDI_CORPS_ATTALLVIEIL') $obj_versement=$obj_versement->where('type','=','SAV');
            else $obj_versement=$obj_versement->where('type','=','RET');
        }
        $versem=$obj_versement->orderby('date','DESC')->first();

        //Si pas trouvé on cherche dans HG
        if(!isset($versem)) {
            $obj_versement=Versement_hg::where('benum','=',$fpdf->beneficiaire->id);
            if($statut=="A") $obj_versement=$obj_versement->where('type','=','ALL');
            if($statut=="S") $obj_versement=$obj_versement->where('type','=','SOC');
            if($statut=="R") {
                if($nom_corps=='EDI_CORPS_ATTALLVIEIL') $obj_versement=$obj_versement->where('type','=','SAV');
                else $obj_versement=$obj_versement->where('type','=','RET');
            }
            $versem=$obj_versement->orderby('date','DESC')->first();
        }
        if(isset($versem)) {
            $montant_versement=number_format($versem->montant, 0, ',', ' ')." CFP";
            if($nb_enfants>0) {
                $montant_versement_par_enfant=($versem->montant/$nb_enfants);
                $montant_versement_par_enfant=number_format($montant_versement_par_enfant, 0, ',', ' ')." CFP";
            }
            $mois_versement=(is_numeric(substr($versem->date,3,2)))?$mois[substr($versem->date,3,2)]:"";
            $annee_versement=(is_numeric(substr($versem->date,6,4)))?substr($versem->date,6,4):"";
        }

        //Mise en forme du corps
        $corps=Parametre::where('ref','=',$nom_corps)->first()->value;
        $corps=str_replace("{CIVILITE_DIRECTEUR}",$fpdf->CiviDir,$corps);
        $corps=str_replace("{NOM_DIRECTEUR}",$fpdf->Directeur,$corps);
        $corps=str_replace("{BENEF_CIVILITE}",$fpdf->beneficiaire->civilite_libelle,$corps);
        $corps=str_replace("{BENEF_NOM_COMPLET}",trim($fpdf->beneficiaire->nom_complet),$corps);
        $corps=str_replace("{BENEF_DATE_NAISS}",$fpdf->beneficiaire->date_naiss,$corps);
        $corps=str_replace("{BENEF_MATRICULE}",$fpdf->beneficiaire->id,$corps);
        $corps=str_replace("{BENEF_MATRICULE}",$fpdf->beneficiaire->id,$corps);
        $corps=str_replace("{EMPLOYEUR}",$fpdf->beneficiaire->employeur,$corps);
        $corps=str_replace("{NOM_ALLOCATION}",$nom_allocation,$corps);
        $corps=str_replace("{MOIS_DERNIER_PAIEMENT}",$mois_versement." ".$annee_versement,$corps);
        $corps=str_replace("{MONTANT_DERNIER_PAIEMENT}",$montant_versement,$corps);
        $corps=str_replace("{MONTANT_PAR_ENFANT}",$montant_versement_par_enfant,$corps);
        $corps=str_replace("{ANNEE}",$fpdf->Annee,$corps);

        //Pour alloc vieillesse
        if(strpos($corps,'MONTANT_ALLOC_VIEILLESSE')>0) {
            $montant_alloc_vieillesse=0;
            $montant_alloc_vieillesse_euro=0;

            $mois_versement="";
            $montant_ann=0;
            $versem=Versement::where('benum','=',$fpdf->beneficiaire->id)
                ->where('type','=','SAV')
                ->orderby('date','DESC')
                ->first();
            $montant=0;

            if(isset($versem)) {
                $montant=$versem->montant;
                $montant_ann=$versem->montant*12;
                $mois_versement=$versem->mois;
            } else {
                $versem_hg=Versement_hg::where('benum','=',$fpdf->beneficiaire->id)
                    ->where('type','=','SAV')
                    ->orderby('date','DESC')
                    ->first();
                if($versem_hg) {
                    $montant=$versem_hg->montant;
                    $montant_ann=$versem_hg->montant*12;
                    $mois_versement=$versem_hg->mois;
                }
            }

            //$montant=$fpdf->beneficiaire->mt_allloc;
            $montant_alloc_vieillesse=number_format($montant, 0, ',', ' ')." CFP";
            $montant_alloc_vieillesse_euro=number_format(round($montant*0.00838,2), 2, ',', ' ')." EUROS";

            $corps=str_replace("{MONTANT_ALLOC_VIEILLESSE}",$montant_alloc_vieillesse,$corps);
            $corps=str_replace("{MONTANT_ALLOC_VIEILLESSE_EURO}",$montant_alloc_vieillesse_euro,$corps);
        }

        //Pour Retraitee
        if(strpos($corps,'MONTANT_RETRAITE_MENS')>0)  {
            $montant_retraite=0;
            $montant_retraite_euro=0;
            $mois_versement="";
            $versem=Versement::where('benum','=',$fpdf->beneficiaire->id)->where('type','=','RET')->orderby('date','DESC')->first();
            if(isset($versem)) {
                $montant=$versem->montant;
                $montant_ann=$versem->montant*12;
                $montant_retraite=number_format($montant, 0, ',', ' ')." CFP";
                $montant_retraite_euro=number_format(round($montant*0.00838,2), 2, ',', ' ')." EUROS";
                $mois_versement=$versem->mois;
            }
            $corps=str_replace("{MOIS_VERS}",$mois_versement,$corps);
            $corps=str_replace("{MONTANT_RETRAITE_MENS}",$montant_retraite,$corps);
            $corps=str_replace("{MONTANT_RETRAITE_MENS_EURO}",$montant_retraite_euro,$corps);
            $corps=str_replace("de Avril","d'Avril",$corps);
            $corps=str_replace("de Octobre","d'Octobre",$corps);
        }

        if(strpos($corps,'MONTANT_RETRAITE_ANN')>0)  {
            $montant_retraite_ann=0;
            $montant_retraite_ann_euro=0;
            $versem_total=Versement_hg::where('benum','=',$fpdf->beneficiaire->id)
                ->where('type','=','RET')
                ->where('date','like',$fpdf->Annee."%")
                ->sum('montant');
            $montant_ann=$versem_total;
            $montant_retraite_ann=number_format($montant_ann, 0, ',', ' ')." CFP";
            $montant_retraite_ann_euro=number_format(round($montant_ann*0.00838,2), 2, ',', ' ')." EUROS";
            $corps=str_replace("{ANNEE_VERS}",$fpdf->Annee,$corps);
            $corps=str_replace("{MONTANT_RETRAITE_ANN}",$montant_retraite_ann,$corps);
            $corps=str_replace("{MONTANT_RETRAITE_ANN_EURO}",$montant_retraite_ann_euro,$corps);
        }


        if($nom_corps=='EDI_CORPS_ATTREV')  {
            $periode="";
            $deb="";$fin="";

            if($fpdf->beneficiaire->sonum==0) {
                $salaire=Salaire::where('benum','=',$fpdf->beneficiaire->id)
                    ->orderby('annee','DESC')
                    ->first();

            } else {
                $salaire=Salaire::where('benum','=',$fpdf->beneficiaire->id)
                    ->where('sonum','=',$fpdf->beneficiaire->sonum)
                    ->where(DB::raw('(jan+fev+mar+avr+mai+jun+jui+aou+sep+oct+nov+salaire.dec)'),">",0)
                    ->orderby('annee','DESC')
                    ->first();
            }

            $mois_fin="";
            $mois_debut="";
            if($salaire) {
                if($salaire->LastMoisSalaire!="") {
                    $mois_fin=date('d/m/Y',mktime(0,0,0,$salaire->LastMoisSalaire+1,1-1,$salaire->annee));
                }



                $salaire=Salaire::where('benum','=',$fpdf->beneficiaire->id)
                    ->where('sonum','=',$fpdf->beneficiaire->sonum)
                    ->orderby('annee','ASC')
                    ->first();

                $mois_debut="01/".$salaire->FirstMoisSalaire."/".$salaire->annee;
            }
            $periode="la période du ".$mois_debut." au ".$mois_fin;
            $corps=str_replace("{PERIODE_ATTESTATION}",$periode,$corps);
        }

        if(($fpdf->beneficiaire->civilite_libelle=="Madame")||($fpdf->beneficiaire->civilite_libelle=="Mademoiselle")) $corps=str_replace("(e)","e",$corps);
        if($fpdf->beneficiaire->civilite_libelle=="Monsieur") $corps=str_replace("(e)","",$corps);


        return $corps;
    }


    /**
     * Liste des enfants
     */
    public function corps($fpdf,$corps)
    {
        //Corps
        $h=7;
        $fpdf->ln(40);
        $depX=20;$fpdf->SetX($depX);
        $fpdf->SetFont('Arial','',10);
        $fpdf->MultiCell(0,7,utf8_decode($corps),'','L');
    }

    /**
     * Liste des enfants
     */
    public function liste_enfants($fpdf)
    {
        //Enfants
        $t_enfant_id=array();
        $enfants=Enfant::where('parents1','=',$fpdf->beneficiaire->id)
            ->orwhere('parents2','=',$fpdf->beneficiaire->id)->get();

        foreach($enfants as $enfant) $t_enfant_id[]=$enfant->id;
        $enfants=Enfant::whereIn('id', $t_enfant_id)->wherein('certif',array('1','2','3'))->get();
        $nb_enfants=count($enfants);

        //Liste des enfants
        $h=7;
        $fpdf->ln(10);
        $depX=20;$fpdf->SetX($depX);
        $col_def=array('NOM'=> 70,'PRENOM' => 60,'DATE DE NAISSANCE' => 45);
        $fpdf->SetFont('Arial','B',10);
        $fpdf->SetFillColor(135,206,250);
        foreach($col_def as $name=>$w) $fpdf->Cell($w,$h,$name,"LRTB",0,'C',1);
        $fpdf->SetFillColor(255, 255, 255);
        $k=0;
        $fpdf->SetFont('Arial','',10);
        foreach($enfants as $enfant) {
            $fpdf->ln(7);
            $k++;
            $depX=20;$fpdf->SetX($depX);
            if($nb_enfants==$k) $bordure="BLR";
            else $bordure="LR";
            $fpdf->Cell($col_def['NOM'],$h,utf8_decode(trim($enfant->nom)),$bordure,0,'L');
            $fpdf->Cell($col_def['PRENOM'],$h,utf8_decode(trim($enfant->PrenomReduit)),$bordure,0,'L');
            $fpdf->Cell($col_def['DATE DE NAISSANCE'],$h,$enfant->date_nais,$bordure,0,'C');
        }

    }


    public function signature($fpdf)
    {
        $formule_finale="Fait pour servir et valoir ce que de droit ./.";
        //Titre Service
        $h=7;
        $fpdf->SetFont('Arial','',10);
        $fpdf->ln(20);
        $depX=20;$fpdf->SetX($depX);
        $fpdf->Cell(200,$h,$formule_finale,0,'L');
        //Lieu
        $fpdf->ln(20);
        $depX=20;$fpdf->SetX($depX);
        $fpdf->Cell(70,$h,$fpdf->param_EDI_LIEU." le ".date('d/m/Y'),"",0,'L');
        $fpdf->Cell(70,$h,$fpdf->param_EDI_SIGNATAIRE,"",0,'R');
    }



}
