<?php namespace App\Http\Controllers\Editions;

use Auth\AuthController;
use Illuminate\Support\Facades\Auth;
use App\Http\Controllers\Controller;
use App\Models\Beneficiaire;
use App\Models\User;
use App\Models\Role2;
use App\Models\Parametre;
use App\Models\Cotisation;
use App\Models\Employeur;
use App\Models\Salaire;

use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Redirect;
use View;
use DB;

use Codedge\Fpdf\Fpdf\Fpdf;





class PDF_AttRegu extends FPDF
{
    var $Titre="";
    var $Service="";
    var $param_EDI_CLR="";
    var $user="";

    function setParam_EDI_CLR($param_EDI_CLR) { $this->param_EDI_CLR=$param_EDI_CLR;}
    function set_titre($titre) { $this->Titre=$titre;}
    function set_service($Service) { $this->Service=$Service;}
    function set_user($user) { $this->user=$user;}

    public function setParametres()
    {
        
        
    }


    function Footer()
    {
        $this->SetFont("Arial",'',7);
        $this->SetY(285);
        $this->SetX(2);
        $this->Cell(60,7,utf8_decode("Edité par ".$this->user->nom),"T",0,'L');
        $this->Cell(100,7,"CPSWF - BP 125 MATA UTU - 98600 WALLIS - TEL : 72.01.20","T",0,'C');
        $this->Cell(40,7,$this->PageNo(),"T",0,'R');        
    }



    function Header()
    {
        $depX=10;
        $this->SetX($depX);
        $img_x=10;
        $img_y=10;

        $this->Image(url('img/logo_cpswf_imp.png'),$img_x,$img_y,40);

        $depX=10;$depY=25;$l=60;$h=4;
        $this->SetFont('Arial','',9);
        
        $this->SetXY($depX,$depY);
        $this->MultiCell($l,$h,utf8_decode($this->param_EDI_CLR),"",'L');  
        $depY=$this->GetY();
        $this->SetXY($depX,$depY);

        //Titre Service
        $depX=130;
        $this->SetX($depX);
        $this->SetFont('Times','',11);
        $this->MultiCell(50,$h,$this->Service,'0','C');
        $img_x=$depX;
        $img_y=$this->GetY()-3*$h+1.5;
        $this->Image(url('img/bloc_adresse2.png'),$img_x,$img_y,50,13);

        //Titre
        $this->SetFont('Times','',14);
        $this->ln(30);
        $this->SetX(55);
        $this->SetFillColor(255, 102, 153);
        $this->Cell(110,$h*2,$this->Titre,"","",'C',"1");
        $this->SetFillColor(255,255,255);

    }  
}




class EditionsCotisationsAttRegu extends Controller {
  
    /**
     * Impressions des documents cotisations
     */
    public function attestation($employeur_id,$mode="")
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );

        $employeur = Employeur::find($employeur_id);
        if(!$employeur) exit();
        $nom_directeur=Parametre::where('ref','=','EDI_NOM_DIRECTEUR')->first()->value;
        $civilite_directeur=Parametre::where('ref','=','EDI_CIVILITE_DIRECTEUR')->first()->value;

        //Paramètres
        $param_EDI_LIEU=Parametre::where('ref','=','EDI_LIEU')->first()->value;
        $param_EDI_SIGNATAIRE=Parametre::where('ref','=','EDI_SIGNATAIRE')->first()->value;
        $param_EDI_CLR=Parametre::where('ref','=','EDI_CLR')->first()->value;

        $date=date('d/m/Y');
        $service="SERVICE DE RECOUVREMENT";
        $titre="ATTESTATION DE REGULARITE";
        $nom_fichier="Attestation cotisation simple N°".$employeur_id.".pdf";
        $ref_modele="EDI_CORPS_COTIS_ATT";
        


        $corps=Parametre::where('ref','=',$ref_modele)->first()->value;
        $corps=str_replace("{CIVILITE_DIRECTEUR}",$civilite_directeur,$corps);
        $corps=str_replace("{NOM_DIRECTEUR}",$nom_directeur,$corps);
        $corps=str_replace("{NUM_EMPLOYEUR}",$employeur->id,$corps);
        $corps=str_replace("{NOM_EMPLOYEUR}",$employeur->nom,$corps);

        //Création de la page
        $fpdf = new PDF_AttRegu();
        $fpdf->SetParametres();
        $fpdf->setParam_EDI_CLR($param_EDI_CLR);
        $fpdf->set_titre($titre);
        $fpdf->set_service($service);
        $fpdf->set_user($user);
        $fpdf->AddPage();




        //Corps
        $h=7;
        $fpdf->ln(25);
        $depX=20;$fpdf->SetX($depX);
        $fpdf->SetFont('Times','',12);
        $fpdf->MultiCell(0,7,"     ".utf8_decode($corps),'','L');

        $fpdf->SetX($depX);
        $txt=utf8_decode("     l'Entreprise ".$employeur->nom.", inscrite sous le N°".$employeur->id);  
        $txt2=" a réglé les cotisations suivantes, connues à ce-jour :";
        $txt.=utf8_decode($txt2);
        $fpdf->MultiCell(180,$h,$txt,0,'L');

        $fpdf->ln(5);
        $fpdf->SetX($depX);
        $fpdf->SetFont('Times','BU',12);
        $txt=utf8_decode("Derniers Paiements effectués :");
        $fpdf->Cell(100,$h,$txt,0,"1",'L');
        $fpdf->ln(5);
        //Liste des Paiements
        $depX=20;$fpdf->SetX($depX);
        $h=7;
        $fpdf->SetFont('Times','B',10);
        $w=array(20,25,25,25,25,25,25);
        $col_def=array('Date'=> $w[0],'Mois de début' => $w[1],'Nbre de mois' => $w[2]
                ,'Montant CFP' => $w[3],'Paiement CFP' => $w[4],"Date d'encaiss." => $w[5]
                ,"Nbre de salariés" =>$w[6]);

        foreach($col_def as $name=>$l) $fpdf->Cell($l,$h,utf8_decode($name),"LRTB",0,'C');
        $k=0;            
        $fpdf->SetFont('Times','',10);
        $nb_cotis=6;
        $cotiss=Cotisation::where('sonum','=',$employeur->id)->orderby('date','DESC')->limit($nb_cotis)->get();
        foreach($cotiss as $cotis) {
            $fpdf->ln(7);
            $k++;$i=0;
            $depX=20;$fpdf->SetX($depX);
            if($nb_cotis==$k) $bordure="BLR";
            else $bordure="LR";
            $a_regler=0;
            $fpdf->Cell($w[$i++],$h,$cotis->date,$bordure,0,'C');
            $fpdf->Cell($w[$i++],$h,$cotis->mois,$bordure,0,'C');
            $fpdf->Cell($w[$i++],$h,$cotis->nbmois,$bordure,0,'C');
            $fpdf->Cell($w[$i++],$h,number_format($cotis->debit,0,","," "),$bordure,0,'C');
            $fpdf->Cell($w[$i++],$h,number_format($cotis->credit,0,","," "),$bordure,0,'C');
            $fpdf->Cell($w[$i++],$h,$cotis->encais_date,$bordure,0,'C');
            $fpdf->Cell($w[$i++],$h,$cotis->nbsal,$bordure,0,'C');
        }
        $fpdf->SetFont('Times','',12);
        $fpdf->ln(5);

        $fpdf->ln(10);
        $fpdf->SetX($depX);
        $fpdf->SetFont('Times','BU',12);
        $txt=utf8_decode("Cotisations Antérieures :");
        $fpdf->Cell(100,$h,$txt,0,"1",'L');
        $fpdf->ln(2);
        $fpdf->SetFont('Times','',12);
        $fpdf->SetX($depX+10);


        $txt=utf8_decode("L'entreprise est à jour de ses cotisations antérieures.");
        $fpdf->Cell(8,$h-2.5," ",1,0,'L');
        $fpdf->Cell(100,$h-2,$txt,0,"1",'L');

         $fpdf->ln(5);
        $fpdf->SetX($depX+10);
        $txt=utf8_decode("L'entreprise n'est pas à jour de ses cotisations antérieures et doit un montant de ");
        $fpdf->Cell(8,$h-2.5," ",1,0,'L');
        $fpdf->Cell(100,$h-2,$txt,0,"1",'L');     


        //Titre Service
        $formule_finale=utf8_decode("En foi de quoi la présente attestation lui est délivrée, pour servir et valoir ce que de droit.");
        $fpdf->ln(10);
        $depX=20;$fpdf->SetX($depX);
        $fpdf->Cell(200,$h,$formule_finale,0,0,'L');

        //Lieu
        $fpdf->ln(20);
        $depX=20;$fpdf->SetX($depX);
        $fpdf->Cell(70,$h,$param_EDI_LIEU." le ".$date,0,0,'L');
        $fpdf->Cell(70,$h,$param_EDI_SIGNATAIRE,0,0,'R');

        $fpdf->Output($nom_fichier,"I");
        exit();
    }

    public function attestation_regul($employeur_id)
    {
        return $this->attestation($employeur_id,"REG");
    }
 
}