<?php namespace App\Http\Controllers\Editions;

use Auth\AuthController;
use Illuminate\Support\Facades\Auth;
use App\Http\Controllers\Controller;
use App\Models\Beneficiaire;
use App\Models\User;
use App\Models\Role2;
use App\Models\Parametre;
use App\Models\Cotisation;
use App\Models\Employeur;
use App\Models\Salaire;

use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Redirect;
use View;
use DB;

use Codedge\Fpdf\Fpdf\Fpdf;



class PDF_AttSitu extends FPDF
{
    var $Titre="";
    var $Service="";
    var $param_EDI_CLR="";
    var $user="";

    function setParam_EDI_CLR($param_EDI_CLR) { $this->param_EDI_CLR=$param_EDI_CLR;}
    function set_titre($titre) { $this->Titre=$titre;}
    function set_service($Service) { $this->Service=$Service;}
    function set_user($user) { $this->user=$user;}

    public function setParametres()
    {
        
        
    }


    function Footer()
    {
        $this->SetFont("Arial",'',7);
        $this->SetY(285);
        $this->SetX(2);
        $this->Cell(60,7,utf8_decode("Edité par ".$this->user->nom),"T",0,'L');
        $this->Cell(100,7,"CPSWF - BP 125 MATA UTU - 98600 WALLIS - TEL : 72.01.20","T",0,'C');
        $this->Cell(40,7,$this->PageNo(),"T",0,'R');        
    }



    function Header()
    {
        $depX=10;
        $this->SetX($depX);
        $img_x=10;
        $img_y=10;
        $this->Image(url('img/logo_cpswf_imp.png'),$img_x,$img_y,40);

        $depX=10;$depY=25;$l=60;$h=4;
        $this->SetFont('Arial','',9);
        
        $this->SetXY($depX,$depY);
        $this->MultiCell($l,$h,utf8_decode($this->param_EDI_CLR),"",'L');  
        $depY=$this->GetY();
        $this->SetXY($depX,$depY);

        //Titre Service
        $depX=130;
        $this->SetX($depX);
        $this->SetFont('Times','',11);
        $this->MultiCell(50,$h,$this->Service,'0','C');
        $img_x=$depX;
        $img_y=$this->GetY()-3*$h+1.5;
        $this->Image(url('img/bloc_adresse2.png'),$img_x,$img_y,50,13);

        //Titre
        $this->SetFont('Times','',14);
        $this->ln(10);
        $this->SetX(55);
        $this->SetFillColor(255, 102, 153);
        $this->Cell(110,$h*2,$this->Titre,"","",'C',"1");
        $this->SetFillColor(255,255,255);

    }  
}



class EditionsCotisationsAttSituation extends Controller {
 
    public function attestation_situation($employeur_id)
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        $employeur = Employeur::find($employeur_id);
        if(!$employeur) exit();
        $nom_directeur=Parametre::where('ref','=','EDI_NOM_DIRECTEUR')->first()->value;
        $civilite_directeur=Parametre::where('ref','=','EDI_CIVILITE_DIRECTEUR')->first()->value;

        //Paramètres
        $param_EDI_LIEU=Parametre::where('ref','=','EDI_LIEU')->first()->value;
        $param_EDI_SIGNATAIRE=Parametre::where('ref','=','EDI_SIGNATAIRE')->first()->value;
        $param_EDI_CLR=Parametre::where('ref','=','EDI_CLR')->first()->value;


        $t_mois=[1=>"Jan",2=>"Fév",3=>"Mar",4=>"Avr",5=>"Mai",
            6=>"Jun",7=>"Jui",8=>"Aoû",9=>"Sep",10=>"Oct",11=>"Nov",12=>"Déc"];

        $date=date('d/m/Y');
        $service="SERVICE DE RECOUVREMENT";
        $titre="ATTESTATION";
        $nom_fichier="Attestation cotisation simple N°".$employeur_id.".pdf";
        $ref_modele="EDI_CORPS_COTIS_ATT";
        
        $corps="Présente la situation suivante vis à vis de la caisse";

        //Création de la page
        $fpdf = new PDF_AttSitu();
        $fpdf->SetParametres();
        $fpdf->setParam_EDI_CLR($param_EDI_CLR);
        $fpdf->set_titre($titre);
        $fpdf->set_service($service);
        $fpdf->set_user($user);
        $fpdf->AddPage();

        //Corps
        $h=5;
        $fpdf->ln(10);
        $depY=$fpdf->GetX();
        $depX=10;
        $fpdf->SetX($depX);
        $fpdf->SetFont('Times','B',14);
        $fpdf->Cell(200,$h,utf8_decode("l'Entreprise ".$employeur->nom),0,1,'C');

        $fpdf->SetFont('Times','',12);
        $txt="Inscrite comme employeur sous le numéro : ".$employeur->id;
        $txt.="\ndomiciliée à : ".trim($employeur->adresse)."\n";
        $txt.=($employeur->ile=="F")?"98600 FUTUNA":"98600 WALLIS";
        $txt=utf8_decode($txt);
        $fpdf->MultiCell(200,$h,$txt,0,'C');

        $fpdf->Cell(200,$h,utf8_decode("Présente la situation suivante vis-à-vis de la Caisse"),0,"",'C');
            

        $fpdf->ln(10);
        $fpdf->SetX($depX);
        $fpdf->SetFont('Times','BU',12);
        $txt=utf8_decode("1) Pour le trimestre exigible :");
        $fpdf->Cell(100,$h,$txt,0,"1",'L');
        $fpdf->ln(5);

        //Liste des Paiements
        $depX=20;$fpdf->SetX($depX);
        $h=7;
        $fpdf->SetFont('Times','B',12);
       $w=array(60,35,40,40);
        $col_def=array('Période'=> $w[0],'Nbre de salariés' => $w[1],'Cotisations dues' => $w[2]
                ,"Cotisations réglées" =>$w[3]);

        foreach($col_def as $name=>$l) $fpdf->Cell($l,$h,utf8_decode($name),"LRTB",0,'C');
        $k=0;            
        $fpdf->SetFont('Times','',10);

        //1et trimestre de l'année
        $date=date('Y-m-d');
        $annee=date('Y');
        $mois=date('m');
        $trimestre_encours=ceil($mois/3);
        $trimestre_exigible=($trimestre_encours==1)?"4":($trimestre_encours-1);
        $annee_exigible=($trimestre_encours==1)?($annee-1):$annee;
        $moisjour="";
        $periode_fin="";
        if($trimestre_exigible==1) {$moisjour="-01-01";$periode_fin=$annee."-10-01";}
        if($trimestre_exigible==2) {$moisjour="-04-01";$periode_fin=$annee."-07-01";}
        if($trimestre_exigible==3) {$moisjour="-07-01";$periode_fin=$annee."-04-01";}
        if($trimestre_exigible==4) {$moisjour="-10-01";$periode_fin=$annee."-01-01";}
        $periode_deb=$annee_exigible.$moisjour;

        //liste des id pour enlever du tableau 2
        $lst_cotis_exig=array();
        $cotiss=Cotisation::where('sonum','=',$employeur->id)
            ->select('id')
            ->where('mois','>=',$periode_deb)
            ->distinct('mois','>=',$periode_deb)->get();
        foreach($cotiss as $cotis) $lst_cotis_exig[]=$cotis->id;


        $cotiss=Cotisation::where('sonum','=',$employeur->id)
            //->select('date','mois','nbmois','nbsal',DB::raw('SUM(debit) as debit'),DB::raw('SUM(debit) as credit'))
            ->select('mois','nbsal',DB::raw('SUM(debit) as debit'),DB::raw('SUM(credit) as credit'))
            //->select('mois','nbsal','debit','credit')
            ->where('mois','>=',$periode_deb)->where('mois','<',$periode_fin)
            ->groupBy('mois','nbsal')
            ->orderby('mois','DESC')
            ->get();


            foreach($cotiss as $cotis) {
                $fpdf->ln(7);
                $i=0;
                $depX=20;$fpdf->SetX($depX);
                $bordure="BLRT";
                $nb_mois=$cotis->nbmois;
                $date=$cotis->mois;
                $annee=substr($date,6,4);
                $mois=substr($date,3,2);
                $lst_mois="";
                for($j=0;$j<$nb_mois;$j++) {
                    $lst_mois.=(($lst_mois=="")?"":"-").$t_mois[$mois+$j];
                }
                $periode=$trimestre_exigible.(($trimestre_exigible==1)?'er':'e')." trimestre ".$annee_exigible;
                $fpdf->Cell($w[$i++],$h,utf8_decode($periode),$bordure,0,'C');
                $fpdf->Cell($w[$i++],$h,$cotis->nbsal,$bordure,0,'C');
                $fpdf->Cell($w[$i++],$h,number_format($cotis->debit,0,","," "),$bordure,0,'C');
                $fpdf->Cell($w[$i++],$h,number_format($cotis->credit,0,","," "),$bordure,0,'C');
                
            }
            $fpdf->SetFont('Times','',12);
            $fpdf->ln(5);

        $depX=10;
        $fpdf->ln(10);
        $fpdf->SetX($depX);
        $fpdf->SetFont('Times','BU',12);
        $txt=utf8_decode("2) Tableau récapitulatif des 4 trimestres précédents :");
        $fpdf->Cell(100,$h,$txt,0,1,'L');
        $fpdf->ln(3);


        $fpdf->SetFont('Times','B',12);
        $fpdf->SetX($depX);
        $w=array(40,30,45,45,30);
        $col_def=array('Période'=> $w[0],'Nbre de Mois' => $w[1],'Cotisations dues' => $w[2]
                ,"Cotisations réglées" =>$w[3],"Nbre de salariés" =>$w[4]);
        foreach($col_def as $name=>$l) $fpdf->Cell($l,$h,utf8_decode($name),"LRTB",0,'C');
        $k=0;            
        $fpdf->SetFont('Times','',10);

        $periode_fin=$periode_deb;
        $periode_deb=($annee_exigible-1).$moisjour;
        
        $cotiss=Cotisation::where('sonum','=',$employeur->id)
            ->select('mois','nbsal','nbmois',
                DB::raw('SUM(debit) as debit'),
                DB::raw('SUM(debit) as credit')
                )
            //->where('date','<=',$periode_fin)
            ->where('mois','>=',$periode_deb)
            ->whereNotIn('id',$lst_cotis_exig)
            ->groupby('mois','nbsal','nbmois')
            ->orderby('mois','DESC')
            ->get();
        /*$cotiss=Cotisation::where('sonum','=',$employeur->id)
            ->select('mois','nbsal','nbmois','debit','credit')
            ->where('mois','>=',$periode_deb)
            ->whereNotIn('id',$lst_cotis_exig)
            ->orderby('mois','DESC')
            ->get();*/

//dd($periode_fin);
        foreach($cotiss as $cotis) {
            $fpdf->ln(7);
            $k++;$i=0;
            $depX=10;$fpdf->SetX($depX);
            $bordure="BLRT";
            $date=$cotis->mois;
            $annee=substr($date,6,4);
            $mois=substr($date,3,2);
            $trimestre=ceil($mois/3);
            $nb_mois=$cotis->nbmois;
            $lst_mois="";
            for($j=0;$j<$nb_mois;$j++) {
                $lst_mois.=(($lst_mois=="")?"":"-").$t_mois[$mois+$j];
            }
            $periode=$trimestre.(($trimestre==1)?'er':'e')." trimestre ".$annee;
            $fpdf->Cell($w[$i++],$h,$periode,$bordure,0,'C');
            $fpdf->Cell($w[$i++],$h,utf8_decode($nb_mois),$bordure,0,'C');
            $fpdf->Cell($w[$i++],$h,number_format($cotis->debit,0,","," "),$bordure,0,'C');
            $fpdf->Cell($w[$i++],$h,number_format($cotis->credit,0,","," "),$bordure,0,'C');
            $fpdf->Cell($w[$i++],$h,$cotis->nbsal,$bordure,0,'C');
        }

        //Lieu
        $fpdf->ln(30);
         $fpdf->SetFont('Times','',12);
        $depX=20;$fpdf->SetX($depX);
        $fpdf->Cell(70,$h,utf8_decode("Fait à ".$param_EDI_LIEU." le ".date('d/m/Y')),0,0,'L');
        $fpdf->Cell(70,$h,$param_EDI_SIGNATAIRE,0,0,'R');

        $fpdf->Output($nom_fichier,"I");
        exit();
    }



}