<?php namespace App\Http\Controllers\Editions;

use App\Http\Controllers\Controller;
use Auth\AuthController;
use Illuminate\Support\Facades\Auth;
use App\Models\Beneficiaire;
use App\Models\User;
use App\Models\Role2;
use App\Models\Parametre;
use App\Models\Cotisation;
use App\Models\Employeur;
use App\Models\Salaire;

use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Redirect;
use View;
use DB;

use Codedge\Fpdf\Fpdf\Fpdf;


class PDF_recu extends FPDF
{
    var $Titre="";
    var $param_EDI_CLR="";
    var $user="";

    function setParam_EDI_CLR($param_EDI_CLR) { $this->param_EDI_CLR=$param_EDI_CLR;}
    function set_titre($titre) { $this->titre=$titre;}
    function set_user($user) { $this->user=$user;}

    public function setParametres()
    {
        
        
    }


    function Footer()
    {
        //Titre
        $this->SetFont("Arial",'',7);
        $this->SetY(285);
        $this->SetX(2);
        //$fpdf->Line(1,100,1,180);
        $this->Cell(60,7,utf8_decode("Edité par ".$this->user->nom),"T",0,'L');
        $this->Cell(100,7,"CPSWF - BP 125 MATA UTU - 98600 WALLIS - TEL : 72.01.20","T",0,'C');
        $this->Cell(40,7,$this->PageNo(),"T",0,'R');        
    }



    function Header()
    {
        $depX=10;
        $this->SetX($depX);
        $img_x=10;
        $img_y=10;
        $this->Image(url('img/logo_cpswf_imp.png'),$img_x,$img_y,40);

        $depX=10;$depY=25;$l=60;$h=4;
        $this->SetFont('Arial','',9);
        
        $this->SetXY($depX,$depY);
        $this->MultiCell($l,$h,utf8_decode($this->param_EDI_CLR),"",'L');  
        $depY=$this->GetY();
        $this->SetXY($depX,$depY);

        //Titre Service
        $depX=130;
        $h=7;
        $this->SetX($depX);
        $this->SetFont('Arial','',12);
        $this->Cell(65,$h,date('d/m/Y'),"",2,'R');
        $this->Cell(65,$h,utf8_decode("Edité par : ".$this->user->nom),'',"2",'R');

        $this->SetFont('Arial','',14);
        $this->ln(5);
        $this->SetX(55);
        $this->Cell(105,$h,$this->titre,"","",'C',"");
        $img_x=105-(135/2);
        $img_y=$this->GetY()-3;
        $this->Image(url('img/bloc_adresse2.png'),$img_x,$img_y,135,13);

    }  
}


class EditionsCotisationsOrdre extends Controller {
    public function ordre($cotisation_id)
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        $cotisation=Cotisation::find($cotisation_id);
        if(!$cotisation_id) exit();
        $employeur=Employeur::find($cotisation->sonum);
        $date=date('d/m/Y');
        $police="Arial";
 
        //Paramètres
        $param_EDI_LIEU=Parametre::where('ref','=','EDI_LIEU')->first()->value;
        $param_EDI_SIGNATAIRE=Parametre::where('ref','=','EDI_SIGNATAIRE')->first()->value;
        $param_EDI_CLR=Parametre::where('ref','=','EDI_CLR')->first()->value;

        $nom=$employeur->nom;
        $adresse=$employeur->adresse;
        $cp=$employeur->cp." ".$employeur->ile;

        $titre="ORDRE DE RECETTE A ENCAISSER";
        $nom_fichier="Ordre_A_Encaisser N°".$cotisation_id.".pdf";


        $periode_dep=$cotisation->mois;
        $periode_fin=$cotisation->mois;
        $nb_mois=$cotisation->nbmois;
        $nb_salaries=$cotisation->nbsal;
        $num_bdx=($cotisation->bdx==0)?$cotisation->bdx_prive:$cotisation->bdx;

        //Création de la page
        $fpdf = new PDF_recu();
        $fpdf->SetParametres();
        $fpdf->setParam_EDI_CLR($param_EDI_CLR);
        $fpdf->set_titre($titre);
        $fpdf->set_user($user);
        $fpdf->AddPage();

        //Cadre
        $y=$fpdf->GetY();$h=120;
        $x=10;$l=190;
        $fpdf->Rect($x,$y+15,$l,$h);

        //Recu N°
        $h=7;$posx=20;
        $fpdf->SetFont($police,'',14);
        $fpdf->ln(20);
        $fpdf->SetX(55);
        $fpdf->SetFillColor(204, 230, 255);
        $fpdf->Cell(110,$h,utf8_decode("Ordre N° :".$cotisation->id." du ".$cotisation->date),"1","",'C',"1");
        $fpdf->SetFillColor(255, 255, 255);

        //Employeur
        $fpdf->ln(20);
        $fpdf->SetFont($police,'UB',10);
        $depX=$posx;$fpdf->SetX($depX);
        $fpdf->Cell(44,$h,utf8_decode("N°Employeur / Société : "),0,0,'L');
        $fpdf->SetFont($police,'',10);
        $fpdf->Cell(10,$h,str_pad($employeur->id,5,"0"),0,2,'L');
        $fpdf->SetFont($police,'',10);
        $depX=$posx+44;$fpdf->SetX($depX);
        $fpdf->Cell(65,$h-2,utf8_decode($employeur->nom),0,2,'L');
        $fpdf->SetFont($police,'',9);
        $fpdf->Cell(65,$h-2,utf8_decode($employeur->adresse),0,2,'L');
        $fpdf->Cell(65,$h-2,utf8_decode($employeur->cp." ".$employeur->ile),0,1,'L');


        //Montant
        $fpdf->ln(10);
        $fpdf->SetFont($police,'B',10);
        $depX=$posx;$fpdf->SetX($depX);
        $fpdf->Cell(45,$h,utf8_decode("Doit un Montant de : "),0,0,'L');
        $fpdf->SetFont($police,'',10);
        $fpdf->Cell(35,$h,number_format($cotisation->debit,0,","," ")." CFP",0,2,'L');

        $fpdf->ln(10);
        $depX=$posx;$fpdf->SetX($depX);
        $fpdf->SetFont($police,'B',10);
        $fpdf->Cell(44,$h,utf8_decode("Pour la période du "),0,0,'L');
        $fpdf->SetFont($police,'',10);
        $fpdf->Cell(20,$h,$periode_dep,0,0,'L');
        $fpdf->SetFont($police,'B',10);
        $fpdf->Cell(20,$h,"sur ",0,0,'C');
        $fpdf->SetFont($police,'',10);
        $fpdf->Cell(20,$h,$nb_mois." mois",0,2,'L');

        $fpdf->ln(10);
        $fpdf->SetFont($police,'',10);
        $depX=$posx;$fpdf->SetX($depX);
        $fpdf->SetFont($police,'B',10);
        $fpdf->Cell(44,$h,utf8_decode("Nombre de salariés : "),0,0,'L');
        $fpdf->SetFont($police,'',10);
        $fpdf->Cell(20,$h,$nb_salaries,0,0,'L');
        $fpdf->SetFont($police,'B',10);
        $fpdf->Cell(30,$h,utf8_decode("N° Bordereau : "),0,0,'L');
        $fpdf->SetFont($police,'',10);
        $fpdf->Cell(20,$h,str_pad($num_bdx,2,"0",STR_PAD_LEFT),0,2,'L');

        $fpdf->ln(10);
        $fpdf->SetFont($police,'',10);
        $depX=$posx;$fpdf->SetX($depX);
        $fpdf->Cell(50,$h,utf8_decode("Sur le compte de la Caisse des Prestations Sociales des îles de Wallis et Futuna."),0,0,'L');

        //Detail
        $fpdf->ln(15);
        $fpdf->SetFont($police,'UB',10);
        $depX=$posx;$fpdf->SetX($depX);
        $fpdf->Cell(65,$h,utf8_decode("Observations : "),"",2,'L');
        $fpdf->ln(5);
        $fpdf->SetFont($police,'',10);
        $depX=$posx;$fpdf->SetX($depX);
        $fpdf->MultiCell(65,$h,utf8_decode($cotisation->observation),0,'L');


        //Date
        $fpdf->ln(5);
        $fpdf->SetFont($police,'',10);
        $depX=$posx;$fpdf->SetX($depX);
        $fpdf->Cell(65,$h,utf8_decode("Fait à MATA UTU, le  : ").$date,"",2,'L');
        
        //Gestionnaire / VISA
        $fpdf->ln(10);
        $fpdf->SetFont($police,'B',10);
        $depX=$posx;$fpdf->SetX($depX);
        $fpdf->Cell(95,$h,"Gestionnaire","",0,'L');
        $fpdf->Cell(65,$h,utf8_decode("Visa du service de la comptabilité"),"",1,'L'); 
        $fpdf->SetX($depX);
        $fpdf->SetFont($police,'',10);
        $fpdf->Cell(85,$h,$user->nom,"",0,'L');


        $fpdf->Output($nom_fichier,"I");
        exit();
    }
}