<?php namespace App\Http\Controllers\Editions;

use Auth\AuthController;
use Illuminate\Support\Facades\Auth;
use App\Models\Mandat;
use App\Models\Creancier;
use App\Models\Imputation;
use App\Models\Banque;
use App\Models\User;
use App\Models\Role2;
use App\Models\Versement;
use App\Models\Versement_b;
use App\Models\Parametre;
use App\Models\Employeur;
use App\library\Numbers_Words_fr;

use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Redirect;
use View;
use DB;

use Codedge\Fpdf\Fpdf\Fpdf;



class PDF_mandat extends FPDF
{
    var $Titre="";
    var $user_nom="";
    var $banque_nom="";
    var $num_bordereau="";
    var $suite="";
    var $param_EDI_CLR="";
    var $param_EDI_LIEU="";
    var $param_EDI_SIGNATAIRE="";
    var $nom_directeur="";
    var $civilite_directeur=""; 
    var $modele="";
    var $exercice="";
     var $compte_CLR="";

    function setModele($modele) { $this->modele=$modele;}
    function setCompte_CLR($compte_CLR) { $this->compte_CLR=$compte_CLR;}
    function setExercice($exercice) { $this->exercice=$exercice;}
    function setTitre($titre) { $this->Titre=$titre;}
    function setIdentifiant($identifiant) { $this->identifiant=$identifiant;}
    function setUserNom($user_nom) { $this->user_nom=$user_nom;}
    function setBanqueNom($banque_nom) { $this->banque_nom=$banque_nom;}
    function setNumBordereau($num_bordereau) { $this->num_bordereau=$num_bordereau;}
    function setSuite($suite) { $this->suite=$suite;}
    function setParam_EDI_CLR($param_EDI_CLR) { $this->param_EDI_CLR=$param_EDI_CLR;}
    function setParam_EDI_LIEU($param_EDI_LIEU) { $this->param_EDI_LIEU=$param_EDI_LIEU;}
    function setParam_EDI_SIGNATAIRE($param_EDI_SIGNATAIRE) { $this->param_EDI_SIGNATAIRE=$param_EDI_SIGNATAIRE;}
    function setNom_directeur($nom_directeur) { $this->nom_directeur=$nom_directeur;}
    function setCivilite_directeur($civilite_directeur) { $this->civilite_directeur=$civilite_directeur;}


    public function setParametres()
    {
        //Paramètres
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        $this->setUserNom($user->FullName);
        $this->setNom_directeur(Parametre::where('ref','=','EDI_NOM_DIRECTEUR')->value('value'));
        $this->setCivilite_directeur(Parametre::where('ref','=','EDI_CIVILITE_DIRECTEUR')->value('value'));
        $this->setParam_EDI_LIEU(Parametre::where('ref','=','EDI_LIEU')->value('value'));
        $this->setParam_EDI_SIGNATAIRE(Parametre::where('ref','=','EDI_SIGNATAIRE')->value('value'));
        $this->setParam_EDI_CLR(Parametre::where('ref','=','EDI_CLR')->value('value'));
    }


    function Footer()
    {
        if($this->modele=="") {
            $this->Line(5,282,205,282);
            $this->SetY(-15);
            $this->SetFont('Arial','I',8);
            $this->Cell(15,7,utf8_decode("Edité par ".$this->user_nom. "le ".date('d/m/Y h:i:s')),"",0,'L');
            $this->Cell(0,10,'Page '.$this->PageNo(),0,0,'C');
        }
        if($this->modele=="mandat_ordre_pmt_imp") {
            $this->SetFont('Arial','BU',12);
            $depX=7;$depY=143;$l=93;$h=7;$h2=23;
            $this->SetXY($depX,$depY);
            $this->SetFont('Arial','',8);
            $this->Cell($l,$h,utf8_decode("Désignation du créancier"),"TLR",2,'L');
            $this->SetFont('Arial','BI',12);
            $this->Cell($l,$h,utf8_decode(" M.le Directeur des Finances Publiques ./."),"BLR",2,'L');
            $this->SetFont('Arial','',8);
            $this->Cell($l,$h,utf8_decode("Pièces justificatives de la dépense :"),"TLR",2,'L');
            $this->Cell($l,$h2,"","BLR",2,'L');

            $this->Cell($l,$h,utf8_decode("Compte à créditer :"),"TLR",2,'L');
            $this->Cell($l,$h/2,utf8_decode("(Virement dans un établissement de crédit ou chez un comptable du"),"LR",2,'L');
            $this->Cell($l,$h/2,utf8_decode("Trésor)"),"LR",2,'L');
            $this->Cell($l,$h+$h+2,"","BLR",2,'L');
            $this->Cell($l,$h-2,"","TLR",2,'L');
            $this->Cell($l,$h/2,utf8_decode("A servir seulement en cas de virement postal."),"LR",2,'L');
            $this->Cell($l,$h/2,utf8_decode("Objet du virement :)"),"LR",2,'L');
            $this->Cell($l,$h,"","LR",2,'L');
            $this->Cell($l,$h,utf8_decode("COMPTE A CREDITER - Bénéficiaire :)"),"LR",2,'L');
            $this->Cell($l,$h,"","LR",2,'L');
            $this->Cell($l,$h/2,utf8_decode("C/c postal:)"),"LR",2,'L');
            $this->Cell($l,$h/2,utf8_decode("Centre de chèques postaux :"),"LR",2,'L');
            $this->Cell($l,$h2+$h-2,"","BLR",2,'L');
            $this->SetFont('Times','',7);
            $this->Cell($l,$h/2,utf8_decode("1 ) Nom , prénoms, adresse omplète.Pour les sociétés :"),"",2,'L');
            $this->Cell($l,$h/2,utf8_decode("raison sociale exacte."),"",2,'L');

            $this->SetFont('Arial','BU',12);
            $depX=100;$l=100;$h=10;$h2=39;
            $this->SetXY($depX,$depY);
            $this->SetFont('Arial','',8);
            $this->Cell($l/2,$h,utf8_decode("Montant brut de l'ordonnancement :"),"TLR",0,'L');
            $this->Cell($l/2,$h,"","BTLR",1,'L');
            $this->SetX($depX);
            $this->Cell($l,$h,utf8_decode(" Somme nette à payer ou à virer(2)"),"LR",2,'L');
            $this->SetFont('Arial','',9);
            $this->Cell($l,$h,utf8_decode("Arrêter par nous le présent mandat de paiement à la somme de :"),"LR",2,'L');
            $this->Cell($l,$h2,"","LR",2,'L');
            $this->Cell($l,$h/2,"","LR",2,'L');
            $this->Cell($l,$h/2,"","TLR",2,'L');
            $this->SetFont('Arial','',8);
            $this->Cell($l,$h/2,utf8_decode("A servir dans tous les cas de paiement par virement."),"LR",2,'L');
            $this->Cell($l,$h-3,"","LR",2,'L');

            $this->Cell($l,$h,utf8_decode("COMPTE A CREDITER - Bénéficiaire :)"),"LR",2,'L');
            $this->Cell($l,$h/2+1,"","LR",2,'L');
            $this->Cell($l,$h/2,utf8_decode("Compte courant postal:)"),"LR",2,'L');
            $this->Cell($l,$h/2,utf8_decode("Centre de chèques postaux ou"),"LR",2,'L');
            $this->Cell($l,$h/2,utf8_decode("Etablissement mandataire"),"LR",2,'L');
            $this->Cell($l,$h/2,"","LR",2,'L');
            $this->Cell($l,$h/2,utf8_decode("Agence de "),"LR",2,'L');
            $this->Cell($l,$h/2,utf8_decode("Compte"),"LR",2,'L');
            $this->Cell($l,$h/2,"","BLR",2,'L');

            $this->SetXY(65,$depY+74.5);
            $this->SetFont('Arial','IB',12);
            $this->SetFillColor(255,255,255);
            $this->Cell(70,$h-5,"PAIEMENT PAR VIREMENT","",2,'C',1);

        }
    }


    function Adress()
    {
        //Zone Entete adresse
        if($this->modele=="") {
            $this->SetFont('Arial','',10);
            $depX=10;$depY=10;
            $this->SetXY($depX,$depY);
            $this->MultiCell(82,4,utf8_decode($this->param_EDI_CLR),'','L');
            $this->SetXY(20,20);
        }
        if($this->modele=="mandat_ordre_pmt_imp") {

        }

    }

    function Identifiant()
    {
        //Zone Entete adresse
        $this->SetFont('Arial','B',13);
        $depX=150;$depY=30;
        $this->SetXY($depX,$depY);
        $this->Cell(45,10,utf8_decode($this->identifiant),'1','0','C');
    }

    function Filigranne()
    {
        //Filigranne
        //if($this->num_bordereau==0)
        //for($d1=25;$d1<200;$d1+=60)
        //   for($d2=9;$d2<290;$d2+=80)
        //        $this->Image(url('img/draft.gif'),$d1,$d2,50);
    }

    function Header()
    {
        //adresse
        if($this->modele=="") {
            $this->Adress();
            $this->Identifiant();
            $depX=20;$depY=60;
            $this->SetXY($depX,$depY);
            $this->SetFont('Arial','B',14);
            $this->SetFillColor(153 , 204, 255);
            $this->Cell(175,10,utf8_decode($this->Titre." ".$this->suite),1,1,'C',1);
            $this->Ln(20);
            $this->suite=" (suite)";
        }
        if($this->modele=="mandat_ordre_pmt_imp") {
            $this->SetFont('Arial','BU',12);
            $depX=7;$depY=7;$l=43;$h=7;
            $this->SetXY($depX,$depY);
            //$this->MultiCell($l,$h,utf8_decode($this->param_EDI_CLR),'','2','C');
            $this->Cell($l,$h,utf8_decode("CAISSE DE"),"LRT",2,'C');
            $this->Cell($l,$h,utf8_decode("PRESTATIONS"),"LR",2,'C');
            $this->Cell($l,$h,utf8_decode("SOCIALES"),"LR",2,'C');
            $this->Cell($l,$h,"","LR",2,'C');
            $this->Cell($l,$h,utf8_decode($this->compte_CLR),"LR",2,'C');
            $this->Cell($l,$h,"","LRB",2,'C');

            $depX=50;$depY=7;$l=100;
            $this->SetXY($depX,$depY);
            $this->SetFont('Arial','',10);
            $this->Cell($l,10,utf8_decode("TERRITOIRE DES ILES WALLIS ET FUTUNA"),"TLR",2,'C');
            $this->SetFont('Arial','B',14);
            $this->Cell($l,10,utf8_decode($this->Titre),"LR",2,'C');
            $this->SetFont('Arial','B',10);
            $this->Cell($l,10,utf8_decode("EXERCICE ".$this->exercice),"LR",2,'C');
            $this->SetFont('Arial','',8);
            $this->Cell($l,4,utf8_decode("En vertu des crédits ouverts au titre du chapitre désigné ci-contre,"),"LR",2,'L');
            $this->Cell($l,4,utf8_decode("l'ordonnateur soussigné mandate sur la caisse du Préposé du"),"LR",2,'L');
            $this->Cell($l,4,utf8_decode("Trésor des Iles Wallis et Futuna.u"),"LBR",2,'L');
            
            $this->SetFont('Arial','BU',12);
            $depX=150;$depY=7;$l=50;$h=8;$h2=4.5;
            $this->SetXY($depX,$depY);
            //$this->MultiCell($l,$h,utf8_decode($this->param_EDI_CLR),'','2','C');
            $this->SetFont('Arial','',8);
            $this->Cell($l/2,$h,utf8_decode("Ministere du C.S."),"LRT",0,'C');
            $this->Cell($l/2,$h,"","BTR",1,'C');
            $this->SetX($depX);
            $this->Cell($l/2,$h,utf8_decode("Ordonnateur"),"LR",0,'C');
            $this->Cell($l/2,$h,"","BTR",1,'C');
            $this->SetX($depX);
            $this->Cell($l/2,$h2,utf8_decode("Mois et exercice"),"LR",0,'C');
            $this->Cell($l/2,$h2,"","TR",1,'C');
            $this->SetX($depX);
            $this->Cell($l/2,$h2,utf8_decode("et d'émission ..."),"LR",0,'C');
            $this->Cell($l/2,$h2,"","BR",1,'C');
            $this->SetX($depX);
            $this->Cell($l/2,$h2,utf8_decode("N° du bordereau"),"LR",0,'C');
            $this->Cell($l/2,$h2,"","TR",1,'C');
            $this->SetX($depX);
            $this->Cell($l/2,$h2,utf8_decode("d'émission"),"LR",0,'C');
            $this->Cell($l/2,$h2,"","BR",1,'C');
            $this->SetX($depX);
            $this->Cell($l/2,$h,utf8_decode("N° du Mandat"),"LBR",0,'C');
            $this->Cell($l/2,$h,"","BTR",1,'C');
        }
         if($this->modele=="mandat_bordereau_rglmt") {
            $this->SetFont('Arial','B',9);
            $depX=7;$depY=7;$l=43;$h=5;
            $this->SetXY($depX,$depY);
            //$this->MultiCell($l,$h,utf8_decode($this->param_EDI_CLR),'','2','C');
            $this->Cell($l,$h,utf8_decode("Comptable"),"LRT",2,'L');
            $this->Cell($l,$h,utf8_decode("Paierie de Mata-utu"),"LR",2,'L');
            $this->Cell($l,$h,utf8_decode("Wallis"),"BLR",2,'L');
            $this->Cell($l,$h,utf8_decode("CCP PARIS"),"LR",2,'L');
            $this->Cell($l,$h,utf8_decode("9000 34D           1.63"),"RL",2,'L');
            $posY=$this->GetY();
            $this->Line($depX+15,$posY,48,$posY);
            $this->SetFont('Arial','',7);
            $this->Cell($l,$h,utf8_decode("                0.00"),"LRB",0,'C');
            /* ********** */
            $depX=$this->GetX();$depY=7;$l=114;$h=4;
            $this->SetXY($depX,$depY);
            $this->SetFont('Arial','B',10);
            $this->Cell($l,$h,utf8_decode($this->Titre),"TLR",2,'C');
            $this->SetFont('Arial','',9);
            $this->Cell($l,$h+2,"","LR",2,'C');
            $this->Cell($l,$h,utf8_decode("                    Virements postaux"),"LR",2,'L');
            $this->Cell($l,$h,utf8_decode("                    Virements bancaires"),"LR",2,'L');
            $this->Cell($l,$h,utf8_decode("                    Virements chez un comptable du trésor"),"LR",2,'L');
            $this->Cell($l,$h,utf8_decode("                    chèques sur le trésor"),"LR",2,'L');
            $this->Cell($l,$h,utf8_decode("                    ordres de paiement"),"BLR",0,'L');
            /* ********** */
            $depX=$this->GetX();$depY=7;$l=18;$l2=25;$h=4;
            $this->SetXY($depX,$depY);
            $this->SetFont('Arial','',7);
            $this->Cell($l,$h,"","TLR",0,'C');
            $this->Cell($l2,$h,utf8_decode("N°du Bordereau"),"TLR",2,'C');
            $this->SetXY($depX,$depY);
            $this->Cell($l,$h*4,"","TLR",0,'C');
            $this->Cell($l2,$h*4,"","TLRB",2,'C');
            $this->SetX($depX);
            $this->Cell($l,$h*4-2,"","TLRB",0,'C');
            $this->Cell($l2,$h*4-2,utf8_decode("N°du Feuillet"),"TLRB",2,'C');
            /* ***** */
            $this->SetFont('Arial','',9);
            $depX=7;$l=43;$h=5;$depY=$h*8-3;
            $h=4;
            $w=[17,70,45,25,18,25];
            $this->SetXY($depX,$depY);
            //$this->MultiCell($l,$h,utf8_decode($this->param_EDI_CLR),'','2','C');
            $this->Cell($w[0],$h,utf8_decode("NUMERO"),"LR",0,'L');
            $this->Cell($w[1],$h,utf8_decode("DESIGNATION DES CREANCIERS"),"LR",0,'L');
            $this->Cell($w[2],$h,utf8_decode("SOMME NETTE LIQUIDEE"),"LR",0,'L');
            $this->Cell($w[3],$h,utf8_decode("RETENUES"),"LR",0,'L');
            $this->Cell($w[4],$h,utf8_decode("NET"),"LR",0,'L');
            $this->Cell($w[5],$h,utf8_decode("Observations"),"LR",2,'L');
            /* lg */
            $this->SetXY($depX,$depY+$h);
            $this->SetFont('Arial','',8);
            $this->Cell($w[0],$h,"","LR",0,'L');
            $this->Cell($w[1],$h,utf8_decode("        Comptes à créditer"),"LR",0,'L');
            $this->Cell($w[2],$h,utf8_decode("au profit de chaque créancier"),"LR",0,'L');
            $this->Cell($w[3],$h,utf8_decode("faites par le"),"LR",0,'L');
            $this->Cell($w[4],$h,utf8_decode("à payer"),"LR",0,'L');
            $this->Cell($w[5],$h,"","LR",2,'L');
            /* lg */
            $this->SetXY($depX,$depY+2*$h);
            $this->SetFont('Arial','',8);
            $this->Cell($w[0],$h,"","LRB",0,'L');
            $this->Cell($w[1],$h,"","LRB",0,'L');
            $this->Cell($w[2],$h,"","LRB",0,'L');
            $this->Cell($w[3],$h,utf8_decode("comptable"),"LRB",0,'L');
            $this->Cell($w[4],$h,"","LRB",0,'L');
            $this->Cell($w[5],$h,"","LRB",2,'L');
        }
        
    }  


}

/* ************* Editions *************** */
class EditionsMandatsController extends Controller {

    public function mandat_imputation($imputation_id)
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );       
        $imputation=Imputation::find($imputation_id);
        $creanciers=Creancier::where('idimp_mdt','=',$imputation_id)->get();
        $mandat=Mandat::find($imputation->idmandat);
        $mandat_id=$mandat->id;
        $font="Arial";
        //Document
        $titre="IMPUTATION ";
        $identifiant="MANDAT N°".$mandat_id;
        $nom_fichier="imputation_ccpf_".$mandat_id;
        $type=trim($imputation->type_imp);
        //Calcul du montant
        $montant=0;
        foreach($creanciers as $creancier) {$montant+=$imputation->creancier;}

        $montant=$imputation->montant;
        //Total en lettre
        $nw = new Numbers_Words_fr();
        $montant_lettre=ucfirst($nw->toWordsDec($montant,"CFP"));
        
        //CLR,CPF,,AVI,ASE .... CLS,CPS
        $compte="";
        if($type=="CPS") {
            $titre.="CCPF";
            $compte="10071/98700/00001000006/67";
        }
        if($type=="CLR") {
            $titre.="CCPF";
            $compte="10071/98700/00001000006/67";
        }
        if(($type=="AVI")||($type=="CSR")) {
            $titre.="CCPF";
            $compte="10071/98700/00001000006/67";
        }
        if($type=="ASE") {
            $titre.="CCPF";
            $compte="10071/98700/00001000006/67";
        }
        //Création de la page
        $fpdf = new PDF_mandat();

        //Zone Entete adresse
        $fpdf->SetParametres();
        $fpdf->setIdentifiant($identifiant);
        $fpdf->setTitre($titre);

        $fpdf->AddPage();

        //Zone Entete adresse
        $fpdf->SetFont('Arial','B',12);
        $depX=50;$depY=80;
        $fpdf->SetXY($depX,$depY);
        $fpdf->Cell(105,10,utf8_decode("Le Directeur de la C.P.S.W.F"),'0','2','C');
        $fpdf->Cell(105,10,utf8_decode("à"),'0','2','C');
        $fpdf->Cell(105,10,utf8_decode("M.le Directeur des Finances Publiques"),'0','2','C');
        $fpdf->ln();
        $fpdf->SetFont($font,'',11);
        $depX=20;$fpdf->SetX($depX);
        $txt="Par débit du compte ".$compte." ouvert dans vos livres au nom";
        $fpdf->Cell(200,7,utf8_decode($txt),'0','2','L');
        $txt="de la CCPF, je vous saurai obligé de bien vouloir créditer le(s) compte(s) ci-après pour un total de :";
        $fpdf->Cell(200,7,utf8_decode($txt),'0','2','L');
        $fpdf->Cell(40,10,"    ".number_format($montant,0,","," ")." CFP soit : ",'0','0','L');
        $fpdf->MultiCell(105,10,utf8_decode($montant_lettre),'0','L');

        //Tableau
        //Liste des Paiements
        $font_size=10;
        $depX=20;$fpdf->SetX($depX);
        $h=5;
        $fpdf->SetFont($font,'B',$font_size);
        $w=array(50,50,50,30);
        $col_def=array('Créancier'=> $w[0],'Banque' => $w[1],'Compte' => $w[2]
                ,'Montant' =>$w[3]);
        $fpdf->SetFillColor(135,206,250);
        foreach($col_def as $name=>$l) $fpdf->Cell($l,$h,utf8_decode($name),"LRTB",0,'C',1);
        $k=0;            
        $fpdf->SetFont($font,'',10);
        $nb=count($creanciers);
        $montant_total=0;$depX=20;
        foreach($creanciers as $creancier) {
            $fpdf->ln($h);
            $k++;$i=0;
            $fpdf->SetX($depX);
            if($nb==$k) $bordure="BLR";
            else $bordure="LR";
            $fpdf->Cell($w[$i++],$h,$creancier->NomComplet,$bordure,0,'C');
            $fpdf->Cell($w[$i++],$h,$creancier->banque,$bordure,0,'C');
            $fpdf->Cell($w[$i++],$h,$creancier->compte,$bordure,0,'C');
            $fpdf->Cell($w[$i++],$h,number_format($creancier->montant,0,","," "),$bordure,0,'C');
            $montant_total+=$creancier->montant;
        }
        $montant_euro=$montant_total*0.00838;
        $montant_euro=round($montant_euro,2);

        //Dernier total
        $fpdf->ln($h);
        $fpdf->SetX($depX);
        $fpdf->Cell($w[0]+$w[1],$h,utf8_decode("Nombre de créanciers : ")." ".$nb,0,'L');
        $fpdf->SetFont($font,'B',$font_size);
        $fpdf->Cell($w[2],$h,"TOTAL CFP :","1",0,'R');
        $fpdf->SetFont($font,'B',$font_size);
        $fpdf->Cell($w[3],$h,number_format($montant_total,0,","," "),"TBLR",1,'R',1);
        $fpdf->SetX($depX);
        $fpdf->Cell($w[0]+$w[1],$h," ",0,'L');
        $fpdf->Cell($w[2],$h,"TOTAL Euros :","1",0,'R');
        $fpdf->SetFont($font,'B',$font_size);
        $fpdf->Cell($w[3],$h,number_format($montant_euro,2,","," "),"TBLR",2,'R',1);
  
        //Fin
        $fpdf->SetFont($font,'',12);

        //Lieu
        $fpdf->ln(20);
        $depX=20;$fpdf->SetX($depX);
        $fpdf->Cell(70,$h,$fpdf->param_EDI_LIEU.", le ".date('d/m/Y'),"",0,'L');
        $fpdf->Cell(60,$h,"Le Comptable","",0,'L');
        $fpdf->Cell(60,$h,"Le Directeur","",0,'L');

        //$fpdf->Cell($w[7],$h,number_format($tot["montant_eur"],0,","," ")." ".chr(128),"TBLR",0,'L',1);
        $fpdf->ln(5);

        //$fpdf->setTitre($titre);

        $fpdf->Output($nom_fichier.".pdf","I");
        exit();
    }


    public function mandat_ordre_pmt_imp($mandat_id)
    {
            
        dd('mandat_ordre_pmt_imp');
        //Création de la page
        $fpdf = new PDF();
        $fpdf->setTitre($nom_titre);

        $fpdf->Output("paiement_imputation.pdf","I");
        exit();
    }


    public function mandat_mandat_pmt_imp($mandat_id,$creancier_id="")
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' ); 
        $date=date('d/m/Y');      

        //$creanciers=Creancier::where('idimp_mdt','=',$imputation_id)->get();
        $mandat=Mandat::find($mandat_id);
        if($creancier_id=="") $imputations=Imputation::where('idmandat','=',$mandat_id)->get();
        else {
            $creancier=Creancier::find($creancier_id);
            $imputations=Imputation::where('id','=',$creancier->idimp_mdt)->get();
        }
        $font="Arial";
        //Document
        $titre="MANDAT DE PAIEMENT";
        $identifiant="MANDAT N°".$mandat_id;
        $nom_fichier="imputation_ccpf_".$mandat_id;
        $Param_EDI_CLR="CAISSE DE PRESTATIONS FAMILIALES";
        $compte_CLR="C.1 000 006/64";

        //Création de la page
        $fpdf = new PDF();
        
        //Zone Entete adresse
        $fpdf->SetParametres();
        $fpdf->setModele("mandat_ordre_pmt_imp");
        $fpdf->setExercice($mandat->exercice);
        $fpdf->setIdentifiant($identifiant);
        $fpdf->setParam_EDI_CLR($Param_EDI_CLR);
        $fpdf->setCompte_CLR($compte_CLR);
        $fpdf->setTitre($titre);
        $fpdf->AddPage();

        //Ordonateur
        $h=9;
        $depX=175;$depY=15;$l=35;
        $fpdf->SetXY($depX,$depY);
        $fpdf->SetFont('Arial','',10);
        $ordonnateur="9300";
        $mois_exercice=$mandat->exercice."/".substr($mandat->date_sai,3,2);
        $fpdf->Cell($l,$h,utf8_decode($ordonnateur),"L",2,'L');
        $fpdf->Cell($l,$h,$mois_exercice,"L",2,'L');
        $fpdf->Cell($l,$h,$mandat->id,"L",2,'L');
        $fpdf->Cell($l,$h,$mandat->id,"L",0,'L');
               
        //Objet
        $fpdf->ln(20);$h=10;
        $depX=7;$depY=49;$l=143;$l2=25;$l3=25;
        $fpdf->SetXY($depX,$depY);
        $fpdf->SetFont('Arial','BU',12);
        $fpdf->Cell($l,$h,utf8_decode("Objet de la dépense :"),"L",0,'L');
        $fpdf->SetFont('Arial','B',10);
        $fpdf->Cell($l2,$h,"Chap. et art.","BLR",0,'L');
        $fpdf->Cell($l3,$h,"Sommes","BLR",2,'L');
        $fpdf->SetFont('Arial','',10);
        
        $h=7;$k=0;$montant_total=0;
        foreach($imputations as $imputation) {
            $k++;
            $fpdf->SetX($depX);
            $fpdf->Cell($l,$h,utf8_decode($imputation->designation),"LR",0,'L');
            $fpdf->Cell($l2,$h,$imputation->cpt_imp,"LR",0,'L');
            $fpdf->Cell($l3,$h,number_format($imputation->montant,0,","," "),"LR",2,'L');
            $montant_total+=$imputation->montant;
        }
        for($j=$k;$k<12;$k++) 
        {
            $fpdf->SetX($depX);
            $fpdf->Cell($l,$h,"","LR",0,'L');
            $fpdf->Cell($l2,$h,"","LR",0,'L');
            $fpdf->Cell($l3,$h,"","LR",2,'L');
        }

        $fpdf->SetX($fpdf->GetX()-$l2);
        $fpdf->Cell($l2,$h+3," ","LR",0,'L');
        $fpdf->Cell($l3,$h+3,number_format($montant_total,0,","," "),"LR",2,'L');
        

        //Total en lettre
        $fpdf->ln(20);$posX=$depX+95;$l1=95;
        $fpdf->SetX($posX);
        $nw = new Numbers_Words_fr();
        $montant_lettre=ucfirst($nw->toWordsDec($montant_total,"CFP"));
        $fpdf->SetFont('Arial','',10);
        $libelle=number_format($montant_total,0,","," ")." CFP soit : ".$montant_lettre;
        $fpdf->MultiCell($l1,$h,utf8_decode($libelle),"",'L');
        $fpdf->ln(3);
        $fpdf->SetX($posX);
        $fpdf->Cell($l1,$h,utf8_decode("Emis à Mata-Utu, le ").$date,"",2,'L');
        $fpdf->SetX($posX);
        $fpdf->Cell($l1,$h,"L'ordonnateur ","",2,'C');
        $fpdf->ln(7);$fpdf->SetX($posX);
        $fpdf->SetFont('Arial','B',12);
        $fpdf->Cell($l1,$h,utf8_decode("M. ".$fpdf->nom_directeur),"",2,'C');

        //Lieu
        /*
        $fpdf->ln(20);$h=7;
        $depX=20;$fpdf->SetX($depX);
        $fpdf->Cell(70,$h,$fpdf->param_EDI_LIEU.", le ".date('d/m/Y'),"",0,'L');
        $fpdf->Cell(60,$h,"Le Comptable","",0,'L');
        $fpdf->Cell(60,$h,"Le Directeur","",0,'L');
        */
        $fpdf->Output("mandat_paiement_".$mandat_id.".pdf","I");
        exit();
    }

    public function mandat_bordereau_rglmt($creancier_id)
    {
        
        if(!($user=Auth::user())) return Redirect::route( 'login' ); 
        $date=date('d/m/Y');     

        $creancier=Creancier::find($creancier_id); 
        $mandat=Mandat::find($creancier->idmandat);
        $imputations=Imputation::where('id','=',$creancier->idimp_mdt)->get();

        $font="Arial";
        //Document
        $titre="BORDEREAU DES REGLEMENTS A EFFECTUER";
        $Param_EDI_CLR="CAISSE DE PRESTATIONS FAMILIALES";
        $compte_CLR="C.1 000 006/64";

        //Création de la page
        $fpdf = new PDF();
        
        //Zone Entete adresse
        $fpdf->SetParametres();
        $fpdf->setModele("mandat_bordereau_rglmt");
        $fpdf->setExercice($mandat->exercice);
        //$fpdf->setIdentifiant($identifiant);
        $fpdf->setParam_EDI_CLR($Param_EDI_CLR);
        $fpdf->setCompte_CLR($compte_CLR);
        $fpdf->setTitre($titre);
        $fpdf->AddPage();
        $fpdf->setAutoPageBreak(false,5);
        /* Corps */
        /* ***** */
        /* Numero bordereau */
        $fpdf->SetXY(185,10);
        $fpdf->Cell(20,7,$mandat->id,"",0,'L');

        $fpdf->SetFont('Arial','',9);
        $depX=7;$l=43;$depY=49;$h=10;
        $w=[17,70,45,25,18,25];
        $fpdf->SetXY($depX,$depY);
        /* lg */
        $fpdf->SetFont('Arial','',8);
        $fpdf->Cell($w[0],$h,"","LR",0,'L');
        $fpdf->Cell($w[1],$h,"","LR",0,'L');
        $fpdf->Cell($w[2],$h,"","LR",0,'L');
        $fpdf->Cell($w[3],$h,"","LR",0,'L');
        $fpdf->Cell($w[4],$h,"","LR",0,'L');
        $fpdf->Cell($w[5],$h,"","LR",2,'L');
        //Banque
        $fpdf->SetX($depX);
        $fpdf->SetFont('Arial','BU',11);
        $fpdf->Cell($w[0],$h,"","LR",0,'L');
        $fpdf->Cell($w[1],$h,utf8_decode($creancier->banque),"LR",0,'L');
        $fpdf->Cell($w[2],$h,"","LR",0,'L');
        $fpdf->Cell($w[3],$h,"","LR",0,'L');
        $fpdf->Cell($w[4],$h,"","LR",0,'L');
        $fpdf->Cell($w[5],$h,"","LR",2,'L');
        //Creancier
        $fpdf->SetFont('Arial','',9);
        $fpdf->SetX($depX);
        $fpdf->Cell($w[0],$h,"","LR",0,'L');
        $fpdf->Cell($w[1],$h,utf8_decode($creancier->nom_complet),"LR",0,'L');
        $fpdf->Cell($w[2],$h,number_format($creancier->montant,0,","," "),"LR",0,'C');
        $fpdf->Cell($w[3],$h,"","LR",0,'L');
        $fpdf->Cell($w[4],$h,"","LR",0,'L');
        $fpdf->Cell($w[5],$h,"","LR",2,'L');
        //Compte
        $fpdf->SetFont('Arial','B',8);
        $fpdf->SetX($depX);
        $fpdf->Cell($w[0],$h,"","LR",0,'L');
        $fpdf->Cell($w[1],$h,utf8_decode($creancier->compte),"LR",0,'L');
        $fpdf->Cell($w[2],$h,"","LR",0,'C');
        $fpdf->Cell($w[3],$h,"","LR",0,'L');
        $fpdf->Cell($w[4],$h,"","LR",0,'L');
        $fpdf->Cell($w[5],$h,"","LR",2,'L');
        for($j=0;$j<15;$j++) {
            $fpdf->SetFont('Arial','B',9);
            $fpdf->SetX($depX);
            $fpdf->Cell($w[0],$h,"","LR",0,'L');
            $fpdf->Cell($w[1],$h,"","LR",0,'L');
            $fpdf->Cell($w[2],$h,"","LR",0,'C');
            $fpdf->Cell($w[3],$h,"","LR",0,'L');
            $fpdf->Cell($w[4],$h,"","LR",0,'L');
            $fpdf->Cell($w[5],$h,"","LR",2,'L');
        }
        $h=7;
        $fpdf->SetX($depX);
        $fpdf->Cell($w[0],$h,"","TLR",0,'L');
        $fpdf->SetFont('Arial','B',9);
        $fpdf->Cell($w[1],$h,"TOTAL CFP","T",0,'R');
        $fpdf->SetFont('Arial','',9);
        $fpdf->Cell($w[2],$h,number_format($creancier->montant,0,","," "),"TLR",0,'C');
        $fpdf->Cell($w[3],$h,"","TLR",0,'L');
        $fpdf->Cell($w[4],$h,"","TLR",0,'L');
        $fpdf->Cell($w[5],$h,"","TLR",2,'L');

        $fpdf->SetX($depX);
        $fpdf->Cell($w[0],$h,"","BLR",0,'L');
        $fpdf->SetFont('Arial','B',9);
        $fpdf->Cell($w[1],$h,"TOTAL EURO","B",0,'R');
        $fpdf->SetFont('Arial','',9);
        $fpdf->Cell($w[2],$h,number_format($creancier->MontantEuro,2,","," "),"BLR",0,'C');
        $fpdf->Cell($w[3],$h,"","BLR",0,'L');
        $fpdf->Cell($w[4],$h,"","BLR",0,'L');
        $fpdf->Cell($w[5],$h,"","BLR",2,'L');

        $h=5;$depX+=15;
        $txt="Le destinataire du présent bordereau est invité à prendre les dispositions nécessaires pour l'exécution des";
        $fpdf->SetX($depX);
        $fpdf->Cell(190,$h,utf8_decode($txt),"",2,'L');

        $txt="virements ci-dessous dont le montant total est indiqué colonne 5.";
        $fpdf->SetX($depX);
        $fpdf->Cell(190,$h,utf8_decode($txt),"",2,'L');

        $txt="Centre des chèques postaux de ..............chèque n° joint.";
        $fpdf->ln();
        $fpdf->SetX($depX);
        $fpdf->Cell(190,$h,utf8_decode($txt),"",2,'L');
        
        $txt="Destin.Banque de ..............................succursale";
        $fpdf->SetX($depX);
        $fpdf->Cell(150,$h,utf8_decode($txt),"",0,'L');
         $fpdf->Cell(10,$h,"Le","",2,'R');
        
        $txt="Trésorerie Générale de ....................................................................";
        $fpdf->SetX($depX);
        $fpdf->Cell(190,$h,utf8_decode($txt),"",2,'L');
        
        $txt="12 130 N°6";
        $fpdf->ln();
        $fpdf->SetX($depX);
        $fpdf->SetFont('Arial','BI',11);
        $fpdf->Cell(50,$h,utf8_decode($txt),"",2,'C');
        



        $fpdf->Output("mandat_bordereau_rglmt_".$mandat->id.".pdf","I");
        exit();
    }

    public function mandat_mandat_pmt_cre($mandat_id)
    {
            
        dd('mandat_mandat_pmt_cre');
        //Création de la page
        $fpdf = new PDF();
        $fpdf->setTitre($nom_titre);

        $fpdf->Output("mandat_paiement_creanciers.pdf","I");
        exit();
    }

    public function mandat_mandat_annulation($mandat_id)
    {
        
        //Création de la page
        $fpdf = new PDF();
        $fpdf->setTitre($nom_titre);

        $fpdf->Output("mandat_annulation.pdf","I");
        exit();
    }

}

