<?php namespace App\Http\Controllers\Editions;

use Illuminate\Support\Facades\Auth;
use App\Http\Controllers\Controller;
use Auth\AuthController;
use App\Models\Banque;
use App\Models\Beneficiaire;
use App\Models\User;
use App\Models\Role2;
use App\Models\Versement;
use App\Models\Parametre;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Redirect;
use View;
use DB;
use Mail;


class ExportVersementsController extends Controller {
    private $menu='versements';
    private $submenu='versements_generation_definitive';
    private $menu_home="allocations";

    public function __construct()
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );

        $this->submenu="export";
        if($type=="ALL") {$this->menu_home="allocations";}
        if($type=="RET") {$this->menu_home="retraites";}
        if($type=="SOC") {$this->menu_home="aides_sociales";}
        if($type=="SAV") {$this->menu_home="aides_sociales";$this->menu="versements_csr";$this->submenu="export";}
    }


    public function index_export_fichier($type,$num_imp)
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );

        $versements=Versement::where('type','=',$type)->where('num_imp','=',$num_imp)->get();

        return View::make('prestations.versements.export_fichier', [
            'user' => $user,'menu' => $this->menu,'submenu' => $this->submenu,'menu_home' => $this->menu_home,
            'type'=>$type,
            'num_imp'=>$num_imp,
            'versements' => $versements,
        ]);
    }




    /* Exportation du fichier BWF */
    // public function export_fichier(Request $request,$type,$num_imp)
    // {
    //     if(!($user=Auth::user())) return Redirect::route( 'login' );
    //      $date=$request->date_export;
    //     $designation=$request->designation;
    //     $compte_cpswf=$request->compte;

    //     $date=substr($date,0,2).substr($date,3,2).substr($date,9,1);
    //     
    //     $versements=Versement::where('type','=',$type)
    //         ->where('num_imp','=',$num_imp)
    //         ->where("bqcleunik","=","1")
    //         ->get();
    //     $date_deb=DB::table('versem')->where('type','=',$type)
    //         ->where('num_imp','=',$num_imp)
    //         ->orderby('date')
    //         ->first()->date;

    //     $nom_file="";
    //     $nb_lignes=0;
    //     //Génération du fichier
    //     $nomfile="CPSWF_versements_".$type."_".substr($date_deb,0,6).".txt";;
    //     $path="./upload/bwf/".$type;
    //     //création du dossier
    //     if(!file_exists($path)) {
    //         mkdir($path,'0777',true);
    //         chmod($path, '0755');
    //     }
    //     if(!file_exists($path)) {
    //         $message_err="Impossible de créer le fichier.";
    //     } else {
    //         $path_nom_file=$path."//".$nomfile;
    //         //ecriture du fichier
    //         $nb_lignes=$this->ecriture_file($path_nom_file,$versements,$date,$designation,$compte_cpswf);
    //     }

    //     $t_email=array();

    //     return View::make('prestations.versements.export_fichier', [
    //         'user'=>$user,
    //         'type'=>$type,
    //         'nom_file'=>$nomfile,
    //         'path_nom_file'=>$path_nom_file,
    //         'nb_lignes'=>$nb_lignes,
    //         'versements' => $versements,
    //         'num_imp' => $num_imp,
    //         't_email' => $t_email,
    //     ]);
    // }


    // public function ecriture_file($path_nom_file,$versements,
    //     $date,$designation,$compte_cpswf)
    // {
    //     $fl="\r\n";
    //     $fp = @fopen($path_nom_file, 'w');
    //     if(!$fp) return false;

    //     //ecriture des lignes
    //     $j=0;
    //     $montant_total=0;
    //     $nb_lignes_total=count($versements);

    //     $line="";$j=1;
    //     $line=$this->getLigne_debut($date,$designation,$compte_cpswf);
    //     fwrite($fp, $line.$fl);
    //     foreach ($versements as $versement) {
    //         $montant_total+=$versement->montant;
    //         $j++;
    //         $line=$this->getLigne($versement,$j);
    //         fwrite($fp, $line.$fl);
    //     }
    //     $line=$this->getLigne_fin($montant_total,$j).$fl;
    //     fwrite($fp, $line);
    //     fclose($fp);
    //     return $j;
    // }

    // public function getLigne($versement,$i)
    // {
    //     $beneficiaire=Beneficiaire::find($versement->benum);
    //     $nom=$beneficiaire->nom;
    //     //if($i=='228') {
    //         //if(strlen($nom)>24) $nom=mb_substr($nom,0,24, 'UTF-8');
    //     $nom=$this->str_to_noaccent($nom);
    //     $nom=utf8_encode($nom);
    //     if(strlen($nom)>24) $nom=substr($nom,0,24);

    //     /* ANCIENS COMPTES
    //     $compte=$versement->compte;
    //     if(strlen($compte)>11) $compte=substr($compte,0,11);
    //     $line="";
    //     $code_enregistrement="06";
    //     $code_operation="02";
    //     $code_guichet="06960";
    //     $code_banque="11408";
    //     */
    //     /* NOUVEAU COMPTE */
    //     $code_guichet="";
    //     $code_banque="";
    //     $line="";
    //     $code_enregistrement="06";
    //     $code_operation="02";
    //     $compte=$versement->compte;
    //     if(strlen($compte)>=21) {
    //         $code_guichet=substr($compte,5,5);
    //         $code_banque=substr($compte,0,5);
    //         $compte=substr($compte,10,11);
    //     }
    //     //dd($versement->compte." => ".$code_banque."-".$code_guichet."-".$compte);
    //     $libelle="";
    //     if($versement->type=="ALL") $libelle="ALLOCATIONS";
    //     if($versement->type=="RET") $libelle="RETRAITES";
    //     if($versement->type=="SOC") $libelle="AIDES SOCIALES";

    //     $line.=$code_enregistrement;//Code enregistrement L:2
    //     $line.=$code_operation;//Code opération L:2
    //     $line.=str_pad($i+1, 8, "0", STR_PAD_LEFT);//Zone réservée L:8
    //     $line.=str_pad("0", 6, "0", STR_PAD_LEFT);//Numéro d'émetteur ou d'ident. pour le virement particulier code 22 L:6
    //     $line.=str_pad($versement->benum, 12, "0", STR_PAD_LEFT);;//Référence
    //     $line.=str_pad($nom, 24, " ");//Nom/Raison sociale du bénéficiaire L:24
    //     $line.=str_pad("B.W.F.", 24, " ");//Domiciliation L:24
    //     $line.=str_pad(" ", 8, " ");//Déclaration à la balance des paiements L:8
    //     $line.=$code_guichet;//Code guichet de la banque qui tient le compte du L:5
    //     $line.=str_pad($compte, 11, "0", STR_PAD_LEFT);//Numéro de compte du bénéficiaire L:11
    //     $line.=str_pad($versement->montant, 16, "0", STR_PAD_LEFT);//Montant L:16
    //     $line.=str_pad($libelle, 31, " ");//Libellé L:31
    //     $line.=$code_banque;//Code établissement de la banque L:5
    //     $line.=str_pad(" ", 6, " ");//Zone réservée L:6
    //     return $line;
    // }


    // public function getLigne_debut($date,$designation,$compte_cpswf)
    // {
    //     $compte=$compte_cpswf;//"03900200176";
    //     if(strlen($compte)>11) $compte=substr($compte,0,11);
    //     $guichet="06960";
    //     $banque="11408";
    //     $reference="2121101";
    //     $nom=$designation;//"CCPF";
    //     $line="03";//03
    //     $line.="02";//02
    //     $line.=str_pad("1", 8, "0", STR_PAD_LEFT);
    //     $line.=str_pad("0", 6, "0", STR_PAD_LEFT);
    //     $line.=str_pad("0", 1, "0", STR_PAD_LEFT);
    //     $line.=str_pad("1", 6, "0", STR_PAD_LEFT);
    //     $line.=str_pad($date, 5, "0", STR_PAD_LEFT);//"000000000000006028";
    //     $line.=str_pad($nom, 24, " ");//CCPF
    //     $line.=str_pad($reference, 7, " "); //Reference de la remise
    //     $line.=str_pad(" ", 17, " ");
    //     $line.=str_pad(" ", 2, " ");
    //     $line.=" ";
    //     $line.=str_pad("", 5, " ");
    //     $line.=$guichet;//Code guichet                                     ";
    //     $line.=$compte;//Compte
    //     $line.=str_pad("", 16, " ");
    //     $line.=str_pad("", 31, " ");
    //     $line.=$banque;  //11408
    //     $line.=str_pad(" ", 6, " ");//Zone réservée L:6
    //     return $line;

    // }

    // public function getLigne_fin($montant_total,$i)
    // {
    //         $line="";
    //         $line.="08";//Code enregistrement L:2
    //         $line.="02";//Code opération L:2
    //         $line.=str_pad($i+1, 8, "0", STR_PAD_LEFT);//Zone réservée L:8
    //         $line.=str_pad("0", 6, "0", STR_PAD_LEFT);//Numéro d'émetteur ou d'ident. pour le virement particulier code 22 L:6
    //         $line.=str_pad(" ", 12, " ");
    //         $line.=str_pad(" ", 24, " ");
    //         $line.=str_pad(" ", 24, " ");
    //         $line.=str_pad(" ", 8, " ");
    //         $line.=str_pad(" ", 5, " ");
    //         $line.=str_pad(" ", 11, " ");
    //         $line.=str_pad($montant_total, 16, "0", STR_PAD_LEFT);;//
    //         $line.=str_pad("", 31, " ");
    //         $line.=str_pad("", 5, " ");
    //         $line.=str_pad("", 6, " ");
    //         return $line;
    // }


    /* ****************************** */
    /* TRESOR PUBLIC - BWF            */
    /* ****************************** */
    // public function index_export_fichier_BWFTP($type,$num_imp)
    // {
    //     if(!($user=Auth::user())) return Redirect::route( 'login' );
    //     $versements=Versement::where('type','=',$type)->where('num_imp','=',$num_imp)->get();

    //     return View::make('prestations.versements.export_fichier_BWFTP', [
    //         'user'=>$user,
    //         'type'=>$type,
    //         'num_imp'=>$num_imp,
    //         'versements' => $versements,
    //     ]);
    // }

    // /* Exportation du fichier Tp */
    // public function export_fichier_BWFTP(Request $request,$type,$num_imp)
    // {
    //     if(!($user=Auth::user())) return Redirect::route( 'login' );
    //     $date=$request->date_export;
    //     $designation=$request->designation;
    //     $compte_cpswf=$request->compte;

    //     $date=substr($date,0,2).substr($date,3,2).substr($date,8,2);
    //     $versements=Versement::where('type','=',$type)
    //         ->where('num_imp','=',$num_imp)
    //         ->where("bqcleunik","=","1")
    //         ->get();
    //     $date_deb=DB::table('versem')->where('type','=',$type)
    //         ->where('num_imp','=',$num_imp)
    //         ->orderby('date')
    //         ->first()->date;

    //     $nom_file="";
    //     $nb_lignes=0;
    //     //Génération du fichier
    //     $nomfile="CPSWF_versements_BWF_".$type."_".substr($date_deb,0,6).".txt";;
    //     $path="./upload/tresor_public/".$type;
    //     //création du dossier
    //     if(!file_exists($path)) {
    //         mkdir($path,'0777',true);
    //         chmod($path, '0755');
    //     }
    //     if(!file_exists($path)) {
    //         $message_err="Impossible de créer le fichier.";
    //     } else {
    //         $path_nom_file=$path."//".$nomfile;
    //         //ecriture du fichier
    //         $nb_lignes=$this->ecriture_file_TP($path_nom_file,$versements,$date,$designation,$compte_cpswf);
    //     }

    //     $t_email=array();

    //     return View::make('prestations.versements.export_fichier_BWFTP', [
    //         'user'=>$user,
    //         'type'=>$type,
    //         'nom_file'=>$nomfile,
    //         'path_nom_file'=>$path_nom_file,
    //         'nb_lignes'=>$nb_lignes,
    //         'versements' => $versements,
    //         'num_imp' => $num_imp,
    //         't_email' => $t_email,
    //     ]);
    // }


    /* ****************************** */
    /* TRESOR PUBLIC */
    /* ****************************** */
    public function index_export_fichier_TP($type,$num_imp)
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );

        $versements=Versement::where('type','=',$type)->where('num_imp','=',$num_imp)->get();
        return View::make('prestations.versements.export_fichier_TP', [
            'user' => $user,'menu' => $this->menu,'submenu' => $this->submenu,'menu_home' => $this->menu_home,
            'type'=>$type,
            'num_imp'=>$num_imp,
            'versements' => $versements,
        ]);
    }

    /* Exportation du fichier Tp */
    public function export_fichier_TP(Request $request,$type,$num_imp)
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );

        $date=$request->date_export;
        $designation=$request->designation;
        $compte_cpswf=$request->compte;

        $date=substr($date,0,2).substr($date,3,2).substr($date,8,2);
        $versements=Versement::where('type','=',$type)
            ->where('num_imp','=',$num_imp)
            //->where("bqcleunik","<>","2") //SAUF BWF
            ->whereNotIn("bqcleunik",["0","1","58"]) //SAUF Aucune, Aucune Futuna, BWF
            ->get();
        $date_deb=DB::table('versem')->where('type','=',$type)
            ->where('num_imp','=',$num_imp)
            ->orderby('date')
            ->first()->date;

        $nom_file="";
        $nb_lignes=0;
        //Génération du fichier
        $nomfile="CPSWF_versements_".$type."_".substr($date_deb,0,6).".txt";;
        $path="./upload/tresor_public/".$type;
        //création du dossier
        if(!file_exists($path)) {
            mkdir($path,'0777',true);
            chmod($path, '0755');
        }
        if(!file_exists($path)) {
            $message_err="Impossible de créer le fichier.";
        } else {
            $path_nom_file=$path."//".$nomfile;
            //ecriture du fichier
            $nb_lignes=$this->ecriture_file_TP($path_nom_file,$versements,$date,$designation,$compte_cpswf);
        }

        $t_email=array();

        return View::make('prestations.versements.export_fichier_TP', [
            'user' => $user,'menu' => $this->menu,'submenu' => $this->submenu,'menu_home' => $this->menu_home,
            'type'=>$type,
            'nom_file'=>$nomfile,
            'path_nom_file'=>$path_nom_file,
            'nb_lignes'=>$nb_lignes,
            'versements' => $versements,
            'num_imp' => $num_imp,
            't_email' => $t_email,
        ]);
    }

    public function ecriture_file_TP($path_nom_file,$versements,$date,$designation,$compte_cpswf)
    {
        $fl="\r\n";
        $fp = @fopen($path_nom_file, 'w');
        if(!$fp) return false;

        //ecriture des lignes
        $j=0;
        $montant_total=0;
        $nb_lignes_total=count($versements);

        $line="";$j=1;
        $line=$this->getLigne_debut_TP($date,$designation,$compte_cpswf);
        fwrite($fp, $line.$fl);
        foreach ($versements as $versement) {
            $montant_total+=$versement->montant;
            $line=$this->getLigne_TP($versement,$j,$date,$compte_cpswf);
            fwrite($fp, $line.$fl);
            $j++;
        }
        $line=$this->getLigne_fin_TP($montant_total,$j,$date,$compte_cpswf).$fl;
        fwrite($fp, $line);
        fclose($fp);
        return $j;
    }

    public function getLigne_TP($versement,$i,$date,$compte_cpswf)
    {
        if(strlen($compte_cpswf)>11) $compte_cpswf=substr($compte_cpswf,0,11);
        $banque_emet="10071"; //TP emetteur
        $guichet="98700"; //TP emetteur

        $beneficiaire=Beneficiaire::find($versement->benum);
        $nom=$beneficiaire->nom;
        $nom=$this->str_to_noaccent($nom);
        $nom=utf8_encode($nom);
        if(strlen($nom)>24) $nom=substr($nom,0,24);
        $bqcleunik=$versement->bqcleunik;
        $banque=Banque::find($bqcleunik);
        //TP ar défaut
        $compte_cli=$versement->compte;
        if(strlen($compte_cli)>=21) $compte_cli=substr($compte_cli,0,21);
        //if($bqcleunik!=2) {
            $banque_cli=substr($compte_cli,0,5);
            $guichet_cli=substr($compte_cli,5,5);
            $compte_cli=substr($compte_cli,10,11);
        //} else {
        //    $guichet_cli="98700";
        //    $banque_cli="10071";
        //    $compte_cli=substr($compte_cli,10,11);

        //}



        //if($versement->benum=="2901") {
           //17499 , 00080 , 21675902010
            //dd(strlen($compte_cli)." , ".$banque_cli." , ".$guichet_cli." , ".$compte_cli);
        //}
        $line="";
        $code_enregistrement="04";
        $code_operation="20";
        $libelle="";
        if($versement->type=="ALL") $libelle="ALLOCATIONS";
        if($versement->type=="RET") $libelle="RETRAITES";
        if($versement->type=="SOC") $libelle="AIDES SOCIALES";

        $line.=$code_enregistrement;//Lg:2 Code enregistrement
        $line.=str_pad($i+1, 6, "0", STR_PAD_LEFT);//Lg:6 N°enregistrement
        $line.=$code_operation;//Lg:2 Code opération 20
        $line.=str_pad($date, 6, "0", STR_PAD_LEFT); //Lg:6 Date de règlement
        $line.=str_pad("F", 1, "0", STR_PAD_LEFT);//Lg:1 Code Monnaie
        $line.=str_pad(" ", 4, " ", STR_PAD_LEFT);//Lg:4 inutilisés
        $line.=$banque_emet;//Lg:5 Etablissement emetteur 30001
        $line.=$guichet;//Lg:5 Guichet emetteur
        $line.=str_pad($compte_cpswf, 11, " ");//Lg:11 compte emetteur
        //$line.=str_pad("1630", 4, " ");//Lg:4 Id client 1630
        //$line.=str_pad("D", 7, " ");//Lg:7 Code application + divers
        $line.=str_pad(" ", 24, " ", STR_PAD_LEFT);//Lg:24 Nom donneur ordre
        $line.=str_pad(" ", 6, " ", STR_PAD_LEFT);//Lg:6 inutilisés
        $line.=str_pad(" ", 5, " ", STR_PAD_LEFT);//Lg:5 réservé BDF
        $line.=$banque_cli;//Lg:5 Etablissement destinataire 30001
        $line.=$guichet_cli;//Lg:5 Guichet destinataire
        $line.=str_pad($compte_cli, 11, "0", STR_PAD_LEFT);//Lg:11 Numéro de compte du destinataire
        $line.=str_pad($nom, 24, " ");//Lg:24 Nom/Raison sociale du destinataire
        $line.=str_pad(" ", 6, " ", STR_PAD_LEFT);//Lg:5 réservé BDF
        $line.=str_pad(" ", 24, " ");//Lg:24 Domiciliation
        $line.=str_pad($libelle, 32, " ");//Lg:32 Libellé
        $line.=str_pad("", 32, " ");//Lg:32 Libellé
        $line.=str_pad(" ", 10, " ", STR_PAD_LEFT);//Lg:10 inutilisés
        $line.=str_pad(" ", 2, " ", STR_PAD_LEFT);//Lg:2 Code flux
        $line.=str_pad($versement->montant, 12, "0", STR_PAD_LEFT);//Lg:12 Montant
        return $line;
    }

    public function getLigne_debut_TP($date,$designation,$compte_cpswf)
    {
        //0100000100061119E 3000130001V754T163000DFIP
        if(strlen($compte_cpswf)>11) $compte_cpswf=substr($compte_cpswf,0,11);
        $guichet="10071";
        $banque="30001";
        $nom=$designation;//"CCPF";
        $line="01";//Lg:2 Code enregistrement
        $line.="000001";//Lg:6 N° Enregistrement
        $line.=str_pad("0", 2, "0", STR_PAD_LEFT); //Lg:2 inutilisés
        $line.=str_pad($date, 6, "0", STR_PAD_LEFT); //Lg:6 Date échange
        $line.=str_pad("F", 1, "0", STR_PAD_LEFT);//Lg:1 Code Monnaie
        $line.=str_pad(" ", 4, " ", STR_PAD_LEFT);//Lg:4 inutilisés
        $line.=$banque;//Lg:5 Etablissement emetteur 30001
        $line.=$banque;//Lg:5 Guichet emetteur
        $line.=str_pad($compte_cpswf, 11, " ");//Lg:11 compte emetteur
        $line.=str_pad($designation, 24, " ", STR_PAD_RIGHT);//Lg:24 Nom donneur ordre
        $line.=str_pad(" ", 174, " ");//Lg:174 inutilisés
        return $line;

    }

    public function getLigne_fin_TP($montant_total,$i,$date,$compte_cpswf)
    {
        if(strlen($compte_cpswf)>11) $compte_cpswf=substr($compte_cpswf,0,11);
        $guichet="10071";
        $banque="30001";
        $line="";
        $line.="09";//Lg:2 Code enregistrement
        $line.=str_pad($i+1, 6, "0", STR_PAD_LEFT);//Lg:6 Numéro de l'enregistrement
        $line.="20";//Lg:2 Code opération
        $line.=str_pad($date, 6, "0", STR_PAD_LEFT); //Lg:6 Date de reglement
        $line.=str_pad("F", 1, "0", STR_PAD_LEFT);//Lg:1 Code Monnaie
        $line.=str_pad(" ", 4, " ", STR_PAD_LEFT);//Lg:4 inutilisés
        $line.=$banque;//Lg:5 Etablissement emetteur 30001
        $line.=$guichet;//Lg:5 Guichet emetteur
        $line.=str_pad($compte_cpswf, 11, " ");//Lg:11 compte emetteur
        //$line.=str_pad("1630", 4, " ");//Lg:4 Id client 1630
        //$line.=str_pad("D", 7, " ");//Lg:7 Code application + divers
        $line.=str_pad(" ", 24, " ");//Lg:24 Nom donneur ordre
        $line.=str_pad(" ", 162, " ");//Lg:174 inutilisés
        $line.=str_pad($montant_total, 12, "0", STR_PAD_LEFT);//Lg:12 Montant

        return $line;
    }



    /* ****************************** */
    /* COMPLET  NEW                   */
    /* ****************************** */
    public function index_export_fichier_complet($type,$num_imp)
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        $versements=Versement::where('type','=',$type)->where('num_imp','=',$num_imp)->get();
        return View::make('prestations.versements.export_fichier_complet', [
            'user' => $user,'menu' => $this->menu,'submenu' => $this->submenu,'menu_home' => $this->menu_home,
            'type'=>$type,
            'num_imp'=>$num_imp,
            'versements' => $versements,
        ]);
    }

    /* Exportation du fichier Tp */
    public function export_fichier_complet(Request $request,$type,$num_imp)
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );

        $date=$request->date_export;
        $designation=$request->designation;
        $compte_cpswf=$request->compte;

        $date=substr($date,0,2).substr($date,3,2).substr($date,8,2);
        $versements=Versement::where('type','=',$type)
            ->where('num_imp','=',$num_imp)
            //->where("bqcleunik","<>","2") //SAUF BWF
            //->whereNotIn("bqcleunik",["0","1","58"]) //SAUF Aucune, Aucune Futuna, BWF
            ->whereNotIn("bqcleunik",["0","58"]) //SAUF Aucune, Aucune Futuna, BWF
            ->get();
        $date_deb=DB::table('versem')->where('type','=',$type)
            ->where('num_imp','=',$num_imp)
            ->orderby('date')
            ->first()->date;

        $nom_file="";
        $nb_lignes=0;
        //Génération du fichier
        $nomfile="CPSWF_versements_".$type."_".substr($date_deb,0,6).".txt";;
        $path="./upload/tresor_public/".$type;
        //création du dossier
        if(!file_exists($path)) {
            mkdir($path,'0777',true);
            chmod($path, '0755');
        }
        if(!file_exists($path)) {
            $message_err="Impossible de créer le fichier.";
        } else {
            $path_nom_file=$path."//".$nomfile;
            //ecriture du fichier
            $nb_lignes=$this->ecriture_file_complet($path_nom_file,$versements,$date,$designation,$compte_cpswf);
        }

        $t_email=array();

        return View::make('prestations.versements.export_fichier_TP', [
            'user' => $user,'menu' => $this->menu,'submenu' => $this->submenu,'menu_home' => $this->menu_home,
            'type'=>$type,
            'nom_file'=>$nomfile,
            'path_nom_file'=>$path_nom_file,
            'nb_lignes'=>$nb_lignes,
            'versements' => $versements,
            'num_imp' => $num_imp,
            't_email' => $t_email,
        ]);
    }

    public function ecriture_file_complet($path_nom_file,$versements,$date,$designation,$compte_cpswf)
    {
        $fl="\r\n";
        $fp = @fopen($path_nom_file, 'w');
        if(!$fp) return false;

        //ecriture des lignes
        $j=0;
        $montant_total=0;
        $nb_lignes_total=count($versements);

        $line="";$j=1;
        $line=$this->getLigne_debut_complet($date,$designation,$compte_cpswf);
        fwrite($fp, $line.$fl);
        foreach ($versements as $versement) {
            $montant_total+=$versement->montant;
            $line=$this->getLigne_complet($versement,$j,$date,$compte_cpswf);
            fwrite($fp, $line.$fl);
            $j++;
        }
        $line=$this->getLigne_fin_complet($montant_total,$j,$date,$compte_cpswf).$fl;
        fwrite($fp, $line);
        fclose($fp);
        return $j;
    }

    public function getLigne_complet($versement,$i,$date,$compte_cpswf)
    {
        if(strlen($compte_cpswf)>11) $compte_cpswf=substr($compte_cpswf,0,11);
        $banque_emet="10071"; //TP emetteur
        $guichet="98700"; //TP emetteur

        $beneficiaire=Beneficiaire::find($versement->benum);
        $nom=$beneficiaire->nom;
        $nom=$this->str_to_noaccent($nom);
        $nom=utf8_encode($nom);
        if(strlen($nom)>24) $nom=substr($nom,0,24);
        $bqcleunik=$versement->bqcleunik;
        $banque=Banque::find($bqcleunik);
        //TP ar défaut
        $compte_cli=$versement->compte;
        if(strlen($compte_cli)>=21) $compte_cli=substr($compte_cli,0,21);
        //if($bqcleunik!=2) {
            $banque_cli=substr($compte_cli,0,5);
            $guichet_cli=substr($compte_cli,5,5);
            $compte_cli=substr($compte_cli,10,11);
        //} else {
        //    $guichet_cli="98700";
        //    $banque_cli="10071";
        //    $compte_cli=substr($compte_cli,10,11);

        //}



        //if($versement->benum=="2901") {
           //17499 , 00080 , 21675902010
            //dd(strlen($compte_cli)." , ".$banque_cli." , ".$guichet_cli." , ".$compte_cli);
        //}
        $line="";
        $code_enregistrement="04";
        $code_operation="20";
        $libelle="";
        if($versement->type=="ALL") $libelle="ALLOCATIONS";
        if($versement->type=="RET") $libelle="RETRAITES";
        if($versement->type=="SOC") $libelle="AIDES SOCIALES";
        if($versement->type=="SAV") $libelle="CSR";

        $line.=$code_enregistrement;//Lg:2 Code enregistrement
        $line.=str_pad($i+1, 6, "0", STR_PAD_LEFT);//Lg:6 N°enregistrement
        $line.=$code_operation;//Lg:2 Code opération 20
        $line.=str_pad($date, 6, "0", STR_PAD_LEFT); //Lg:6 Date de règlement
        $line.=str_pad("F", 1, "0", STR_PAD_LEFT);//Lg:1 Code Monnaie
        $line.=str_pad(" ", 4, " ", STR_PAD_LEFT);//Lg:4 inutilisés
        $line.=$banque_emet;//Lg:5 Etablissement emetteur 30001
        $line.=$guichet;//Lg:5 Guichet emetteur
        $line.=str_pad($compte_cpswf, 11, " ");//Lg:11 compte emetteur
        //$line.=str_pad("1630", 4, " ");//Lg:4 Id client 1630
        //$line.=str_pad("D", 7, " ");//Lg:7 Code application + divers
        $line.=str_pad(" ", 24, " ", STR_PAD_LEFT);//Lg:24 Nom donneur ordre
        $line.=str_pad(" ", 6, " ", STR_PAD_LEFT);//Lg:6 inutilisés
        $line.=str_pad(" ", 5, " ", STR_PAD_LEFT);//Lg:5 réservé BDF
        $line.=$banque_cli;//Lg:5 Etablissement destinataire 30001
        $line.=$guichet_cli;//Lg:5 Guichet destinataire
        $line.=str_pad($compte_cli, 11, "0", STR_PAD_LEFT);//Lg:11 Numéro de compte du destinataire
        $line.=str_pad($nom, 24, " ");//Lg:24 Nom/Raison sociale du destinataire
        $line.=str_pad(" ", 6, " ", STR_PAD_LEFT);//Lg:5 réservé BDF
        $line.=str_pad(" ", 24, " ");//Lg:24 Domiciliation
        $line.=str_pad($libelle, 32, " ");//Lg:32 Libellé
        $line.=str_pad("", 32, " ");//Lg:32 Libellé
        $line.=str_pad(" ", 10, " ", STR_PAD_LEFT);//Lg:10 inutilisés
        $line.=str_pad(" ", 2, " ", STR_PAD_LEFT);//Lg:2 Code flux
        $line.=str_pad($versement->montant, 12, "0", STR_PAD_LEFT);//Lg:12 Montant
        return $line;
    }

    public function getLigne_debut_complet($date,$designation,$compte_cpswf)
    {
        //0100000100061119E 3000130001V754T163000DFIP
        if(strlen($compte_cpswf)>11) $compte_cpswf=substr($compte_cpswf,0,11);
        $guichet="10071";
        $banque="30001";
        $nom=$designation;//"CCPF";
        $line="01";//Lg:2 Code enregistrement
        $line.="000001";//Lg:6 N° Enregistrement
        $line.=str_pad("0", 2, "0", STR_PAD_LEFT); //Lg:2 inutilisés
        $line.=str_pad($date, 6, "0", STR_PAD_LEFT); //Lg:6 Date échange
        $line.=str_pad("F", 1, "0", STR_PAD_LEFT);//Lg:1 Code Monnaie
        $line.=str_pad(" ", 4, " ", STR_PAD_LEFT);//Lg:4 inutilisés
        $line.=$banque;//Lg:5 Etablissement emetteur 30001
        $line.=$banque;//Lg:5 Guichet emetteur
        $line.=str_pad($compte_cpswf, 11, " ");//Lg:11 compte emetteur
        $line.=str_pad($designation, 24, " ", STR_PAD_RIGHT);//Lg:24 Nom donneur ordre
        $line.=str_pad(" ", 174, " ");//Lg:174 inutilisés
        return $line;

    }

    public function getLigne_fin_complet($montant_total,$i,$date,$compte_cpswf)
    {
        if(strlen($compte_cpswf)>11) $compte_cpswf=substr($compte_cpswf,0,11);
        $guichet="10071";
        $banque="30001";
        $line="";
        $line.="09";//Lg:2 Code enregistrement
        $line.=str_pad($i+1, 6, "0", STR_PAD_LEFT);//Lg:6 Numéro de l'enregistrement
        $line.="20";//Lg:2 Code opération
        $line.=str_pad($date, 6, "0", STR_PAD_LEFT); //Lg:6 Date de reglement
        $line.=str_pad("F", 1, "0", STR_PAD_LEFT);//Lg:1 Code Monnaie
        $line.=str_pad(" ", 4, " ", STR_PAD_LEFT);//Lg:4 inutilisés
        $line.=$banque;//Lg:5 Etablissement emetteur 30001
        $line.=$guichet;//Lg:5 Guichet emetteur
        $line.=str_pad($compte_cpswf, 11, " ");//Lg:11 compte emetteur
        //$line.=str_pad("1630", 4, " ");//Lg:4 Id client 1630
        //$line.=str_pad("D", 7, " ");//Lg:7 Code application + divers
        $line.=str_pad(" ", 24, " ");//Lg:24 Nom donneur ordre
        $line.=str_pad(" ", 162, " ");//Lg:174 inutilisés
        $line.=str_pad($montant_total, 12, "0", STR_PAD_LEFT);//Lg:12 Montant

        return $line;
    }






/* ****************** */
/* Fonctions communes */
/* ****************** */

function str_to_noaccent($str)
{
    $url = $str;
    $url = preg_replace('#Ç#', 'C', $url);
    $url = preg_replace('#ç#', 'c', $url);
    $url = preg_replace('#è|é|ê|ë#', 'e', $url);
    $url = preg_replace('#È|É|Ê|Ë#', 'E', $url);
    $url = preg_replace('#à|á|â|ã|ä|å#', 'a', $url);
    $url = preg_replace('#@|À|Á|Â|Ã|Ä|Å#', 'A', $url);
    $url = preg_replace('#ì|í|î|ï#', 'i', $url);
    $url = preg_replace('#Ì|Í|Î|Ï#', 'I', $url);
    $url = preg_replace('#ð|ò|ó|ô|õ|ö#', 'o', $url);
    $url = preg_replace('#Ò|Ó|Ô|Õ|Ö#', 'O', $url);
    $url = preg_replace('#ù|ú|û|ü#', 'u', $url);
    $url = preg_replace('#Ù|Ú|Û|Ü#', 'U', $url);
    $url = preg_replace('#ý|ÿ#', 'y', $url);
    $url = preg_replace('#Ý#', 'Y', $url);

    return ($url);
}


/*

    public function sendEmailBordereau(Request $request)
    {
        $nomfile=$request->fichier;
        $path_nom_file=$request->path_nom_file;

        //echo $nomfile." , ".$path_nom_file;


        if(!($user=Auth::user())) return Redirect::route( 'login' );
        $expediteur="philn@mail.wf";
        $destinataire="pn@mail.wf";
        $destinataire_nom="BWF";
        $nom="toto";
        $sujet='Your Reminder!';
        Mail::send('emails.reminder', ['user' => $user], function ($m) use ($user) {
            $m->from($expediteur, 'Your Application');
            $m->to($destinataire, $destinataire_nom)->subject('Your Reminder!');
        });
    }
*/

}



