<?php namespace App\Http\Controllers;

use Illuminate\Support\Facades\Auth;
use Auth\AuthController;
use App\Models\Employeur;
use App\Models\Beneficiaire;
use App\Models\Banque;
use App\Models\Beneftype;
use App\Models\Benefstatut;
use App\Models\Versement;
use App\Models\Versement_b;
use App\Models\Parametre;
use App\Models\User;
use App\Models\Role2;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Redirect;
use View;
use DB;

use Codedge\Fpdf\Fpdf\Fpdf;


class EditionsVersementsController extends Controller {
    /**
     * Liste des versements
     */

    public function imprimer_definitif($type="",$num_imp)
    {
        return $this->imprimer($type,$num_imp);
    }

    public function imprimer_brouillon($type="")
    {
        return $this->imprimer($type);
    }


    public function imprimer($type,$num_imp="")
    {
        if($type=="SOC") return $this->imprimer_soc($type,$num_imp);
        return $this->imprimer_all_ret($type,$num_imp);
    }


    public function imprimer_all_ret($type,$num_imp="")
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        
        $date=date('d/m/Y');
        $titre_doc="";
        if($type=="ALL") {
            $titre="VERSEMENT DES ALLOCATIONS";
            $titre_doc="VERSEMENT DES ALLOCATIONS";
        }
        if($type=="RET") {
            $titre="VERSEMENT DES RETRAITES";
            $titre_doc="VERSEMENT DES RETRAITES";
        }
        if($type=="SAV") {
            $titre="VERSEMENT DE LA CSR";
            $titre_doc="VERSEMENT DE LA CSR";
        }
        $nom_fichier="versements_brouillon_ N°".date("Y_m_d").".pdf";
        $font="Arial";
        $font_size=8;


        //Partage par Banque 
        if($num_imp=="") {
            $titre.=" (préparation)";
            $titre_doc.=" (préparation)";
            $versements=Versement_b::where('type','=',$type)
                ->join("beneficiaires","beneficiaires.id","=","versem_b.benum")
                ->join("banques","banques.id","=","versem_b.bqcleunik")
                ->select('beneficiaires.nom as nom','beneficiaires.prenom as prenom')
                ->select('versem_b.id as ver_id','versem_b.benum','versem_b.sonum')
                ->orderby('banques.nom','DESC')
                //->orderby('beneficiaires.ile','DESC')
                //->orderby('versem_b.sonum')
                ->orderby('beneficiaires.nom')->orderby('beneficiaires.prenom')
                ->get();
        } else {
            $titre.=" N°".$num_imp;
            $titre_doc.=" N°".$num_imp;
            $versements=Versement::where('type','=',$type)->where('num_imp','=',$num_imp)
                ->join("beneficiaires","beneficiaires.id","=","versem.benum")
                ->join("banques","banques.id","=","versem.bqcleunik")
                ->select('beneficiaires.nom as nom','beneficiaires.prenom as prenom')
                ->select('versem.id as ver_id','versem.benum','versem.sonum')
                ->orderby('banques.nom','DESC')
                //->orderby('beneficiaires.ile','DESC')
                //->orderby('versem.sonum')
                ->orderby('beneficiaires.nom')->orderby('beneficiaires.prenom')
                ->get();    

        }

        $nb_benef=0;
        $nb_ligne=0;
        $t_beneficiaires=array();
        foreach($versements as $versement_) {
            if($num_imp=="") $versement=Versement_b::find($versement_->ver_id);
            else $versement=Versement::find($versement_->ver_id);
            $beneficiaire=beneficiaire::find($versement->benum);
            $nom=trim($beneficiaire->nom);
            $prenom=trim($beneficiaire->prenom);
            $nb_enfants=$beneficiaire->NbEnfantsAlloc;
            if(strlen($nom)>21) $nom=substr($nom,0,21);
            if(strlen($prenom)>21) $prenom=substr($prenom,0,21);
            $banque=$versement->BanqueNom;
            if($versement->bqcleunik==0) $banque="ESPECES WALLIS";
            if($banque=="Aucun futuna") $banque="ESPECES FUTUNA";
                //if($beneficiaire->ile=="W") 
                //if($beneficiaire->ile=="F") 
            $t_beneficiaires["bqcleunik"][]=$versement->bqcleunik;
            $t_beneficiaires["banque"][]=$banque;
            $t_beneficiaires["benum"][]=$versement->benum;
            $t_beneficiaires["sonum"][]=$versement->sonum;
            $t_beneficiaires["nom"][]=utf8_decode($nom);
            $t_beneficiaires["prenom"][]=utf8_decode($prenom);
            $t_beneficiaires["nbenf"][]=$beneficiaire->NbEnfantsAlloc;
            $t_beneficiaires["montant_r"][]=$versement->montant_r;
            $t_beneficiaires["montant"][]=$versement->montant;
            $t_beneficiaires["montant_eur"][]=$versement->MontantEuro;
            $t_beneficiaires["compte"][]=$versement->compte;
            $t_beneficiaires["ret_type"][]=($beneficiaire->ret_type=='0')?'':$beneficiaire->ret_type;
            $nb_benef++;
        }

        //Création de la page
        $fpdf = new Fpdf();
        $fpdf->SetAutoPageBreak(false,5);
        $fpdf->AddPage();
        

        //Titre Service
        $h=7;$cadre="";
        $depX=5;
        //Titre
        $fpdf->SetFont($font,'',14);
        $fpdf->SetX($depX);
        $fpdf->SetFillColor(135,206,250);
        //$fpdf->Cell(200,$h,$titre_doc,$cadre,"1",'C',"1");


        $this->Header($fpdf,$titre_doc);

        //Liste des Versements
        $fpdf->SetX($depX);
        $fpdf->SetFont($font,'B',$font_size);
        
        $w=array(10,10,40,30,10,20,20,20,40);

         if(($type=="RET")||($type=="SAV")) {
            $col_def=array('N°BEN'=> $w[0],'N°EMP' => $w[1],
                    'NOM' => $w[2],'PRENOM' => $w[3],'TYPE' => $w[4]
                    ,'RAPPEL' => $w[5],"MNT CFP" => $w[6]
                    ,"MNT EUR" =>$w[7],"COMPTE" =>$w[8]);

            $col_def_espece=array('N°BEN'=> $w[0],'N°EMP' => $w[1],
                    'NOM' => $w[2],'PRENOM' => $w[3],'TYPE' => $w[4]
                    ,'RAPPEL' => $w[5],"MNT CFP" => $w[6]
                    ,"DATE" =>$w[7],"EMARGEMENT" =>$w[8]);


            $col_def_tresor=array('N°BEN'=> $w[0],
                'NOM' => $w[2],'PRENOM' => $w[3],'TYPE' => $w[4]
                ,'RAPPEL' => $w[5],"MNT CFP" => $w[6]
                ,"COMPTE" =>$w[8]);  

        } else {
            $col_def=array('N°BEN'=> $w[0],'N°EMP' => $w[1],
                    'NOM' => $w[2],'PRENOM' => $w[3],'ENF' => $w[4]
                    ,'RAPPEL' => $w[5],"MNT CFP" => $w[6]
                    ,"MNT EUR" =>$w[7],"COMPTE" =>$w[8]);  

            $col_def_espece=array('N°BEN'=> $w[0],'N°EMP' => $w[1],
                    'NOM' => $w[2],'PRENOM' => $w[3],'ENF' => $w[4]
                    ,'RAPPEL' => $w[5],"MNT CFP" => $w[6]
                    ,"DATE" =>$w[7],"EMARGEMENT" =>$w[8]); 

            $col_def_tresor=array('N°BEN'=> $w[0],
                'NOM' => $w[2],'PRENOM' => $w[3],'ENF' => $w[4]
                ,'RAPPEL' => $w[5],"MNT CFP" => $w[6]
                ,"COMPTE" =>$w[8]);               
        }

           
        $banque_id_old="";
        $nb_ligne=0;$nbmax_ligne=32;
        $tot=["nb_benef"=>0,"enfant"=>0,"rappel"=>0,"montant"=>0,"montant_eur"=>0,];
        //if($type=="RET") $tot=["nb_benef"=>0,"enfant"=>0,"rappel"=>0,"montant"=>0,"montant_eur"=>0,"PRE"=>0,"PRV"=>0,"PAV"=>0];
        //else 
        $tot=["nb_benef"=>0,"enfant"=>0,"rappel"=>0,"montant"=>0,"montant_eur"=>0,];

        $tot_g=["nb_benef"=>0,"cfp"=>0,"eur"=>0,"cfp_h"=>0,"eur_h"=>0,"nbenf"=>0,"nbenf_h"=>0,
            "nb_10K"=>0,"nb_5K"=>0,"nb_1K"=>0,"nb_500"=>0,
            "nb_200"=>0, //Modif 10/2021 ajout 200XPF
            "nb_100"=>0,"nb_50"=>0,"nb_20"=>0,"nb_10"=>0,

            "nb_10K_F"=>0,"nb_5K_F"=>0,"nb_1K_F"=>0,"nb_500_F"=>0,
            "nb_200_F"=>0, //Modif 10/2021 ajout 200XPF
            "nb_100_F"=>0,"nb_50_F"=>0,"nb_20_F"=>0,"nb_10_F"=>0
                ];

        $t_sstotal_type=array();$espece=false;$tresor=false;
        for($i=0;$i<$nb_benef;$i++) {
            $banque_id=$t_beneficiaires["bqcleunik"][$i];
            $espece=($t_beneficiaires["banque"][$i]=="ESPECES WALLIS")
                || ($t_beneficiaires["banque"][$i]=="ESPECES FUTUNA") ;
            $tresor=($t_beneficiaires["banque"][$i]=="TRESOR PUBLIC");

            if(($banque_id_old!=$banque_id)||($i==0)||($nb_ligne>$nbmax_ligne)) {
                if( ($i>0)&&($banque_id_old!=$banque_id) ) {
                    //Sous total
                    $this->sous_total($fpdf,$tot,$type);
                    //TABLEAU RECAP PAR BANQUE
                    if(($type=="RET")||($type=="SAV"))  {
                        if($fpdf->GetY()>230) {
                                $fpdf->AddPage();
                                $this->Header($fpdf,$titre_doc);
                        }
                        $this->Footer_types_retraites($fpdf,$tot);
                    }
                    $tot[$ret_type]=0;
                    $tot=["nb_benef"=>0,"enfant"=>0,"rappel"=>0,"montant"=>0,"montant_eur"=>0,];

                }
                if($i>0) {
                    $this->Footer($fpdf,$user);
                    $fpdf->AddPage();
                    $this->Header($fpdf,$titre_doc);
                }
                $nb_ligne=0;
                $fpdf->ln($h);
                $fpdf->SetX($depX);
                $fpdf->SetFont($font,'BU',$font_size+1);
                $fpdf->Cell(100,$h,utf8_decode($t_beneficiaires["banque"][$i]),"","1",'L',"");
                $fpdf->ln(5);
                $fpdf->SetX($depX);
                
                $fpdf->SetFont($font,'B',$font_size);
                $nom_col=$col_def;
                if($espece) $nom_col=$col_def_espece;
                if($tresor) $nom_col=$col_def_tresor;
                foreach($nom_col as $name=>$l) {
                        $fpdf->Cell($l,$h,utf8_decode($name),"LRTB",0,'C',1);
                }
                $fpdf->SetFont($font,'',$font_size);
            }
            $k=0;

            $bordure="BLR";
            $fpdf->ln($h);$fpdf->SetX($depX);
            $fpdf->Cell($w[$k++],$h,$t_beneficiaires["benum"][$i],$bordure,0,'L');
            if($tresor) {
                $k++;
                //$fpdf->Cell($w[$k++],$h,$t_beneficiaires["sonum"][$i],$bordure,0,'L');
            } else {
                $fpdf->Cell($w[$k++],$h,$t_beneficiaires["sonum"][$i],$bordure,0,'L');
            }
            $fpdf->Cell($w[$k++],$h,$t_beneficiaires["nom"][$i],$bordure,0,'L');
            $fpdf->Cell($w[$k++],$h,$t_beneficiaires["prenom"][$i],$bordure,0,'L');
            if(($type=="RET")||($type=="SAV")) {
                $fpdf->Cell($w[$k++],$h,$t_beneficiaires["ret_type"][$i],$bordure,0,'L');
            } else {
                $fpdf->Cell($w[$k++],$h,$t_beneficiaires["nbenf"][$i],$bordure,0,'L');
            }
            $fpdf->Cell($w[$k++],$h,number_format($t_beneficiaires["montant_r"][$i],0,","," "),$bordure,0,'L');
            $fpdf->Cell($w[$k++],$h,number_format($t_beneficiaires["montant"][$i],0,","," "),$bordure,0,'L');
            if($espece) {
                $fpdf->Cell($w[$k++],$h,"",$bordure,0,'L');
                $fpdf->Cell($w[$k++],$h,"",$bordure,0,'L');
            }
            elseif($tresor) {
                $k++;
                //$fpdf->Cell($w[$k++],$h,"",$bordure,0,'L');
                $fpdf->Cell($w[$k++],$h,$t_beneficiaires["compte"][$i],$bordure,0,'L');
            } 
            else {
                $fpdf->Cell($w[$k++],$h,number_format($t_beneficiaires["montant_eur"][$i],2,","," "),$bordure,0,'L');
                $fpdf->Cell($w[$k++],$h,$t_beneficiaires["compte"][$i],$bordure,0,'L');
            } 
           

            $banque_id_old=$t_beneficiaires["bqcleunik"][$i];
            $tot["nb_benef"]+=1;
            $tot["enfant"]+=$t_beneficiaires["nbenf"][$i];
            $tot["rappel"]+=$t_beneficiaires["montant_r"][$i];
            $tot["montant"]+=$t_beneficiaires["montant"][$i];
            $tot["montant_eur"]+=$t_beneficiaires["montant_eur"][$i];

            //Sous total types
            $ret_type=$t_beneficiaires["ret_type"][$i];
            if( !isset($tot[$ret_type]) ) {
                $tot[$ret_type]=0;
                $tot[$ret_type."_nb"]=0;
            }
            $tot[$ret_type]+=$t_beneficiaires["montant"][$i];
            $tot[$ret_type."_nb"]+=1;

            $bqe_terr=false;
            $banque=Banque::find($t_beneficiaires["bqcleunik"][$i]);
            if($banque) $bqe_terr=($banque->cp=="98600");
          
            $tot_g["cfp"]+=$t_beneficiaires["montant"][$i];
            $tot_g["eur"]+=$t_beneficiaires["montant_eur"][$i];

            if(!isset($tot_g[$ret_type])) {
                $tot_g[$ret_type]=0;
                $tot_g[$ret_type."_nb"]=0;
            }
            $tot_g[$ret_type]+=$t_beneficiaires["montant"][$i];
            $tot_g[$ret_type."_nb"]+=1;
            $tot_g["nb_benef"]++;
            $tot_g["cfp_h"]+=($bqe_terr)?$t_beneficiaires["montant"][$i]:0;
            $tot_g["eur_h"]+=($bqe_terr)?$t_beneficiaires["montant_eur"][$i]:0;
            $tot_g["nbenf"]+=$t_beneficiaires["nbenf"][$i];
            $tot_g["nbenf_h"]+=($bqe_terr)?$t_beneficiaires["nbenf"][$i]:0;

            //Billetage
            if( ($t_beneficiaires["banque"][$i]=='ESPECES FUTUNA')||($t_beneficiaires["banque"][$i]=='ESPECES WALLIS') ) {
                $ent_10000=(int)($t_beneficiaires["montant"][$i]/10000);
                $reste=$t_beneficiaires["montant"][$i]-($ent_10000*10000);

                $ent_5000=(int)($reste/5000);
                $reste=$reste-($ent_5000*5000);

                $ent_1000=(int)($reste/1000);
                $reste=$reste-($ent_1000*1000);

                $ent_500=(int)($reste/500);
                //AJOUT PIECES 01/2020
                $reste=$reste-($ent_500*500);

                //Modif 10/2021 ajout 200XPF
                $ent_200=(int)($reste/200);
                $reste=$reste-($ent_200*200);
                //

                $ent_100=(int)($reste/100);
                $reste=$reste-($ent_100*100);

                $ent_50=(int)($reste/50);
                $reste=$reste-($ent_50*50);

                $ent_20=(int)($reste/20);
                $reste=$reste-($ent_20*20);

                $ent_10=(int)($reste/10);
                //$reste=$reste-($ent_10*10);


                $tot_g["nb_10K"]+=$ent_10000;
                $tot_g["nb_5K"]+=$ent_5000;
                $tot_g["nb_1K"]+=$ent_1000;
                $tot_g["nb_500"]+=$ent_500;
                $tot_g["nb_200"]+=$ent_200; //Modif 200XPF 10/2021
                $tot_g["nb_100"]+=$ent_100;
                $tot_g["nb_50"]+=$ent_50;
                $tot_g["nb_20"]+=$ent_20;
                $tot_g["nb_10"]+=$ent_10;
                if($t_beneficiaires["banque"][$i]=='ESPECES FUTUNA') {
                    $tot_g["nb_10K_F"]+=$ent_10000;
                    $tot_g["nb_5K_F"]+=$ent_5000;
                    $tot_g["nb_1K_F"]+=$ent_1000;
                    $tot_g["nb_500_F"]+=$ent_500; 
                    $tot_g["nb_200_F"]+=$ent_200; //Modif 200XPF 10/2021
                    $tot_g["nb_100_F"]+=$ent_100;
                    $tot_g["nb_50_F"]+=$ent_50;
                    $tot_g["nb_20_F"]+=$ent_20;
                    $tot_g["nb_10_F"]+=$ent_10;   
                }
            }
            $nb_ligne++;
        }

        //Dernier total
        $this->sous_total($fpdf,$tot,$type);
        if(($type=="RET")||($type=="SAV"))  $this->Footer_types_retraites($fpdf,$tot);

        $this->Footer($fpdf,$user);
        $fpdf->AddPage();
        $this->Header($fpdf,$titre_doc);

               
        //Tableau TOTAL
        $this->Footer_total($fpdf,$tot_g,$type);
        //Tableau Retraite
        if(($type=="RET")||($type=="SAV"))  {
            $this->Footer_types_retraites($fpdf,$tot_g,true);
        }
        //Tableau Billetage
        $fpdf->ln(5);
        $this->Footer_billetage($fpdf,$tot_g);
        //Visas
        $this->Footer_Visas($fpdf,$user);
        

        $this->Footer($fpdf,$user);
        $fpdf->Output($nom_fichier,"I");
        exit(); 
    }




    public function imprimer_soc($type,$num_imp="")
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        
        $date=date('d/m/Y');
        $titre_doc="";
        $titre="VERSEMENT DES AIDES SOCIALES";
        $titre_doc="VERSEMENT DES AIDES SOCIALES";
        $nom_fichier="versements_brouillon_ N°".date("Y_m_d").".pdf";
        $font="Arial";
        $font_size=8;

        //Partage par Banque 
        if($num_imp=="") {
            $titre.=" (préparation)";
            $titre_doc.=" (préparation)";
            $versements=Versement_b::where('type','=',$type)
                ->join("beneficiaires","beneficiaires.id","=","versem_b.benum")
                ->join("banques","banques.id","=","versem_b.bqcleunik")
                ->select('beneficiaires.nom as nom','beneficiaires.prenom as prenom')
                ->select('versem_b.id as ver_id','versem_b.benum','versem_b.sonum')
                ->distinct()
                ->orderby('ile','DESC')
                ->orderby('district','DESC')
                ->orderby('beneficiaires.nom')->orderby('beneficiaires.prenom')
                ->get();
        } else {
            $titre.=" N°".$num_imp;
            $titre_doc.=" N°".$num_imp;
            $versements=Versement::where('type','=',$type)->where('num_imp','=',$num_imp)
                ->join("beneficiaires","beneficiaires.id","=","versem.benum")
                ->join("banques","banques.id","=","versem.bqcleunik")
                ->select('beneficiaires.nom as nom','beneficiaires.prenom as prenom')
                ->select('versem.id as ver_id','versem.benum','versem.sonum')
                ->orderby('ile','DESC')
                ->orderby('district','DESC')
                ->orderby('beneficiaires.nom')->orderby('beneficiaires.prenom')
                ->get();    

        }

        $nb_benef=0;
        $nb_ligne=0;
        $t_beneficiaires=array();
        foreach($versements as $versement_) {
            if($num_imp=="") $versement=Versement_b::find($versement_->ver_id);
            else $versement=Versement::find($versement_->ver_id);
            $beneficiaire=beneficiaire::find($versement->benum);
            $nom=trim($beneficiaire->nom);
            $prenom=trim($beneficiaire->prenom);
            $nb_enfants=$beneficiaire->NbEnfantsAlloc;
            if(strlen($nom)>21) $nom=substr($nom,0,21);
            if(strlen($prenom)>21) $prenom=substr($prenom,0,21);
            $banque=$versement->BanqueNom;
            $ile=$beneficiaire->ile;
            // Banque Espece
            if( ($ile=="W") && ($versement->bqcleunik==0)) {
                $banque="ESPECES WALLIS";
            } elseif (  ($ile=="F") && 
                        (($banque=="Aucun futuna")||($versement->bqcleunik==0))
                    )
                 {
                    $banque="ESPECES FUTUNA";
            }
            
            $district=$beneficiaire->district;
            $t_beneficiaires["bqcleunik"][]=$versement->bqcleunik;
            $t_beneficiaires["banque"][]=$banque;
            $t_beneficiaires["benum"][]=$versement->benum;
            $t_beneficiaires["sonum"][]=$versement->sonum;
            $t_beneficiaires["nom"][]=utf8_decode($nom);
            $t_beneficiaires["prenom"][]=utf8_decode($prenom);
            $t_beneficiaires["nbenf"][]=$beneficiaire->NbEnfantsAlloc;
            $t_beneficiaires["montant_r"][]=$versement->montant_r;
            $t_beneficiaires["montant"][]=$versement->montant;
            $t_beneficiaires["montant_eur"][]=$versement->MontantEuro;
            $t_beneficiaires["compte"][]=$versement->compte;
            $t_beneficiaires["ret_type"][]=$beneficiaire->ret_type;
            $t_beneficiaires["ile"][]=$ile;
            $t_beneficiaires["district"][]=$district;
            $nb_benef++;
        }



        //Création de la page
        $fpdf = new Fpdf();
        $fpdf->SetAutoPageBreak(false,5);
        $fpdf->AddPage();
        

        //Titre Service
        $h=7;$cadre="";
        $depX=5;
        //Titre
        $fpdf->SetFont($font,'',14);
        $fpdf->SetX($depX);
        $fpdf->SetFillColor(135,206,250);
        //$fpdf->Cell(200,$h,$titre_doc,$cadre,"1",'C',"1");


        $this->Header($fpdf,$titre_doc);

        //Liste des Versements
        $fpdf->SetX($depX);
        $fpdf->SetFont($font,'B',$font_size);
        
        $w=array(10,10,40,30,10,20,20,20,40);

        $col_def=array('N°BEN'=> $w[0],'N°EMP' => $w[1],
                'NOM' => $w[2],'PRENOM' => $w[3],'ENF' => $w[4]
                ,'RAPPEL' => $w[5],"MNT CFP" => $w[6]
                ,"MNT EUR" =>$w[7],"COMPTE" =>$w[8]);            


        $col_def_espece=array('N°BEN'=> $w[0],'N°EMP' => $w[1],
                'NOM' => $w[2],'PRENOM' => $w[3],'ENF' => $w[4]
                ,'RAPPEL' => $w[5],"MNT CFP" => $w[6]
                ,"DATE" =>$w[7],"EMARGEMENT" =>$w[8]);   


        $col_def_tresor=array('N°BEN'=> $w[0],
                'NOM' => $w[1],'PRENOM' => $w[2],'ENF' => $w[3]
                ,'RAPPEL' => $w[4],"MNT CFP" => $w[5]
                ,"COMPTE" =>$w[6]);   
           
        $district_old="";
        $nb_ligne=0;$nbmax_ligne=32;
        $tot=["nb_benef"=>0,"enfant"=>0,"rappel"=>0,"montant"=>0,"montant_eur"=>0,];
        //if($type=="RET") $tot=["nb_benef"=>0,"enfant"=>0,"rappel"=>0,"montant"=>0,"montant_eur"=>0,"PRE"=>0,"PRV"=>0,"PAV"=>0];
        //else 
        $tot=["nb_benef"=>0,"enfant"=>0,"rappel"=>0,"montant"=>0,"montant_eur"=>0,];

        $tot_g=["nb_benef"=>0,"cfp"=>0,"eur"=>0,"cfp_h"=>0,"eur_h"=>0,"nbenf"=>0,"nbenf_h"=>0,
            "nb_10K"=>0,"nb_5K"=>0,"nb_1K"=>0,"nb_500"=>0,
            "nb_200"=>0, //Modif 200XPF 10/2021
            "nb_100"=>0,"nb_50"=>0,"nb_20"=>0,"nb_10"=>0,
            "nb_10K_F"=>0,"nb_5K_F"=>0,"nb_1K_F"=>0,"nb_500_F"=>0,
            "nb_200_F"=>0, //Modif 200XPF 10/2021
            "nb_100_F"=>0,"nb_50_F"=>0,"nb_20_F"=>0,"nb_10_F"=>0
                ];

        $t_sstotal_type=array();$espece=false;$tresor=false;
        for($i=0;$i<$nb_benef;$i++) {
            $district=$t_beneficiaires["district"][$i];
            $ile==$t_beneficiaires["ile"][$i];
            $espece=($t_beneficiaires["banque"][$i]=="ESPECES WALLIS")
                || ($t_beneficiaires["banque"][$i]=="ESPECES FUTUNA") ;

            $tresor=($t_beneficiaires["banque"][$i]=="TRESOR PUBLIC");
            $just_add=false;
            if(($district_old!=$district)||($i==0)||($nb_ligne>$nbmax_ligne)) {
                if( ($i>0)&&($district_old!=$district) ) {
                    //Sous total
                    $this->sous_total($fpdf,$tot,$type);
                    if($fpdf->GetY()>230) {
                            $fpdf->AddPage();
                            $this->Header($fpdf,$titre_doc);
                            $just_add=true;
                    }

                    $tot[$ret_type]=0;
                    $tot=["nb_benef"=>0,"enfant"=>0,"rappel"=>0,"montant"=>0,"montant_eur"=>0,];

                }
                if(($i>0)&&(!$just_add)) {
                    $this->Footer($fpdf,$user);
                    $fpdf->AddPage();
                    $this->Header($fpdf,$titre_doc);
                }
                $nb_ligne=0;
                $fpdf->ln($h);
                $fpdf->SetX($depX);
                $fpdf->SetFont($font,'BU',$font_size+1);
                $fpdf->Cell(100,$h,utf8_decode("District de ".$t_beneficiaires["district"][$i]),"","1",'L',"");
                $fpdf->ln(5);
                $fpdf->SetX($depX);
                
                $fpdf->SetFont($font,'B',$font_size);
                //$nom_col=($espece)?$col_def_espece:$col_def;
                //$nom_col=($tresor)?$col_def_tresor:$col_def;
                $nom_col=$col_def_espece;
                foreach($nom_col as $name=>$l) $fpdf->Cell($l,$h,utf8_decode($name),"LRTB",0,'C',1);
                $fpdf->SetFont($font,'',$font_size);
            }
            $k=0;

            $bordure="BLR";
            $fpdf->ln($h);$fpdf->SetX($depX);
            $fpdf->Cell($w[$k++],$h,$t_beneficiaires["benum"][$i],$bordure,0,'L');
            $fpdf->Cell($w[$k++],$h,$t_beneficiaires["sonum"][$i],$bordure,0,'L');
            $fpdf->Cell($w[$k++],$h,$t_beneficiaires["nom"][$i],$bordure,0,'L');
            $fpdf->Cell($w[$k++],$h,$t_beneficiaires["prenom"][$i],$bordure,0,'L');
            $fpdf->Cell($w[$k++],$h,$t_beneficiaires["nbenf"][$i],$bordure,0,'L');
            $fpdf->Cell($w[$k++],$h,number_format($t_beneficiaires["montant_r"][$i],0,","," "),$bordure,0,'L');
            $fpdf->Cell($w[$k++],$h,number_format($t_beneficiaires["montant"][$i],0,","," "),$bordure,0,'L');
            if(!$espece) {
                $fpdf->Cell($w[$k++],$h,number_format($t_beneficiaires["montant_eur"][$i],2,","," "),$bordure,0,'L');
                $fpdf->Cell($w[$k++],$h,$t_beneficiaires["compte"][$i],$bordure,0,'L');
            } else {
                $fpdf->Cell($w[$k++],$h,"",$bordure,0,'L');
                $fpdf->Cell($w[$k++],$h,"",$bordure,0,'L');
            } 

            $district_old=$t_beneficiaires["district"][$i];
            $tot["nb_benef"]+=1;
            $tot["enfant"]+=$t_beneficiaires["nbenf"][$i];
            $tot["rappel"]+=$t_beneficiaires["montant_r"][$i];
            $tot["montant"]+=$t_beneficiaires["montant"][$i];
            $tot["montant_eur"]+=$t_beneficiaires["montant_eur"][$i];

            //Sous total types
            $ret_type=$t_beneficiaires["ret_type"][$i];
            if( !isset($tot[$ret_type]) ) {
                $tot[$ret_type]=0;
                $tot[$ret_type."_nb"]=0;
            }
            $tot[$ret_type]+=$t_beneficiaires["montant"][$i];
            $tot[$ret_type."_nb"]+=1;
            $tot_g["cfp"]+=$t_beneficiaires["montant"][$i];
            $tot_g["eur"]+=$t_beneficiaires["montant_eur"][$i];

            if(!isset($tot_g[$ret_type])) {
                $tot_g[$ret_type]=0;
                $tot_g[$ret_type."_nb"]=0;
            }
            $tot_g[$ret_type]+=$t_beneficiaires["montant"][$i];
            $tot_g[$ret_type."_nb"]+=1;
            $tot_g["nb_benef"]++;


            //$tot_g["cfp_h"]+=($bqe_terr)?$t_beneficiaires["montant"][$i]:0;
            //$tot_g["eur_h"]+=($bqe_terr)?$t_beneficiaires["montant_eur"][$i]:0;
            $tot_g["nbenf"]+=$t_beneficiaires["nbenf"][$i];
            //$tot_g["nbenf_h"]+=($bqe_terr)?$t_beneficiaires["nbenf"][$i]:0;


            //Billetage
            if( ($t_beneficiaires["banque"][$i]=='ESPECES FUTUNA')||($t_beneficiaires["banque"][$i]=='ESPECES WALLIS') ) {
                
                $ent_10000=(int)($t_beneficiaires["montant"][$i]/10000);
                $reste=$t_beneficiaires["montant"][$i]-($ent_10000*10000);

                $ent_5000=(int)($reste/5000);
                $reste=$reste-($ent_5000*5000);

                $ent_1000=(int)($reste/1000);
                $reste=$reste-($ent_1000*1000);

                $ent_500=(int)($reste/500);
                //AJOUT PIECES 01/2020
                $reste=$reste-($ent_500*500);

                //Modif 200XPF 10/2021
                $ent_200=(int)($reste/200);
                $reste=$reste-($ent_200*200);
                //Modifi Fin

                $ent_100=(int)($reste/100);
                $reste=$reste-($ent_100*100);

                $ent_50=(int)($reste/50);
                $reste=$reste-($ent_50*50);

                $ent_20=(int)($reste/20);
                $reste=$reste-($ent_20*20);

                $ent_10=(int)($reste/10);
                //$reste=$reste-($ent_10*10);


                $tot_g["nb_10K"]+=$ent_10000;
                $tot_g["nb_5K"]+=$ent_5000;
                $tot_g["nb_1K"]+=$ent_1000;
                $tot_g["nb_500"]+=$ent_500;
                $tot_g["nb_200"]+=$ent_200; //Modif 200XPF 10/2021
                $tot_g["nb_100"]+=$ent_100;
                $tot_g["nb_50"]+=$ent_50;
                $tot_g["nb_20"]+=$ent_20;
                $tot_g["nb_10"]+=$ent_10;
                if($t_beneficiaires["banque"][$i]=='ESPECES FUTUNA') {
                    $tot_g["nb_10K_F"]+=$ent_10000;
                    $tot_g["nb_5K_F"]+=$ent_5000;
                    $tot_g["nb_1K_F"]+=$ent_1000;
                    $tot_g["nb_500_F"]+=$ent_500; 
                    $tot_g["nb_200_F"]+=$ent_200; //Modif 200XPF 10/2021
                    $tot_g["nb_100_F"]+=$ent_100;
                    $tot_g["nb_50_F"]+=$ent_50;
                    $tot_g["nb_20_F"]+=$ent_20;
                    $tot_g["nb_10_F"]+=$ent_10;   
                }

            }
            $nb_ligne++;
        }

        //Dernier total
        $this->sous_total($fpdf,$tot,$type);

        $this->Footer($fpdf,$user);
        $fpdf->AddPage();
        $this->Header($fpdf,$titre_doc);

               
        //Tableau TOTAL
        $this->Footer_total($fpdf,$tot_g,$type);

        //Tableau Billetage
        $fpdf->ln(10);
        $this->Footer_billetage($fpdf,$tot_g);
        //Visas
        $this->Footer_Visas($fpdf,$user);

        $this->Footer($fpdf,$user);
        $fpdf->Output($nom_fichier,"I");
        exit(); 
    }





    function sous_total($fpdf,$tot,$type)
    {
        //Dernier total
        $h=7;
        $depX=5;
        $w=array(10,10,40,30,10,20,20,20,40);
        $font="Arial";$font_size=8;
        $fpdf->ln($h);
        $fpdf->SetX($depX);
        $fpdf->Cell($w[0]+$w[1]+$w[2],$h,utf8_decode("Nombre de bénéficiaires : ")." ".$tot["nb_benef"],0,'L');
        $fpdf->SetFont($font,'UB',$font_size);
        if(($type=="RET")||($type=="SAV")) {
            $fpdf->Cell($w[3]+$w[4],$h,"Totaux :","",0,'R');
            $fpdf->SetFont($font,'B',$font_size);
        } else {
            $fpdf->Cell($w[3],$h,"Totaux :","",0,'R');
            $fpdf->SetFont($font,'B',$font_size);
            $fpdf->Cell($w[4],$h,number_format($tot["enfant"],0,","," "),"TBLR",0,'L',1);
        }
        $fpdf->Cell($w[5],$h,number_format($tot["rappel"],0,","," "),"TBLR",0,'L',1);
        $fpdf->Cell($w[6],$h,number_format($tot["montant"],0,","," "),"TBLR",0,'L',1);
        $fpdf->Cell($w[7],$h,number_format($tot["montant_eur"],0,","," ")." ".chr(128),"TBLR",0,'L',1);
        $fpdf->ln(5);

    }

    function Header($fpdf,$titre_doc)
    {
        //Titre
        $fpdf->SetFont("Arial",'',14);
        $fpdf->SetX(45);
        $fpdf->SetFillColor(135,206,250);
        $fpdf->Cell(120,7,utf8_decode($titre_doc),"",0,'C',"1");
        $fpdf->Cell(30,7,date("d/m/Y"),"",1,'R',"");
    }


    function Footer($fpdf,$user)
    {
        //Titre
        $fpdf->SetFont("Arial",'',7);
        $fpdf->SetY(285);
        $fpdf->SetX(2);
        //$fpdf->Line(1,100,1,180);
        $fpdf->Cell(60,7,utf8_decode("Edité par ".$user->nom),"T",0,'L');
        $fpdf->Cell(100,7,"CPSWF - BP 125 MATA UTU - 98600 WALLIS - TEL : 72.01.20","T",0,'C');
        $fpdf->Cell(40,7,$fpdf->PageNo(),"T",0,'R');
    }


    function Footer_total($fpdf,$tot_g,$type)
    {
        $depX=5;$h=7;
        $font="Arial";
        $fpdf->ln(15);
        //Titre
        $fpdf->SetFont($font,'B',10);
        $fpdf->SetX($depX+20);
        $fpdf->Cell(100,$h,utf8_decode("Nombre total de bénéficiaire : ").$tot_g['nb_benef'],"","1",'L');
        $fpdf->ln(5);
        $w=array(50,30,30,30);

        $fpdf->SetFillColor(240,248,255);
        $fpdf->SetX($depX+20);
        $fpdf->SetFont($font,'B',9);
        $fpdf->Cell($w[0],$h,"","",0,'L');
        $fpdf->Cell($w[1],$h,"CFP","LTR",0,'C',1);
        $fpdf->Cell($w[2],$h,"EUR","LTR",0,'C',1);
        if(($type=="RET")||($type=="SAV"))  $fpdf->ln();
        else $fpdf->Cell($w[3],$h,"Nbre d'enfants","LTR",1,'C',1);

        $fpdf->SetX($depX+20);
        $fpdf->Cell($w[0],$h,"TOTAUX:","LTB",0,'L',1);
        $fpdf->SetFont($font,'',9);
        $fpdf->Cell($w[1],$h,number_format($tot_g["cfp"],0,","," "),"LTRB",0,'C');
        $fpdf->Cell($w[2],$h,number_format($tot_g["eur"],0,","," "),"LTRB",0,'C');
        if(($type=="RET")||($type=="SAV")) $fpdf->ln();
        else $fpdf->Cell($w[3],$h,number_format($tot_g["nbenf"],0,","," "),"LTRB",1,'C');

        if($type!="SOC") {
            $fpdf->SetX($depX+20);$y_pos=$fpdf->GetY();
            $fpdf->SetFont($font,'B',9);
            $fpdf->MultiCell($w[0],$h,"Dont TOTAUX BANQUES HORS TERRITOIRE","LTB",'L',1);
            $fpdf->SetFont($font,'',9);
            $fpdf->SetY($y_pos);
            $fpdf->SetX($depX+20+$w[0]);
            $fpdf->Cell($w[1],$h+$h,number_format($tot_g["cfp_h"],0,","," "),"LBTR",0,'C');
            $fpdf->Cell($w[2],$h+$h,number_format($tot_g["eur_h"],2,","," "),"LBTR",0,'C');
            if(($type!="RET")&&($type!="SAV")) 
                $fpdf->Cell($w[3],$h+$h,number_format($tot_g["nbenf_h"],0,","," "),"LTBR",1,'C');
        }
    }

    function Footer_types_retraites($fpdf,$t_types,$mode_final=false)
    {
        if($mode_final) {
            $titre="";
            $w=array(50,30,30,30);
            $posX=25;
            $fpdf->ln(15);
        } else {
            $titre="";
            $w=array(30,20,20,20);
            $posX=10;
            $fpdf->ln(20);
        }
        
        $h=7;
        
        $posY=$fpdf->GetY();
        $fpdf->SetXY($posX,$posY);
        $fpdf->SetFont("ARIAL",'B',9);
        $fpdf->Cell($w[0],$h-2,$titre,"",0,'L');
        $fpdf->Cell($w[1],$h-2,"CFP","LTR",0,'C',1);
        $fpdf->Cell($w[2],$h-2,"EURO","LTR",0,'C',1);
        $fpdf->Cell($w[3],$h-2,"Nbre","LTR",1,'C',1);
        $fpdf->SetFont("ARIAL",'',9);
        $t_type=["PRE"=>"PRE","PRV"=>"PRV","PAV"=>"PAV","PRA"=>"PRA",""=>"sans"];
        //$t_type=["PRE"=>"PRE","PRV"=>"PRV"];
        $nb_total=0;$montant_total=0;
        foreach($t_type as $type=>$nomtype) {
            if(isset($t_types[$type])) {
                $montant=$t_types[$type];
                $montant_euro=round($montant*0.00838,2);
                $nb=$t_types[$type."_nb"];
            } else {
                $montant=0;
                $montant_euro=0;
                $nb=0;
            }
            if(($type!="")||($nb>0)) {
                $fpdf->SetX($posX);
                $fpdf->SetFont("ARIAL",'',10);
                $fpdf->Cell($w[0]/2,$h,"Total ","LBT",0,'R',1);
                $fpdf->SetFont("ARIAL",'B',10);
                $fpdf->Cell($w[0]/2,$h,utf8_decode($nomtype),"BTR",0,'L',1);
                $fpdf->SetFont("ARIAL",'',10);
                $fpdf->Cell($w[1],$h,number_format($montant,0,","," "),"LBTR",0,'C');
                $fpdf->Cell($w[2],$h,number_format($montant_euro,2,","," "),"LBTR",0,'C');
                $fpdf->Cell($w[3],$h,number_format($nb,0,","," "),"LTBR",1,'C');
                $montant_total+=$montant;  
            }
            $nb_total+=$nb;
        }
        $montant_total_euro=round($montant_total*0.00838,2);
        $fpdf->SetX($posX);
        $fpdf->SetFont("ARIAL",'B',10);
        $fpdf->Cell($w[0],$h,utf8_decode("TOTAL"),"LBTR",0,'C',1);
        $fpdf->Cell($w[1],$h,number_format($montant_total,0,","," "),"LBTR",0,'C');
        $fpdf->Cell($w[2],$h,number_format($montant_total_euro,2,","," "),"LBTR",0,'C');
        $fpdf->Cell($w[3],$h,number_format($nb_total,0,","," "),"LTBR",1,'C');
    }

    function Footer_billetage($fpdf,$tot_g)
    {
        //Billetage 
        $font="Arial";
        $l=70;$h=7;$depX=50;

        $fpdf->SetX($depX);
        $img_x=40;
        $img_y=$fpdf->GetY()+11;
        $fpdf->Image(url('img/billetage.png'),$img_x,$img_y,130,90.7);

        $x=140;$y=$img_y+14;$l=21;
        $delta_X=57;$delta_Y=15;$hh=8.2;
        $pos_idx=1;
        $fpdf->SetFont($font,'B',11);

        $fpdf->SetY($img_y+$delta_Y);
        $fpdf->SetX($img_x+$delta_X);
        $fpdf->SetTextColor(220,20,60);
        $fpdf->Cell($l,$h,$tot_g["nb_10K_F"],"",0,'C');
        $fpdf->SetTextColor(0,128,0);
        $fpdf->Cell($l+9,$h,($tot_g["nb_10K"]-$tot_g["nb_10K_F"]),"",0,'C');
        $fpdf->SetTextColor(0,0,139);
        $fpdf->Cell($l,$h,$tot_g["nb_10K"],"",0,'C');

        $fpdf->SetY($img_y+$delta_Y+$hh);
        $fpdf->SetX($img_x+$delta_X);
        $fpdf->SetTextColor(220,20,60);
        $fpdf->Cell($l,$h,$tot_g["nb_5K_F"],"",0,'C');
        $fpdf->SetTextColor(0,128,0);
        $fpdf->Cell($l+9,$h,($tot_g["nb_5K"]-$tot_g["nb_5K_F"]),"",0,'C');
        $fpdf->SetTextColor(0,0,139);
        $fpdf->Cell($l,$h,$tot_g["nb_5K"],"",0,'C');

        $pos_idx++;
        $fpdf->SetY($img_y+$delta_Y+$pos_idx*($hh)+1);
        $fpdf->SetX($img_x+$delta_X);
        $fpdf->SetTextColor(220,20,60);
        $fpdf->Cell($l,$h,$tot_g["nb_1K_F"],"",0,'C');
        $fpdf->SetTextColor(0,128,0);
        $fpdf->Cell($l+9,$h,($tot_g["nb_1K"]-$tot_g["nb_1K_F"]),"",0,'C');
        $fpdf->SetTextColor(0,0,139);
        $fpdf->Cell($l,$h,$tot_g["nb_1K"],"",0,'C');

        $pos_idx++;
        $fpdf->SetY($img_y+$delta_Y+$pos_idx*($hh)+1);
        $fpdf->SetX($img_x+$delta_X);
        $fpdf->SetTextColor(220,20,60);
        $fpdf->Cell($l,$h,$tot_g["nb_500_F"],"",0,'C');
        $fpdf->SetTextColor(0,128,0);
        $fpdf->Cell($l+9,$h,($tot_g["nb_500"]-$tot_g["nb_500_F"]),"",0,'C');  
        $fpdf->SetTextColor(0,0,139);
        $fpdf->Cell($l,$h,$tot_g["nb_500"],"",0,'C');

//Modif 200XPF 10/2021
        $pos_idx++;
        $fpdf->SetY($img_y+$delta_Y+$pos_idx*($hh)+1);
        $fpdf->SetX($img_x+$delta_X);
        $fpdf->SetTextColor(220,20,60);
        $fpdf->Cell($l,$h,$tot_g["nb_200_F"],"",0,'C');
        $fpdf->SetTextColor(0,128,0);
        $fpdf->Cell($l+9,$h,($tot_g["nb_200"]-$tot_g["nb_200_F"]),"",0,'C');  
        $fpdf->SetTextColor(0,0,139);
        $fpdf->Cell($l,$h,$tot_g["nb_200"],"",0,'C');
//
        $pos_idx++;
        $fpdf->SetY($img_y+$delta_Y+$pos_idx*($hh)+1);
        $fpdf->SetX($img_x+$delta_X);
        $fpdf->SetTextColor(220,20,60);
        $fpdf->Cell($l,$h,$tot_g["nb_100_F"],"",0,'C');
        $fpdf->SetTextColor(0,128,0);
        $fpdf->Cell($l+9,$h,($tot_g["nb_100"]-$tot_g["nb_100_F"]),"",0,'C');  
        $fpdf->SetTextColor(0,0,139);
        $fpdf->Cell($l,$h,$tot_g["nb_100"],"",0,'C');

        $pos_idx++;
        $fpdf->SetY($img_y+$delta_Y+$pos_idx*($hh)+1);
        $fpdf->SetX($img_x+$delta_X);
        $fpdf->SetTextColor(220,20,60);
        $fpdf->Cell($l,$h,$tot_g["nb_50_F"],"",0,'C');
        $fpdf->SetTextColor(0,128,0);
        $fpdf->Cell($l+9,$h,($tot_g["nb_50"]-$tot_g["nb_50_F"]),"",0,'C');  
        $fpdf->SetTextColor(0,0,139);
        $fpdf->Cell($l,$h,$tot_g["nb_50"],"",0,'C');

        $pos_idx++;
        $fpdf->SetY($img_y+$delta_Y+$pos_idx*($hh)+1);
        $fpdf->SetX($img_x+$delta_X);
        $fpdf->SetTextColor(220,20,60);
        $fpdf->Cell($l,$h,$tot_g["nb_20_F"],"",0,'C');
        $fpdf->SetTextColor(0,128,0);
        $fpdf->Cell($l+9,$h,($tot_g["nb_20"]-$tot_g["nb_20_F"]),"",0,'C');  
        $fpdf->SetTextColor(0,0,139);
        $fpdf->Cell($l,$h,$tot_g["nb_20"],"",0,'C');

        $pos_idx++;
        $fpdf->SetY($img_y+$delta_Y+$pos_idx*($hh)+1);
        $fpdf->SetX($img_x+$delta_X);
        $fpdf->SetTextColor(220,20,60);
        $fpdf->Cell($l,$h,$tot_g["nb_10_F"],"",0,'C');
        $fpdf->SetTextColor(0,128,0);
        $fpdf->Cell($l+9,$h,($tot_g["nb_10"]-$tot_g["nb_10_F"]),"",0,'C');  
        $fpdf->SetTextColor(0,0,139);
        $fpdf->Cell($l,$h,$tot_g["nb_10"],"",0,'C');
    }


    function Footer_Visas($fpdf,$user)
    {
        //Visas
        $font="Arial";
        $font_size=8;
        $depX=40;
        $h=5;
        $fpdf->ln(20);
        $fpdf->SetX($depX);
        $d=$h+6;$lrg=40;$lrg2=90;
        $fpdf->SetFont($font,'',$font_size);
        $fpdf->Cell($lrg,$d,"VISA CHEF DE SERVICE","LRT",0,'C');
        $fpdf->Cell($lrg2,$d,"","LRT",1,'C');
        $fpdf->SetX($depX);
        $fpdf->Cell($lrg,$d,"Date","RLB",0,'C');
        $fpdf->Cell($lrg2,$d,"","RLB",1,'C');

        $fpdf->SetX($depX);
        $fpdf->Cell($lrg,$d,"VISA DIRECTEUR","LRT",0,'C');
        $fpdf->Cell($lrg2,$d,"","LRT",1,'C');
        $fpdf->SetX($depX);
        $fpdf->Cell($lrg,$d,"Date","RLB",0,'C');
        $fpdf->Cell($lrg2,$d,"","RLB",1,'C');
    }
}