<?php namespace App\Http\Controllers;

use App\Models\Employeur;
use App\Models\Beneficiaire;
use App\Models\Cotisation;
use App\Models\Controle;
use App\Models\User;
use App\Models\Role2;
use App\Models\MyApp;
use App\Models\GrandLivre;
use App\Models\Log;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Redirect;
use View;
use DB;
use Illuminate\Support\Facades\Auth;
use App\Http\Requests\EmployeurRequest;
use App\Http\Requests\EmployeurListeRequest;
use App\Http\Requests\AutoResponsableRequest;
use Illuminate\Http\Request;
use Response;

class EmployeursController extends Controller {

    private $menu='tiers';
    private $submenu='employeurs';
    private $menu_home='comptabilite';


    public function index($origine="",$statut="",$ile="")
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if(!$user->hasRole('ADMINISTRATEUR')) if(!$user->can("EMP_VISU")) return redirect('home');
        if($origine=="V") $this->menu_home="recouvrement";

        if($origine!="") Session::put("origine_menu",$origine);
        else $origine=Session::get('origine_menu');

        //Filtre sur Ile & statut
        $employeurs=[];
        if($statut=="") $statut=Session::get('statut_employeur');
        if($statut!="") {
            if($statut=="0") $statut="";
            Session::put("statut_employeur", $statut);
            $employeurs = Employeur::where('id','<>','0');
            if($statut!="ALL")  $employeurs->where('statut','=', $statut);
            if($ile=="")  $ile=Session::get('ile_employeur');
            if($ile!="")  {
                Session::put("ile_employeur", $ile);
                if($ile!="ALL") $employeurs = $employeurs->where('ile','=',$ile);
            }
            $employeurs = $employeurs->orderBy('nom')->get();
        }

        $statuts=MyApp::STATUTS_ENTREPRISE+['ALL'=>'Tout'];
        $iles=MyApp::ILES2+['ALL'=>'Tout'];

        return View::make('tiers.employeurs.index',
            [
                'user' => $user,'menu' => $this->menu,'submenu' => $this->submenu,'menu_home' => $this->menu_home,
                'origine' => $origine,
                'employeurs' => $employeurs,
                'statut' => $statut, 'statuts' =>$statuts,
                'ile' => $ile,'iles' => $iles,

            ]);
    }


    public function create($origine="")
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if(!$user->hasRole('ADMINISTRATEUR')) if(!$user->can("EMP_AJO")) return redirect('home');

        if($origine=="V") $this->menu_home="recouvrement";

        $exercices=MyApp::getListeExercices();
        $mode='create';
        $onglet_actif="nom";
        return View::make('tiers.employeurs.create', [
            'user' => $user,'menu' => $this->menu,'submenu' => $this->submenu,'menu_home' => $this->menu_home,'mode' => $mode,
            'origine' => $origine,'onglet_actif' => $onglet_actif,
            'exercices'=> $exercices,
        ]);
    }

    public function store(EmployeurRequest $request)
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if(!$user->hasRole('ADMINISTRATEUR')) if(!$user->can("EMP_AJO")) return redirect('home');

        //$t_error['doublon']="Ce bénéficiaire existe déjà sous le numéro :";
        //if ($t_error) return Redirect::back()->withInput()->withErrors($t_error);

        $employeur=$this->setData($request);

        $origine=$request->origine;
        if($origine=="") $origine="C"; 
        return Redirect::to('employeurs_liste/'.$origine);
    }

    public function edit($id,$origine="",$onglet_actif="nom",$mode="edit",$mode_lettrage=false)
    {

        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if(!$user->hasRole('ADMINISTRATEUR')) if(!$user->can("EMP_VISU")) return  redirect('home');

        if($origine=="V") $this->menu_home="recouvrement";

        $view_lettrage=Session::get('view_lettrage');
        if(!$view_lettrage) $view_lettrage=0;

        $ile="";
        $employeur = Employeur::find($id);
        $employes=Beneficiaire::where("sonum","=",$id)->get();
        $date1=intVal(date('Y'));$date2=$date1-1;
        $t_date=array($date1,$date2);
        $cotisations=Cotisation::where("sonum","=",$id)
            ->whereIn('exercice',$t_date)
            ->orderBy('date','DESC')
            ->get();

        $exercices=MyApp::getListeExercices();
        $salaires=$employeur->getSalairesActifs();
        $controles=Controle::where("sonum","=",$id)->orderBy('date_cont','DESC')->get();
        $ecritures=[];$exercice=date('Y');

        if($employeur->compte_aux) {
            $ecritures=GrandLivre::where('compte_aux','=',$employeur->compte_aux)->where('compte','like',"474%"); //->where(DB::raw('YEAR(date_doc)'),'=', $exercice)
            //$ecritures=GrandLivre::where('compte_aux','=',$employeur->compte_aux);
            if($view_lettrage==0) $ecritures=$ecritures->whereNull(db::raw("NULLIF(lettrage_code, ' ')"));
            $ecritures=$ecritures->get();
        }
        

        $liste_id="";
        foreach ($ecritures as $ecriture) $liste_id.=(($liste_id=='')?'':',').$ecriture->id;

        if($mode_lettrage) $mode="edit";

        return View::make('tiers.employeurs.'.$mode, [
            'user' => $user,'menu' => $this->menu,'submenu' => $this->submenu,'menu_home' => $this->menu_home,'mode' => $mode,
            'origine' => $origine,'onglet_actif' => $onglet_actif,
            'employeur'=> $employeur,
            'cotisations'=> $cotisations,
            'controles'=> $controles,
            'ile'=>$ile,
            'employes'=>$employes,
            'salaires'=>$salaires,
            'exercices'=> $exercices,
            'ecritures'=> $ecritures,
            'mode_lettrage' => $mode_lettrage,
            'view_lettrage' => $view_lettrage,'liste_id' => $liste_id
        ]);
    }

    public function edit_s($id,$origine,$onglet_actif="nom")
    {
        return $this->edit($id,$origine,$onglet_actif);
    }

    public function show($id,$origine="",$onglet_actif="nom")
    {
        return $this->edit($id,$origine,$onglet_actif,"show");
    }


    public function update($id,EmployeurRequest $request)
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if(!$user->hasRole('ADMINISTRATEUR')) if(!$user->can("EMP_MAJ")) return redirect('home');

        $origine=$request->origine;
        $employeur=$this->setData($request,$id);
        return Redirect::to('employeurs_liste/'.$origine);
    }

    public function setData($request,$id="")
    {

        if($id) $employeur = Employeur::find($id);
        else $employeur = new Employeur;
        $employeur->sec_id = $request->sec_id;
        $employeur->nom = strtoupper($request->nom);
        $employeur->adresse = $request->adresse;
        $employeur->ile = $request->ile;
        $employeur->tel = $request->tel;
        $employeur->fax = $request->fax;
        $employeur->email = $request->email;
        $employeur->responsable = $request->responsable;

        //$employeur->nbsal = $request->nbsal;
        $employeur->statut = $request->statut;
        $date = $request->date_deb;
        $employeur->date_deb = ($date!="")?date('Y-m-d', strtotime(str_replace('/', '-', $date))):null ;
        $date = $request->date_fin;
        $employeur->date_fin = ($date!="")?date('Y-m-d', strtotime(str_replace('/', '-', $date))):null ;
        $employeur->numrc = $request->numrc;
        $employeur->verrou = ($request->verrou=='on')?1:0;;
        $employeur->compte = $request->compte;
        $employeur->iban = $request->iban;
        $employeur->banque_id = $request->banque_id;
        $employeur->mode_cotis = $request->mode_cotis;
        $employeur->der_cotis = $request->der_cotis;
        $date = $request->der_mois;
        $employeur->der_mois = ($date!="")?date('Y-m-d', strtotime(str_replace('/', '-', $date))):null ;
        $employeur->soldei = $request->soldei;
        $employeur->nom_cont = $request->nom_cont;
        $date = $request->date_cont;
        $employeur->date_cont = ($date!="")?date('Y-m-d', strtotime(str_replace('/', '-', $date))):null ;
        $employeur->district = $request->district;
        $employeur->cp = $request->cp;
        $date = $request->date_med;
        $employeur->date_med = ($date!="")?date('Y-m-d', strtotime(str_replace('/', '-', $date))):null ;
        $date = $request->date_maj;
        $employeur->date_maj = ($date!="")?date('Y-m-d', strtotime(str_replace('/', '-', $date))):null ;
        $employeur->observation = $request->observation;
        $employeur->contact_nom = isset($request->contact_nom)?$request->contact_nom:"";
        $employeur->contact_tel = $request->contact_tel;
        $employeur->contact_email = $request->contact_email;
        //$employeur->date_contr  = $request->date_contr;

        //LOG de la transaction
        if(!$id) $employeur->log_transaction('','I');
        else $employeur->log_transaction($request->url(),'U');

        $employeur->save();

        //MAJ compte_aux
        if(!$employeur->compte_aux) {
            $employeur->compte_aux = "474".str_pad($employeur->id,4,0,STR_PAD_LEFT);
            $employeur->save();
        }

        return $employeur;

    }

    public function destroy($id,$origine="")
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );

        $nb_employes=Beneficiaire::count("sonum","=",$id);
        if($nb_employes==0) {
             //LOG de la transaction
            $employeur=Employeur::find($id);
            $employeur->log_transaction('','D');
            Employeur::destroy($id);
        }

        return Redirect::to('employeurs_liste/'.$origine);
    }

    public function autocomplete_employes(Request $request)
    {
        $param      = $request->input('term');
        $param = "OR";
        $associate = array();
        $search    = DB::select(
            "select id ,CONCAT(TRIM(nom) ,'  ',TRIM(prenom)) as value
            from beneficiaires
            where nom like ('{$param}%')
            "
        );

        foreach ($search as $result) {
            $associate[] = $result;
        }
        return json_encode($associate);

    }

    public function autocomplete_employeur(Request $request)
    {
        $param = trim($request->input('term'));
        $associate = array();
        if(($param=='**')||(strtoupper($param)=='TOUS')) {
            $search = ['id'=>"TOUS"];
        } else {
            $sql="select id as id,CONCAT(id,' ',TRIM(nom)) as value from employeurs
                where nom like ('%{$param}%') or id like ('%{$param}%') order by id";
            $search = DB::select($sql);
        }
        foreach ($search as $result) {
            $associate[] = $result;
        }
        return json_encode($associate);
    }

    /* ****************************** */
    /*    lETTRAGE
    /* ****************************** */
    public function edit_lettrage($id,$origine)
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if(!$user->hasRole('ADMINISTRATEUR')) if(!$user->can("GLI_MAJ")) return redirect('home');
        return $this->edit($id,$origine,"compta","edit",true);
    }

    public function view_lettrage($employeur_id,$origine,$mode="")
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if(!$user->hasRole('ADMINISTRATEUR')) if(!$user->can("GLI_VISU")) return redirect('home');
        $view_lettrage=Session::get('view_lettrage');
        if((!$view_lettrage)||($view_lettrage==0)) $view_lettrage=1;
        else  $view_lettrage=0;
        Session::put('view_lettrage', $view_lettrage);

        if($mode=="lettrage") return $this->edit_lettrage($employeur_id,$origine);
        return $this->show($employeur_id,$origine,"compta");
    }

    public function save_lettrage($employeur_id,Request $request)
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if(!$user->hasRole('ADMINISTRATEUR')) if(!$user->can("GLI_MAJ")) return redirect('home');
        $erreur=false;
        $origine=$request->origine;
        $liste_ecritures=$request->checklist;
        $t_ecritures=explode(",",$liste_ecritures);
        $lettre=$this->getLettre();
        $employeur=Employeur::find($employeur_id);
        foreach($t_ecritures as $id_ecriture) {
            $ecriture=GrandLivre::find($id_ecriture);
            $ecriture->lettrage_code=$lettre;
            $ecriture->save();
        }
        //Vérification
        $montant=DB::table('grand_livre')
            ->select(db::raw("SUM(debit-credit) as total"))
            ->where('lettrage_code','=',$lettre)
            ->where('compte_aux','=',$employeur->compte_aux)
            ->value('total');


        //Si pas zéro on detricotte
        if($montant!=0) {
            foreach($t_ecritures as $id_ecriture) {
                $ecriture=GrandLivre::find($id_ecriture);
                $ecriture->lettrage_code="";
                $ecriture->save();
            }
            Session::flash('success', "Lettrage non équilibré. Opération annulée");
        } else Session::flash('success',"Lettrage effectué");

        return $this->view_lettrage($employeur_id,$origine,"lettrage");
    }

    //Get Lettre pour lettrage
    private function getLettre() {
        $max=5;
        $lastlettre=GrandLivre::select("lettrage_code")
            ->whereNotNull('lettrage_code')
            ->orderby('lettrage_code','DESC')
            ->limit(1)
            ->value('lettrage_code');
        $newlettre="";
        $t_Alpha=array();
        $l=array();
        $l_ascii=array();

        if($lastlettre=="") {
            for($j=0;$j<$max;$j++) $newlettre.="A";
        } else {
            for($j=0;$j<$max;$j++) {
                $l[$j]=substr($lastlettre,$j,1);
                $l_ascii[$j]=ord($l[$j]);
            }

            for($j=($max-1);$j>=0;$j--) {
                if($l[$j]=="Z") $l[$j]="A";
                else {
                    $l[$j]=chr(ord($l[$j])+1);break;
                }
            }
            for($j=0;$j<$max;$j++) $newlettre.=$l[$j];

        }
        return $newlettre;
    }


}
