<?php namespace App\Http\Controllers;

use Auth\AuthController;
use App\Models\Enfant;
use App\Models\Beneficiaire;
use App\Models\User;
use App\Models\Role2;
use App\Models\Beneftype;
use App\Models\Benefstatut;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Auth;
use View;
use DB;

use App\Http\Requests\EnfantRequest;

class EnfantsController extends Controller {
    private $menu='tiers';
    private $submenu='enfants';
    private $menu_home="allocations";


    public function index($benef_type="",$mode="")
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if($benef_type=="S") $this->menu_home="aides_sociales";

        //Liste des types de bénéficiaires & titre
        $liste_beneftype=Beneftype::orderby('libelle')->select("libelle", "ref")->get()->pluck("libelle", "ref")->toArray();
        $liste_beneftype["X"]="Sans parents";
        $titre2=$liste_beneftype[$benef_type];

        //Statuts asscociés
        if($benef_type=="") $benef_type="A";
        if($benef_type!="X") {
            $filtre=Beneftype::where('ref','=',$benef_type)->first()->statuts;
            $t_filtre=explode(';',$filtre);
            if(count($t_filtre)>0) {
                $enfants = Enfant::join("_enfants_parents","_enfants_parents.id","=","enfants.id")
                    ->whereIn('statut_parent1', $t_filtre)
                    ->orwhereIn('statut_parent2', $t_filtre)
                    ->get();
            } else {
                $titre2.=" Tous";
                $enfants = Enfant::orderBy('enfants.nom')->orderBy('enfants.prenom')->get();
            }
        } else {
            $titre2=" Sans parents";
            $enfants = Enfant::orderBy('enfants.nom')
                ->where(db::raw('COALESCE(parents1,0)'),"=","0")
                ->where(db::raw('COALESCE(parents2,0)'),"=","0")
                ->orderBy('enfants.prenom')->get();
        }
        $page=($mode=="")?"index":"index_in";
        return View::make('tiers.enfants.'.$page, [
            'user' => $user,'menu' => $this->menu,'submenu' => $this->submenu,'menu_home' => $this->menu_home,
            'enfants' => $enfants,
            "benef_type" => $benef_type,"liste_beneftype" =>  $liste_beneftype]);
    }


    public function index_in($benef_type="",$mode="") { return $this->index($benef_type,$mode);}

    public function create($beneficiaire_id="",$benef_type="") {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        //REcupère le type de liste
        if(isset($_GET["benef_type"])) $benef_type=$_GET["benef_type"];
        if($benef_type=="S") $this->menu_home="aides_sociales";

        $beneficiaire="";
        if($beneficiaire_id) $beneficiaire=Beneficiaire::find($beneficiaire_id);
        $mode='create';
        return View::make('tiers.enfants.create', [
            'user' => $user,'menu' => $this->menu,'submenu' => $this->submenu,'menu_home' => $this->menu_home,
            'mode' => $mode,
            'benef_type' => $benef_type,
            'beneficiaire' => $beneficiaire
        ]);
    }

    public function create_avec_benef($beneficiaire_id) { return $this->create($beneficiaire_id); }

    public function store(EnfantRequest $request)
    {

        $mode_frame=$request->mode_frame;
        $benef_type=$request->benef_type;

        $enfant = $this->setData($request);
        //LOG de la transaction
        $enfant->log_transaction('','I');
        if($mode_frame) {
            Session::put("onglet_beneficiaire","o_famille");
            $msg="<blockquote><h2>La fiche de l'enfant <strong>".$enfant->nomcomplet."</strong> a été modifiée.</h2></blockquote>";
            Session::flash('message', $msg);
            return Redirect::back();
        }
        return Redirect::to('enfants_liste/'.$benef_type);
    }

    public function edit($id,$mode="edit",$beneficiaire_id="",$benef_type="")
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );

                
        //REcupère le type de liste
        if(isset($_GET["benef_type"])) $benef_type=$_GET["benef_type"];
        if($benef_type=="S") $this->menu_home="aides_sociales";

        $form_mode=false;
        $beneficiaire="";
        $enfant=Enfant::find($id);
        if($beneficiaire_id) {$beneficiaire=Beneficiaire::find($beneficiaire_id);$form_mode=true;}
        //else $beneficiaire=Beneficiaire::find($enfant->parents1);

        return View::make('tiers.enfants.'.$mode, [
            'user' => $user,'menu' => $this->menu,'submenu' => $this->submenu,'menu_home' => $this->menu_home,
            'form_mode' => $form_mode,
            'mode' => $mode,
            'benef_type' => $benef_type,
            'beneficiaire' => $beneficiaire,
            'enfant' => $enfant, 'user'=>$user
        ]);
    }

    public function edit_avec_benef($id,$beneficiaire_id) { return $this->edit($id,"edit",$beneficiaire_id);}

    public function show($id,$benef_type="")
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        
        return $this->edit($id,"show","",$benef_type);
    }
    public function show_avec_benef($id,$beneficiaire_id,$benef_type="") { return $this->edit($id,"show",$beneficiaire_id,$benef_type);}

    public function update($id,EnfantRequest $request)
    {
        $mode_frame=$request->mode_frame;
        $benef_type=$request->benef_type;
        $enfant = $this->setData($request,$id);
        //LOG de la transaction
        $enfant->log_transaction($request->url(),'U');

        if($mode_frame) {
            Session::put("onglet_beneficiaire","o_famille");
            $msg="<blockquote><h2>La fiche de l'enfant <strong>".$enfant->nomcomplet."</strong> a été modifiée.</h2></blockquote>";
            Session::flash('message', $msg);
            return Redirect::back();
        }
        return Redirect::to('enfants_liste/'.$benef_type);
    }

    public function destroy($id,$benef_type="")
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        //REcupère le type de liste
        if(isset($_GET["benef_type"])) $benef_type=$_GET["benef_type"];
         //LOG de la transaction
        $enfant=Enfant::find($id);
        $enfant->log_transaction('','D');
        Enfant::destroy($id);

        return Redirect::to('enfants_liste/'.$benef_type);
    }

    public function setData($request,$id="")
    {
        if($id) $enfant = Enfant::find($id);
        else $enfant = new Enfant;
        $enfant->nom  = strtoupper($request->nom);
        $enfant->prenom  = ($request->prenom);
        $enfant->sexe = $request->sexe;
        $date=$request->datenais;
        $enfant->datenais = ($date!="")?date('Y-m-d', strtotime(str_replace('/', '-', $date))):"" ;
        $enfant->certif = $request->certif;
        $enfant->parents1 = $request->parents1;
        $enfant->parents2 = $request->parents2;
        //$enfant->compte_p = $request->compte_p;
        //$enfant->compte_m = $request->compte_m;
        $enfant->obs = $request->obs;
        $enfant->verrou = ($request->verrou=="on")?"1":"0";
        $enfant->save();
        return $enfant;
    }
}
