<?php namespace App\Http\Controllers;

use Auth\AuthController;
use App\Models\GrandLivre;
use App\Models\Journal;
use App\Models\PlanComptable;
use App\Models\Employeur;
use App\Models\MyApp;
use App\Http\Requests\TransactionRequest;
use App\Http\Requests\EcritureRequest;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Auth;
use Illuminate\Http\Request;
use View;
use DB;



class GrandLivreController extends Controller {

    private $menu='ecritures';
    private $submenu='journaux';
    private $menu_home='comptabilite';


    public function __construct()
    {
        //$this->beforeFilter('auth');
    }

    public function index($jnx="",$date_deb="",$date_fin="",$view="")
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if(!$user->hasRole('ADMINISTRATEUR')) if(!$user->can("GLI_VISU")) return redirect('home');
        


        //Selection vue - cookie en cours ou defaut
        $view=MyApp::getSessionValue($view,'view_grand_livre');

        //Période
        if(!MyApp::isValidDate($date_deb)) $date_deb="";
        $date_deb=MyApp::getSessionValue($date_deb,'date_deb');
        $date_debFR=date('d/m/Y', strtotime($date_deb));

        if(!MyApp::isValidDate($date_fin)) $date_fin="";
        $date_fin=MyApp::getSessionValue($date_fin,'date_fin');
        $date_finFR=date('d/m/Y', strtotime($date_fin));

        //Selection vue - cookie en cours ou defaut
        if($jnx=="") $jnx=MyApp::getSessionValue($jnx,'jnx');
        if($jnx=="0") $jnx="ALL";

        //Selection vue - cookie en cours ou defaut
        if($view=="") {
            $view=Session::get('view_grand_livre');
            if($view=="") $view="ecritures";
        }
        Session::put('view_grand_livre', $view);


        $grandlivre=[];$transactions=[];
        if(($jnx!="")&&($view!="")) {
            if($view=="ecritures") {
                Session::put('jnx', $jnx);
                if($jnx=="ALL") $grandlivre=GrandLivre::WhereBetween('date_doc', [$date_deb, $date_fin])->orderby('compte','ASC')->get();
                else $grandlivre=GrandLivre::WhereBetween('date_doc', [$date_deb, $date_fin])->where('journal','=',$jnx)->orderby('compte','ASC')->get();

            }
            if($view=="transactions") {
                $transactions=GrandLivre::select('transaction','date_doc','ref_doc','journal',db::raw('SUM(debit) as debit'),db::raw('SUM(credit) as credit'))
                    ->WhereBetween('date_doc', [$date_deb, $date_fin]);
                if($jnx!="ALL") $transactions=$transactions->where('journal','=',$jnx);
                $transactions=$transactions->distinct()
                    ->groupby('transaction','date_doc','ref_doc','journal')
                    ->orderby('transaction','ASC')
                    ->get();
            }
        }


        $liste_journaux=Journal::select('nom_court',db::raw("CONCAT(nom_court,' - ',nom) as nom"))
            ->pluck('nom','nom_court')->toArray();//MyApp::JOURNAUX;

        return View::make('comptabilite.grandlivre.index_journaux',
            [
                'user' => $user,'menu' => $this->menu,'submenu' => $this->submenu,'menu_home' => $this->menu_home,
                'liste_journaux'=>$liste_journaux,"jnx" =>$jnx,
                'date_deb'=>$date_debFR,"date_fin" =>$date_finFR,
                'grandlivre'=>$grandlivre,'transactions'=>$transactions,
                'view'=>$view,
            ]);

    }

    
    /* *********** */
    /* ECRITURES   */
    /* *********** */
    public function index_ecritures($date_deb="",$date_fin="")
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if(!$user->hasRole('ADMINISTRATEUR')) if(!$user->can("GLI_VISU")) return redirect('home');
                
        //Période
        if(!MyApp::isValidDate($date_deb)) $date_deb="";
        $date_deb=MyApp::getSessionValue($date_deb,'date_deb');
        $date_debFR=date('d/m/Y', strtotime($date_deb));

        if(!MyApp::isValidDate($date_fin)) $date_fin="";
        $date_fin=MyApp::getSessionValue($date_fin,'date_fin');
        $date_finFR=date('d/m/Y', strtotime($date_fin));

        $grandlivre=[];
        if(($date_deb!="")&&($date_fin!=""))
            $grandlivre=GrandLivre::WhereBetween('date_doc', [$date_deb, $date_fin])
                ->whereNull(db::raw("NULLIF(lettrage_code, ' ')"))
                ->orderby('compte','ASC')->get();

        $this->submenu="ecritures";
        return View::make('comptabilite.grandlivre.index_ecritures',
            [
                'user' => $user,'menu' => $this->menu,'submenu' => $this->submenu,'menu_home' => $this->menu_home,
                'date_deb'=>$date_debFR,"date_fin" =>$date_finFR,
                'grandlivre'=>$grandlivre,
            ]);
    }

    
    /* *********** */
    /* COMPTES     */
    /* *********** */
    public function index_comptes($compte="",$compte_aux="",$date_deb="",$date_fin="")
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if(!$user->hasRole('ADMINISTRATEUR')) if(!$user->can("GLI_VISU")) return redirect('home');
        
        //Période
        if(!MyApp::isValidDate($date_deb)) $date_deb="";
        $date_deb=MyApp::getSessionValue($date_deb,'date_deb');
        $date_debFR=date('d/m/Y', strtotime($date_deb));

        if(!MyApp::isValidDate($date_fin)) $date_fin="";
        $date_fin=MyApp::getSessionValue($date_fin,'date_fin');
        $date_finFR=date('d/m/Y', strtotime($date_fin));

        $grandlivre=[];
        if(($date_deb!="")&&($date_fin!="")&&($compte!="")) {
            
            $grandlivre=GrandLivre::WhereBetween('date_doc', [$date_deb, $date_fin])
                ->whereNull(db::raw("NULLIF(lettrage_code, ' ')"));
            if($compte ) {
                $grandlivre=$grandlivre->where('compte','=',$compte);

                if($compte_aux) $grandlivre=$grandlivre->where('compte_aux','=',$compte_aux);
            } 
            $grandlivre=$grandlivre->orderby('compte','ASC')->get();
        }
        $this->submenu="comptes";

        $liste_comptes_aux="";
        $liste_comptes=PlanComptable::select('compte',db::raw("CONCAT(compte,' - ',libelle) as libelle"))
            ->pluck('libelle','compte')->toArray();//MyApp::JOURNAUX;
        if($compte!="") {
            if(substr($compte,0,3)=="474") $liste_comptes_aux=MyApp::getCompteAux("employeurs");  
        }

        //comptes
        $comptes=DB::table('plan_comptable')->select(db::raw("CONCAT(compte,' ',libelle) as nom"),"compte")->orderby("compte")->get();
        $data=array();
        foreach($comptes as $cpt) $data[] = ["id"=> $cpt->compte,"text"=>$cpt->nom];
        $comptes_json=json_encode($data);  

        //comptes AUxiliaires
        $data_aux=[];$comptes_aux_json='';  
        if($compte!="") {
            if(substr($compte,0,3)=="474") {
                $comptes_aux=DB::table('employeurs')->select(db::raw("CONCAT(compte_aux,' (',LEFT(TRIM(nom),20),'..)') as nom"),"compte_aux")->whereNotNull('compte_aux')->orderby("compte_aux")->get();
                $data_aux=array();
                $data_aux[] =["id"=>"","text"=>""];
                foreach($comptes_aux as $cpt) $data_aux[] = ["id"=> $cpt->compte_aux,"text"=>$cpt->nom];
                $comptes_aux_json=json_encode($data_aux);  
            }
        }

        return View::make('comptabilite.grandlivre.index_comptes',
            [
                'user' => $user,'menu' => $this->menu,'submenu' => $this->submenu,'menu_home' => $this->menu_home,
                'date_deb'=>$date_debFR,"date_fin" =>$date_finFR,
                'grandlivre'=>$grandlivre,
                'comptes_json'=>$comptes_json,'compte'=>$compte,
                'comptes_aux_json'=>$comptes_aux_json,'compte_aux'=>$compte_aux,
            ]);
    }

    /* *********** */
    /* TRANSACTION */
    /* *********** */
     public function create()
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if(!$user->hasRole('ADMINISTRATEUR')) if(!$user->can("GLI_MAJ")) return redirect('home');

        $mode="create";

        $liste_journaux=Journal::select('nom_court',db::raw("CONCAT(nom_court,' - ',nom) as nom"))
            ->pluck('nom','nom_court')->toArray();//MyApp::JOURNAUX;

            /*
        $comptes=DB::table('plan_comptable')
                    ->select(db::raw("CONCAT(compte,' ',libelle) as nom"), 'libelle')
                    ->orderby("nom")->pluck('nom', 'libelle')->toArray();
        foreach($comptes as $code=>$nom) $lst_comptes[]=['id'=>$code,'nom'=>$nom];

        $comptes_aux=MyApp::getCompteAux('employeurs');
        foreach($comptes_aux as $code=>$nom) $lst_comptesaux[]=['id'=>$code,'nom'=>$nom];
        */


        //comptes
        $comptes=DB::table('plan_comptable')->select(db::raw("CONCAT(compte,' ',libelle) as nom"),"compte")->orderby("compte")->get();
        $data=array();
        foreach($comptes as $cpt) $data[] = ["id"=> $cpt->compte,"text"=>$cpt->nom];
        $comptes_json=json_encode($data);  
        //comptes AUxiliaires
        $comptes_aux=DB::table('employeurs')->select(db::raw("CONCAT(compte_aux,' (',LEFT(TRIM(nom),20),'..)') as nom"),"compte_aux")->whereNotNull('compte_aux')->orderby("compte_aux")->get();

        $data_aux=array();
        $data_aux[] =["id"=>"","text"=>""];
        foreach($comptes_aux as $cpt) $data_aux[] = ["id"=> $cpt->compte_aux,"text"=>$cpt->nom];
        $comptes_aux_json=json_encode($data_aux); 

        $journal=Session::get("jnx");
        return View::make('comptabilite.grandlivre.create',
            [
                'user' => $user, 'menu' => $this->menu,'submenu' => $this->submenu,'menu_home' => $this->menu_home,'mode' => $mode,
                'comptes' => $comptes,'comptes_json' => $comptes_json,'comptes_aux_json' => $comptes_aux_json,
                'liste_journaux' => $liste_journaux,'journal' => $journal
            ]);
    }

    public function store(TransactionRequest $request)
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if(!$user->hasRole('ADMINISTRATEUR')) if(!$user->can("GLI_MAJ")) return redirect('home');

        $grandlivre = new GrandLivre;

        $date = $request->date_doc;
        $grandlivre->date_doc = ($date!="")?date('Y-m-d', strtotime(str_replace('/', '-', $date))):"" ;
        $grandlivre->date_ref  = ($date!="")?date('Y-m-d', strtotime(str_replace('/', '-', $date))):"" ;
        $grandlivre->ref_doc = $request->ref_doc;
        $grandlivre->journal = $request->journal;
        $journal=Journal::where('nom_court','=',$request->journal)->first();
        $grandlivre->journal_label = $journal->nom;
        $num_transaction=GrandLivre::max('transaction')+1;
        $grandlivre->transaction=$num_transaction;
        $grandlivre->save();
        //Sauve les lignes
        $nb=$this->saveDataLignes($grandlivre->id,$request);

        $msg="Transaction N°".$num_transaction." crée avec ".$nb." écritures";
        Session::flash('message', $msg);

        return Redirect::to('grand_livre_filtre/'.$request->journal);
    }

    public function edit($id)
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if(!$user->hasRole('ADMINISTRATEUR')) if(!$user->can("GLI_MAJ")) return redirect('home');

        $mode="edit";
        $grand_livre_ligne=GrandLivre::find($id);
        $transaction=$grand_livre_ligne->transaction;
        $ecritures=GrandLivre::where('transaction','=',$transaction )->orderby('id','asc')->get();
        $is_new=true;
        if($ecritures->count()>1) $is_new=false;
        else {
            $e=$ecritures->first();
            if($e->compte!="")  $is_new=false;
        }

        //comptes
        $comptes=DB::table('plan_comptable')->select(db::raw("CONCAT(compte,' ',libelle) as nom"),"compte")->orderby("compte")->get();
        $data=array();
        foreach($comptes as $cpt) $data[] = ["id"=> $cpt->compte,"text"=>$cpt->nom];
        $comptes_json=json_encode($data);  
        //comptes AUxiliaires
        $comptes_aux=DB::table('employeurs')->select(db::raw("CONCAT(compte_aux,' (',LEFT(TRIM(nom),20),'..)') as nom"),"compte_aux")->whereNotNull('compte_aux')->orderby("compte_aux")->get();

        $data_aux=array();
        $data_aux[] =["id"=>"","text"=>""];
        foreach($comptes_aux as $cpt) $data_aux[] = ["id"=> $cpt->compte_aux,"text"=>$cpt->nom];
        $comptes_aux_json=json_encode($data_aux);  


        return View::make('comptabilite.grandlivre.edit',
        [
            'user' => $user, 'menu' => $this->menu,'submenu' => $this->submenu,'menu_home' => $this->menu_home,'mode' => $mode,
            'comptes' => $comptes,'comptes_json' => $comptes_json,'comptes_aux_json' => $comptes_aux_json,
            'grand_livre_ligne' => $grand_livre_ligne,'ecritures' => $ecritures, "is_new" => $is_new
        ]);
    }

    public function saveDataLignes($id,Request $request)
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );

        $ecriture_base=GrandLivre::find($id);
        if(!$ecriture_base) return Redirect::to('grand_livre');

        $data=$request->all_data;
        $t_values=explode("|",$data);$nb=0;

        //Enregistre les lignes
        foreach($t_values as $data) {
            $t_col=explode(";",$data);
            $compte=$t_col[0];
            $compte_aux=$t_col[1];
            $date_ref=$t_col[2];
            $libelle=$t_col[3];
            $debit=intVal(str_replace(' ','',$t_col[4]));if($debit=="") $debit=0;
            $credit=intVal(str_replace(' ','',$t_col[5]));if($credit=="") $credit=0;
            $nb++;
            if($nb>1) $grandlivre = new GrandLivre;
            else $grandlivre =$ecriture_base;
            $grandlivre->transaction=$ecriture_base->transaction;
            $date  = $ecriture_base->date_doc ;
            $grandlivre->date_doc  =($date!="")?date('Y-m-d', strtotime(str_replace('/', '-', $date))):null ;

            $grandlivre->date_ref  =($date_ref!="")?date('Y-m-d', strtotime(str_replace('/', '-', $date_ref))):null ;
            $grandlivre->ref_doc  = $ecriture_base->ref_doc ;
            $grandlivre->journal  = $ecriture_base->journal ;
            $grandlivre->journal_label  = $ecriture_base->journal_label ;

            $grandlivre->compte  = $compte ;
            $compte=PlanComptable::where('compte','=',$compte)->first();
            $grandlivre->compte_label  =($compte)?$compte->libelle:'';

            $grandlivre->compte_aux  = $compte_aux ;
            $compte=Employeur::where('compte_aux','=',$compte_aux)->first();
            $grandlivre->compte_aux_label  = "";
            if($request->compte_aux!=null) $grandlivre->compte_aux_label  = ($compte)?$compte->nom:'';

            $grandlivre->designation  = $libelle ;
            $grandlivre->debit  = $debit ;
            $grandlivre->credit  = $credit ;
            $grandlivre->montant  = abs($debit-$credit) ;
            $grandlivre->sens  = ($credit>$debit)?"C":"D" ;
            $grandlivre->lettrage_code  = '';
            $grandlivre->date_lettrage  = null ;
            $grandlivre->user_id_modif = $user->id ;
            $grandlivre->user_id_create  = $user->id ;
            $grandlivre->verrou = 0;
            $grandlivre->date_verrou = null;

            $grandlivre->save(); 
        } 
        return $nb;
    }

    public function update($id,Request $request)
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if(!$user->hasRole('ADMINISTRATEUR')) if(!$user->can("GLI_MAJ")) return redirect('home');

        $nb=$this->saveDataLignes($id,$request);
        $ecriture_base=GrandLivre::find($id);
       
        return Redirect::to('grand_livre');
    }


    public function show($id)
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if(!$user->hasRole('ADMINISTRATEUR')) if(!$user->can("GLI_VISU")) return redirect('home');


        $mode="show";
        $grand_livre_ligne=GrandLivre::find($id);
        $transaction=$grand_livre_ligne->transaction;
        $ecritures=GrandLivre::where('transaction','=',$transaction )->orderby('id','asc')->get();

        return View::make('comptabilite.grandlivre.show',
        [
            'user' => $user, 'menu' => $this->menu,'submenu' => $this->submenu,'menu_home' => $this->menu_home,
            'mode' => $mode,
            'grand_livre_ligne' => $grand_livre_ligne,'ecritures' => $ecritures
        ]);
    }


    public function show_transaction($transaction)
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if(!$user->hasRole('ADMINISTRATEUR')) if(!$user->can("GLI_VISU")) return redirect('home');

        $mode="show";
        $grand_livre_ligne=GrandLivre::where('transaction','=',$transaction)->first();

        return $this->show($grand_livre_ligne->id);
    }



    public function destroy($id)
    {
        /*
        $msg="";
        $grandlivre=GrandLivre::find($id) ;
        $numtransaction=$grandlivre->IdTransaction;
        if(!$grandlivre->IsSupprimable) {
            $msg="Suppression impossible, il faut supprimer le lettrage et la contrepartie";
            Session::flash('message', $msg);
            Redirect::back()->with('msg', $msg);
        }
        //Suppression de transactions sur Achats et Versements
        $transaction=$grandlivre->transaction;
        $nb_ecritures=GrandLivre::where('transaction','=',$id)->count() ;
        $msg="La transaction ".$numtransaction." comprenant ".$nb_ecritures." écritures a été supprimée";
        GrandLivre::where('transaction','=',$transaction)->delete();
        return Redirect::back()->with('msg', $msg);
        */
        $msg="Opération interdite";
        return Redirect::back()->with('msg', $msg);
    }

    public function delete_transaction($id)
    {
        /*
        $msg="";
        $grandlivre=GrandLivre::where('transaction','=',$id)->first() ;
        $numtransaction=$grandlivre->IdTransaction;
        $nb_ecritures=GrandLivre::where('transaction','=',$id)->count() ;
        //Supprime la transaction si la cotisation est liée
        $cotisations=Cotisation::where('compta_id','=',$id)->get();
        foreach($cotisations as $cotisations) {
            $cotisations->releve_ref=null;
            $cotisation->transaction=null;
            $cotisation->save();
        }

        $grandlivre=GrandLivre::where('transaction','=',$id)->delete() ;
        $msg="La transaction ".$numtransaction." comprenant ".$nb_ecritures." écritures a été supprimée";

        return Redirect::back()->with('message', $msg);
        */
    }




    /* ***********  */
    /* ECRITURE POP */
    /* ***********  */
/*
    public function create_ligne_pop($id_ecriture_base)
    {
        $user = Auth::user();
        if(!$user) return Redirect::route( 'login' );

        $mode="create";
        $ecriture_base=GrandLivre::find($id_ecriture_base);

        $comptes=DB::table('plan_comptable')
                    ->select(db::raw("CONCAT(compte,' ',libelle) as nom"), 'compte')
                    ->orderby("nom")->pluck('nom', 'compte')->toArray();

        $comptes_aux=MyApp::getCompteAux('employeurs');

        return View::make('comptabilite.grandlivre.lignes.create_ligne_pop',
        [
            'user' => $user, 'menu' => $this->menu,'submenu' => $this->submenu,'menu_home' => $this->menu_home,
            'mode' => $mode,
            'comptes'=>$comptes,'comptes_aux'=>$comptes_aux,
            'ecriture_base'=> $ecriture_base
        ]);
    }
*/

/*
    public function store_ligne_pop($id_ecriture_base,EcritureRequest $request)
    {
        $user = Auth::user();
        if(!$user) return Redirect::route( 'login' );


        $error="";
        if((!$request->compte)) $error="Vous devez saisir un compte";
        if((!$request->designation)) $error="Vous devez saisir une désignation";
        if((!$request->debit) && (!$request->credit)) $error="Vous devez saisir un montant";
        if(($request->debit) && ($request->credit)) $error="Vous devez saisir un crédit ou un débit, pas les deux";
        if($error) {
            return redirect()->back()->withInput()->withErrors([$error]);
        }

        $grandlivre=$this->set_data_ligne_pop($request,"",$id_ecriture_base);

        $msg="Ecriture enregistrée";
        Session::flash('message', $msg);
        return Redirect::back();
    }
*/

/*

     public function edit_ligne_pop($id="")
    {
        $user = Auth::user();
        if(!$user) return Redirect::route( 'login' );

        $mode="create";
        $ecriture=GrandLivre::find($id);

        $comptes=DB::table('plan_comptable')
                    ->select(db::raw("CONCAT(compte,' ',libelle) as nom"), 'compte')
                    ->orderby("nom")->pluck('nom', 'compte')->toArray();

        $comptes_aux=MyApp::getCompteAux('employeurs');

        return View::make('comptabilite.grandlivre.lignes.edit_ligne_pop',
        [
            'user' => $user, 'menu' => $this->menu,'submenu' => $this->submenu,'menu_home' => $this->menu_home,
            'mode' => $mode,
            'comptes'=>$comptes,'comptes_aux'=>$comptes_aux,
            'ecriture'=> $ecriture
        ]);
    }
*/

/*

    public function update_ligne_pop($id,Request $request)
    {

        $user = Auth::user();
        if(!$user) return Redirect::route( 'login' );

        $error="";
        if((!$request->compte)) $error="Vous devez saisir un compte";
        if((!$request->designation)) $error="Vous devez saisir une désignation";
        if((!$request->debit) && (!$request->credit)) $error="Vous devez saisir un montant";
        if(($request->debit) && ($request->credit)) $error="Vous devez saisir un crédit ou un débit, pas les deux";
        if($error) {
            return redirect()->back()->withInput()->withErrors([$error]);
        }

        $grandlivre=$this->set_data_ligne_pop($request,$id);

        $msg="Ecriture modifiée";
        Session::flash('message', $msg);
        return Redirect::back();

    }
*/

/*
     public function delete_ligne($id)
    {
        $msg="Suppression effectuée";
        $grandlivre=GrandLivre::find($id);
        //Si lien avec cotisation on supprime le  lien
        // $cotisations=Cotisation::where('compta_id','=',$id)->get();
        // foreach($cotisations as $cotisations) {
        //     $cotisations->releve_ref=null;
        //     $cotisation->compta_id=null;
        //     $cotisation->save();
        // }


        GrandLivre::find($id)->delete();
        if($msg!="") Session::flash('message', $msg);
        return Redirect::back()->with('msg', $msg);

    }
*/

/*
    public function set_data_ligne_pop($request,$id="",$id_ecriture_base="")
    {
        $user = Auth::user();
        if(!$user) return Redirect::route( 'login' );

        $error="";
        if((!$request->compte)) $error="Vous devez saisir un compte";
        if((!$request->designation)) $error="Vous devez saisir une désignation";
        if((!$request->debit) && (!$request->credit)) $error="Vous devez saisir un montant";
        if(($request->debit) && ($request->credit)) $error="Vous devez saisir un crédit ou un débit, pas les deux";
        if($error) {
            return redirect()->back()->withInput()->withErrors([$error]);
        }

        if($id_ecriture_base) {
            $ecriture_base=GrandLivre::find($id_ecriture_base);
            $grandlivre = new GrandLivre;
            $grandlivre->transaction=$ecriture_base->transaction;
            $date  = $ecriture_base->date_doc ;
            $grandlivre->date_doc  =($date!="")?date('Y-m-d', strtotime(str_replace('/', '-', $date))):null ;
            $grandlivre->ref_doc  = $ecriture_base->ref_doc ;
            $grandlivre->journal  = $ecriture_base->journal ;
            $grandlivre->journal_label  = $ecriture_base->journal_label ;
        }
        if($id) {
            $grandlivre =  GrandLivre::find($id);
        }

        $grandlivre->compte  = $request->compte ;
        $compte=PlanComptable::where('compte','=',$request->compte)->first();
        $grandlivre->compte_label  =($compte)?$compte->libelle:'';

        $grandlivre->compte_aux  = $request->compte_aux ;
        $compte=Employeur::where('compte_aux','=',$request->compte_aux)->first();
        $grandlivre->compte_aux_label  = "";
        if($request->compte_aux!=null) $grandlivre->compte_aux_label  = ($compte)?$compte->nom:'';

        $grandlivre->designation  = $request->designation ;
        $grandlivre->debit  = $request->debit ;
        $grandlivre->credit  = $request->credit ;
        $grandlivre->montant  = abs($request->debit-$request->credit) ;
        $grandlivre->sens  = ($request->credit>$request->debit)?"C":"D" ;
        $grandlivre->lettrage_code  = '';
        $grandlivre->date_lettrage  = null ;
        $grandlivre->user_id_modif = $user->id ;
        if(!$id) {
            $grandlivre->user_id_create  = $user->id ;
            $grandlivre->verrou = 0;
            $grandlivre->date_verrou = null;
        }

        $grandlivre->save();
        return $grandlivre;

    }
    */


}



