<?php

namespace App\Http\Controllers;

use View;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\Models\User;
use App\Models\Connection;
use App\Models\MyApp;
use App\Models\Beneficiaire;
use App\Models\Enfant;
use App\Models\Employeur;
use App\Models\Beneftype;
use App\Models\Versement_b;
use App\Models\Cotisation;
use App\Models\Mandat;
use App\Models\Imputation;



use Illuminate\Support\Facades\Session;
use Spatie\Permission\Traits\HasRoles;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;

class HomeController extends Controller
{

     public $role_name="";

    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }


    public function index()
    {
        $user = Auth::user();
        if(!$user) return;

        $this->role_name=$user->getRoleNames()->first();

        return $this->dash_Administrateur();
    }

    public function index_type($mode)
    {
        $user = Auth::user();
        if(!$user) return;

        return $this->{"index_".$mode}();
    }

    public function index_comptabilite()
    {
        $user = Auth::user();
        if(!$user) return;

        $this->role_name=$user->getRoleNames()->first();
        $menu_home="comptabilite";
        $dashboard_title = "Comptabilite";

        $t_indicateurs=MyApp::getIndicateurs("comptabilite");

        return view::make('home',[
            "user"=>$user,
            "dashboard_title"=>$dashboard_title,
            "menu_home" => $menu_home,
            "t_indicateurs" => $t_indicateurs
        ]);
    }

    public function index_allocations()
    {
        $user = Auth::user();
        if(!$user) return;

        $this->role_name=$user->getRoleNames()->first();
        $menu_home="allocations";
        $dashboard_title = "Allocations";

        //Allocataires seulement
        $benef_type="A";
        $filtre=Beneftype::where('ref','=',$benef_type)->value('statuts');
        $t_filtre=explode(';',$filtre);
        $nb_beneficiaires = Beneficiaire::whereIn('statut', $t_filtre)->count();
        //Enfants
        $nb_enfants = Enfant::
            join("_enfants_parents","_enfants_parents.id","=","enfants.id")
            ->whereIn('statut_parent1', $t_filtre)
            ->orwhereIn('statut_parent2', $t_filtre)
            ->count();
        //Versements
        $nb_versements = Versement_b::where('type','=','ALL')->count();

        $t_indicateurs=[];
        $t_indicateurs["nb_beneficiaires"]=$nb_beneficiaires;
        $t_indicateurs["nb_enfants"]=$nb_enfants;
        $t_indicateurs["nb_versements"]=$nb_versements;

        return view::make('home',[
            "user"=>$user,
            "dashboard_title"=>$dashboard_title,
            "menu_home" => $menu_home,
            "t_indicateurs" => $t_indicateurs
        ]);
    }

    public function index_aides_sociales()
    {
        $user = Auth::user();
        if(!$user) return;

        $this->role_name=$user->getRoleNames()->first();
        $menu_home="aides_sociales";
        $dashboard_title = "Aides Sociales";

        //Aides sociales seulement
        $benef_type="S";
        $filtre=Beneftype::where('ref','=',$benef_type)->value('statuts');
        $t_filtre=explode(';',$filtre);
        $beneficiaires = Beneficiaire::whereIn('statut', $t_filtre)->get();

        //Enfants
        $enfants = Enfant::
            join("_enfants_parents","_enfants_parents.id","=","enfants.id")
            ->whereIn('statut_parent1', $t_filtre)
            ->orwhereIn('statut_parent2', $t_filtre)
            ->get();
        //Versements
        $nb_versements = Versement_b::whereIn('type',['SOC'])->count();
        $nb_versements_csr = Versement_b::whereIn('type',['SAV'])->count();

        $t_indicateurs=[];
        $t_indicateurs["nb_beneficiaires"]=$beneficiaires->count();
        $t_indicateurs["nb_enfants"]=$enfants->count();
        $t_indicateurs["nb_versements"]=$nb_versements;
        $t_indicateurs["nb_versements_csr"]=$nb_versements_csr;

        return view::make('home',[
            "user"=>$user,
            "dashboard_title"=>$dashboard_title,
            "menu_home" => $menu_home,
            "t_indicateurs" => $t_indicateurs
        ]);
    }


    public function index_retraites()
    {
        $user = Auth::user();
        if(!$user) return;

        $this->role_name=$user->getRoleNames()->first();
        $menu_home="retraites";
        $dashboard_title = "Retraites";

        //Aides sociales seulement
        $benef_type="R";
        $filtre=Beneftype::where('ref','=',$benef_type)->value('statuts');
        $t_filtre=explode(';',$filtre);
        $beneficiaires = Beneficiaire::whereIn('statut', $t_filtre)->get();

        //Enfants
        $enfants = Enfant::
            join("_enfants_parents","_enfants_parents.id","=","enfants.id")
            ->whereIn('statut_parent1', $t_filtre)
            ->orwhereIn('statut_parent2', $t_filtre)
            ->get();
        //Versements
        $nb_versements = Versement_b::where('type','=','RET')->count();

        $t_indicateurs=[];
        $t_indicateurs["nb_beneficiaires"]=$beneficiaires->count();
        $t_indicateurs["nb_versements"]=$nb_versements;

        return view::make('home',[
            "user"=>$user,
            "dashboard_title"=>$dashboard_title,
            "menu_home" => $menu_home,
            "t_indicateurs" => $t_indicateurs
        ]);
    }

    public function index_mandatement()
    {
        $user = Auth::user();
        if(!$user) return;

        $this->role_name=$user->getRoleNames()->first();
        $menu_home="mandatement";
        $dashboard_title = "Mandatements";

        $nb_mandats = Mandat::where('id',"<>","")->count();
        $nb_imputation = Imputation::where('id',"<>","")->count();
        $t_indicateurs=[];
        $t_indicateurs["nb_mandats"]=$nb_mandats;
        $t_indicateurs["nb_imputations"]=$nb_imputation;

        return view::make('home',[
            "user"=>$user,
            "dashboard_title"=>$dashboard_title,
            "menu_home" => $menu_home,
            "t_indicateurs" => $t_indicateurs
        ]);
    }

    public function index_recouvrement()
    {
        $user = Auth::user();
        if(!$user) return;

        $this->role_name=$user->getRoleNames()->first();
        $menu_home="recouvrement";
        $dashboard_title = "Recouvrement";

        $employeurs = Employeur::where('statut',"=","ACT")->get();
        $cotisations = Cotisation::where('encais_compte','=','')->orderBy('date','ASC')->get();
        $t_indicateurs=[];
        $t_indicateurs["nb_employeurs"]=$employeurs->count();
        $t_indicateurs["nb_cotis_aenc"]=$cotisations->count();

        return view::make('home',[
            "user"=>$user,
            "dashboard_title"=>$dashboard_title,
            "menu_home" => $menu_home,
            "t_indicateurs" => $t_indicateurs
        ]);
    }

    public function index_analyses()
    {
        $user = Auth::user();
        if(!$user) return;

        $menu_home="analyses";
        $dashboard_title = "Analyses";
        $t_indicateurs=[];
        $t_indicateurs["nb_beneficiaires"]="";//$beneficiaires->count();
        $t_indicateurs["nb_entreprises"]="";//$enfants->count();
        $t_indicateurs["nb_employes"]="";//$versements->count();

        return view::make('home',[
            "user"=>$user,
            "dashboard_title"=>$dashboard_title,
            "menu_home" => $menu_home,
            "t_indicateurs" => $t_indicateurs
        ]);
    }

    public function index_parametres()
    {
        $user = Auth::user();
        if(!$user) return;

        $menu_home="parametres";
        $dashboard_title = "Parametres";
        $t_indicateurs=[];


        return view::make('home',[
            "user"=>$user,
            "dashboard_title"=>$dashboard_title,
            "menu_home" => $menu_home,
            "t_indicateurs" => $t_indicateurs
        ]);
    }

    public function index_acces()
    {
        $user = Auth::user();
        if(!$user) return;

        $this->role_name=$user->getRoleNames()->first();
        $menu_home="acces";
        $dashboard_title = "Droits d'accès";

 
        $t_indicateurs=[];
        $t_indicateurs["nb_utilisateurs"]=User::count();
        $t_indicateurs["nb_roles"]=Role::count();
        $t_indicateurs["nb_permissions"]=Permission::count();

        return view::make('home',[
            "user"=>$user,
            "dashboard_title"=>$dashboard_title,
            "menu_home" => $menu_home,
            "t_indicateurs" => $t_indicateurs
        ]);
    }

    public function dash_Administrateur()
    {
        $user = Auth::user();
        $users=User::where('nom','<>','')->get();
        $this->role_name=$user->getRoleNames()->first();

        $dashboard_title = "Tableau de bord";
        $menu_home="";
        $t_indicateurs=MyApp::getIndicateurs("administration");


        return view::make('home',[
            "user"=>$user,
            "dashboard_title"=>$dashboard_title,
            "menu_home" => $menu_home,
            "t_indicateurs" => $t_indicateurs

        ]);
    }


}
