<?php namespace App\Http\Controllers;

use Illuminate\Support\Facades\Auth;
use Auth\AuthController;
use App\Models\User;
use App\Models\Role2;
use App\Models\Parametre;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Redirect;
use View;
use DB;

use App\Http\Requests\AutoResponsableRequest;
use Request;
use Response;
use Illuminate\Database\Schema\MySqlBuilder;


class ImportationController extends Controller {
 

    /**
     * @var array
     */
    public $dbConnection;
    public $table_import = [
            'BANQUE'=>'banques',
            'BENEF'=>'beneficiaires',
            'CLASSE_CPTE'=>'classe_cptes',
            'CONTROLE'=>'controle',
            'CONTROLE_BENEF'=>'controle_benef',
            'COTIS'=>'cotis',
            //'COTISG'=>'cotis_g',
            'CREANCIERS'=>'creanciers',
            'ENFANTS'=>'enfants',
            'IMPUTATION_MDT'=>'imputation_mdt',
            //'JOURNA_H'=>'journal_h',
            'JOURNAL'=>'journal',
            'MANDATS'=>'mandats',
            'PARAMETRES'=>'',
            'PLAN'=>'plans',
            'SALAIRE'=>'salaire',
            'SECTEUR'=>'secteurs',
            'SOCIETE'=>'employeurs',
            'STATUT_BENEF'=>'benef_statuts',
            'SUIVI_SOC'=>'suivi_soc',
            'VERSEM'=>'versem',
            'VERSEM_ARCHIV'=>'',
            'VERSEM_H'=>'versem_h',
            'VERSEM_HG'=>'versem_hg',
        ];



    /**
     * Display a listing of the user.
     *
     * @return Response
     */
    public function index($message="")
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        $path_origine=Parametre::where('ref','=','IMPORT_ORIGINE')->first()->value;       
        $tables=$this->table_import;
        $t_nbligne_dest=array();
        foreach($tables as $origine=>$dest) {
            $nbligne_dest=0;
            if($dest!='') $nbligne_dest = DB::tables($dest)->count();
            $t_nbligne_dest[$dest]=$nbligne_dest;
        }
         

        return View::make('param.importation.index', ["message"=>$message,
            "t_nbligne_dest"=>$t_nbligne_dest,'path_origine'=>$path_origine
            ,'user'=>$user,'table'=>$tables]);
    }

 
     public function index_hyper()
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        $tables=$this->table_import;
        $tablehyper_vol=array();
        $tablesipre_vol=array();
        $cnx_hyper=$this->connexion_hyper();
        foreach($tables as $origine=>$dest) {
            if($cnx_hyper) $tablehyper_vol[$origine]=$this->getCount($origine);
            $tablesipre_vol[$origine]=($dest!='')?DB::table($dest)->count():"-";
        }
        return View::make('param.importation.index_hyper', ['user'=>$user
            ,'tables'=>$tables
            ,'tablehyper_vol'=>$tablehyper_vol
            ,'tablesipre_vol'=>$tablesipre_vol]);
    }


    /* Connexvion au driver ODBC Silae */
    public function connexion_hyper()
    {

        $dsn="siale2";
        //$dsn="DRIVER={Hyper File 7};SERVER=127.0.0.1;";
        $login="";
        $pass="";
        $dbConnection = odbc_connect($dsn, $login, $pass,SQL_CUR_USE_ODBC) or die("echec connexion");
        $this->dbConnection=$dbConnection;
        return $dbConnection;
    }

    /* renvoi le nb enregi via odbc driver */
    public function getCount($table)
    {
        $nb=0;

        if(!$this->dbConnection) return "";
        $sql="SELECT count(*) FROM ".$table.";";
        $result=odbc_exec($this->dbConnection,$sql) or die("echec connexion");
        if(!$result) return false; 
        $fetch=odbc_fetch_row($result);
        if($fetch) $nb=odbc_result($result,1);
        return $nb;
    }


     /**
     * Display a listing of the user.
     *
     * @return Response
     */
    public function load_odbc()
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        $table_org=Request::Input('load_odbc_file');
        $tables=$this->table_import;
        $table_dest=$tables[$table_org];
        if($table_dest=="") {
            return "Rien à faire";
        } 
        $t_org_rows=array();
        $rows_dest=DB::table($table_dest)->get();
        $cnx_hyper=$this->connexion_hyper();
        if($cnx_hyper) {
            $t_org_rows=$this->getRows_ODBC($table_org);
        }
        return Redirect::to('/param/hyperfile');
    }

    public function load_txt()
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        $table_org=Request::Input('load_txt_file');
        $table=$this->table_import;
        $t_nbligne_dest=array();

        $path=Parametre::where('ref','=','IMPORT_ORIGINE')->first()->value;
        $dest=$table_org.".csv";
        $file=$path.$dest;

        if(file_exists($file)) {
            //Vide la table locale
            $table_local=$this->table_import[$table_org];
            DB::table($table_local)->truncate();
            //Lecture du fichier
            $handle = fopen($file, "rb");
            $chaine = '';
            while (!feof($handle)) $chaine .= fread($handle, 8192);
            fclose($handle);
            $tmp=explode("\r\n",$chaine);
            $t_column = $this->getColumnNames($table_local);
            $classe=$this->getClass($table_local);
            $kk=0;$supp_first=false;
            foreach($tmp as $row) {
                $t_row=explode("\t",$row);
                //1ere ligne de titre de colonne
                if($kk==0) {
                    if(strpos($t_row[0],"Enr")>0) { //Cas des exports outils windev
                        $supp_first=true;
                    }
                } else {
                    if($supp_first) {
                        unset($t_row[0]);
                        $t_row = array_values($t_row);  
                    }
                    //if($kk==3) dd($t_row);
                    if(count($t_row)>1) {
                        $t_values=array();
                        $k=0;
                        $table = new $classe;
                        foreach($t_column as $nom_hyper=>$nom_local) {
                            if($nom_hyper!="") $value=$t_row[$k++];
                            else $value='';
                            $value_def=$this->format_value($nom_local,$value);
                            $table->$nom_local=$value_def;
                        }
                        $table->save();
                    //if($t_row[0]=="2130") dd($table);
                    }
                }
                $kk++;
            }
        }
        return Redirect::to('/param/hyperfile');
    }

    public function getRows_ODBC($table_hyper)
    {
        if(!$this->dbConnection) return "";
        $k=0;
        ini_set( 'memory_limit' , '-1' );
        ini_set ( 'odbc.defaultlrl' , '65536' );
        //Vide la table locale
        $table_local=$this->table_import[$table_hyper];
        DB::table($table_local)->truncate();

        $liste_cols=$this->getListeCols($table_local);
        $sql = "SELECT ".$liste_cols." FROM ".$table_hyper;
        $result=odbc_exec($this->dbConnection,$sql);
        while($rows=odbc_fetch_object($result)){
            $this->insert_rows($rows,$table_local);
            $k++;
        }
        return $k;
  }


    public function insert_rows($rows,$table_local)
    {
        $t_column=$this->getColumnNames($table_local);
        $classe=$this->getClass($table_local);
        $table = new $classe;
        foreach($t_column as $nom_hyper=>$nom_local) {
            if($nom_hyper!="")
                $value=$rows->$nom_hyper;
            else $value='';
            $value_def=$this->format_value($nom_local,$value);
            $table->$nom_local=$value_def;
            //echo $table->$nom_local."<br>";
        }
        $table->save();
        return true;
    }



    public function getListeCols($table)
    {
        $liste_cols="";
        $cols=$this->getColumnNames($table);
        foreach($cols as $hyper_name=>$local_name) {
            $liste_cols.=(($liste_cols=="")?"":",").$hyper_name;
        }
        return $liste_cols;
    }

    /* renvoi la classe correspondnate à la table */
    public function getClass($table)
    {
        if($table=="cotis")  $class="Cotisation";
        elseif($table=="versem")  $class="Versement";
        elseif($table=="versem_h")  $class="Versement_h";
        elseif($table=="versem_hg")  $class="Versement_hg";
        else {
            $class=ucfirst($table);
            if(substr($class,-1)=="s") $class=substr($class,0,strlen($class)-1); 
        }
        return "App\\".$class;
    }

    //Mise en forme de la veur selon le type
    public function format_value($col,$value)
    {
        //Cas des dates
        if( (substr($col,0,3)=="dat")
            ||($col=="der_mois") 
            ||($col=="mois") 
            ||($col=="ret_dateed") 
            ||($col=="encais_date")
            ||($col=="ret_date")
            ) {
                $value=($value!="")?date('Y-m-d', strtotime(str_replace('/', '-', $value))):"" ;
            }

        else if(($col=="assiette")||($col=="clr")
            ||($col=="ccpf")||($col=="debit")||($col=="credit")) {
            $value=str_replace(" ","",$value); //assiette,clr,ccpf,debit,credit
        }
        $value=str_replace("|$","\r\n",$value); //Code pour les RC

        return utf8_encode($value);
    }

    /* renvoi l nom de la Table correspondnate à la table (qui peut être abrégée)  */
    public function getTable($table)
    {
        if($table=="cotis")  $table="cotisations";
        elseif($table=="versem")  $table="versements";
        elseif($table=="versem_h")  $table="versements_h";
        elseif($table=="versem_hg")  $table="versements_hg";
        else {
            $class=ucfirst($dest);
            if(substr($class,-1)=="s") $class=substr($class,0,strlen($class)-1); 
        }
        return $table;
    }

     /*
     Chagement via fichier
     */
    public function load_old()
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        $path_origine=Parametre::where('ref','=','IMPORT_ORIGINE')->first()->value;
        $load_file=Request::Input('load_file');
        $table=$this->table_import;
        $t_nbligne_dest=array();
        foreach($table as $origine=>$dest) {
            $nbligne_dest=0;
            if($dest!='') $nbligne_dest = DB::table($dest)->count();
            $t_nbligne_dest[$dest]=$nbligne_dest;
        }
    

        $t=explode('~',Request::Input('load_file'));
        $path=$t[0];
        $dest=$t[1];


        $file=$path;

        if(file_exists($file)) {

            //Suppresion table origine
            DB::table($dest)->truncate();
            //$colums = DB::getSchemaBuilder()->getColumnListing($dest);
            $colums = $this->getColumnNames($dest);

            if($dest=="cotis")  {$class="Cotisation";$dest="cotisations";}
            elseif($dest=="versem")  {$class="Versement";$dest="versements";}
            elseif($dest=="versem_h")  {$class="Versement_h";$dest="versements_h";}
            elseif($dest=="versem_hg")  {$class="Versement_hg";$dest="versements_hg";}
            else {
                $class=ucfirst($dest);
                if(substr($class,-1)=="s") $class=substr($class,0,strlen($class)-1); 
            }
            $class="App\\".$class;



            $handle = fopen($file, "rb");
            $chaine = '';
            while (!feof($handle)) $chaine .= fread($handle, 8192);
            fclose($handle);
            $tmp=explode("\r\n",$chaine);


            $t_rows=array();
            for($i=0;$i<(count($tmp)-2);$i++) { //-2 car updated_at et created_at
                //if($i>27) break;
                $row=explode(";",$tmp[$i+1]);
                //$row=explode("\t",$tmp[$i+1]);
                $k=0;$col_values="";

                foreach($colums as $nomcol_origine=>$nomcol_dest) { 
                    $value=$row[$k];
                    if($nomcol_dest!="") {
                        if( (substr($nomcol_dest,0,3)=="dat")
                            ||($nomcol_dest=="der_mois") 
                            ||($nomcol_dest=="mois") 
                            ||($nomcol_dest=="ret_dateed") 
                            ||($nomcol_dest=="encais_date")
                            ||($nomcol_dest=="ret_date")
                            ) {
                            $value=($value!="")?date('Y-m-d', strtotime(str_replace('/', '-', $value))):"" ;
                        }
                        
                        if(($nomcol_dest=="assiette")||($nomcol_dest=="clr")
                            ||($nomcol_dest=="ccpf")||($nomcol_dest=="debit")||($nomcol_dest=="credit")) {

                            $value=str_replace(" ","",$value); //assiette,clr,ccpf,debit,credit
                        }
                        $col_values.=(($col_values=="")?"":"||").$nomcol_dest."@@".$value;
                    }
                    $k++;
                }
                $t_rows[$i]=utf8_encode($col_values);
                if($k>10) break;
            }

            $k=0;
            foreach($t_rows as $cols) {
                $row = new $class();
                $values=explode("||",$cols);
                foreach($values as $colvalue) {
                    $t_colvalue=explode("@@",$colvalue);
                    $champ=$t_colvalue[0];
                    $value=$t_colvalue[1];
                    $row->{$champ}=$value;
                }
                $row->save();
                //if($k++>10) break;
            }
        }
        $message="Chargement de la table [".$t[1]."] terminé.";     
        return Redirect::to('/param/importations')->with('message', $message);
    }



    public function getColumnNames($table)
    {
        $t_column=array();
        if($table=="salaire") 
            $t_column=["SACLEUNIK"=>"id","BENUM"=>"benum","SONUM"=>"sonum","DATE_ENT"=>"dat_ent",
                "DATESOR"=>"date_sor","ANNEE"=>"annee","JAN"=>"jan","FEV"=>"fev","MAR"=>"mar","AVR"=>"avr","MAI"=>"mai",
                "JUN"=>"jun","JUI"=>"jui","AOU"=>"aou","SEP"=>"sep","OCT"=>"oct","NOV"=>"nov","DEC"=>"dec"];



        if($table=="banques") {
            $t_column=["BQCLEUNIK"=>"id","NOM"=>"nom","Adresse"=>"adresse","CP"=>"cp"
                ,"Ville"=>"ville","TEL"=>"tel","Fax"=>"fax"
                ,"CONTACT"=>"contact","Agence"=>"agence"];
        }

        if($table=="beneficiaires") {
            $t_column=['BENUM' => 'id','SONUM' => 'sonum','N_ALL' => 'n_all','NOM' => 'nom',
                'PRENOM' => 'prenom','DATENAISS' => 'datenaiss','LIEUNAISS' => 'lieunaiss','ADRESSE' => 'adresse',
                'DISTRICT' => 'district','ILE' => 'ile','TEL' => 'tel','FAX' => 'fax','EMAIL' => 'email',
                'NB_ENF' => 'nb_enf','NB_ENF_TOT' => 'nb_enf_tot','OBS' => 'obs','COMPTE' => 'compte',
                'BQCLEUNIK' => 'banque_id','MT_ALLOC' => 'mt_allloc','MT_CALC' => 'mt_calc','RAPPEL' => 'rappel',
                'STATUT' => 'statut','VERROU' => 'verrou','RET_DATEDEC' => 'ret_dateed','RET_NUMDEC' => 'ret_numdec',
                'RET_MONTANT' => 'ret_montant','RET_TYPE' => 'ret_type','RET_RAPPEL' => 'ret_rappel',
                'CONJOINT' => 'conjoint','DATE_PI' => 'date_pi','CIVILITE' => 'civilite','CODE_POSTAL' => 'code_postal',
                'OBS_VERS' => 'obs_vers','NOM_CONJ' => 'nom_conj','PRENOM_CONJ' => 'prenom_conj'
                ];
        }

        
        if($table=="classe_cptes") {
            $t_column=[""=>"id","N_CLASSE"=>"classe","LIB_CLASSE"=>"libelle"];
        }

        
        if($table=="controle") {
            $t_column=["IDCONTROLE"=>"id",'SONUM'=>'sonum','DATE_CONT'=>'date_cont','AGENT1'=>'agent1'
            ,'AGENT2'=>'agent2','DATE_VALID'=>'date_valid','OBSERVATION'=>'observations','BENUM'=>'benum'];
        }
                           

        if($table=="controle_benef") {
            $t_column=["CONTCLEUNIK"=>"id","BENUM"=>"benum"
            ,"IDCONTROLE"=>"idcontrole"
            ,"SALAIRE"=>"salaire","NOM"=>"nom","PRENOM"=>"prenom"
            ,"DATENAIS"=>"date_naiss","DATE_EMBAUCHE"=>"date_embauche"
            ,"DATE_DEBAUCHE"=>"date_debauche"];
        }



        
        if($table=="cotis") {
            $t_column=['COCLEUNIK'=>'id','SONUM'=>'sonum','DATE'=>'date','ASSIETTE'=>'assiette','CLR'=>'clr',
                'CCPF'=>'ccpf','DEBIT'=>'debit','CREDIT'=>'credit','COMPTE'=>'compte','MOIS'=>'mois',
                'NBMOIS'=>'nbmois','BDX'=>'bdx','TYPEPMT'=>'typepmt','ENCAIS_DATE'=>'encais_date',
                'ENCAIS_COMPTE'=>'encais_compte','TYPECOTIS'=>'type_cotis','OBSERVATION'=>'observation',
                'EXERCICE'=>'exercice','NBSAL'=>'nbsal','BDX_PRIVE'=>'bdx_prive'];
        }
        
        if($table=="cotis_g") {
            $t_column=['COCLEUNIK'=>'id','SONUM'=>'sonum','DATE'=>'date','ASSIETTE'=>'assiette','CLR'=>'clr',
                'CCPF'=>'ccpf','DEBIT'=>'debit','CREDIT'=>'credit','COMPTE'=>'compte','MOIS'=>'mois',
                'NBMOIS'=>'nbmois','BDX'=>'bdx','TYPEPMT'=>'typepmt','ENCAIS_DATE'=>'encais_date',
                'ENCAIS_COMPTE'=>'encais_compte','TYPECOTIS'=>'type_cotis','OBSERVATION'=>'observation',
                'EXERCICE'=>'exercice','NBSAL'=>'nbsal','BDX_PRIVE'=>'bdx_prive'];
        }
        
        if($table=="creanciers") {
            $t_column=["IDCREANCIER"=>"id","NUM_CREANCIER"=>"num_creancier","NOM"=>"nom","PRENOM"=>"prenom","DATENAIS"=>"datenaiss",
            "BQCLE_CREANCIER"=>"bqcle_creancier","COMPTE"=>"compte","MONTANT"=>"montant","IDMANDAT"=>"idmandat","OBS"=>"obs",
            "TYPEPMT"=>"typepmt","IDIMP_MDT"=>"idimp_mdt"];
        }
        


        if($table=="employeurs") {                                                               
            $t_column=["SONUM"=>"id","SECLEUNIK"=>"sec_id","NOM"=>"nom","ADRESSE"=>"adresse",
                "ILE"=>"ile","TEL"=>"tel","FAX"=>"fax","EMAIL"=>"email","RESPONSABLE"=>"responsable","NBSAL"=>"nbsal","STATUT"=>"statut",
                "DATE_DEB"=>"date_deb","DATE_FIN"=>"date_fin","NUMRC"=>"numrc","VERROU"=>"verrou","COMPTE"=>"compte",
                "BQCLEUNIK"=>"banque_id","MODE_COTIS"=>"mode_cotis","DER_COTIS"=>"der_cotis","DER_MOIS"=>"der_mois","SOLDEI"=>"soldei",
                "NOM_CONT"=>"nom_cont","DATE_CONT"=>"date_cont","DISTRICT"=>"district","CODE_POSTAL"=>"cp",
                "DATE_MED"=>"date_med","DATE_MAJ"=>"date_maj","OBSERVATION"=>"observation","DATE_CONTR"=>"date_contr"];
        }


        
        if($table=="enfants") {
            $t_column=['ENCLEUNIK'=>'id','NOM'=>'nom','PRENOM'=>'prenom','DATENAIS'=>'datenais',
                'SEXE'=>'sexe','PARENT1'=>'parents1','PARENT2'=>'parents2','CERTIF'=>'certif','COMPTE_P'=>'compte_p',
                'COMPTE_M'=>'compte_m','OBS'=>'obs','VERROU'=>'verrou',
                'BENUM'=>'benum'];
        }
        

        if($table=="imputation_mdt") {
            $t_column=["IDIMP_MDT"=>"id","CPT_IMP"=>"cpt_imp","DESIGNATION"=>"designation","MONTANT"=>"montant",
            "TYPE_IMP"=>"type_imp","OBS"=>"obs","IDMANDAT"=>"idmandat",];
        }
        


        if($table=="journal") {
            $t_column=["JOCLEUNIK"=>"id","DATE"=>"date","NUMCPT"=>"numcpt","REF"=>"ref",
            "LIBELLE"=>"libelle","DEBIT"=>"debit","CREDIT"=>"credit"
            ,"ENC"=>"enc","BUDGET"=>"budget","AMORTISSEMENT"=>"amortissement"];
        }
                  
        if($table=="journal_h") {
            $t_column=["JOCLEUNIK"=>"id","DATE"=>"date","NUMCPT"=>"numcpt","REF"=>"ref",
            "LIBELLE"=>"libelle","DEBIT"=>"debit","CREDIT"=>"credit","ENC"=>"enc","BUDGET"=>"budget","AMORTISSEMENT"=>"amortissement"];
        }


        
        if($table=="mandats") {
            $t_column=["IDMANDAT"=>"id","EXERCICE"=>"exercice","DATE_SAI"=>"date_sai","STATUT_MDT"=>"statut_mdt",
            "DATE_VALID"=>"date_valid","OBSERV_VAL"=>"observation_val","OBSERVATION"=>"observation",
            "DATE_VALID_DIR"=>"date_valid_dir","OBSERV_DIR"=>"observation_dir",];
        }
        

        
        if($table=="plans") {
            $t_column=[""=>"id","NUMCPT"=>"numcpt","NOMCPT"=>"nomcpt","CATEG"=>"categ","POSTE"=>"poste",
            "BUDGET"=>"budget","DEBIT"=>"debit","CREDIT"=>"credit","SOLDEI"=>"soldei","DEBIT_CREDIT"=>"debit_credit",
            "AMORTISSEMENT"=>"amortissement","N_CLASSE"=>"n_classe",];
        }
 


        if($table=="secteurs") {
            $t_column=["SECLEUNIK"=>"id","SECTEUR"=>"nom"];
        }
        
        if($table=="suivi_soc") {                                     
            $t_column=['IDSUIVI_SOC' => 'id','SONUM'=>'so_num'
            ,'TYPE_LETTRE'=>'type_lettre','DATE_SUIVI'=>'date_suivi'
            ,'MAJ_CCPF'=>'maj_ccpf','MAJ_CLR'=>'maj_clr'
            ,'COTIS_CCPF'=>'cotis_ccpf','COTIS_CLR'=>'cotis_clr','VERSMT_MED'=>'versmt_med'
            ,'TOTAL_DETTE'=>'total_dette','EXIGIBILITE'=>'exigibilite','ANNEE'=>'annee'
            ];
        }
        
        if($table=="versem") {
            $t_column=['VECLEUNIK' => 'id','BENUM' => 'benum',
                'MONTANT' => 'montant','DATE' => 'date',
                'BQCLEUNIK' => 'bqcleunik','COMPTE' => 'compte',
                'MODEPMT' => 'mode_pmt','TYPE' => 'type',
                'SONUM' => 'sonum','MONTANT_C' => 'montant_c',
                'MONTANT_R' => 'montant_r','NUMIMP' => 'num_imp',
                'RET_TYPE' => 'ret_type','RET_DATEDEC' => 'ret_date',
                'RET_NUMDEC' => 'ret_num','OBS_VERS' => 'obs_vers',
            ];
        }
        
        if($table=="versem_h") {
            $t_column=['V0CLEUNIK' => 'id','BENUM' => 'benum',
                'MONTANT' => 'montant','DATE' => 'date',
                'BQCLEUNIK' => 'bqcleunik','COMPTE' => 'compte',
                'MODEPMT' => 'mode_pmt','TYPE' => 'type',
                'DATE_VALID' => 'date_valid',
                'SONUM' => 'sonum','MONTANT_C' => 'montant_c',
                'MONTANT_R' => 'montant_r','NUMIMP' => 'num_imp',
                'RET_TYPE' => 'ret_type','RET_DATEDEC' => 'ret_date',
                'RET_NUMDEC' => 'ret_num','OBS_VERS' => 'obs_vers',
            ];
        }

         if($table=="versem_hg") {
            $t_column=['V1CLEUNIK' => 'id','BENUM' => 'benum',
                'MONTANT' => 'montant','DATE' => 'date',
                'BQCLEUNIK' => 'bqcleunik','COMPTE' => 'compte',
                'MODEPMT' => 'mode_pmt','TYPE' => 'type',
                'DATE_VALID' => 'date_valid',
                'SONUM' => 'sonum','MONTANT_C' => 'montant_c',
                'MONTANT_R' => 'montant_r','NUMIMP' => 'num_imp',
                'RET_TYPE' => 'ret_type','RET_DATEDEC' => 'ret_date',
                'RET_NUMDEC' => 'ret_num','OBS_VERS' => 'obs_vers',
            ];

        }
        
        
        return $t_column;

    }
}