<?php namespace App\Http\Controllers;

use Auth\AuthController;
use App\User;
use App\Models\Journal;
use App\Models\Compte;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Auth;
use Illuminate\Http\Request;
use App\Http\Requests\JournalRequest;
use View;
use Validator;

class JournauxController extends Controller {
 
    private $menu='configuration';
    private $submenu='journaux';
    private $menu_home='comptabilite';

    public function __construct()
    {
        //$this->beforeFilter('auth');

    }
 
    public function index()
    {
        $user = Auth::user();
        if(!$user) return Redirect::route( 'login' );
        $journaux=Journal::orderby('nom_court','ASC')->get(); 
        return View::make('comptabilite.journaux.index', 
            [
                'user' => $user,'menu' => $this->menu,'submenu' => $this->submenu,'menu_home' => $this->menu_home,
                'journaux'=>$journaux
            ]);

    }
 
    public function create()
    {
        $user = Auth::user();
        if(!$user) return Redirect::route( 'login' );
        $mode="create";

        return View::make('comptabilite.journaux.create', 
            [
                'user' => $user,'menu' => $this->menu,'submenu' => $this->submenu,'menu_home' => $this->menu_home,
                'mode' => $mode,
            ]);
    }
 
    public function store(JournalRequest $request)
    {
        $user = Auth::user();
        if(!$user) return Redirect::route( 'login' );

        $journal=$this->setData($request);
        return Redirect::to('/journaux');
    }
 
    public function edit($id)
    {
        $user = Auth::user();
        if(!$user) return Redirect::route( 'login' );
        $mode="edit";

        $journal=Journal::find($id);
        return View::make('comptabilite.journaux.edit', 
            [
                'user' => $user,'menu' => $this->menu,'submenu' => $this->submenu,'menu_home' => $this->menu_home,
                'mode' => $mode,
                'journal' => $journal
            ]);
    }
 

    public function update($id,JournalRequest $request)
    {
        $user = Auth::user();
        if(!$user) return Redirect::route( 'login' );

        $journal=$this->setData($request,$id);

        return Redirect::to('/journaux');
    }
 
    public function show($id)
    {
        $user = Auth::user();
        if(!$user) return Redirect::route( 'login' );
        $mode="show";

        $journal=Journal::find($id);
        return View::make('comptabilite.journaux.show', 
            [
                'user' => $user,'menu' => $this->menu,'submenu' => $this->submenu,'menu_home' => $this->menu_home,
                'mode' => $mode,
                'journal' => $journal,
            ]);
    }

    public function destroy($id)
    {
        $journal=Journal::find($id);
        $msg="Le Journal ".$journal->nom." a été supprimé";
        $nb_ecritures=$journal->NbEcritures;
        if($nb_ecritures>0) {
            $msg="Ce journal ne peut pas être supprimé, il contient des écritures";
            return Redirect::back()->with('message', $msg);
        }

        Journal::destroy($id);
        return Redirect::to('/journaux')->with('message', $msg);
        
    }

    public function setData($request,$id="")
    {
        if($id!="") $journal=Journal::find($id);
        else $journal=new Journal;

        $journal->nom = $request->nom;
        $journal->nom_court = strtoUpper($request->nom_court);
        $journal->save();

        return Redirect::to('/journaux');
    }


}



