<?php namespace App\Http\Controllers;

use Illuminate\Support\Facades\Auth;
use Auth\AuthController;
use Illuminate\Support\Facades\Session;
use App\Models\User;
use App\Models\Log;


class Logs  {

    /* ********************************************************************** */
    /* enregistrement d'une opération dans logs                               */
    /* Ex.$this->addlog(array('url'=>'http://..','table'=>'user','operation'=>'u','values'=>'..sql')); */
    /* ********************************************************************** */
    public function addlog($t_values)
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        $log = new Log;
        $log->login  = $user->login;
        $log->ip = $this->getUserIP();
        $log->date  = date('Y-m-d H:i:s');
        $log->menu = $t_values['url'];
        $log->table = $t_values['table'];
        $log->operation = $t_values['operation'];
        $log->values = $t_values['values'];
        $log->save();
        return;
    }


    public function getUserIP()
    {
        $client  = @$_SERVER['HTTP_CLIENT_IP'];
        $forward = @$_SERVER['HTTP_X_FORWARDED_FOR'];
        $remote  = $_SERVER['REMOTE_ADDR'];

        if(filter_var($client, FILTER_VALIDATE_IP))
        {
            $ip = $client;
        }
        elseif(filter_var($forward, FILTER_VALIDATE_IP))
        {
            $ip = $forward;
        }
        else
        {
            $ip = $remote;
        }

        return $ip;
    }
}
