<?php namespace App\Http\Controllers;

use Illuminate\Support\Facades\Auth;
use Auth\AuthController;
use App\Models\Employeur;
use App\Models\Beneficiaire;
use App\Models\Salaire;
use App\Models\User;
use App\Models\LogSalaire;
use App\Models\MyApp;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Redirect;
use View;


class LogsSalairesController extends Controller {

    private $menu='tiers';
    private $submenu='salaires';
    private $menu_home='recouvrement';


    public function __construct()
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
    }


    /**
     * Liste des salaires modifiés
     */
    public function index_salaires($id)
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        $salaire=Salaire::find($id);
        $t_res=$salaire->get_log();

        $mode="S";
        return View::make('logs.index_salaires', [
            'user' => $user,'menu' => $this->menu,'submenu' => $this->submenu,'menu_home' => $this->menu_home,
            't_res' => $t_res,'salaire' => $salaire,
            'mode'=>$mode
        ]);
    }


     public function index_historique($annee="",$id_employeur=0)
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );

        if($annee=="") $annee=date('Y');
        $employeur=[];
        if($id_employeur>0) {
            $employeur = Employeur::find($id_employeur);
            $salaires_logs=LogSalaire::where('created_at','like',$annee."%")
            ->where('sonum','=',$id_employeur)->orderby('id','DESC')->get();
        } else {
            $salaires_logs=LogSalaire::where('created_at','like',$annee."%")->orderby('id','DESC')->get();
        }

        $t_res=[];
        foreach($salaires_logs as $salaire_log) {
            $salaire=Salaire::find($salaire_log->id_salaire);
            $t_res[]=$salaire->get_log($salaire_log->id);
        }

        return View::make('logs.index_salaires_employeur',
            [
                'user' => $user,'menu' => $this->menu,'submenu' => $this->submenu,'menu_home' => $this->menu_home,
                't_res' => $t_res,
                'employeur' => $employeur
            ])
            ;
    }
    /**
     * Show the form for creating a new user.
     *
     * @return Response
     */
    public function create($beneficiaire_id,$employeur_id)
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );

        $liste_employeur = Employeur::orderBy('nom','ASC')->pluck('nom','id')->toArray();
        $beneficiaire = Beneficiaire::find($beneficiaire_id);
        $employeur = Employeur::find($employeur_id);

        return View::make('recouvrement.salaires.create',
        [
            'user' => $user,'menu' => $this->menu,'submenu' => $this->submenu,'menu_home' => $this->menu_home,
            'employeur' => $employeur,
            'beneficiaire' => $beneficiaire,
        ]);
    }



    /**
     * Store a newly created user in storage.
     *
     * @return Response
     */
    public function store(SalaireRequest $request)
    {
        $salaire_exist=salaire::where('annee','=',$request->annee)
            ->where('benum','=',$request->benum)
            ->where('sonum','=',$request->sonum)
            ->first();

        $t_error=array();
        if($salaire_exist) {
            $t_error['doublon']="Cette année de salaire existe déjà pour cet employé et cet employeur, vous ne pouvez pas la créer une nouvelle fois !";
        }
        //if($request->annee>date('Y')) {
        //    $t_error['doublon']="Vous ne pouvez pas saisir les salaires d'une années supérieur à l'année en cours.";
        //}
        if(intval($request->annee)>(intval(date('Y'))+10)) {
            $t_error['doublon']="Vous ne pouvez pas saisir les salaires d'une années supérieur à l'année en cours plus 10 ans.";
        }
        if (count($t_error)>0) {
            //Session::flash('nom_compte2', $plan2->nomcpt);
            return redirect()->back()
                ->withInput()
                ->withErrors($t_error);
        }

        $salaire = $this->setData($request);

        //Changement d'Employeur si besoin
        $employeur_id=$salaire->sonum;
        $beneficiaire=Beneficiaire::find($salaire->benum);
        $salaire_last=Salaire::where('benum','=',$salaire->benum)->orderby('annee','DESC')->first();
        if( ($salaire_last->annee==$salaire->annee) && ($salaire->sonum!=$beneficiaire->sonum) ) {
            $beneficiaire->sonum=$salaire->sonum;
            $beneficiaire->save();
        }

        return Redirect::to('recouvrement/salaire_annee/'.$request->sonum.'/'.$salaire->benum.'/'.$salaire->annee);
    }


    public function edit($id)
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );

        $salaire=Salaire::find($id);
        $liste_employeur = Employeur::orderBy('nom','ASC')->pluck('nom','id')->toArray();
        $beneficiaire=Beneficiaire::find($salaire->benum);
        $employeur = Employeur::find($salaire->sonum);

        return View::make('recouvrement.salaires.edit',
            [
                'user' => $user,'menu' => $this->menu,'submenu' => $this->submenu,'menu_home' => $this->menu_home,
                'employeur' => $employeur,
                'salaire' => $salaire,
            ]);
    }


    public function show($id)
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );

        $salaire = Salaire::find($id);
        return View::make('recouvrement.salaires.show', [
            'user' => $user,'menu' => $this->menu,'submenu' => $this->submenu,'menu_home' => $this->menu_home,
            'salaire'=> $salaire
        ]);
    }


    public function update($id,SalaireRequest $request)
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );

        $salaire = $this->setData($request,$id);
        //Changement d'Employeur si besoin
        $employeur_id=$salaire->sonum;
        $beneficiaire=Beneficiaire::find($salaire->benum);
        $salaire_last=Salaire::where('benum','=',$salaire->benum)->orderby('annee','DESC')->first();
        if( ($salaire_last->id==$salaire->id) && ($salaire->sonum!=$beneficiaire->sonum) ) {
            $beneficiaire->sonum=$salaire->sonum;
            $beneficiaire->save();
        }

        return Redirect::to('recouvrement/salaire_annee/'.$request->sonum.'/0/'.$salaire->annee);
    }


     public function setData($request,$id="")
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );

        $tmois=['jan','fev','mar','avr','mai','jun','jui','aou','sep','oct','nov','dec'];
        if($id) $salaire = Salaire::find($id);
        else $salaire = new Salaire;

        //Si modification on logs
        if($id) {
            $t_salaire_old=[];
            $t_cols=['benum','sonum','sonum','dat_ent','date_sor','annee','jan','fev','mar','avr','mai','jun','jui','aou','sep','oct','nov','dec'];
            foreach($t_cols as $col) $t_salaire_old[$col]=$salaire->{$col};
        }

        $salaire->benum = $request->benum;
        $salaire->sonum = $request->sonum;
        $date = $request->dat_ent;
        $salaire->dat_ent = ($date!="")?date('Y-m-d', strtotime(str_replace('/', '-', $date))):null  ;
        $date = $request->date_sor;
        $salaire->date_sor = ($date!="")?date('Y-m-d', strtotime(str_replace('/', '-', $date))):null  ;
        $salaire->annee = $request->annee;
        foreach($tmois as $mois) {
            $salaire->{$mois} = $request->{$mois};
            if($request->{$mois.'_vent'}<>0) $salaire->{$mois}+=$request->{$mois.'_vent'};
        }
        $salaire->save();

        //LOG de la transaction
        $type_log=($id)?'I':'U';
        $salaire->log_transaction($request->url(),$type_log);

        //LOG Modifications
        if($id) {
            foreach($t_cols as $col) {
                if($t_salaire_old[$col]!=$salaire->{$col}) {
                    $log_salaire = new LogSalaire;
                    $log_salaire->id_salaire=$salaire->id;
                    $log_salaire->benum=$salaire->benum;
                    $log_salaire->sonum=$salaire->sonum;
                    $log_salaire->col=$col;
                    $log_salaire->val_old=$t_salaire_old[$col];
                    $log_salaire->val_new=$salaire->{$col};
                    $log_salaire->login=$user->login;
                    $log_salaire->ip=MyApp::getUserIP();
                    $log_salaire->save();
                }
            }
        }

        return $salaire;
    }



    /**
     * Remove the specified user from storage.
     *
     * @param  int  $id
     * @return Response
     */
    public function destroy($id,$employeur_id='999999',$beneficiaire_id=0,$exercice="")
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );

        $salaire = Salaire::find($id);
        if(!$salaire) return Redirect::to('recouvrement/salaire_annee/'.$employeur_id.'/'.$beneficiaire_id.'/'.$exercice);

        $sonum = $salaire->sonum;
        $benum = $salaire->benum;
        Salaire::destroy($id);

        if(($employeur_id==0)||($employeur_id=='999999')) $sonum="999999";
        if($beneficiaire_id==0) $benum="0";

        return Redirect::to('recouvrement/salaire_annee/'.$sonum.'/'.$benum.'/'.$exercice);
    }



    /**
     * Listes des employeurs
     */
    public function getListeEmployeur($avec_id=false)
    {
        $liste_employeur=Employeur::distinct()->select('nom','id')
            ->whereIn('statut',array('ACT','ASV'))
            ->orderBy(($avec_id)?'id':'nom')->pluck('nom','id')->toArray();
        $liste_employeur2=array();
        foreach($liste_employeur as $id=>$nom) {
            $id_pad=str_pad($id,4,"0", STR_PAD_LEFT);
            $nom=trim($nom);
            $liste_employeur2[$id]=htmlentities(str_replace('"','',$nom));
            if($avec_id) $liste_employeur2[$id]=$id_pad." ".$liste_employeur2[$id];
            else $liste_employeur2[$id]=$liste_employeur2[$id]." (".$id_pad.")";
        }
        asort($liste_employeur2);
        return $liste_employeur2;
    }


    /**
     * Listes des exercices
     */
    public function getListeExercices()
    {
        $exercices = Parametre::where('ref','=','TAUX_CLR_CCPF')->first()->Exercices;

        return $exercices;
    }

    public function getListeExercicesBi()
    {
        $exercices = $this->getListeExercices();
        $nb_exercices=count($exercices );
        $k=0;$t=array();
        foreach($exercices as $exercice) {
            $k++;
            $exercice_min=intval($exercice)-1;
            $exercice_max=intval($exercice)+1;
            if($k%2==0) {
                $t[$exercice_min."-".$exercice]=$exercice_min." - ".$exercice;
                if($k<$nb_exercices) $t[$exercice."-".$exercice_max]=$exercice." - ".$exercice_max;
            }
        }
        arsort($t);
        $t['*']='Tous';
        return $t;
    }





}
