<?php namespace App\Http\Controllers;

use Auth\AuthController;
use App\Models\Med;
use App\Models\Employeur;
use App\Models\User;
use App\Models\Role2;
use App\Models\Parametre;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Redirect;
use View;
use DB;
use Illuminate\Support\Facades\Auth;
use App\Http\Requests\MedRequest;
use Request;
use Response;


class MedController extends Controller {
    private $menu='suivi';
    private $submenu='med';
    private $menu_home='recouvrement';

    public function index($param="")
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        $meds = Med::all();

        return View::make('recouvrement.med.index', ['meds' => $meds, 'user'=>$user]);
    }
 

    public function create($employeur_id="",$exercice="")
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );

        $employeur = Employeur::find($employeur_id);
        $liste_employeur=$this->getListeEmployeur(true);  

        $exercice_encours=Parametre::where('ref','=','CPT_EXERCICE')->first()->value;
        if($exercice=="") $exercice=$exercice_encours-1; 
        $prc_maj=Parametre::where('ref','=','CAL_PRC_MAJ')->first()->value;
        $taux_CLR=Parametre::where('ref','=','TAUX_CLR_CCPF')->first()->getTauxCLRAttribute();
        $taux_CPF=Parametre::where('ref','=','TAUX_CLR_CCPF')->first()->getTauxCCPFAttribute();
        $taux=$taux_CLR[$exercice]+$taux_CPF[$exercice];
        $masse_dernier=$employeur->getMasseDerniersSalaires($exercice);
        $mois_manquants=$employeur->getNbMoisManquantsSalaires($exercice);
        $taux_total=$taux;
        $cotisations=round($masse_dernier*$taux_total/100,0);
        $cotisations=$cotisations*$mois_manquants;
        $majorations=$employeur->getMajoration($exercice);

        return View::make('recouvrement.med.create', [
            'user' => $user,'menu' => $this->menu,'submenu' => $this->submenu,'menu_home' => $this->menu_home,
            "employeur"=>$employeur,
            "liste_employeur"=>$liste_employeur,
            'cotisations'=>$cotisations,
            'majorations'=>$majorations,
            'nbmois' => $mois_manquants
            ]);
    }
 

    public function store(MedRequest $request)
    {
        $med = $this->setData($request);
        return Redirect::to('/med_prepa');
    }
 

    public function edit($id)
    {

    }
 

    public function update($id,MedRequest $request)
    {
        $med = $this->setData($request,$id);
        return Redirect::to('/med');
    }
 


    public function show($id)
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        $med=Med::find($id);
        $mode="show";
        return View::make('recouvrement.med.show', 
            [
                'user' => $user,'menu' => $this->menu,'submenu' => $this->submenu,'menu_home' => $this->menu_home,
                'mode' => $mode,'med' => $med,
            ]);
     }


    public function destroy($id)
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if(!$user->can("MED_SUP") && !$user->HasRole("ADMINISTRATEUR")) return Redirect::to('med');

        $med=Med::find($id);  
        $employeur_id=$med->sonum;
        Med::destroy($id);
        return Redirect::to('med');
    }


    public function setData($request,$id="")
    {
        if($id) $med = Med::find($id);
        else $med = new Med;

        $med->date_envoi = ($date!="")?date('Y-m-d', strtotime(str_replace('/', '-', $date))):"" ;
        $med->sonum = $request->sonum;
        $med->motif = $request->motif;
        $med->nbmois = $request->nbmois;
        $med->cotisations = $request->cotisations;
        $med->majorations = $request->majorations;
        $date=$request->periode_deb;
        $med->periode_deb = ($date!="")?date('Y-m-d', strtotime(str_replace('/', '-', $date))):"" ;

        $date=$request->periode_fin;
        $med->periode_fin = ($date!="")?date('Y-m-d', strtotime(str_replace('/', '-', $date))):"" ;

        $med->obs = $request->obs;
        $med->numero =DB::table('med')->max('numero')+1;
        $med->save();

        return $med;
    }


    /**
     * Listes des employeurs
     */
    public function getListeEmployeur($avec_id=false)
    {
        $liste_employeur=Employeur::distinct()->select('nom','id')->orderBy('id')->pluck('nom','id')->toArray();
        $liste_employeur2=array();
        foreach($liste_employeur as $id=>$nom) {
            $nom=trim($nom);
            $liste_employeur2[$id]=htmlentities(str_replace('"','',$nom));
            if($avec_id) $liste_employeur2[$id]=str_pad($id,4,"0", STR_PAD_LEFT)." ".$liste_employeur2[$id];
        }
        return $liste_employeur2;
    }

}