<?php namespace App\Http\Controllers;

use Auth\AuthController;

use Illuminate\Support\Facades\Auth;
use App\Models\User;
use App\Models\Parametre;
use App\Models\Role2;
use Illuminate\Support\Facades\Session;
use View;
use DB;
use Illuminate\Http\Request;

class ParametresController extends Controller {


    private $menu='parametres';
    private $submenu='';
    private $menu_home='parametres';


    public function index($page="",$mode="edit")
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        //$parametres = Parametre::where('nom', 'not like', 'date_%')->orderBy('position')->get();
        //les paramètres commencant pas np ne sont pas utilisés dans les interfaces
        $parametres = Parametre::where('ref', 'not like', 'np%')->orderBy('position')->get();

        $this->submenu=$page;
        $title="";
        if($page=="messages") {$title="Messages";$this->menu='messages';}
        if($page=="emails") {$title="Emails";$this->menu='messages';}
        if($page=="divers") $title="Divers";
        if($page=="recouvrement") $title="Recouvrement";
        if($page=="taux") $title="Taux et Calculs";
        if($page=="editions") $title="Edition";
        if($page=="comptabilite") $title="Comptabilite";
        
        return View::make('param.index', [
            'user' => $user,'menu' => $this->menu,'submenu' => $this->submenu,'menu_home' => $this->menu_home,
            'page' => $page,'title' => $title,'mode' => $mode,
            'parametres' => $parametres,
        ]);
    }

    public function show($id=0,$page)
    {
        return $this->index($page,"show");
        exit();
    }


    public function create()
    {
        return View::make('param.parametres.create');
    }

    public function store(Request $request)
    {
        return Redirect::to('/param/parametres');
    }


    public function edit($id)
    {
        $parametre = Parametre::find($id);
        return View::make('param.parametres.edit', [ 'parametre' => $parametres ]);
    }


    public function update(Request $request)
    {
        

        $page=$request->page;
         $parametres="";
        if($page=="messages") $parametres=Parametre::where('ref', 'like', 'MSG%')->get(); //sauf les dates $code=["MSG"];
        if($page=="emails") $parametres=Parametre::where('ref', 'like', 'MAI%')->get(); //$code=["MAI"];
        if($page=="comptabilite") $parametres=Parametre::where('ref', 'like', 'CPT%')->get(); //$code=["CPT"];
        if($page=="divers") $parametres=Parametre::where('ref', 'like', 'DIV%')->get(); //$code=["DIV"];
        if($page=="recouvrement") $parametres=Parametre::where('ref', 'like', 'REC%')->orwhere('ref', 'like', 'LST%')->get(); //$code=["REC"];
        if($page=="taux") $parametres=Parametre::where('ref', 'like', 'CAL%')->orwhere('ref', 'like', 'TAUX%')->get(); //$code=["CAL","TAUX"];
        if($page=="editions") $parametres=Parametre::where('ref', 'like', 'EDI%')->get(); //$code=["EDI"];

        $msg="Aucune mise à jour effectuée";
        if($parametres) {
            foreach($parametres as $param) {
                if($param) {
                    if($param->ref=="TAUX_CLR_CCPF") { //Cas particulier ds taux
                        $res="";
                        $t_taux=explode("\r\n",$param->value);
                        rsort($t_taux);
                        $max_annee=(intval(substr($t_taux[0],0,4))+1);
                        sort($t_taux);
                        $min_annee=(intval(substr($t_taux[0],0,4)));
                        for($i=$min_annee;$i<=$max_annee;$i++) {
                            $annee=$request->{$param->ref."_clr_".$i};
                            $ccpf=$request->{$param->ref."_ccpf_".$i};
                            $clr=$request->{$param->ref."_clr_".$i};
                            if($ccpf.$clr!="") $res.=(($res=="")?"":"\r\n").$i.";".$clr.";".$ccpf;
                        }
                        $param->value =$res;
                        $param->save();
                    }
                    else {
                        $param->value = ($request->{$param->ref});
                        
                        $param->save();
                    }
                }
            }
            $msg="Mise à jour effectuée";
        }

        $page=$request->page;
        Session::flash('success', $msg);

        return redirect('/parametres_detail/'.$page);
    }

    public function destroy($id)
    {
        dd('ee');
    }
}
