<?php namespace App\Http\Controllers;

use Auth\AuthController;
use App\User;
use App\Models\Employeur;
use App\Models\PlanComptable;
use App\Models\GrandLivre;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Auth;
use Illuminate\Http\Request;
use App\Http\Requests\PlanComptableRequest;
use View;
use Validator;

class PlanComptableController extends Controller {
 
    private $menu='configuration';
    private $submenu='plan_comptable';
    private $menu_home='comptabilite';

    public function __construct()
    {
        //$this->beforeFilter('auth');

    }
 
    public function index()
    {
        $user = Auth::user();
        if(!$user) return Redirect::route( 'login' );
        $plancomptables=PlanComptable::orderby('compte','ASC')->get(); 
        return View::make('comptabilite.plan_comptable.index', 
            [
                'user' => $user,'menu' => $this->menu,'submenu' => $this->submenu,'menu_home' => $this->menu_home,
                'plancomptables'=>$plancomptables
            ]);

    }
 
    public function create()
    {
        $user = Auth::user();
        if(!$user) return Redirect::route( 'login' );
        $mode="create";
        return View::make('comptabilite.plan_comptable.create', 
            [
                'user' => $user, 'menu' => $this->menu,'submenu' => $this->submenu,'menu_home' => $this->menu_home,
                'mode' => $mode
            ]);
    }
 
    public function store(PlanComptableRequest $request)
    {
        $plancomptable =$this->setData($request);
        return Redirect::to('/plan_comptable');
    }
 
    public function edit($id)
    {
        $user = Auth::user();
        if(!$user) return Redirect::route( 'login' );
        $mode="edit";
        $plan_comptable=PlanComptable::find($id);
        return View::make('comptabilite.plan_comptable.edit', 
            [
                'user' => $user, 'menu' => $this->menu,'submenu' => $this->submenu,'menu_home' => $this->menu_home,
                'mode' => $mode, 
                'plan_comptable' => $plan_comptable
            ]);
    }
 

    public function update($id,PlanComptableRequest $request)
    {
        $plancomptable=$this->setData($request,$id);
        return Redirect::to('/plan_comptable');
    }
 
    public function show($id)
    {
        $user = Auth::user();
        if(!$user) return Redirect::route( 'login' );


        $mode="show";
        $plan_comptable=PlanComptable::find($id);

        return View::make('comptabilite.plan_comptable.show', 
            [
                'user' => $user, 'menu' => $this->menu,'submenu' => $this->submenu,'menu_home' => $this->menu_home,
                'mode' => $mode, 
                'plan_comptable' => $plan_comptable
            ]);
    }

    public function destroy($id)
    {
        $msg="";
        $plancomptable=PlanComptable::find($id);

        if(!$plancomptable->HasLink) PlanComptable::destroy($id);
        else $msg="Il faut supprimer les opérations ou les tiers liés à ce compte avant de pouvoir le supprimer.";

        if($msg!="") Session::flash('message', $msg);
        return Redirect::back()->with('msg', $msg);
    }
 
     public function setData($request,$id="") {
        $plancomptable=[];
        if($id!="") $plancomptable=PlanComptable::find($id);
        else $plancomptable =  new PlanComptable;

        $plancomptable->compte = $request->compte;
        $plancomptable->libelle = ($request->libelle);
        $plancomptable->categ_bilan = $request->categ_bilan;
        $plancomptable->titre = isset($request->titre)?$request->titre:0;
        $plancomptable->actif = isset($request->actif)?$request->actif:0;
        $plancomptable->previsionnel = $request->previsionnel;
        $plancomptable->save();

        return $plancomptable;
    }


}



