<?php namespace App\Http\Controllers;

use Auth\AuthController;
use App\Models\GrandLivre;
use App\Models\MyApp;
use App\Models\Cotisation;
use App\Models\PlanComptable;
use App\Models\Employeur;
use App\Models\Journal;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Auth;
use Illuminate\Http\Request;
use App\Models\Parametre;
use View;
use DB;


class RANController extends Controller {

    private $menu='configuration';
    private $submenu='ran';
    private $menu_home='comptabilite';
    /*
    private $compte_cotis_clr="474001"; //COTISANTS CLR...
    private $compte_cotis_cpswf="474000"; //COTISANTS CCPF...
    private $compte_contrep_cpswf="756200"; //COTISATIONS PRIVE CCPF..
    private $compte_contrep_clr="756201"; //COTISATIONS PRIVE CLR...
    */

    private $compte_cotis_clr=MyApp::RAN_COMPTES_COTISANT_CLR; //COTISANTS CLR...
    private $compte_cotis_cpswf=MyApp::RAN_COMPTES_COTISANT_CPSWF; //COTISANTS CCPF...
    private $compte_contrep_cpswf=MyApp::RAN_COMPTES_CONTREP_CPSWF; //COTISATIONS PRIVE CCPF..
    private $compte_contrep_clr=MyApp::RAN_COMPTES_CONTREP_CLR; //COTISATIONS PRIVE CLR...

    public function index($categ="R",$exercice="",$compte_aux="")
    {
        $user = Auth::user();
        if(!$user) return Redirect::route( 'login' );

        //Exercices .. cumul avant 2021
        $t_exercices = Parametre::where('ref','=','TAUX_CLR_CCPF')->first()->Exercices;
        foreach($t_exercices as $value) if($value>2020) $exercices[$value]=$value;
        if(!$exercice) {
            $exercice=Session::get("select_exercice_ran");
            if(!$exercice) $exercice=date('Y')-1;
        } 

        if($compte_aux=="") $compte_aux=Session::get("select_compte_aux_ran");
        $data_aux=[];
        $data_aux[]=["id"=> "0","text"=>"Tous"];
        $comptes_aux=DB::table('employeurs')->select(db::raw("CONCAT(compte_aux,' (',LEFT(TRIM(nom),20),'..)') as nom"),"compte_aux")->whereNotNull('compte_aux')->orderby("compte_aux")->get();
        foreach($comptes_aux as $cpt) $data_aux[] = ["id"=> $cpt->compte_aux,"text"=>$cpt->nom];
        $comptes_aux_json=json_encode($data_aux);  

        return View::make('comptabilite.ran.index_ran', [ 
            'user' => $user,'menu' => $this->menu,'submenu' => $this->submenu,'menu_home' => $this->menu_home,
            "exercices"=>$exercices,'exercice'=>$exercice,
            'compte_aux'=>$compte_aux,'comptes_aux_json'=>$comptes_aux_json

        ]);
    }


    public function getDataRAN($exercice,$compte_aux="")
    {
       //1658 ACADEMIE DES LANGUES ...
        if($compte_aux)  $employeurs=Employeur::where('compte_aux','=',$compte_aux)->get();
        else $employeurs=Employeur::where('id','<>','')->orderby("compte_aux","ASC")->get();
        $data_compta=[];$i=0;

        $taux_CLR=MyApp::getTauxCLR($exercice);
        $taux_CPF=MyApp::getTauxCPF($exercice);

        foreach($employeurs as $employeur) {
            if($exercice<="2021") {
                $cotisation=Cotisation::select(DB::raw('sonum,SUM(clr) as tot_clr, SUM(ccpf) as tot_ccpf'))
                ->where('sonum','=',$employeur->id)
                ->where('exercice','<=',$exercice)
                ->groupby('sonum')
                ->first();
            } else {
                $cotisation=Cotisation::select(DB::raw('sonum,SUM(clr) as tot_clr, SUM(ccpf) as tot_ccpf, SUM(credit) as tot_credit'))
                ->where('sonum','=',$employeur->id)
                ->where('exercice','=',$exercice)
                //->where(DB::raw('YEAR(mois)'),"=",$exercice)
                ->groupby('sonum')
                ->first();   
            }
            if($cotisation) {
                $tot_clr=intVal($cotisation->tot_clr);
                $tot_ccpf=intVal($cotisation->tot_ccpf);
                $tot_credit=intVal($cotisation->tot_credit);
                $tot_credit_clr=intVal($taux_CLR/($taux_CLR+$taux_CPF)*$tot_credit); // On répartie le credi en fonction des taux
                $tot_credit_cpf=$tot_credit-$tot_credit_clr;

//$tot_credit_clr=0;$tot_credit_cpf=0;
                //CLR
                $data_compta['type'][$i]="CLR";
                $data_compta['id_employeur'][$i]=$employeur->id;
                $data_compta['compte'][$i]=$this->compte_cotis_clr;
                $data_compta['compte_aux'][$i]=$employeur->compte_aux;
                $data_compta['solde'][$i]=$tot_clr;//-$tot_credit_clr;
                $data_compta['credit'][$i]=$tot_credit_clr;
                $i++;
                //CCPF
                $data_compta['type'][$i]="CCPF";
                $data_compta['id_employeur'][$i]=$employeur->id;
                $data_compta['compte'][$i]=$this->compte_cotis_cpswf;
                $data_compta['compte_aux'][$i]=$employeur->compte_aux;
                $data_compta['solde'][$i]=$tot_ccpf;//-$tot_credit_cpf;
                $data_compta['credit'][$i]=$tot_credit_cpf;
                $i++;
            }

            //Recherche des Crédits
            /*
            if($exercice>"2021") { //Comptesa ux après 2021
                $cotisation=Cotisation::select(DB::raw('sonum,SUM(credit) as tot_credit'))
                ->where('sonum','=',$employeur->id)
                ->where('exercice','=',$exercice)
                //->where(DB::raw('YEAR(mois)'),"=",$exercice)
                ->groupby('sonum')
                ->first(); 
                //CCPF
                $data_compta['type'][$i]="REG";
                $data_compta['id_employeur'][$i]=$employeur->id;
                $data_compta['compte'][$i]=$this->compte_cotis_cpswf;
                $data_compta['compte_aux'][$i]=$employeur->compte_aux;
                $data_compta['solde'][$i]=intVal($cotisation->tot_ccpf);
                $i++;
            }
            */
        }
        return $data_compta;
    }


    public function generate($exercice,$compte_aux="")
    {
        $user = Auth::user();
        if(!$user) return Redirect::route( 'login' );

        $msg="";
        if(!$exercice) $msg="Il faut choisir un exercice";

        Session::put("select_exercice_ran",$exercice); //Mise en session le dernier choix recouvrement
        Session::put("select_compte_aux_ran",$compte_aux); //Mise en session le dernier choix recouvrement

        date_default_timezone_set('Pacific/Noumea');
        $date_time=date('Y-m-d h:i:s');
        $data_compta=$this->getDataRAN($exercice,$compte_aux);
        if(count($data_compta)==0) {
            return Redirect::back()->with('message', "Aucune écriture à reporter");
        }

        $total=["CLR"=>0,"CCPF"=>0];
        $total_reg=["CLR"=>0,"CCPF"=>0];
        $journal_code="ANV";
        $journal_label="";
        $journal=Journal::where('nom_court','=',$journal_code)->first();
        if($journal_label) $journal_label=$journal->nom;

        //Suppression des anciennes lignes
        foreach($total as $caisse=>$value) {
            $grand_livre=GrandLivre::where("ref_doc","=","RAN ".$caisse."-".$exercice)->delete();
        }
        //

        //* ************************************************
        //1. CREATION des lignes APPEL A COTISATIONS
        //* ************************************************
        $nb_lignes=0;
        $t_transaction=[];

        for($i=0;$i<count($data_compta['compte']);$i++) {
            if($data_compta['solde'][$i]<>0) {
                $caisse=$data_compta['type'][$i];
                if(!isset($t_transaction[$caisse])) $t_transaction[$caisse]=GrandLivre::max('transaction')+1;
                $num_transaction=$t_transaction[$caisse];
                // Recherche comptes 
                $compte_label=""; $compte_aux_label="";
                $compte=$data_compta['compte'][$i];
                $compte_aux=$data_compta['compte_aux'][$i];
                $plan_comptable=PlanComptable::where('compte','=',$compte)->first();
                if($plan_comptable) $compte_label=$plan_comptable->libelle;
                if($compte_aux) {
                    $employeur=Employeur::where('compte_aux','=',$compte_aux)->first();
                    if($employeur) $compte_aux_label=$employeur->nom;
                }
                $solde=$data_compta['solde'][$i];
                $type=$data_compta['type'][$i];
                $grand_livre=new GrandLivre;
                $grand_livre->transaction=$num_transaction;
                $grand_livre->date_doc=($exercice+1)."-01-01"; 
                $grand_livre->date_ref=($exercice+1)."-01-01"; //date('Y')."-01-01";
                $grand_livre->ref_doc="RAN ".$caisse."-".$exercice;
                $grand_livre->compte=$compte;
                $grand_livre->compte_label=$compte_label;
                $grand_livre->compte_aux=$compte_aux;
                $grand_livre->compte_aux_label=$compte_aux_label;
                $grand_livre->designation="REPORT A NOUVEAU ".$caisse." ".$exercice;
                $grand_livre->credit=0;
                $grand_livre->debit=0;
                if($solde>0) $grand_livre->debit=abs($solde);
                else $grand_livre->credit=abs($solde);
                $grand_livre->sens=($solde>0)?"D":"C";
                $grand_livre->montant=abs($solde);
                $grand_livre->journal=$journal_code; 
                $grand_livre->journal_label=$journal_label;
                $grand_livre->user_id_modif=$user->id;
                $grand_livre->user_id_create=$user->id;
                //$grand_livre->lettrage_code
                //$grand_livre->date_lettrage
                $grand_livre->verrou=1;
                $grand_livre->save();
                $nb_lignes++;
                if($type=="CLR") $total["CLR"]+=$solde;
                elseif($type=="CCPF") $total["CCPF"]+=$solde;
            }
        }

        //Création de la contrepartie
        foreach($total as $caisse=>$value) {
            $compte="";$compte_label="";
            if($caisse=="CLR") $compte=$this->compte_contrep_clr;
            if($caisse=="CCPF") $compte=$this->compte_contrep_cpswf;
            $num_transaction=$t_transaction[$caisse];
            $plancomptable=PlanComptable::where('compte','=',$compte)->first();
            if($plancomptable) $compte_label=$plancomptable->libelle;
            $grand_livre=new GrandLivre;
            $grand_livre->transaction=$num_transaction;
            $grand_livre->date_doc=($exercice+1)."-01-01";
            $grand_livre->date_ref=($exercice+1)."-01-01";
            $grand_livre->ref_doc="RAN ".$caisse."-".$exercice;
            $grand_livre->compte=$compte;
            $grand_livre->compte_label=$compte_label;
            $grand_livre->compte_aux="";
            $grand_livre->compte_aux_label="";
            $grand_livre->designation="REPORT A NOUVEAU ".$caisse." ".$exercice;
            $grand_livre->debit=($value>0)?0:abs($value);
            $grand_livre->credit=($value<0)?0:abs($value);
            $grand_livre->sens="C";
            $grand_livre->montant=$value;
            $grand_livre->journal=$journal_code; 
            $grand_livre->journal_label=$journal_label;
            $grand_livre->user_id_modif=$user->id;
            $grand_livre->user_id_create=$user->id;
            $grand_livre->verrou=1;
            $grand_livre->save();
            $nb_lignes++;
        }
        

        //* ************************************************
        //2. CREATION des lignes REGLEMENTS DE COTISATIONS
        //* ************************************************
        if($exercice>"2021") {
            $nb_lignes=0;
            for($i=0;$i<count($data_compta['compte']);$i++) {
                //if($data_compta['solde'][$i]<>0) {
                    $caisse=$data_compta['type'][$i];
                    if(!isset($t_transaction[$caisse."_REG"])) $t_transaction[$caisse."_REG"]=GrandLivre::max('transaction')+1;
                    $num_transaction=$t_transaction[$caisse."_REG"];
                    // Recherche comptes 
                    $compte_label=""; $compte_aux_label="";
                    $compte=$data_compta['compte'][$i];
                    $compte_aux=$data_compta['compte_aux'][$i];
                    $plan_comptable=PlanComptable::where('compte','=',$compte)->first();
                    if($plan_comptable) $compte_label=$plan_comptable->libelle;
                    if($compte_aux) {
                        $employeur=Employeur::where('compte_aux','=',$compte_aux)->first();
                        if($employeur) $compte_aux_label=$employeur->nom;
                    }
                    $solde=$data_compta['credit'][$i]; //CREDIT
                    $type=$data_compta['type'][$i];
                    $grand_livre=new GrandLivre;
                    $grand_livre->transaction=$num_transaction;
                    $grand_livre->date_doc=($exercice+1)."-01-01"; 
                    $grand_livre->date_ref=($exercice+1)."-01-01"; //date('Y')."-01-01";
                    $grand_livre->ref_doc="RAN ".$caisse."-".$exercice;
                    $grand_livre->compte=$compte;
                    $grand_livre->compte_label=$compte_label;
                    $grand_livre->compte_aux=$compte_aux;
                    $grand_livre->compte_aux_label=$compte_aux_label;
                    $grand_livre->designation="REPORT A NOUVEAU ".$caisse." ".$exercice. "REG";
                    $grand_livre->credit=0;
                    $grand_livre->debit=0;
                    $grand_livre->credit=$solde;
                    $grand_livre->sens="C";
                    $grand_livre->montant=abs($solde);
                    $grand_livre->journal=$journal_code; 
                    $grand_livre->journal_label=$journal_label;
                    $grand_livre->user_id_modif=$user->id;
                    $grand_livre->user_id_create=$user->id;
                    $grand_livre->verrou=1;
                    $grand_livre->save();
                    $nb_lignes++;
                    if($type=="CLR") $total_reg["CLR"]+=$solde;
                    elseif($type=="CCPF") $total_reg["CCPF"]+=$solde;
            }
            //Création de la contrepartie
            foreach($total_reg as $caisse=>$value) {
                $compte="";$compte_label="";
                if($caisse=="CLR") $compte=$this->compte_contrep_clr;
                if($caisse=="CCPF") $compte=$this->compte_contrep_cpswf;
                $num_transaction=$t_transaction[$caisse."_REG"];
                $plancomptable=PlanComptable::where('compte','=',$compte)->first();
                if($plancomptable) $compte_label=$plancomptable->libelle;
                $grand_livre=new GrandLivre;
                $grand_livre->transaction=$num_transaction;
                $grand_livre->date_doc=($exercice+1)."-01-01";
                $grand_livre->date_ref=($exercice+1)."-01-01";
                $grand_livre->ref_doc="RAN ".$caisse."-".$exercice;
                $grand_livre->compte=$compte;
                $grand_livre->compte_label=$compte_label;
                $grand_livre->compte_aux="";
                $grand_livre->compte_aux_label="";
                $grand_livre->designation="REPORT A NOUVEAU ".$caisse." ".$exercice." REG";
                $grand_livre->debit=$value;
                $grand_livre->credit=0;
                $grand_livre->sens="D";
                $grand_livre->montant=$value;
                $grand_livre->journal=$journal_code; 
                $grand_livre->journal_label=$journal_label;
                $grand_livre->user_id_modif=$user->id;
                $grand_livre->user_id_create=$user->id;
                $grand_livre->verrou=1;
                $grand_livre->save();
                $nb_lignes++;
            }  
        } 
        

        $lst_transaactions=implode(",", $t_transaction);
        $msg=$nb_lignes." écritures de Report à Nouveau ".$exercice." ont été générées sur les transactions  N° ";
        foreach($t_transaction as $caisse=>$num) {
            $msg.="<a target='_blank' href='".url('transaction/'.$num)."'> (".$caisse.")".$num."</a>";
            $msg.=" , ";
        }
        if($msg) {
            Session::flash('message', $msg);
            return Redirect::back()->with('msg', $msg);
        }

        return "";
    }

    public function destroy($exercice,$compte_aux="")
    {
        $user = Auth::user();
        if(!$user) return Redirect::route( 'login' );

        Session::put("select_exercice_ran",$exercice); //Mise en session le dernier choix recouvrement
        Session::put("select_compte_aux_ran",$compte_aux); //Mise en session le dernier choix recouvrement

        $caisses=["CLR","CCPF"];$nb=0;
        
        foreach($caisses as $caisse) {
            if(!$compte_aux) {
                $nb+=GrandLivre::where("ref_doc","=","RAN ".$caisse."-".$exercice)->count();
                $grand_livre=GrandLivre::where("ref_doc","=","RAN ".$caisse."-".$exercice)->delete();
            } else {
                $nb+=GrandLivre::where("ref_doc","=","RAN ".$caisse."-".$exercice)->where('compte_aux','=',$compte_aux)->count();
                $grand_livre=GrandLivre::where("ref_doc","=","RAN ".$caisse."-".$exercice)->where('compte_aux','=',$compte_aux)->delete();   
                
            }
        }
        $msg="Suppession du report à nouveau Report à Nouveau ".$exercice;
        if($compte_aux) $msg.=" pour le compte auxiliaire ".$compte_aux;
        $msg.=" et correspondant à ".$nb." ecritures";;
        Session::flash('message', $msg);
        return  Redirect::back()->with('msg', $msg);
    }
 
}