<?php namespace App\Http\Controllers;

use Auth\AuthController;
use App\Models\Employeur;
use App\Models\Beneficiaire;
use App\Models\Cotisation;
use App\Models\Parametre;
use App\Models\User;
use App\Models\Role2;
use App\Models\Email;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Redirect;
use View;
use DB;

use Illuminate\Http\Request;
use Response;
use Illuminate\Support\Facades\Mail;
use App\Http\Controllers\Editions\EditionsCotisationsBordereau;

class RecouvrementController extends Controller {
 
    private $menu='bordereaux';
    private $submenu='bordereaux';
    private $menu_home='recouvrement';

 
    /**
    * Liste des salaires
    */
    /*
    public function index_salaires($employe_id)
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        $titre2="";
        $employe = Beneficiaire::find($employe_id);
        $salaires = Salaire::whereIn('ile', ['W'])->orderBy('nom')->get();

        $this->submenu="salaires";
        return View::make('recouvrement.salaires', 
        [
            'user' => $user,'menu' => $this->menu,'submenu' => $this->submenu,'menu_home' => $this->menu_home,
            'salaires' => $salaires, *'employe'=>$employe
        ]);

    }*/
 
    /**
    * Liste des bordereaux
    */
    public function index_bordereaux($exercice="",$bdx_id="",$pupri="PU")
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );

        $titre2="";
        if($exercice=="") $exercice=date('Y');
        $exercices=$this->getListeExercices();
        $cotisations=array();
        if($bdx_id!="") {
            if( $pupri=="PU") {
                if($bdx_id!="9999") 
                    $cotisations = Cotisation::where('exercice','=',$exercice)
                    ->where("bdx","=",$bdx_id)->orderby("sonum")->get();
                else $cotisations = Cotisation::where('exercice','=',$exercice)
                    ->orderby("sonum")->get();
            } else {
                if( $pupri=="PR") {
                    if($bdx_id!="9999") 
                        $cotisations = Cotisation::where('exercice','=',$exercice)
                        ->where("bdx_prive","=",$bdx_id)->orderby("sonum")->get();
                    else 
                        $cotisations = Cotisation::where('exercice','=',$exercice)
                        ->orderby("sonum")->get();     
                }
            }    
        }

        $nb=0;
        $t_typeval=["C"=>0,"D"=>0,"Z"=>0];
        foreach($cotisations as $cotisation) {
            $nb++;
            if($cotisation->statut=="CRE") $t_typeval["C"]++;
            if($cotisation->statut=="DEB") $t_typeval["D"]++;
            if($cotisation->statut=="ALL") $t_typeval["Z"]++;
        }

        $typeval="";
        if($nb==$t_typeval["C"]) $typeval="C";
        if($nb==$t_typeval["D"]) $typeval="D";
        if($nb==$t_typeval["Z"]) $typeval="Z";
        
        //Numéros privée
        $lst_bdx_prives = Cotisation::where('exercice','=',$exercice)
            ->orderby("bdx_prive")->pluck('bdx_prive','bdx_prive')->toArray();; 
        if(!$lst_bdx_prives) $lst_bdx_prives=array();
        $lst_bdx_prives["9999"]="Tous";
        $lst_bdx_prives[""]=" ";

        //Numéros publics
        $lst_bdx_publics = Cotisation::where('exercice','=',$exercice)
            ->orderby("bdx")->pluck('bdx','bdx')->toArray();;  
        $lst_bdx_publics["9999"]="Tous";

        if(!$lst_bdx_publics) $lst_bdx_publics=array();
        $lst_bdx_publics[""]=" ";

        $bdx_prive_id="";
        //Select par defaut
        if($bdx_id!="") {
            if( $pupri=="PU") $bdx_prive_id="";
            if( $pupri=="PR") {
                $bdx_prive_id=$bdx_id;
                $bdx_id="";
            }
        }

        return View::make('recouvrement.suivi.bordereaux_index', 
            [
                'user' => $user,'menu' => $this->menu,'submenu' => $this->submenu,'menu_home' => $this->menu_home,
                'cotisations' => $cotisations
                ,'exercice'=>$exercice,'exercices'=>$exercices
                ,'pupri'=>$pupri
                , 'lst_bdx_prives'=>$lst_bdx_prives
                , 'lst_bdx_publics'=>$lst_bdx_publics
                , 'bdx_id'=>$bdx_id
                , 'bdx_prive_id'=>$bdx_prive_id
                , 'typeval' => $typeval
            ]);
    }


    /**
    * Verrouillage d'un bordereau
    */
    public function valider($type_val,$bdx_id,$pupri,$exercice)
    {
        $cotisations=array();
        if($bdx_id!="") {
            if( $pupri=="PU") {
                $cotisations = Cotisation::where('exercice','=',$exercice)
                    ->where("bdx","=",$bdx_id)
                    ->orderby("sonum")
                    ->get();
            } else {
                if( $pupri=="PR") {
                    $cotisations = Cotisation::where('exercice','=',$exercice)
                        ->where("bdx_prive","=",$bdx_id)
                        ->orderby("sonum")
                        ->get();
                }
            }    
        }

        foreach($cotisations as $cotisation) {
            if($type_val=="C") {
                if($cotisation->statut=="")  $cotisation->statut="CRE";
                if($cotisation->statut=="DEB")  $cotisation->statut="ALL";
            }
            if($type_val=="D") {
                if($cotisation->statut=="")  $cotisation->statut="DEB";
                if($cotisation->statut=="CRE")  $cotisation->statut="ALL";
            }
            if($type_val=="Z") {
                $cotisation->statut="";
            }
            $cotisation->save();
        }


        return $this->index_bordereaux($exercice,$bdx_id,$pupri);   
    }


    /**
    * Liste des bordereaux
    */
    public function index_bordereaux_liste($exercice="")
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );

        if($exercice=="") $exercice=date('Y');
        $exercices=$this->getListeExercices();
        $bordereaux=array();
        
        $lst_bdx_public = Cotisation::select("bdx as num")->where('exercice','=',$exercice)
            ->distinct()->get();
        $lst_bdx_prive = Cotisation::select("bdx_prive as num")->where('exercice','=',$exercice)
            ->distinct()->get();

        $t_bdx=array("");
        $i=0;
        foreach($lst_bdx_public as $bdx)  {
            $bdx_id=$bdx->num;
            $t_bdx['bdx_id'][$i]=$bdx->num;
            $t_bdx['type'][$i]="PU";
            $t_bdx['total_clr'][$i]=Cotisation::where('bdx','=',$bdx_id)->sum('clr');
            $t_bdx['total_ccpf'][$i]=Cotisation::where('bdx','=',$bdx_id)->sum('ccpf');
            $t_bdx['total_debit'][$i]=Cotisation::where('bdx','=',$bdx_id)->sum('debit');
            $t_bdx['total_credit'][$i]=Cotisation::where('bdx','=',$bdx_id)->sum('credit');
            $t_bdx['nb_societe'][$i]=Cotisation::where('bdx','=',$bdx_id)->count();
            $t_bdx['total_assiette'][$i]=Cotisation::where('bdx','=',$bdx_id)->sum('assiette');
            $t_bdx['total_salaries'][$i]=Cotisation::where('bdx','=',$bdx_id)->sum('nbsal');
            $i++;
        }
        foreach($lst_bdx_prive as $bdx)  {
            $bdx_id=$bdx->num;
            $t_bdx['bdx_id'][$i]=$bdx_id;
            $t_bdx['type'][$i]="PR";
            $t_bdx['total_clr'][$i]=Cotisation::where('bdx','=',$bdx_id)->sum('clr');
            $t_bdx['total_ccpf'][$i]=Cotisation::where('bdx','=',$bdx_id)->sum('ccpf');
            $t_bdx['total_debit'][$i]=Cotisation::where('bdx','=',$bdx_id)->sum('debit');
            $t_bdx['total_credit'][$i]=Cotisation::where('bdx','=',$bdx_id)->sum('credit');
            $t_bdx['nb_societe'][$i]=Cotisation::where('bdx','=',$bdx_id)->count();
            $t_bdx['total_assiette'][$i]=Cotisation::where('bdx','=',$bdx_id)->sum('assiette');
            $t_bdx['total_salaries'][$i]=Cotisation::where('bdx','=',$bdx_id)->sum('nbsal');
            $i++;
        }
        $this->submenu="bordereaux_liste";


        return View::make('recouvrement.suivi.liste_bordereaux_index', 
            [
                'user' => $user,'menu' => $this->menu,'submenu' => $this->submenu,'menu_home' => $this->menu_home,
                't_bdx' => $t_bdx,'nb'=>$i,
                'exercices'=>$exercices,
                'exercice'=>$exercice
            ]);

    }

    /**
    * Liste des Employeurs pour rappel
    */
    public function index_rappel()
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );

        $titre2="";
        $employeurs = Employeur::wherein('statut',['ACT','ASV','CTE'])->get();
        $exercices=$this->getListeExercices();

        $this->menu="suivi";
        $this->submenu="rappels";
        return View::make('recouvrement.suivi.index_rappel', [
                'user' => $user,'menu' => $this->menu,'submenu' => $this->submenu,'menu_home' => $this->menu_home,
                'employeurs' => $employeurs,
                'exercices'=>$exercices
            ]);    
    }


    /**
    * Liste des Emails pour Employeurs
    */
    public function index_emails()
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );

        $titre2="";
        $employeurs = Employeur::wherein('statut',['ACT','ASV','CTE'])->get();
        $exercices=$this->getListeExercices();

        $this->menu="suivi";
        $this->submenu="emails";
        return View::make('recouvrement.suivi.index_emails', 
            [
                'user' => $user,'menu' => $this->menu,'submenu' => $this->submenu,'menu_home' => $this->menu_home,
                'employeurs' => $employeurs,
                'exercices'=>$exercices,
                'user'=>$user
        ]);    
    }

    public function show_emails($employeur_id)
    {

        if(!($user=Auth::user())) return Redirect::route( 'login' );

        $employeur=Employeur::find($employeur_id);

        $emails=Email::where('sonum','=',$employeur_id)
            ->where('destinataire','<>','phil@mail.wf')->where('destinataire','<>','pnazeyrollas@ac-noumea.nc')
            ->orderby('id','desc')->get();

        return View::make('recouvrement.suivi.emails_detail', [
            'user' => $user,'menu' => $this->menu,'submenu' => $this->submenu,'menu_home' => $this->menu_home,
            'employeur'=>$employeur,
            'emails'=>$emails,
            ]);

    }


    /**
    * Liste des Employeurs pour le srestes à payer
    */
    public function index_resteapayer()
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );

        $titre2="";
        //$employeurs = Employeur::where('statut','=','ACT')->get();
        $employeurs = Employeur::all();
        //$employeurs = Employeur::where('id','=','29')->get();

        $this->menu="suivi";
        $this->submenu="reste_a_payer";
        return View::make('recouvrement.suivi.index_resteapayer', [
            'user' => $user,'menu' => $this->menu,'submenu' => $this->submenu,'menu_home' => $this->menu_home,
            'employeurs' => $employeurs
        ]);    
    }


    /**
    * Liste des Employeurs pour le srestes à payer par annee de ratachement
    */
    public function index_resteapayer_annee($exercice="",$date_obs="")
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );

        $titre2="";
        $exercice_encours=Parametre::where('ref','=','CPT_EXERCICE')->first()->value;
        if($exercice=="") $exercice=$exercice_encours-1; 
        $employeurs = Employeur::where('statut','=','ACT')->get();
        //$employeurs = Employeur::where('id','=','38')->get();

        $exercices=$this->getListeExercices();
        $date_obs_fr="";
        if($date_obs!="") {
            $date = explode('-',$date_obs);
            $date_obs_fr = ($date[2].'/'.$date[1].'/'.$date[0]);
        }

        $this->menu="suivi";
        $this->submenu="reste_a_payer_annee";
        //dd($date_obs_fr );
        return View::make('recouvrement.suivi.index_resteapayer_annee', [
            'user' => $user,'menu' => $this->menu,'submenu' => $this->submenu,'menu_home' => $this->menu_home,
            'employeurs' => $employeurs,
            'exercice' => $exercice,
            'exercices' => $exercices,
            'date_obs' => $date_obs,
            'date_obs_fr' => $date_obs_fr
        ]);    
    }

    /**
    * Liste des Employeurs pour les restes à payer trimestriel / année
    */
    public function index_resteapayer_trim($annee="")
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );

        $titre2="";
        if($annee=="") $annee=date("Y");
        //$employeurs = Employeur::where('statut','=','ACT')->get();
        $employeurs = Employeur::all();
        $exercices=$this->getListeExercices();

        $this->menu="suivi";
        $this->submenu="reste_a_payer_annee";
        
        return View::make('recouvrement.suivi.index_resteapayer_trim', 
        [
            'user' => $user,'menu' => $this->menu,'submenu' => $this->submenu,'menu_home' => $this->menu_home,
            'employeurs' => $employeurs,
            'annee'=>$annee,'exercices'=>$exercices
        ]);    
    }

    /**
    * Liste des Employeurs pour MED
    */
    public function index_med($exercice="")
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );

        $titre2="";
        $employeurs = Employeur::where('statut','=','ACT')->get();

        $exercice_encours=Parametre::where('ref','=','CPT_EXERCICE')->first()->value;
        if($exercice=="") $exercice=$exercice_encours-1; 
        $exercices=$this->getListeExercices();
        $prc_maj=Parametre::where('ref','=','CAL_PRC_MAJ')->first()->value;

        $taux_CLR=Parametre::where('ref','=','TAUX_CLR_CCPF')->first()->getTauxCLRAttribute();
        $taux_CPF=Parametre::where('ref','=','TAUX_CLR_CCPF')->first()->getTauxCCPFAttribute();

        $taux=$taux_CLR[$exercice]+$taux_CPF[$exercice];

        $this->submenu='med';
        $this->menu='suivi';

        return View::make('recouvrement.suivi.index_med', ['employeurs' => $employeurs,
            'user' => $user,'menu' => $this->menu,'submenu' => $this->submenu,'menu_home' => $this->menu_home,
            'exercices'=>$exercices,
            'exercice'=>$exercice,
            'prc_maj'=>$prc_maj,
            'taux'=>$taux
            ]);    
    }


    public function saisie_email($employeur_id)
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );

        $employeur=Employeur::find($employeur_id);
        $periode="";
        $annee=date('Y')-1;
        $objet=Parametre::where('ref','=','MAI_OBJET_REV_APPEL')->first()->value;
        $message=Parametre::where('ref','=','MAI_MESS_REV_APPEL')->first()->value;
        return View::make('recouvrement.suivi.email', [
            'user' => $user,'menu' => $this->menu,'submenu' => $this->submenu,'menu_home' => $this->menu_home,
            'employeur'=>$employeur,
            'periode'=>$periode,
            'annee'=>$annee,
            'objet'=>$objet,
            'message'=>$message
            ]);    
    }

    public function email_info($destinataire,$objet,$message,$pj)
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );

        $data=["destinataire"=>$destinataire,"objet"=>$objet,"message"=>$message,"pj"=>$pj];
        return View::make('recouvrement.suivi.email_sent', 
            [
                'user' => $user,'menu' => $this->menu,'submenu' => $this->submenu,'menu_home' => $this->menu_home,
                'data'=>$data
            ]);    
    }


    public function sendmail(Request $request,$employeur_id)
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );

        $employeur=Employeur::find($employeur_id);
        //Param pdf
        $annee=$request->annee;
        $libelle_periode=$request->libelle_periode;
        //Email
        $destinataire=trim($request->destinataire);
        $objet=$request->objet;
        $text=$request->message;
        $cc="";
        $pj=$request->pj;
        $reference="REC_BRD_RELEVE";
        $data = ["destinataire"=>$destinataire,"objet"=>$objet,"pj"=>$pj
            ,"text"=>str_replace("\r\n","<br/>",$text)];
        //Recherche PJ
        $annee=date('Y');
        $periode="";

        $ed=new EditionsCotisationsBordereau;
        $t=$ed->bordereau($employeur_id,$annee,"",$libelle_periode,"F");
        if(!file_exists($t[0])) {
            echo "Le fichier n'a pas pu être ajouté. Le mail n'a pas été envoyé";
            return;
        } 
        $pathToFile=$t[0];
        $pj=$t[1];


        $dest=$this->mysql_escape($destinataire);
        $res=Mail::send("emails.mailEvent", 
            $data, 
            function($message) use ($user,$dest,$objet,$pathToFile) {
                $message->to($dest);
                $message->subject($objet);
                //$message->from($address, $name = null);
                //$message->replyTo($address, $name = null);
                //$message->sender($address, $name = null);
                //$message->cc($address, $name = null);
                //$message->cci($cci,null);
                //$message->bcc($address, $name = null);
                $message->attach($pathToFile);

        });


        date_default_timezone_set('Pacific/Noumea');
        $email=new Email;
        $email->date=date('Y-m-d H:i:s');
        $email->destinataire=$destinataire;
        $email->cc=$cc;
        //$email->cci=$cci;
        $email->objet=$objet;
        $email->texte=$text;
        $email->pj=$pj;
        $email->statut="ENV";
        $email->reference=$reference;
        $email->user_id=$user->id;
        $email->sonum=$employeur->id;
        $email->save();

        return $this->email_info($destinataire,$objet,$text,$pj);
    }


    function mysql_escape($inp)
    { 
        if(is_array($inp)) return array_map(__METHOD__, $inp);

        if(!empty($inp) && is_string($inp)) { 
            return str_replace(array('\\', "\0", "\n", "\r", "'", '"', "\x1a"), array('\\\\', '\\0', '\\n', '\\r', "\\'", '\\"', '\\Z'), $inp); 
        } 

        return $inp; 
    }


    public function create()
    {
        return View::make('recouvrement.create', []);
    }

    public function store(RecouvrementRequest $request)
    {

        return Redirect::to('/recouvrement');
    }
 

    public function edit($id)
    {

        return View::make('recouvrement.edit', [ ]);

    }
 

    public function update($id,RecouvrementRequest $request)
    {

        return Redirect::to('/recouvrement');
    }
 

    public function destroy($id)
    {

    }
 

    /**
     * Listes des exercices
     */
    public function getListeExercices()
    {
        $exercices = Parametre::where('ref','=','TAUX_CLR_CCPF')->first()->Exercices; 
        return $exercices;
    }


}