<?php namespace App\Http\Controllers;

use Auth\AuthController;
use App\Models\Employeur;
use App\Models\Beneficiaire;
use App\Models\Salaire;
use App\Models\Secteur;
use App\Models\User;
use App\Models\Role2;
use App\Models\LogSalaire;
use App\Models\MyApp;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Redirect;
use View;
use DB;
use Illuminate\Support\Facades\Auth;
use App\Http\Requests\SalaireRequest;
use App\Http\Requests\AutoResponsableRequest;
use Request;
use Response;
use App\Models\Parametre;


class SalairesController extends Controller {

    private $menu='tiers';
    private $submenu='salaires';
    private $menu_home='recouvrement';

    /**
     * Liste des salaires
     */
    public function index($employeur_id=0,$beneficiaire_id=0,$exercice="")
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if(!$user->hasRole('ADMINISTRATEUR')) if(!$user->can("SAL_VISU")) return redirect('home');

        $liste_employeur=$this->getListeEmployeur(false);
        $salaires=array();

        $exercices = ['*'=>'Tous']+$this->getListeExercices();
        if(($exercice=="")||($exercice=="0")) $exercice=date('Y');

        $liste_employes=array();
        $employeur_nom="";$beneficiaire="";
        $nb_salaire=array();
        if($employeur_id) {
            if($employeur_id!="999999") {
                $employeur=employeur::find($employeur_id);
                $employeur_nom=$employeur_id." ".trim($employeur->nom);

                $liste_employes2=array();
                if($exercice=="*") { //Tous uniquement si toutes les années
                    $liste_employes1=Beneficiaire::
                        join('salaire','salaire.benum','=','beneficiaires.id', 'left outer')
                        ->select(db::raw('CONCAT(TRIM(beneficiaires.nom)," ",TRIM(beneficiaires.prenom)," (",beneficiaires.id,")") as nom'),'beneficiaires.id as id')
                        ->where('salaire.sonum','=',$employeur_id)
                        ->orderBy('beneficiaires.nom')
                        ->pluck('beneficiaires.nom','beneficiaires.id')->toArray();

                    $liste_employes2=Beneficiaire::
                        where('beneficiaires.sonum','=',$employeur_id)
                        ->select(db::raw('CONCAT(TRIM(beneficiaires.nom)," ",TRIM(beneficiaires.prenom)," (",beneficiaires.id,")") as nom'),'beneficiaires.id as id')
                        ->orderBy('beneficiaires.nom')
                        ->pluck('beneficiaires.nom','beneficiaires.id')->toArray();
                } else { //sinon seuls ceux de lannée en cours
                    $liste_employes1=Beneficiaire::
                        join('salaire','salaire.benum','=','beneficiaires.id', 'left outer')
                        ->select(db::raw('CONCAT(TRIM(beneficiaires.nom)," ",TRIM(beneficiaires.prenom)," (",beneficiaires.id,")") as nom'),'beneficiaires.id as id')
                        ->where('salaire.sonum','=',$employeur_id)
                        ->where('salaire.annee','=',$exercice)
                        /*->where(function($query) use ($exercice) {
                            $query->where('date_sor', '>', $exercice."01-01")
                            ->orwhereNull('date_sor');
                        })*/
                        ->orderBy('beneficiaires.nom')
                        ->pluck('beneficiaires.nom','beneficiaires.id')->toArray();
                }

                foreach($liste_employes1 as $id=>$nom) $liste_employes[$id]=$nom;
                foreach($liste_employes2 as $id=>$nom) {
                    if(!isset($liste_employes1[$id])) $liste_employes[$id]=$nom;
                }
                asort($liste_employes);

                $salaires_obj = Salaire::where('sonum','=',$employeur_id);
                if($beneficiaire_id) {
                    $salaires_obj = $salaires_obj->where('benum','=',$beneficiaire_id);
                    $beneficiaire=Beneficiaire::find($beneficiaire_id);
                }
                //if($list_exercice!='') $salaires_obj = $salaires_obj->wherein('annee',$list_exercice);
                if(($exercice!='')&&($exercice!='*') ) $salaires_obj = $salaires_obj->where('annee',"=",$exercice);
                $salaires = $salaires_obj->orderBy('annee','DESC')->get();

            } else {
                $employeur_nom="TOUS";
                $liste_employes1=Beneficiaire::
                    where('beneficiaires.sonum','<>','0')
                    ->orderBy('beneficiaires.nom')
                    ->pluck('beneficiaires.nom','beneficiaires.id')->toArray();
                foreach($liste_employes1 as $id=>$nom) {
                    $liste_employes[$id]=$nom;
                }

                $salaires = Salaire::where('annee','=',$exercice)
                    ->orderBy('annee','DESC')->get();

            }
            //Pour total salaires

            $t_mois=array('jan','fev','mar','avr','mai','jun','jui','aou','sep','oct','nov','dec');
            foreach($t_mois as $mois) $nb_salaire[$mois]=0;
            $nb_salaire["total"]=0;
            foreach ($salaires as $salaire) {
                $t_nb=$salaire->Nbsalaire;
                foreach($t_mois as $mois) $nb_salaire[$mois]+=$t_nb[$mois];
                $nb_salaire["total"]+=$t_nb["total"];
            }
        }
        $t_mois=[0=>"jan",1=>"fev",2=>"mar",3=>"avr",4=>"mai",
                    5=>"jun",6=>"jui",7=>"aou",8=>"sep",9=>"oct",10=>"nov",11=>"dec"];


        return View::make('recouvrement.salaires.index', [
            'user' => $user,'menu' => $this->menu,'submenu' => $this->submenu,'menu_home' => $this->menu_home,
            'salaires' => $salaires,
            'employeur_id'=>$employeur_id,
            'employeur_nom'=>$employeur_nom,
            'beneficiaire_id'=>$beneficiaire_id,'beneficiaire'=>$beneficiaire,
            'liste_employeur' => $liste_employeur,
            'liste_employes' => $liste_employes,
            'exercices' => $exercices,'exercice' => $exercice,'t_mois' => $t_mois,
            'nb_salaire' => $nb_salaire
        ]);
    }


    /**
     * Liste des salaires depuis la fiche Employeur
     */
    public function index_beneficiaire_employeur($beneficiaire_id="",$employeur_id="")
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );

        $beneficiaire = Beneficiaire::find($beneficiaire_id);
        $salaires_obj = Salaire::where('benum','=',$beneficiaire_id);
        if($employeur_id) {
            $employeur = Employeur::find($employeur_id);
            $salaires = $salaires_obj->where('sonum','=',$employeur_id);
        }
        $salaires = $salaires_obj->orderBy("annee","DESC")->get();

        return View::make('recouvrement.salaires.index_beneficiaire_employeur', [
            'user' => $user,'menu' => $this->menu,'submenu' => $this->submenu,'menu_home' => $this->menu_home,
            'beneficiaire' => $beneficiaire,
            'employeur' => $employeur,
            'salaires' => $salaires,
        ]);
    }

     public function  index_iframe_secteur($sec_id,$date)
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );

        $secteur = Secteur::find($sec_id);
        $salaires=Salaire::whereIn('sonum',$secteur->getlisteEmployeurs($date))
            ->where('annee','=',substr($date,0,4))->get();

        return View::make('recouvrement.salaires.index_secteurs_iframe',
        [
            'user' => $user,'menu' => $this->menu,'submenu' => $this->submenu,'menu_home' => $this->menu_home,
            'secteur' => $secteur,
            'date' => $date,
            'salaires' => $salaires,
        ]);
    }


    public function create($beneficiaire_id,$employeur_id)
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if(!$user->hasRole('ADMINISTRATEUR')) if(!$user->can("SAL_AJO")) return redirect('home');

        $liste_employeur = Employeur::orderBy('nom','ASC')->pluck('nom','id')->toArray();
        $beneficiaire = Beneficiaire::find($beneficiaire_id);
        $employeur = Employeur::find($employeur_id);
        $mode="create";
        return View::make('recouvrement.salaires.create',
            [
                'user' => $user,'menu' => $this->menu,'submenu' => $this->submenu,'menu_home' => $this->menu_home,"mode"=>$mode,
                'employeur' => $employeur,
                'beneficiaire' => $beneficiaire,
            ]);
    }

    public function store(SalaireRequest $request)
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if(!$user->hasRole('ADMINISTRATEUR')) if(!$user->can("SAL_AJO")) return redirect('home');

        $salaire_exist=salaire::where('annee','=',$request->annee)
            ->where('benum','=',$request->benum)
            ->where('sonum','=',$request->sonum)
            ->first();

        $t_error=array();
        if($salaire_exist) {
            $t_error['doublon']="Cette année de salaire existe déjà pour cet employé et cet employeur, vous ne pouvez pas la créer une nouvelle fois !";
        }

        if(intval($request->annee)>(intval(date('Y'))+10)) {
            $t_error['doublon']="Vous ne pouvez pas saisir les salaires d'une années supérieur à l'année en cours plus 10 ans.";
        }
        if (count($t_error)>0) {
            //Session::flash('nom_compte2', $plan2->nomcpt);
            return redirect()->back()
                ->withInput()
                ->withErrors($t_error);
        }

        $salaire = $this->setData($request);

        //Changement d'Employeur si besoin
        $employeur_id=$salaire->sonum;
        $beneficiaire=Beneficiaire::find($salaire->benum);
        $salaire_last=Salaire::where('benum','=',$salaire->benum)->orderby('annee','DESC')->first();
        if( ($salaire_last->annee==$salaire->annee) && ($salaire->sonum!=$beneficiaire->sonum) ) {
            $beneficiaire->sonum=$salaire->sonum;
            $beneficiaire->save();
        }

        return Redirect::to('salaire_annee/'.$request->sonum.'/'.$salaire->benum.'/'.$salaire->annee);
    }

    public function edit($id,$mode="edit")
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if(!$user->hasRole('ADMINISTRATEUR')) if(!$user->can("SAL_VISU")) return redirect('home');
        if(!$user->hasRole('ADMINISTRATEUR')) if($mode=="edit" && !$user->can("SAL_MAJ")) return redirect('home');

        $salaire=Salaire::find($id);
        $liste_employeur = Employeur::orderBy('nom','ASC')->pluck('nom','id')->toArray();
        $beneficiaire=Beneficiaire::find($salaire->benum);
        $employeur = Employeur::find($salaire->sonum);

        return View::make('recouvrement.salaires.'.$mode,
            [
                'user' => $user,'menu' => $this->menu,'submenu' => $this->submenu,'menu_home' => $this->menu_home,"mode"=>$mode,
                'employeur' => $employeur,
                'beneficiaire' => $beneficiaire,
                'salaire' => $salaire,
            ]);
    }

    public function show($id)
    {
        return $this->edit($id,$mode="show");
    }

    public function update($id,SalaireRequest $request)
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if(!$user->hasRole('ADMINISTRATEUR')) if(!$user->can("SAL_MAJ")) return redirect('home');
        $salaire = $this->setData($request,$id);

        //Changement d'Employeur si besoin
        $employeur_id=$salaire->sonum;
        $beneficiaire=Beneficiaire::find($salaire->benum);
        $salaire_last=Salaire::where('benum','=',$salaire->benum)->orderby('annee','DESC')->first();
        if( ($salaire_last->id==$salaire->id) && ($salaire->sonum!=$beneficiaire->sonum) ) {
            $beneficiaire->sonum=$salaire->sonum;
            $beneficiaire->save();
        }

        return Redirect::to('salaire_annee/'.$request->sonum.'/0/'.$salaire->annee);
    }


    public function setData($request,$id="")
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );

        $tmois=['jan','fev','mar','avr','mai','jun','jui','aou','sep','oct','nov','dec'];
        if($id) $salaire = Salaire::find($id);
        else $salaire = new Salaire;

        //Si modification on logs
        if($id) {
            $t_salaire_old=[];
            $t_cols=['benum','sonum','sonum','dat_ent','date_sor','annee','jan','fev','mar','avr','mai','jun','jui','aou','sep','oct','nov','dec'];
            foreach($t_cols as $col) $t_salaire_old[$col]=$salaire->{$col};
        }
        $salaire->benum = $request->benum;
        $salaire->sonum = $request->sonum;
        $date = $request->dat_ent;
        $salaire->dat_ent = ($date!="")?date('Y-m-d', strtotime(str_replace('/', '-', $date))):null  ;
        $date = $request->date_sor;
        $salaire->date_sor = ($date!="")?date('Y-m-d', strtotime(str_replace('/', '-', $date))):null  ;
        $salaire->annee = $request->annee;
        $suspendus="";$k=0;
        foreach($tmois as $mois) {
            $k++;
            $salaire->{$mois} = $request->{$mois};
            if($request->{$mois.'_vent'}<>0) $salaire->{$mois}+=$request->{$mois.'_vent'};
            //Suspendus
            if($request->{"box_".$mois}=="1") {
                $suspendus.=(($suspendus=="")?"":"|").$k;
                $salaire->{$mois}=null;
            }
        }
        $salaire->suspendus = $suspendus;

        $salaire->save();

        //LOG de la transaction
        $type_log=($id)?'I':'U';
        $salaire->log_transaction($request->url(),$type_log);

        //LOG Modifications
        if($id) {
            foreach($t_cols as $col) {
                if($t_salaire_old[$col]!=$salaire->{$col}) {
                    $log_salaire = new LogSalaire;
                    $log_salaire->id_salaire=$salaire->id;
                    $log_salaire->benum=$salaire->benum;
                    $log_salaire->sonum=$salaire->sonum;
                    $log_salaire->col=$col;
                    $log_salaire->val_old=$t_salaire_old[$col];
                    $log_salaire->val_new=$salaire->{$col};
                    $log_salaire->login=$user->login;
                    $log_salaire->ip=MyApp::getUserIP();
                    $log_salaire->save();
                }
            }
        }
        return $salaire;
    }


    public function destroy($id)
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if(!$user->hasRole('ADMINISTRATEUR')) if(!$user->can("SAL_SUP")) return redirect('home');

        $salaire = Salaire::find($id);
        $employeur_id = $salaire->annee;
        if(!$salaire) return Redirect::to('salaire_annee/'.$employeur_id.'/'.$beneficiaire_id.'/'.$exercice);

        $exercice=$salaire->annee;
        $sonum = $salaire->sonum;
        $benum = $salaire->benum;

        Salaire::destroy($id);

        return Redirect::to('salaire_annee/'.$sonum.'/0/'.$exercice);
    }



    /**
     * Listes des employeurs
     */
    public function getListeEmployeur($avec_id=false)
    {
        $liste_employeur=Employeur::distinct()->select('nom','id')
            ->whereIn('statut',array('ACT','ASV'))
            ->orderBy(($avec_id)?'id':'nom')->pluck('nom','id')->toArray();
        $liste_employeur2=array();
        foreach($liste_employeur as $id=>$nom) {
            $id_pad=str_pad($id,4,"0", STR_PAD_LEFT);
            $nom=trim($nom);
            $liste_employeur2[$id]=htmlentities(str_replace('"','',$nom));
            if($avec_id) $liste_employeur2[$id]=$id_pad." ".$liste_employeur2[$id];
            else $liste_employeur2[$id]=$liste_employeur2[$id]." (".$id_pad.")";
        }
        asort($liste_employeur2);
        return $liste_employeur2;
    }


    /**
     * Listes des exercices
     */
    public function getListeExercices()
    {
        $exercices = Parametre::where('ref','=','TAUX_CLR_CCPF')->first()->Exercices;
        return $exercices;
    }

    public function getListeExercicesBi()
    {
        $exercices = $this->getListeExercices();
        $nb_exercices=count($exercices );
        $k=0;$t=array();
        foreach($exercices as $exercice) {
            $k++;
            $exercice_min=intval($exercice)-1;
            $exercice_max=intval($exercice)+1;
            if($k%2==0) {
                $t[$exercice_min."-".$exercice]=$exercice_min." - ".$exercice;
                if($k<$nb_exercices) $t[$exercice."-".$exercice_max]=$exercice." - ".$exercice_max;
            }
        }
        arsort($t);
        $t['*']='Tous';
        return $t;
    }





}
