<?php namespace App\Http\Controllers;

use Auth\AuthController;
use App\Models\User;
use App\Models\Beneftype;
use App\Models\Beneficiaire;
use App\Models\Secteur;
use App\Models\Salaire;
use App\Models\Salaire_cumules;
use App\Models\Employeur;
use App\Models\Parametre;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Auth;
use View;
use DB;

class StatistiquesController extends Controller {
    private $menu='analyses';
    private $submenu='tdb_asoc';
    private $menu_home='analyses';

    public function index_tdb($benef_type)
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        $zones=["WALLIS","FUTUNA","AUTRE","TOTAL"];
        $titre="";
        $t_header=[];
        $beneficiaires = $this->get_beneficiaire($benef_type);    
        if($benef_type=="A") {
            if(!$user->HasRole("ADMINISTRATEUR") && !$user->can("ANA_ALL")) return View::make('stats.forbidden');
            $titre="Tableau de bord - Allocataires";
            $this->submenu='tdb_alloc';
            $t_header=['nb_alloc'=>'Bénéficiaires (B)','nb_enfant_all'=>'Enfants avec allocations (EA)',
                'ratio_all'=>'Rapport EA/B','nb_enfant'=>'Total Enfants (ET)','ratio'=>'Rapport ET/B'];
        }
        if($benef_type=="S") {
            if(!$user->HasRole("ADMINISTRATEUR") && !$user->can("ANA_ASOC")) return View::make('stats.forbidden');
            $titre="Tableau de bord - Aide Sociale";
            $this->submenu='tdb_asoc';
            $t_header=['nb_alloc'=>'Bénéficiaires (B)','nb_enfant_all'=>'Enfants avec allocations (EA)',
            'ratio_all'=>'Rapport EA/B','nb_enfant'=>'Total Enfants (ET)','ratio'=>'Rapport ET/B'];
        }
        if($benef_type=="R") {
            if(!$user->HasRole("ADMINISTRATEUR") && !$user->can("ANA_RET")) return View::make('stats.forbidden');
            $titre="Tableau de bord - Retraites";
            $this->submenu='tdb_ret';
            $t_header=['nb_alloc'=>'Bénéficiaires (B)','age_max'=>'Age Max','age_min'=>'Age Min','moy_age'=>'Moyenne age'];
        }

        //Calcul des bénéficiaires
        $nb_alloc=array();
        $nb_enfant_all=array();
        $nb_enfant=array();
        $t_famille=array();
        $maxenfant=0;
        foreach($zones as $zone) {
            $nb_alloc[$zone]=0;
            $nb_enfant_all[$zone]=0;
            $nb_enfant[$zone]=0;
            $age_max[$zone]=0;
            $age_min[$zone]=0;
            $moy_age[$zone]=0;
            for($i=0;$i<20;$i++) $t_famille[$zone][$i]=0;
        }

        foreach($beneficiaires as $beneficiaire) {
            if($beneficiaire->ile=='W') {
                $nb_alloc["WALLIS"]++;
                $nb_enfant_all["WALLIS"]+=$beneficiaire->NbEnfantsAlloc;
                $nb_enfant["WALLIS"]+=$beneficiaire->NbEnfants;   
                if($beneficiaire->age>$age_max["WALLIS"]) $age_max["WALLIS"]=$beneficiaire->age;  
                if($beneficiaire->age<$age_min["WALLIS"] || $age_min["WALLIS"]==0) $age_min["WALLIS"]=$beneficiaire->age;  
                $moy_age["WALLIS"]+=$beneficiaire->age;   
                //Nb Enfants par famille
                $t_famille["WALLIS"][$beneficiaire->NbEnfantsAlloc]+=1;         
            } else {
                if($beneficiaire->ile=='F') {
                    $nb_alloc["FUTUNA"]++;
                    $nb_enfant_all["FUTUNA"]+=$beneficiaire->NbEnfantsAlloc;
                    $nb_enfant["FUTUNA"]+=$beneficiaire->NbEnfants;
                    if($beneficiaire->age>$age_max["FUTUNA"]) $age_max["FUTUNA"]=$beneficiaire->age;  
                    if($beneficiaire->age<$age_min["FUTUNA"] || $age_min["FUTUNA"]==0) $age_min["FUTUNA"]=$beneficiaire->age; 
                    $moy_age["FUTUNA"]+=$beneficiaire->age;
                    //Nb Enfants par famille
                    $t_famille["FUTUNA"][$beneficiaire->NbEnfantsAlloc]+=1;   
                }
                else {
                    $nb_alloc["AUTRE"]++;
                    $nb_enfant_all["AUTRE"]+=$beneficiaire->NbEnfantsAlloc;
                    $nb_enfant["AUTRE"]+=$beneficiaire->NbEnfants;
                    if($beneficiaire->age>$age_max["AUTRE"]) $age_max["AUTRE"]=$beneficiaire->age;  
                    if($beneficiaire->age<$age_min["AUTRE"] || $age_min["AUTRE"]==0) $age_min["AUTRE"]=$beneficiaire->age; 
                    $moy_age["AUTRE"]+=$beneficiaire->age;
                    //Nb Enfants par famille
                    $t_famille["AUTRE"][$beneficiaire->NbEnfantsAlloc]+=1; 
                }
            }
            $nb_alloc["TOTAL"]++;
            $nb_enfant_all["TOTAL"]+=$beneficiaire->NbEnfantsAlloc;
            $nb_enfant["TOTAL"]+=$beneficiaire->NbEnfants;
            //Nb Enfants par famille
            $maxenfant=($maxenfant>=$beneficiaire->NbEnfantsAlloc)?$maxenfant:$beneficiaire->NbEnfantsAlloc;
            $t_famille["TOTAL"][$beneficiaire->NbEnfantsAlloc]++; 
        }  
        $moy_age["WALLIS"]=round($moy_age["WALLIS"]/$nb_alloc["WALLIS"],0);
        $moy_age["FUTUNA"]=round($moy_age["FUTUNA"]/$nb_alloc["FUTUNA"],0);
        $moy_age["AUTRE"]=round($moy_age["AUTRE"]/$nb_alloc["AUTRE"],0);
        $moy_age["TOTAL"]=round(($moy_age["WALLIS"]+$moy_age["FUTUNA"]+$moy_age["AUTRE"])/3,0);

        $age_min["TOTAL"]=$age_min["WALLIS"];
        if($age_min["FUTUNA"]<$age_min["TOTAL"]) $age_min["TOTAL"]=$age_min["FUTUNA"];
        if($age_min["AUTRE"]<$age_min["TOTAL"]) $age_min["TOTAL"]=$age_min["AUTRE"];
        
        $age_max["TOTAL"]=$age_max["WALLIS"];
        if($age_max["FUTUNA"]>$age_max["TOTAL"]) $age_max["TOTAL"]=$age_max["FUTUNA"];
        if($age_max["AUTRE"]>$age_max["TOTAL"]) $age_max["TOTAL"]=$age_max["AUTRE"];

        $t_table=array();
        foreach($zones as $zone) {
            $classe="";$style="";
            if($zone=='TOTAL') {
                $classe='bg-secondary';
                $style='font-weight:bold';
            }
            if(($benef_type=="A")||($benef_type=="S")) {
                if($benef_type=="S") {$this->submenu='tdb_s';$this->menu='analyses_s';}
                if($benef_type=="A") {$this->submenu='tdb_a';$this->menu='analyses_a';}
                $t_table[$zone]=[
                    "nom"=>$zone,
                    "value_nb_alloc"=>$nb_alloc[$zone],"classe_nb_alloc"=>'',"style_nb_alloc"=>'',
                    "value_nb_enfant_all"=>$nb_enfant_all[$zone],"classe_nb_enfant_all"=>'',"style_nb_enfant_all"=>'',
                    "value_ratio_all"=>round($nb_enfant_all[$zone]/$nb_alloc[$zone],1),"classe_ratio_all"=>'',"style_ratio_all"=>'',
                    "value_nb_enfant"=>$nb_enfant[$zone],"classe_nb_enfant"=>'',"style_nb_enfant"=>'',
                    "value_ratio"=>round($nb_enfant[$zone]/$nb_alloc[$zone],1),"classe_ratio"=>'',"style_ratio"=>'',
                    "classe"=>$classe,
                    "style"=>$style,
                ];
            }
            if($benef_type=="R") {
                $this->submenu='tdb_r';$this->menu='analyses_r';
                $t_table[$zone]=[
                    "nom"=>$zone,
                    "value_nb_alloc"=>$nb_alloc[$zone],"classe_nb_alloc"=>'',"style_nb_alloc"=>'',
                    "value_age_min"=>$age_min[$zone],"classe_age_min"=>'',"style_age_min"=>'',
                    "value_age_max"=>$age_max[$zone],"classe_age_max"=>'',"style_age_max"=>'',
                    "value_moy_age"=>$moy_age[$zone],"classe_moy_age"=>'',"style_moy_age"=>'',
                    "classe"=>$classe,
                    "style"=>$style,
                ];
            }
        }
   
        foreach($zones as $zone) {
            $classe="";$style="";
            if($zone=='TOTAL') {
                $classe='bg-secondary';
                $style='text-align:centerfont-weight:bold';
            }
            $t_famille[$zone]["nom"]=$zone;
            $t_famille[$zone]["classe"]=$classe;
            $t_famille[$zone]["style"]=$style;
        }

        return View::make('stats.index_tdb', [
            'user' => $user,'menu' => $this->menu,'submenu' => $this->submenu,'menu_home' => $this->menu_home,
            'titre'=>$titre,
            't_header' => $t_header,
            't_table' => $t_table,
            'zones'=>$zones,
            't_famille' => $t_famille,
            'benef_type'=>$benef_type,
            'maxenfant' => $maxenfant
        ]);
    }

    public function index_periode_tdb($benef_type,$exercice="",$mois="")
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        $zones=["WALLIS","FUTUNA","AUTRE","TOTAL"];

        if($exercice=="") $exercice=date('Y');
        if($mois=="") {
            $mois=intval(date('m'))-1;
            if ($mois==0) $mois='12';
            else $mois=str_pad($mois,'2','0',STR_PAD_LEFT);
        }
        $exercices = Parametre::where('ref','=','TAUX_CLR_CCPF')->first()->Exercices; 
        $exercices = ['*'=>'Tous']+$exercices;
        $moiss=['01'=>"janvier",'02'=>"Février",'03'=>"Mars",'04'=>"Avril",'05'=>"Mai",
          '06'=>"Juin",'07'=>"Juillet",'08'=>"Août",'09'=>"Septembre",'10'=>"Octobre",
          '11'=>"Novembre",'12'=>"Décembre"];

        $type="";$titre="Tableau de bord/Période";
        $allocenf =0;
        if($benef_type=="A") {
            $this->menu='analyses_a';$this->submenu='tdb_nbenfant_a';
            $allocenf = Parametre::where('ref','=','CAL_MONTANT_ALLOC')->first()->value;
            $type="ALL";
            if(!$user->HasRole("ADMINISTRATEUR") && !$user->can("ANA_ALL")) return View::make('stats.forbidden');
            $titre.=" - ALLOCATAIRES";
            $t_header=['nb_alloc'=>'Bénéficiaires (B)','nb_enfant_all'=>'Enfants avec allocations (EA)',
                'ratio_all'=>'Rapport EA/B'];
        }
        if($benef_type=="S") {
            $this->menu='analyses_s';$this->submenu='tdb_nbenfant_s';
            $allocenf = Parametre::where('ref','=','CAL_MONTANT_SOC')->first()->value;
            $type="SOC";
            if(!$user->HasRole("ADMINISTRATEUR") && !$user->can("ANA_ASOC")) return View::make('stats.forbidden');
            $titre.=" - AIDE SOCIALE";
            $t_header=['nb_alloc'=>'Bénéficiaires (B)','nb_enfant_all'=>'Enfants avec allocations (EA)',
            'ratio_all'=>'Rapport EA/B'];
        }

        $nb_alloc=array();$nb_enfant_all=array();
        foreach($zones as $zone) {
            $nb_alloc[$zone]=0;
            $nb_enfant_all[$zone]=0;
        }

        $critdate=$exercice."-".$mois."%";
        $date=$exercice."-".$mois."-01";

        if($exercice<'2017') {
            $t_benef = DB::table('_stat_versem_all')->select('benum')->where('type','=',$type)->where('date','like',$critdate)->pluck('benum')->toArray();
        } else {
            $t_benef = DB::table('versem')->select('benum')->where('type','=',$type)->where('date','like',$critdate)->pluck('benum')->toArray();
        }
        $beneficiaires = Beneficiaire::whereIn('id', $t_benef)->orderBy('nom')->orderBy('prenom')->get();

        foreach($beneficiaires as $beneficiaire) {
            /* Aujourd'hui */
            $ile=$beneficiaire->ile;
            $NbEnfantsAlloc=$beneficiaire->NbEnfantsAlloc;  
            $montant_vers =0;

            //Recherche du versement 
            if($exercice<'2017') {
                $montant_vers = DB::table('_stat_versem_all')
                    ->select(DB::raw('montant_c'))
                    ->where('benum','=',$beneficiaire->id)
                    ->where('type','=',$type)
                    ->where('date','like',$critdate)
                    ->value('montant_c');
            } else  {
                $montant_vers = DB::table('versem')
                    ->select(DB::raw('montant_c'))
                    ->where('benum','=',$beneficiaire->id)
                    ->where('type','=',$type)
                    ->where('date','like',$critdate)
                    ->value('montant_c');    
            }

            $NbEnfantsAlloc=round($montant_vers/$allocenf,0); 
            $age=$beneficiaire->age-(date('Y')-$exercice);

            if($ile=='W') {
                $nb_alloc["WALLIS"]++;
                $nb_enfant_all["WALLIS"]+=$NbEnfantsAlloc;            
            } else {
                if($ile=='F') {
                    $nb_alloc["FUTUNA"]++;
                    $nb_enfant_all["FUTUNA"]+=$NbEnfantsAlloc;
                }
                else {
                    $nb_alloc["AUTRE"]++;
                    $nb_enfant_all["AUTRE"]+=$NbEnfantsAlloc;
                }
            }
            $nb_alloc["TOTAL"]++;
            $nb_enfant_all["TOTAL"]+=$NbEnfantsAlloc;
        }  

        $t_table=array();
        foreach($zones as $zone) {
            $classe="";$style="";
            if($zone=='TOTAL') {
                $classe='bg-secondary';
                $style='font-weight:bold';
            }
            if(($benef_type=="A")||($benef_type=="S")) {
                if($nb_alloc[$zone]>0) $ratio=round($nb_enfant_all[$zone]/$nb_alloc[$zone],1);
                else $ratio="-";
                $t_table[$zone]=[
                    "nom"=>$zone,
                    "value_nb_alloc"=>$nb_alloc[$zone],"classe_nb_alloc"=>'',"style_nb_alloc"=>'',
                    "value_nb_enfant_all"=>$nb_enfant_all[$zone],"classe_nb_enfant_all"=>'',"style_nb_enfant_all"=>'',
                    "value_ratio_all"=>$ratio,"classe_ratio_all"=>'',"style_ratio_all"=>'',
                    "classe"=>$classe,
                    "style"=>$style,
                ];
            }
        }
        return View::make('stats.index_tdb_periode', [
            'user' => $user,'menu' => $this->menu,'submenu' => $this->submenu,'menu_home' => $this->menu_home,
            'titre'=>$titre,
            't_header' => $t_header,'t_table' => $t_table,'zones'=>$zones,
            "exercices"=>$exercices,"exercice"=>$exercice,
            "moiss"=>$moiss,"mois"=>$mois,'benef_type'=>$benef_type]);
    }

    public function index_secteurs()
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        $this->menu="analyses_c";
        $this->submenu="secteur";

        $zones=["WALLIS","FUTUNA","AUTRE","TOTAL"];
        $secteurs = Secteur::all();
        $t_secteur_employeurs=array();
        $t_secteur_employes=array();
        $t_secteur_masse=array();
        $t_secteur=array();
        $andep=Salaire::select('annee')->orderby('annee')->first()->annee;
        $andep=intVal(date("Y"))-10;

        for($an=$andep;$an<=date('Y');$an++) {
            foreach($secteurs as $secteur) {
                $nb_employeurs=$secteur->getNbEmployeurs($an."-01-01");//getNbEmployeursAnnee($an);
                $nb_employes=$secteur->getNbEmployes($an."-01-01");//getNbEmployesAnnee($an);
                $masse=$secteur->getMasseSalariale($an."-01-01");//getMasseAnnee($an);
                $t_secteur_employeurs[$secteur->id][$an]=$nb_employeurs;
                $t_secteur_employes[$secteur->id][$an]=$nb_employes;
                $t_secteur_masse[$secteur->id][$an]=$masse;
            }
            $t_annees[]=$an;
        }

        return View::make('stats.index_secteur', [
            'user' => $user,'menu' => $this->menu,'submenu' => $this->submenu,'menu_home' => $this->menu_home,
            'secteurs' => $secteurs,
            't_secteur_employeurs' => $t_secteur_employeurs,
            't_secteur_employes' => $t_secteur_employes,
            't_secteur_masse' => $t_secteur_masse,
            't_annees' => $t_annees]);
    }


    public function index_secteurs_gene($date="") {
        if(!($user=Auth::user())) return Redirect::route( 'login' );

        $this->menu="analyses_c";
        $this->submenu="secteur_general";

        $exercices = Parametre::where('ref','=','TAUX_CLR_CCPF')->first()->Exercices; 
        $exercices = ['*'=>'Tous']+$exercices;
        if($date=="") $date=date('Y-m')."-01";
        $exercice=substr($date,0,4);
        $mois=substr($date,5,2);
        $moiss=['01'=>"Janvier",'02'=>"Février",'03'=>"Mars",'04'=>"Avril",'05'=>"Mai",
          '06'=>"Juin",'07'=>"Juillet",'08'=>"Août",'09'=>"Septembre",'10'=>"Octobre",
          '11'=>"Novembre",'12'=>"Décembre"];

        $secteurs = Secteur::all();
        //$secteurs = Secteur::where('id','=','8')->get();
        return View::make('stats.index_secteur2', [
            'user' => $user,'menu' => $this->menu,'submenu' => $this->submenu,'menu_home' => $this->menu_home,
            'secteurs' => $secteurs, 
            "date" => $date,
            "exercices"=>$exercices,"exercice"=>$exercice,
            "moiss"=>$moiss,"mois"=>$mois,]);
    }

    public function index_salaries($exercice="",$mois="") {
        if(!($user=Auth::user())) return Redirect::route( 'login' );

        $this->menu="analyses_c";
        $this->submenu="salaires";

        if($exercice=="") {
            $exercice=date("Y");
            if(intval(date('m'))<3) $exercice-=1;
        }
        if($mois=="") $mois=0;

        $exercices = ['*'=>'Toutes']+$this->getListeExercices();

        $t_employeurs=array();
        $t_mois=[0=>"Tous",1=>"Janvier",2=>"Février",3=>"Mars",4=>"Avril",5=>"Mai",
            6=>"Juin",7=>"Juillet",8=>"Août",9=>"Septembre",10=>"Octobre",11=>"Novembre",12=>"Décembre"];

        $salaires=Salaire::where('annee','=',$exercice)->get();
        foreach($salaires as $salaire) {
            if($mois==0)   {
                $deb_mois=1;$fin_mois=12;
                $t_salaires=$salaire->getSalairesTab();
                foreach($t_salaires as $key=>$value) {
                    if(!isset($t_employeurs["nbsal"][$key][$salaire->sonum])) {
                        $t_employeurs["nbsal"][$key][$salaire->sonum]=0;
                        $t_employeurs["massesal"][$key][$salaire->sonum]=0;
                        $t_societes[]=$salaire->sonum;
                    }
                    if($value>0) {
                        $t_employeurs["nbsal"][$key][$salaire->sonum]+=1;
                        $t_employeurs["massesal"][$key][$salaire->sonum]+=$value;
                    } else {
                        if($value<0) {
                            echo $salaire->sonum." - ". $salaire->benum." - ".$value."<br>";
                        }
                    }
                }
            } 
            else  
            {
                $deb_mois=$mois;$fin_mois=$mois;
                $value=$salaire->getSalairesMois($mois);
                if(!isset($t_employeurs["nbsal"][$mois][$salaire->sonum])) {
                    $t_employeurs["nbsal"][$mois][$salaire->sonum]=0;
                    $t_employeurs["massesal"][$mois][$salaire->sonum]=0;
                    $t_societes[]=$salaire->sonum;
                }  
                $t_societes[]=$salaire->sonum;
                if($value>0) {
                    $t_employeurs["nbsal"][$mois][$salaire->sonum]+=1;
                    $t_employeurs["massesal"][$mois][$salaire->sonum]+=$value;
                } else {
                    if($value<0) {
                        echo $salaire->sonum." - ". $salaire->benum." - ".$value."<br>";
                    }
                }
        
            }
        }

        $societes=Employeur::wherein('id',$t_societes)->orderby('nom','ASC')->get();
        return View::make('stats.index_salaries', [
            'user' => $user,'menu' => $this->menu,'submenu' => $this->submenu,'menu_home' => $this->menu_home,
            't_employeurs' => $t_employeurs, 
            'societes' => $societes,
            "exercices" => $exercices,
            "exercice" => $exercice,"t_mois" => $t_mois,
            "mois" => $mois,
            "deb_mois"=>$deb_mois,"fin_mois"=>$fin_mois
            ]);
    }

    public function index_optimind($exercice="") {
        if(!($user=Auth::user())) return Redirect::route( 'login' );

        if($exercice=="") {
            $exercice=date("Y");
        }

        $exercices = ['*'=>'Toutes']+$this->getListeExercices();

        //$t_statuts=['R','RA','RAU','RAV','RVE','AR','SAR','AAV']
        $beneficiaires=Beneficiaire::where("statut","<>","D")->get(); //->limit(1000)

        $this->menu='analyses_r';$this->submenu='optimind';

        return View::make('stats.index_optimind', [
            'user' => $user,'menu' => $this->menu,'submenu' => $this->submenu,'menu_home' => $this->menu_home,
            'beneficiaires' => $beneficiaires, 
            'user'=>$user,
            "exercices" => $exercices,
            "exercice" => $exercice
            ]);

    }

    public function get_beneficiaire($benef_type)
    {
        $liste_beneftype=Beneftype::orderby('libelle')->select("libelle", "ref")->get()->pluck("libelle", "ref")->toArray();
        $filtre=Beneftype::where('ref','=',$benef_type)->value('statuts');
        $t_filtre=explode(';',$filtre); 
        $beneficiaires = Beneficiaire::whereIn('statut', $t_filtre)
                    ->orderBy('nom')->orderBy('prenom')
                    ->get();
        return $beneficiaires;
    }


    public function getListeExercices()
    {
        $exercices = Parametre::where('ref','=','TAUX_CLR_CCPF')->first()->Exercices; 

        return $exercices;
    }

    public function graph_tdb($type)
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );

        $numgraph=0;$api_data="";$data_graph=[];$data=[];
        if($type=='S') {
            $numgraph=1;
            $this->menu='analyses_s';
            $this->submenu='graph_s';
            $titre="Analyses graphiques - Aide Sociale";
            $this->menu='analyses_s';$this->submenu='graph_s';
            $this->submenu='graph_asoc';
            $api_data="api_nb_aidesocales";
            $libelle_tab="Statistiques sur les bénéficiaires d'Aides Sociales";
            $data_graph=$this->getApiASR("SOC");
            $data=$this->getApiNbAideSocialData("SOC");
        }
        if($type=='A') {
            $numgraph=2;
            $this->menu='analyses_a';
            $this->submenu='graph_a';
            $titre="Analyses graphiques - Allocations";
            $this->menu='analyses_a';$this->submenu='graph_a';
            $api_data="api_nb_aidesocales";
            $libelle_tab="Statistiques sur les bénéficiaires d'Allocations";
            $data_graph=$this->getApiASR("ALL");
            $data=$this->getApiNbAideSocialData("ALL");
        }
        if($type=='R') {
            $numgraph=3;
            $this->menu='analyses_r';
            $this->submenu='graph_r';
            $titre="Analyses graphiques - Aide Retraites";
            $this->menu='analyses_r';$this->submenu='graph_r';
            $api_data="api_nb_aidesocales";
            $libelle_tab="Statistiques sur les bénéficiaires de Retraites";
            $data_graph=$this->getApiASR("RET");
            $data=$this->getApiNbAideSocialData("RET");
        }


        return View::make('stats.index_graph', [
            'user' => $user,'menu' => $this->menu,'submenu' => $this->submenu,'menu_home' => $this->menu_home,
            'titre'=>$titre,
            'numgraph' => $numgraph,'api_data' => $api_data,'libelle_tab' => $libelle_tab,
            'data_graph'=>$data_graph,'data'=>$data,
        ]);
    }




/*
- au 31/12/2018
- au 31/01/2019,
- au 31/02/2019,
- au 31/03/2019,
- au 31/04/2019
- et au 31/05/2019

pour avoir :
- le nombre d'enfants bénéficiaires actifs à ces périodes et qui ont reçu un paiement effectif,
- le nombre d'enfants bénéficiaires actifs mais dont le paiement est suspendu à ces périodes,
- le nombre d'enfants radiés à ces périodes et les motifs si possible,
- le nombre d'enfants bénéficiaires actifs du régime des prestations familiales qui ont basculé vers le régime social de l'aide à l'enfance,
- le nombre d'enfants bénéficiaires actifs du régime social de l'aide à l'enfance qui ont basculé vers le régime des prestations familiales.
*/

    public function data_nbenfant($type,$periode="")
    {

    }

    /* ********************************************* */
    /* DONNEEES STATISTIQUES
    /* ********************************************* */




     /* ALLOCATIONS */
    public function getApiASR($type)
    {
        /*
            CREATE ALGORITHM = UNDEFINED VIEW `_stat_versem_all` AS 
            select `versem`.`benum` AS `benum`,`versem`.`date` AS `date`,
            `versem`.`type` AS `type`,`versem`.`montant` AS `montant` 
            from `versem` 
            union 
            select `versem_hg`.`benum` AS `benum`,
            `versem_hg`.`date` AS `date`,`versem_hg`.`type` AS `type`,
            `versem_hg`.`montant` AS `montant` 
            from `versem_hg` 
            order by `date` desc;
        */
        $stats = DB::table('_stat_versem_all')
            ->select(DB::raw('benum,LEFT(date,4) as annee,SUM(montant) as montant'))
            ->where('type','=',$type)
            ->groupBy(DB::raw('LEFT(date,4),benum'))
            ->get();

        $res=array('annee'=>[],'nb'=>[],'montant'=>[]);
        foreach($stats as $stat) {
            if(!isset($res['annee'][$stat->annee])) {
                $res['nb'][$stat->annee]=0;
                $res['montant'][$stat->annee]=0;
            }
            $res['annee'][$stat->annee]=$stat->annee;
            $res['nb'][$stat->annee]++;
            $res['montant'][$stat->annee]+=$stat->montant;
        }

         $res_2=array();
        foreach($res['annee'] as $annee) {
            $res_2[]=[
            "annee"=>$res['annee'][$annee],"nb"=>$res['nb'][$annee],"montant"=>$res['montant'][$annee],
            ];
        }

        return $res_2;
    }

    public function getApiASRData($type)
    {
        $stats = $this->getApiASR($type);
        $res=array();
        foreach($stats as $stat) {
            $res[]=[
                $stat["annee"],
                $stat["nb"],
                $stat["montant"],
            ];
        }
        return $res;
    }

     /* AIDE SOCIALES */
    public function getApiNbAideSocial()
    {
        return $this->getApiASR("SOC");
    }


    public function getApiNbAideSocialData()
    {
        return $this->getApiASRData("SOC");
    }



     /* ALLOCATIONS */
    public function getApiAllocations()
    {
        return $this->getApiASR("ALL");
    }


    public function getApiAllocationsData()
    {
        return $this->getApiASRData("ALL");
    }

     /* RETRAITES */
    public function getApiNbRetraites()
    {
        return $this->getApiASR("RET");
    }


    public function getApiNbRetraitesData()
    {
        return $this->getApiASRData("RET");
    }


}
