<?php namespace App\Http\Controllers;

use Auth\AuthController;
use App\Models\User;
use Illuminate\Support\Facades\Session;
use View;
use DB;

class StatsController extends Controller {

    public function getIndexTaxe()
    {
        $user=User::where('usr_id','=',Session::get('usr_id'))->first();
        return View::make('stats.taxes', ['user'=>$user]);
    }

    public function getIndexValeur()
    {
        $user=User::where('usr_id','=',Session::get('usr_id'))->first();
        return View::make('stats.valeur', ['user'=>$user]);
    }

    public function getIndexOrigine()
    {
        return View::make('stats.origines');
    }

    public function getIndexImportateur()
    {
        return View::make('stats.importateur');
    }


/*
    public function getApiTaxes()
    {
        $days = Input::get('days', 7);

        $range = \Carbon\Carbon::now()->subDays($days);

        $stats = DB::table('orders')
            ->where('created_at', '>=', $range)
            ->groupBy('date')
            ->orderBy('date', 'ASC')
            ->remember(1440) // Cache the data for 24 hours
            ->get([
                DB::raw('Date(created_at) as date'),
                DB::raw('COUNT(*) as value')
            ]);

        return $stats;
    }
    */


    /* ***********************************
    /*               TAXES PAR ANNEE
    /* ***********************************

    /* Total Taxes par année */
    public function getApiTaxes()
    {
        $daus = DB::table('_dau_net')
            ->groupBy('annee')
            ->get([
                DB::raw('annee'),
                DB::raw('SUM(mt_taxes - mt_exo) as mt_taxes'),
            ]);

        return $daus;
    }

    public function getApiTaxesData()
    {
        $daus = $this->getApiTaxes();
        $res=array();
        foreach($daus as $dau) {
            $montant=intval($dau->mt_taxes);
            //money_format('%=*^-14#8.2i',  $montant);
            $montant= number_format($montant, 0, ',', ' ');
        	$res[]=[$dau->annee,$montant];
        }
        return $res;
    }

    /* Total Taxes par année et bureau*/
    public function getApiTaxesBureau()
    {
        $daus = DB::table('_dau_total_taxe_par_an_bureau')
            ->orderby('annee','ASC')
            ->orderby('bureau','ASC')
            ->get([
                DB::raw('annee'),
                DB::raw('bureau'),
                DB::raw('taxes as mt_taxes'),
            ]);
        $res=array();
        foreach($daus as $dau) {
            if($dau->bureau=="8112") $montant_F=$dau->mt_taxes;
            if($dau->bureau=="8111") $montant_W=$dau->mt_taxes;
            //Si 2e passage on enregistre
            if($dau->bureau=="8112") $res[]=["annee"=>$dau->annee,"mt_taxes_W"=>$montant_W,"mt_taxes_F"=>$montant_F];
        }
        return $res;
    }
    public function getApiTaxesBureauData()
    {
        $daus = $this->getApiTaxesBureau();
        $res=array();
        foreach($daus as $dau) {
            $montant_W= number_format(intval($dau['mt_taxes_W']), 0, ',', ' ');
            $montant_F= number_format(intval($dau['mt_taxes_F']), 0, ',', ' ');
            $res[]=[$dau['annee'],$montant_W,$montant_F];
        }
        return $res;
    }


    /* Détail des Taxes par année */
    public function getApiDetailTaxes()
    {
        $daus = DB::table('_dau_net')
            ->groupBy('annee')
            ->get([
                DB::raw('annee'),
                DB::raw('SUM(mt_dd_net) as mt_dd'),
                DB::raw('SUM(mt_dp_net) as mt_dp'),
                DB::raw('SUM(mt_rsi) as mt_rsi'),
                DB::raw('SUM(mt_te_net) as mt_te'),
                DB::raw('SUM(mt_tica_net) as mt_tica'),
                DB::raw('SUM(mt_tich_net) as mt_tich'),
                DB::raw('SUM(mt_tict_net) as mt_tict'),
                DB::raw('SUM(mt_tpp_net) as mt_tpp'),
                DB::raw('SUM(mt_tic_net) as mt_tic'),
                DB::raw('SUM(mt_tsa_net) as mt_tsa'),
                DB::raw('SUM(mt_mill) as mt_mill'),
            ]);

        return $daus;
    }


    public function getApiDetailTaxesData()
    {
        //$t_list_taxes=array('mt_dd','mt_dp','mt_rsi','mt_te','mt_tica','mt_tich','mt_tict','mt_tpp','mt_tic','mt_tsa','mt_mill');

        $daus = $this->getApiDetailTaxes();
        $res=array();
        foreach($daus as $dau) {
            $mt_dd=number_format($dau->mt_dd, 0, ',', ' ');
            $mt_dp=number_format($dau->mt_dp, 0, ',', ' ');
            $mt_rsi=number_format($dau->mt_rsi, 0, ',', ' ');
            $mt_te=number_format($dau->mt_te, 0, ',', ' ');
            $mt_tica=number_format($dau->mt_tica, 0, ',', ' ');
            $mt_tich=number_format($dau->mt_tich, 0, ',', ' ');
            $mt_tict=number_format($dau->mt_tict, 0, ',', ' ');
            $mt_tpp=number_format($dau->mt_tpp, 0, ',', ' ');
            $mt_tic=number_format($dau->mt_tic, 0, ',', ' ');
            $mt_tsa=number_format($dau->mt_tsa, 0, ',', ' ');
            $mt_mill=number_format($dau->mt_mill, 0, ',', ' ');
            $res[]=[$dau->annee,$mt_dd,$mt_dp,$mt_rsi,$mt_te,$mt_tica,$mt_tich,$mt_tict,$mt_tpp,$mt_tic,$mt_tsa,$mt_mill];
        }
        return $res;
    }




    /* ***********************************
    /*               VALEURS
    /* ***********************************

    /* Total Taxes par année */
    public function getApiValeur()
    {
        $dau_details = DB::table('_dau_detail')
            ->groupBy('annee')
            ->get([
                DB::raw('annee'),
                DB::raw('SUM(valeur) as valeur'),
                DB::raw('ROUND(SUM(valeur),0) as Montant'),
            ]);

        return $dau_details;
    }

    public function getApiValeurData()
    {
        $dau_details = $this->getApiValeur();
        $res=array();
        foreach($dau_details as $dau_detail) {
            $montant= number_format($dau_detail->Montant, 0, ' ', ' ');
            $res[]=[$dau_detail->annee,$montant];
        }
        return $res;
    }

    /* Détail des Taxes par année */
    public function getApiDetailValeur($param=array())
    {

        $annee=array((!isset($param['annee']))?'2015': $param['annee']);
        $limit=(!isset($param['limit']))?'20': $param['limit'];
        $champ_tri=(!isset($param['champ_tri']))?'valeur': $param['champ_tri'];
        $sens_tri=(!isset($param['sens_tri']))?'DESC': $param['sens_tri'];

        if($limit=='') $limit='999999';
        $daus = DB::table('_dau_detail')
            ->whereIn('annee',$annee)
            ->groupBy('annee')
            ->groupBy('nomenclature')
            ->orderby($champ_tri,$sens_tri)
            ->limit($limit)
            ->get([
                DB::raw('annee'),
                DB::raw('nomenclature'),
                DB::raw('chapitre'),
                DB::raw('designation'),
                DB::raw('SUM(valeur) as valeur'),
                DB::raw('ROUND(SUM(valeur),0) as Montant'),
            ]);

        return $daus;
    }

    public function getApiDetailValeurData()
    {
        $dau_details = $this->getApiDetailValeur(array('limit'=>'999999','champ_tri'=>'valeur','sens_tri'=>'DESC'));
        $res=array();
        foreach($dau_details as $dau_detail) {
            $valeur=number_format($dau_detail->valeur, 0, ',', ' ');
            $libelle=$dau_detail->nomenclature." ".$dau_detail->chapitre." ".$dau_detail->designation;
            $res[]=[$libelle,$valeur];
        }
        return $res;
    }

}
