<?php namespace App\Http\Controllers;

use Auth\AuthController;
use App\User;
use App\Models\Cotisation;
use App\Models\Employeur;
use App\Models\Mandat;
use App\Models\Imputation;
use App\Models\Journal;
use App\Models\MyApp;
use App\Models\GrandLivre;
use App\Models\PlanComptable;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Auth;
use Illuminate\Http\Request;
use View;
use Validator;
use DB;

class TransfertsController extends Controller {

    private $menu='ecritures';
    private $submenu='transferts';
    private $menu_home='comptabilite';

    public function __construct()
    {
        //$this->beforeFilter('auth');

    }

    public function index($type="",$date_deb="",$date_fin="",$compte_aux="")
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );

        $liste_types=MyApp::TYPE_PIECES;
        if($date_deb=="") $date_deb=date('Y-m-d');

        $t_JoursMois=MyApp::getJoursMois($date_deb);

        if($date_fin=="")  {
            $t_JoursMois=MyApp::getJoursMois($date_deb);
            $date_fin=$t_JoursMois["dernier"];
        }

        $id_employeur=0;
        if($compte_aux) {
            $employeur=Employeur::where("compte_aux",'=',$compte_aux)->first();
            if($employeur) $id_employeur=$employeur->id;
        }
        $t_lignes=array();
        if(($type!="")&&($date_deb!="")&&($date_fin!="")) {
            if($type=="AC") $t_lignes=$this->getListeAppelsCotisations($date_deb,$date_fin,$id_employeur);
            if($type=="RG") $t_lignes=$this->getListeReglements($date_deb,$date_fin,$id_employeur);
            //Mandats
            if($type=="MD") $t_lignes=$this->getListeImputations($date_deb,$date_fin);

            //if($type=="FA") $t_lignes=$this->getListeFactures($type);
            //if($type=="SA") $t_lignes=$this->getListeSalaires($type);
            //if($type=="PM") $t_lignes=$this->getListePaiements($type);
        }
        //dd($t_lignes);
        if($date_deb) {$date_debFR=date('d/m/Y', strtotime($date_deb));Session::put("transfert_date_deb");}
        else $date_debFR=Session::get("transfert_date_deb");
        if($date_fin) {$date_finFR=date('d/m/Y', strtotime($date_fin));Session::put("transfert_date_fin");}
        else $date_finFR=Session::get("transfert_date_fin");

        //comptes AUxiliaires
        $comptes_aux_json='';  
        $comptes_aux=DB::table('employeurs')->select(db::raw("CONCAT(compte_aux,' (',LEFT(TRIM(nom),20),'..)') as nom"),"compte_aux")->whereNotNull('compte_aux')->orderby("compte_aux")->get();
        $data_aux=array();
        $data_aux[] =["id"=>" ","text"=>"Tous"];
        foreach($comptes_aux as $cpt) $data_aux[] = ["id"=> $cpt->compte_aux,"text"=>$cpt->nom];
        $comptes_aux_json=json_encode($data_aux);  

        return View::make('comptabilite.transferts.index',
            [
                'user' => $user, 'menu' => $this->menu,'submenu' => $this->submenu,'menu_home' => $this->menu_home,
                'liste_types' => $liste_types,'type' => $type,
                't_lignes' => $t_lignes,
                'date_debFR'=>$date_debFR,'date_finFR'=>$date_finFR,
                'comptes_aux_json'=>$comptes_aux_json,'compte_aux'=>$compte_aux,

            ]);

    }

    public function index_filtre($type,$date_deb="",$date_fin="",$compte_aux="")
    {
        return $this->index($type,$date_deb,$date_fin,$compte_aux);
    }

    /* Génération des écritures */
    public function valide(Request $request )
    {
        if(!$user= Auth::user()) return Redirect::route( 'login' );

        $type=$request->type;
        $t_error=[];
        $msg="";

        if($type=="RG") $msg=$this->transfertReglements($request,$t_error);
        if($type=="AC") $msg=$this->transfertAppelsCotisations($request,$t_error);
        if($type=="MD") $msg=$this->transfertImputations($request,$t_error);

        //if($type=="FA") $this->transfertFactures($request);
        //if($type=="SA") $this->transfertSalaires($request);

        if(!$msg && $t_error) return redirect()->back()->withErrors($t_error)->withInput();

        Session::flash('message', $msg);
        return redirect()->back();
    }

    //REcherche des appels à cotisation
    public function getListeAppelsCotisations($date_deb,$date_fin,$id_employeur=0) {
        //REcherche des factures déjà passées
        $exercice=substr($date_deb,0,4);
        $obj_cotisations = Cotisation::orderBy('date','ASC');
        //$obj_cotisations = $obj_cotisations->where('exercice','=',$exercice);
        if($id_employeur) $obj_cotisations = $obj_cotisations->where('sonum','=',$id_employeur);
        $obj_cotisations = $obj_cotisations->where('type_ope','<>','REG');
        //$obj_cotisations = $obj_cotisations->whereBetween('mois',[$date_deb,$date_fin]);
        $obj_cotisations = $obj_cotisations->where('exercice','=',$exercice);
        $obj_cotisations = $obj_cotisations->where(function($query) {
                $query->where('transaction', '=', '')->orwhereNull('transaction');
            });
        $cotisations = $obj_cotisations->orderby('id','ASC')->get();

        return $cotisations;
    }

    public function getListeReglements($date_deb,$date_fin,$id_employeur=0) {
        //REcherche des factures déjà passées
        $exercice=date('Y');
        $obj_cotisations = Cotisation::orderBy('date','ASC');
        if($id_employeur) $obj_cotisations = $obj_cotisations->where('sonum','=',$id_employeur);
        //$obj_cotisations = $obj_cotisations->where('exercice','=',$exercice);
        $obj_cotisations = $obj_cotisations->where('type_ope','=','REG');
        $obj_cotisations = $obj_cotisations->whereBetween('encais_date',[$date_deb,$date_fin]);
        $obj_cotisations = $obj_cotisations->where(function($query) {
                $query->where('transaction', '=', '')->orwhereNull('transaction');
            });
        $cotisations = $obj_cotisations->orderby('id','ASC')->get();

        return $cotisations;
    }


    public function getListeImputations($date_deb,$date_fin) {
        $imputations = Imputation::select(db::raw('imputation_mdt.id as id'))
                ->join('mandats','mandats.id','=','imputation_mdt.idmandat')
                //->where('mandats.statut_mdt','=','VAL')
                //->where('mandats.statut_transfert','=','TRA')
                ->whereBetween('mandats.date_valid',[$date_deb,$date_fin])
                ->where(function($query) {
                    $query->where('imputation_mdt.transaction', '=', '')->orwhereNull('imputation_mdt.transaction');
                })
                //->where('mandats.id','=','12526')
                ->orderBy('idmandat','ASC')
                ->pluck('id')->toArray();

        $liste_imp=Imputation::whereIn('id',$imputations)->get();
        /*
        $liste_imp=[];
        foreach($imputations as $imputation){
            $imp=Imputation::where('id','=',$imputation)->get();
            $liste_imp[]=$imp;
        }
        */
        return $liste_imp;
    }

    public function getListeFactures($type)
    {
    }

    public function getListeSalaires($type)
    {

    }

    public function getListePaiements($type)
    {

    }

    public function transfertAppelsCotisations(Request $request,&$t_error)
    {
        $reference=$request->reference;
        $type=$request->type;
        $list_check=$request->list_check;
        if($reference=="") {
            $t_error['error']="Il faut saisir une référence";
            return false;
            //return redirect()->back()->withInput()->withErrors($t_error)->with("type",$type);
        }
        $list_check=$request->list_check;

        $nb=0;$num_transaction=0;$lst_transac="";
        if($list_check) {
            $t_list_check=explode(";",$list_check);
            //date_default_timezone_set('Pacific/Noumea');
            //$date_transaction=date("Y-m-d");
            $journal_code="BDX-COT"; //Cotisations
            $journal=Journal::where('nom_court','=',$journal_code)->first();
            if(!$journal) {
                $t_error['doublon']="Le journal ".$journal_code." n'existe pas, la génération est impossible.";
                return redirect()->back()->withInput()->withErrors($t_error);
            }

            foreach($t_list_check as $id_cotisation) {
                $cotisation=Cotisation::find($id_cotisation);
                $date_transaction=$cotisation->DateUS;
                $id_cotisation=$cotisation->id_cotisation;
                $employeur=Employeur::find($cotisation->sonum);
                $compte_aux=$employeur->compte_aux;
                $num_transaction=GrandLivre::max('transaction')+1; //NEW add transaction
                $lib_cotisation="AP.COTIS:".str_pad($cotisation->id,6,"0", STR_PAD_LEFT)."/".$compte_aux." - ".$reference;
                if($compte_aux) {
                     $t_id=[];
                    //APPEL COTISATION CPSWF
                    $mois=(strlen($cotisation->MoisUS)>5)?substr($cotisation->MoisUS,0,7):"";
                    $prive=$cotisation->bdx_prive?true:false;
                    $bdx=$prive?$cotisation->bdx_prive:$cotisation->bdx;
                    $bdx=($prive?"PR":"PU").str_pad($bdx,2,"0", STR_PAD_LEFT);
                    $designation=$employeur->NomComplet."-".$bdx."-".$cotisation->observation;
                    $t_comptes=["CPSWF","CLR"];
                    foreach($t_comptes as $cpt) {
                        $designation="AP.COTIS:".$compte_aux."/".$cotisation->type_ope."/".$cpt." - BDX".$bdx." - MOIS:".$mois; //." - ".$cotisation->observation
                        $compte=($cpt=="CPSWF")?"474000":"474100"; 
                        $plan_comptable=PlanComptable::where('compte','=',$compte)->first();
                        $montant=($cpt=="CPSWF")?$cotisation->ccpf:$cotisation->clr;
                        $sens="D";
                        $t_ligne=[];
                        $t_ligne["transaction"]=$num_transaction;
                        $t_ligne["date_ref"]= $cotisation->MoisUS; 
                        $t_ligne["date_doc"]= $date_transaction; 
                        $t_ligne["ref_doc"]= $lib_cotisation;
                        $t_ligne["id_ref"]= $cotisation->id; 
                        $t_ligne["compte"]= $compte;
                        $t_ligne["compte_label"]= ($plan_comptable)?$plan_comptable->libelle:"";
                        $t_ligne["compte_aux"]= $compte_aux;
                        $t_ligne["compte_aux_label"]= strtoupper(trim($employeur->nom));
                        $t_ligne["designation"]= $designation;
                        $t_ligne["debit"]= $montant;
                        $t_ligne["crédit"]= 0;
                        $t_ligne["montant"]= $montant;
                        $t_ligne["sens"]= "D";
                        $t_ligne["journal"]= $journal->nom_court;
                        $t_ligne["journal_label"]= $journal->nom;
                        $id_pple=$this->insertLigne($t_ligne);
                        $t_id[]=$id_pple;

                        //CONTREPARTIE
                        $t_ligne=[];
                        if($prive) {
                            if($cotisation->type_ope<>"MAJ") $compte=($cpt=="CPSWF")?"756200":"756201"; 
                            else  $compte=($cpt=="CPSWF")?"756300":"756301"; 
                        } else {
                            if($cotisation->type_ope<>"MAJ") $compte=($cpt=="CPSWF")?"756100":"756101"; 
                            else  $compte=($cpt=="CPSWF")?"756300":"756301"; 
                        }
                        $plan_comptable=PlanComptable::where('compte','=',$compte)->first();
                        $t_ligne["transaction"]=$num_transaction;
                        $t_ligne["date_ref"]= $cotisation->MoisUS; 
                        $t_ligne["date_doc"]= $date_transaction; 
                        $t_ligne["ref_doc"]= $lib_cotisation;
                        $t_ligne["id_ref"]= $cotisation->id; 
                        $t_ligne["compte"]= $compte;
                        $t_ligne["compte_label"]=($plan_comptable)?$plan_comptable->libelle:"";
                        $t_ligne["compte_aux"]= null;
                        $t_ligne["compte_aux_label"]= null;
                        $t_ligne["designation"]= $designation;
                        $t_ligne["debit"]= 0;
                        $t_ligne["crédit"]= $montant;
                        $t_ligne["montant"]= $montant;
                        $t_ligne["sens"]= "C";
                        $t_ligne["journal"]= $journal->nom_court;
                        $t_ligne["journal_label"]= $journal->nom;
                        $t_id[]=$this->insertLigne($t_ligne);
                    }
                    //Mise à jour ref cotisations
                    $cotisation->releve_ref=$lib_cotisation;
                    $cotisation->transaction=$num_transaction; //NEW
                    $cotisation->save();
                    $nb++;
                    $lst_transac.=(($lst_transac=="")?"":",")."<a target='_blank' href='".url('transaction/'.$num_transaction)."'>".$num_transaction.'</a>';
                }
                //Mise à jour de l'écriture pour transaction
                //$num_transaction=GrandLivre::max('transaction')+1;
                //$lignes=GrandLivre::whereIn('id',$t_id)->update(['transaction' => $num_transaction]);
            }
        }

        if($num_transaction!=0) {
            if($num_transaction==1) $msg=$nb." ecritures ont été générées dans la transaction N°<a href='".url('transaction/'.$num_transaction)."'>".$num_transaction.'</a>';
            else $msg=$nb." ecritures ont été générées dans ".$nb." transactions : ".$lst_transac;
        } else $msg="Aucune transaction créé";

        return $msg;
    }

    public function transfertReglements(Request $request,&$t_error)
    {
        $reference=$request->releve_ref;
        $type=$request->type;
        $list_check=$request->list_check;
        if($reference=="") {
            $t_error['error']="Il faut saisir une référence";
            return false;
            //return redirect()->back()->withInput()->withErrors($t_error)->with("type",$type);
        }
        $list_check=$request->list_check;

        $nb=0;$num_transaction=0;$lst_transac="";
        if($list_check) {
            $t_list_check=explode(";",$list_check);
            date_default_timezone_set('Pacific/Noumea');
            $date_transaction=date("Y-m-d");
            $journal_code="VTE";
            $journal=Journal::where('nom_court','=',$journal_code)->first();
            if(!$journal) {
                $t_error['doublon']="Le journal ".$journal_code." n'existe pas, la génération est impossible.";
                return redirect()->back()
                    ->withInput()
                    ->withErrors($t_error);
            }
            //Recherche si la référence existe popur mettre sur la m^me transaction
            //$transaction_GL=GrandLivre::where('ref_doc','like','%'.$reference.'%')->first();
            //if(!$transaction_GL) $num_transaction=GrandLivre::max('transaction')+1;
            //else $num_transaction=$transaction_GL->transaction;

            foreach($t_list_check as $id_cotisation) {
                $cotisation=Cotisation::find($id_cotisation);
                $employeur=Employeur::find($cotisation->sonum);
                $compte_aux=$employeur->compte_aux;
                $num_transaction=GrandLivre::max('transaction')+1; //NEW add transaction
                if($compte_aux) {
                    $t_id=[];
                    $compte="474000";
                    $lib_cotisation="REG".str_pad($cotisation->id,6,"0", STR_PAD_LEFT)." - ".$reference;
                    $plan_comptable=PlanComptable::where('compte','=',$compte)->first();
                    $designation=$employeur->NomComplet." - ".$cotisation->bdx_prive." - ".$cotisation->observation;
                    $t_ligne=[];
                    $t_ligne["transaction"]=$num_transaction;
                    $t_ligne["date_doc"]= $cotisation->EncaisDateUS; //NEW
                    $t_ligne["ref_doc"]= $lib_cotisation;
                    $t_ligne["id_ref"]= $cotisation->id; //NEW
                    $t_ligne["date_ref"]=$date_transaction;
                    $t_ligne["compte"]= $compte;
                    $t_ligne["compte_label"]= ($plan_comptable)?$plan_comptable->libelle:"";
                    $t_ligne["compte_aux"]= $compte_aux;
                    $t_ligne["compte_aux_label"]= strtoupper(trim($employeur->nom));
                    $t_ligne["designation"]= $cotisation->observation;
                    $t_ligne["debit"]= 0;
                    $t_ligne["crédit"]= $cotisation->credit;
                    $t_ligne["montant"]= $cotisation->credit;
                    $t_ligne["sens"]= "C";
                    $t_ligne["journal"]= $journal->nom_court;
                    $t_ligne["journal_label"]= $journal->nom;

                    $id_pple=$this->insertLigne($t_ligne);
                    $t_id[]=$id_pple;
                    //CONTREPARTIE
                    $t_ligne=[];
                    $compte="512201";  //Compte cotisant CPSWF
                    $plan_comptable=PlanComptable::where('compte','=',$compte)->first();
                    $t_ligne["transaction"]=$num_transaction;
                    $t_ligne["date_doc"]= $cotisation->EncaisDateUS; //NEW
                    $t_ligne["ref_doc"]= $lib_cotisation;
                    $t_ligne["id_ref"]= $cotisation->id; //NEW
                    $t_ligne["date_ref"]=$date_transaction;
                    $t_ligne["compte"]= $compte;
                    $t_ligne["compte_label"]=($plan_comptable)?$plan_comptable->libelle:"";
                    $t_ligne["compte_aux"]= null;
                    $t_ligne["compte_aux_label"]= null;
                    $t_ligne["designation"]= $cotisation->observation;
                    $t_ligne["debit"]= $cotisation->credit;
                    $t_ligne["crédit"]= 0;
                    $t_ligne["montant"]= $cotisation->credit;
                    $t_ligne["sens"]= "D";
                    $t_ligne["journal"]= $journal->nom_court;
                    $t_ligne["journal_label"]= $journal->nom;
                    $t_id[]=$this->insertLigne($t_ligne);

                    //Mise à jour ref cotisations
                    $cotisation->releve_ref=$lib_cotisation;
                    $cotisation->transaction=$num_transaction; //NEW
                    $cotisation->save();
                    $nb++;
                    $lst_transac.=(($lst_transac=="")?"":",")."<a  target='_blank' href='".url('transaction/'.$num_transaction)."'>".$num_transaction.'</a>';
                }
                //Mise à jour de l'écriture pour transaction
                //$num_transaction=GrandLivre::max('transaction')+1;
                //$lignes=GrandLivre::whereIn('id',$t_id)->update(['transaction' => $num_transaction]);
            }
        }

        if($num_transaction!=0) {
            if($num_transaction==1) $msg=$nb." ecritures ont été générées dans la transaction N°<a target='_blank' href='".url('transaction/'.$num_transaction)."'>".$num_transaction.'</a>';
            else $msg=$nb." ecritures ont été générées dans ".$nb." transactions : ".$lst_transac;
        } else $msg="Aucune transaction créé";

        return $msg;
    }



    public function transfertImputations(Request $request,&$t_error)
    {
        $reference=$request->releve_ref;
        $type=$request->type;
        $list_check=$request->list_check;
        if($reference=="") {
            $t_error['error']="Il faut saisir une référence";
            return false;
        }
        $list_check=$request->list_check;

        $nb=0;$num_transaction=0;$lst_transac="";
        if($list_check) {
            $t_list_check=explode(";",$list_check);
            date_default_timezone_set('Pacific/Noumea');
            $date_transaction=date("Y-m-d");
            $journal_code="MDT";
            $journal=Journal::where('nom_court','=',$journal_code)->first();
            if(!$journal) {
                $t_error['doublon']="Le journal ".$journal_code." n'existe pas, la génération est impossible.";
                return redirect()->back()
                    ->withInput()
                    ->withErrors($t_error);
            }
            //Recherche si la référence existe popur mettre sur la m^me transaction
            //$transaction_GL=GrandLivre::where('ref_doc','like','%'.$reference.'%')->first();
            //if(!$transaction_GL) $num_transaction=GrandLivre::max('transaction')+1;
            //else $num_transaction=$transaction_GL->transaction;

            foreach($t_list_check as $id_imputation) {
                $imputation=Imputation::find($id_imputation);
                $mandat=Mandat::find($imputation->idmandat);
                if($imputation->transaction=="") {
                    $num_transaction=GrandLivre::max('transaction')+1; //NEW add transaction
                    $t_id=[];
                    $compte=$imputation->cpt_imp;
                    $ref_doc="MDT:".str_pad($mandat->id,6,"0", STR_PAD_LEFT)."/IMP:".str_pad($imputation->id,6,"0", STR_PAD_LEFT)." - ".$reference;
                    $plan_comptable=PlanComptable::where('compte','=',$compte)->first();
                    $t_ligne=[];
                    $t_ligne["transaction"]=$num_transaction;
                    $t_ligne["date_doc"]= $mandat->DateValidUS; 
                    $t_ligne["ref_doc"]= $ref_doc;
                    $t_ligne["id_ref"]= $imputation->id; 
                    $t_ligne["date_ref"]=$date_transaction;
                    $t_ligne["compte"]=$compte;
                    $t_ligne["compte_label"]= ($plan_comptable)?$plan_comptable->libelle:"";
                    $t_ligne["compte_aux"]= null;
                    $t_ligne["compte_aux_label"]= null;
                    $t_ligne["designation"]= $imputation->designation;
                    $t_ligne["debit"]= $imputation->montant;
                    $t_ligne["crédit"]= 0;
                    $t_ligne["montant"]= $imputation->montant;
                    $t_ligne["sens"]= "D";
                    $t_ligne["journal"]= $journal->nom_court;
                    $t_ligne["journal_label"]= $journal->nom;

                    $id_pple=$this->insertLigne($t_ligne);
                    $t_id[]=$id_pple;
                    //CONTREPARTIE
                    $t_ligne=[];
                    $compte_dest=MyApp::getCompteImputation($imputation->type_imp);
                    if($compte_dest=="") $compte_dest="512000";  //Compte cotisant CPSWF
                    $plan_comptable=PlanComptable::where('compte','=',$compte)->first();
                    $t_ligne["transaction"]=$num_transaction;
                    $t_ligne["date_doc"]= $mandat->DateValidUS; 
                    $t_ligne["ref_doc"]= $ref_doc;
                    $t_ligne["id_ref"]= $imputation->id; 
                    $t_ligne["date_ref"]=$date_transaction;
                    $t_ligne["compte"]= $compte_dest;
                    $t_ligne["compte_label"]=($plan_comptable)?$plan_comptable->libelle:"";
                    $t_ligne["compte_aux"]= null;
                    $t_ligne["compte_aux_label"]= null;
                    $t_ligne["designation"]= $imputation->designation;
                    $t_ligne["debit"]= 0;
                    $t_ligne["crédit"]= $imputation->montant;
                    $t_ligne["montant"]= $imputation->montant;
                    $t_ligne["sens"]= "C";
                    $t_ligne["journal"]= $journal->nom_court;
                    $t_ligne["journal_label"]= $journal->nom;
                    $t_id[]=$this->insertLigne($t_ligne);

                    //Mise à jour ref cotisations
                    $imputation->transaction=$num_transaction; //NEW
                    $imputation->save();
                    $nb++;
                    $lst_transac.=(($lst_transac=="")?"":",")."<a target='_blank' href='".url('transaction/'.$num_transaction)."'>".$num_transaction.'</a>';
                }
                //Mise à jour de l'écriture pour transaction
                //$num_transaction=GrandLivre::max('transaction')+1;
                //$lignes=GrandLivre::whereIn('id',$t_id)->update(['transaction' => $num_transaction]);
            }
        }

        if($num_transaction!=0) {
            if($num_transaction==1) $msg=$nb." ecritures ont été générées dans la transaction N°<a href='".url('transaction/'.$num_transaction)."'>".$num_transaction.'</a>';
            else $msg=$nb." ecritures ont été générées dans ".$nb." transactions : ".$lst_transac;
        } else $msg="Aucune transaction créé";

        return $msg;
    }



    public function insertLigne($t_ligne) {
        if(!$user= Auth::user()) return Redirect::route( 'login' );
        $grand_livre=new GrandLivre;
        $grand_livre->transaction = $t_ligne["transaction"];
        $grand_livre->date_doc = $t_ligne["date_doc"];
        $grand_livre->ref_doc = $t_ligne["ref_doc"];
        $grand_livre->date_ref = $t_ligne["date_ref"];
        $grand_livre->id_ref = $t_ligne["id_ref"]; 
        $grand_livre->compte = $t_ligne["compte"];
        $grand_livre->compte_label = $t_ligne["compte_label"];
        $grand_livre->compte_aux = $t_ligne["compte_aux"];
        $grand_livre->compte_aux_label = $t_ligne["compte_aux_label"];
        $grand_livre->designation = $t_ligne["designation"];
        $grand_livre->debit = $t_ligne["debit"];
        $grand_livre->credit = $t_ligne["crédit"];
        $grand_livre->montant = $t_ligne["montant"];
        $grand_livre->sens = $t_ligne["sens"];
        $grand_livre->lettrage_code = null;
        $grand_livre->date_lettrage = null;
        $grand_livre->user_id_create = $user->id;
        $grand_livre->user_id_modif = null;
        $grand_livre->journal = $t_ligne["journal"];
        $grand_livre->journal_label = $t_ligne["journal_label"];
        $grand_livre->verrou  = null;
        $grand_livre->date_verrou  = null;

        $grand_livre->save();


        return $grand_livre->id;
    }

/*
    public function transfertSalaires(Request $request)
    {
        if(!$user= Auth::user()) return Redirect::route( 'login' );

        //ECRITURE 1 : 641111 => Débit Salaire Brut
        //ECRITURE 2 : 6451 => Débit Charges partronales
        //ECRITURE 3 : 43731 => Crédit CLR/CCPF pers.entretien écoles
        //ECRITURE 3 : 43732 => Crédit CLR/CCPF personnel ATOSS
        //ECRITURE 4 : 425xxx => Crédit compte employé


        $type=$request->type_pieces;
        if($type=="SA") {
            $list_check=$request->list_check;
            if($list_check) {
                $t_list_check=explode(";",$list_check);
                foreach($t_list_check as $id_salaire) {
                    $salaire=Salaire::find($id_salaire);
                    $id_employe=$salaire->id_employe;
                    $employe=Employe::find($id_employe);
                    $forfait=Forfait::find($salaire->ForfaitId);
                    if($salaire && $employe && $forfait && $employe->compte) {
                        $t_ligne=[];
                        $t_id=[];
                        //ECRITURE 1 : 641111 => Débit Salaire Brut
                        $compte="641111";
                        $plan_comptable=PlanComptable::where('compte','=',$compte)->first();
                        $t_ligne=[];
                        $t_ligne["id_forfait"]=$forfait->id;
                        $t_ligne["creancier"]=null;
                        $t_ligne["id_employe"]=$id_employe;
                        $t_ligne["type"]= "SALAIRE ".$forfait->nom;
                        $t_ligne["piece"]= $salaire->id;
                        $t_ligne["date_doc"]= $salaire->DateUS;
                        $t_ligne["ref_doc"]= $salaire->id;
                        $t_ligne["ref_creancier"]=null;
                        $t_ligne["compte"]= $compte;
                        $t_ligne["compte_label"]= ($plan_comptable)?$plan_comptable->libelle:"";
                        $t_ligne["compte_aux"]= "";
                        $t_ligne["compte_aux_label"]= "";
                        $t_ligne["designation"]= "Salaire - ".$employe->NomComplet." - ".$salaire->MoisFR;
                        $t_ligne["debit"]= $salaire->salaire_base;
                        $t_ligne["crédit"]= 0;
                        $t_ligne["montant"]= $salaire->salaire_base;;
                        $t_ligne["sens"]= "D" ;
                        $t_ligne["journal"]= "OD";
                        $t_ligne["journal_label"]= "Opérations diverses";
                        $t_id[]=$this->insertLigne($t_ligne);


                        //ECRITURE 2 : 6451 => Débit Charges partronales
                        $compte="6451";
                        $plan_comptable=PlanComptable::where('compte','=',$compte)->first();
                        $t_ligne=[];
                        $t_ligne["id_forfait"]=$forfait->id;
                        $t_ligne["creancier"]=null;
                        $t_ligne["id_employe"]=$id_employe;
                        $t_ligne["type"]= "SALAIRE ".$forfait->nom;
                        $t_ligne["piece"]= $salaire->id;
                        $t_ligne["date_doc"]= $salaire->DateUS;
                        $t_ligne["ref_doc"]= $salaire->id;
                        $t_ligne["ref_creancier"]=null;
                        $t_ligne["compte"]=$compte;
                        $t_ligne["compte_label"]= ($plan_comptable)?$plan_comptable->libelle:"";
                        $t_ligne["compte_aux"]= "";
                        $t_ligne["compte_aux_label"]= "";
                        $t_ligne["designation"]= "Salaire - ".$employe->NomComplet." - ".$salaire->MoisFR;
                        $t_ligne["debit"]= $salaire->ChargesPatronales;
                        $t_ligne["crédit"]= 0;
                        $t_ligne["montant"]= $salaire->ChargesPatronales;;
                        $t_ligne["sens"]= "D" ;
                        $t_ligne["journal"]= "OD";
                        $t_ligne["journal_label"]= "Opérations diverses";
                        $t_id[]=$this->insertLigne($t_ligne);

                        //ECRITURE 3 : 43731/43732 => Crédit CLR/CCPF pers.entretien écoles§Atoss
                        $compte=($forfait->id==1)?"43732":"43731";
                        $plan_comptable=PlanComptable::where('compte','=',$compte)->first();
                        $t_ligne=[];
                        $t_ligne["id_forfait"]=$forfait->id;
                        $t_ligne["creancier"]=null;
                        $t_ligne["id_employe"]=$id_employe;
                        $t_ligne["type"]= "SALAIRE ".$forfait->nom;
                        $t_ligne["piece"]= $salaire->id;
                        $t_ligne["date_doc"]= $salaire->DateUS;
                        $t_ligne["ref_doc"]= $salaire->id;
                        $t_ligne["ref_creancier"]=null;
                        $t_ligne["compte"]= $compte;
                        $t_ligne["compte_label"]= ($plan_comptable)?$plan_comptable->libelle:"";
                        $t_ligne["compte_aux"]= "";
                        $t_ligne["compte_aux_label"]= "";
                        $t_ligne["designation"]= "Salaire - ".$employe->NomComplet." - ".$salaire->MoisFR;
                        $t_ligne["debit"]= 0;
                        $t_ligne["crédit"]= $salaire->ChargesSalariales;
                        $t_ligne["montant"]= $salaire->ChargesSalariales;;
                        $t_ligne["sens"]= "C" ;
                        $t_ligne["journal"]= "OD";
                        $t_ligne["journal_label"]= "Opérations diverses";
                        $t_id[]=$this->insertLigne($t_ligne);

                        //ECRITURE 4 : 425xxx => Crédit compte employé
                        $compte1="442101"; //Pers.entretien écoles rem.dues
                        $compte2="42102"; //Pers.rémun.dues ATOSS DEC/In M
                        $compte3="42103"; //Pers.rémun.dues ATOSS In Lano
                        if($forfait->id==1) $compte=$compte1;
                        else {
                            if($salaire->NomEtablissement=="Internat de Malaetoli") $compte=$compte2;
                            else $compte=$compte3;
                        }
                        $plan_comptable=PlanComptable::where('compte','=',$compte)->first();
                        $t_ligne=[];
                        $t_ligne["id_forfait"]=$forfait->id;
                        $t_ligne["creancier"]=null;
                        $t_ligne["id_employe"]=$id_employe;
                        $t_ligne["type"]= "SALAIRE ".$forfait->nom;
                        $t_ligne["piece"]= $salaire->id;
                        $t_ligne["date_doc"]= $salaire->DateUS;
                        $t_ligne["ref_doc"]= $salaire->id;
                        $t_ligne["ref_creancier"]=null;
                        $t_ligne["compte"]= $compte;
                        $t_ligne["compte_label"]= ($plan_comptable)?$plan_comptable->libelle:"";
                        $t_ligne["compte_aux"]= $employe->compte;
                        $t_ligne["compte_aux_label"]= $employe->NomComplet;
                        $t_ligne["designation"]= "Salaire - ".$employe->NomComplet." - ".$salaire->MoisFR;
                        $t_ligne["debit"]= 0;
                        $t_ligne["crédit"] = $salaire->SalaireNet;
                        $t_ligne["montant"]= $salaire->SalaireNet;
                        $t_ligne["sens"]= "C" ;
                        $t_ligne["journal"]= "OD";
                        $t_ligne["journal_label"]= "Opérations diverses";
                        $t_id[]=$this->insertLigne($t_ligne);

                        //Mise à jour de l'écriture
                        $num_transaction=GrandLivre::max('transaction')+1;
                        $lignes=GrandLivre::whereIn('id',$t_id)->update(['transaction' => $num_transaction]);

                        $salaire->date_transfert=date("Y-m-d h:i:s");
                        $salaire->transaction=$num_transaction;
                        $salaire->save();
                    }
                }
            }
        }

    }


    public function transfertFactures(Request $request)
    {
        if(!$user= Auth::user()) return Redirect::route( 'login' );
        $type=$request->type_pieces;
        if($type=="FA") {
            $list_check=$request->list_check;
            if($list_check) {
                $t_list_check=explode(";",$list_check);
                foreach($t_list_check as $id_achat) {
                    $achat=Achat::find($id_achat);
                    $id_creancier=$achat->id_creancier;
                    $creancier=Creancier::find($id_creancier);
                    if($achat && $creancier) {
                        $t_id=[];
                        $compte="401";
                        $plan_comptable=PlanComptable::where('compte','=',$compte)->first();
                        $designation=$creancier->nom_court." - ".$achat->num_facture." - ".$achat->designation;
                        $t_ligne=[];
                        $t_ligne["id_forfait"]=$achat->id_forfait;
                        $t_ligne["creancier"]= $id_creancier;
                        $t_ligne["id_employe"]= null;
                        $t_ligne["type"]=  "FACTURE FOURNISSEUR";
                        $t_ligne["piece"]= $achat->id;
                        $t_ligne["date_doc"]= $achat->DateFactureUS;
                        $t_ligne["ref_doc"]= $achat->num_facture;
                        $t_ligne["ref_creancier"]= $id_creancier;
                        $t_ligne["compte"]= $compte;
                        $t_ligne["compte_label"]= ($plan_comptable)?$plan_comptable->libelle:"";
                        $t_ligne["compte_aux"]= $creancier->compte;
                        $t_ligne["compte_aux_label"]= $creancier->nom;
                        $t_ligne["designation"]= $designation;
                        $t_ligne["debit"]= 0;
                        $t_ligne["crédit"]= $achat->montant;
                        $t_ligne["montant"]= $achat->montant;
                        $t_ligne["sens"]= "C";
                        $t_ligne["journal"]= "HA";
                        $t_ligne["journal_label"]= "Journat des achats";
                        $t_id[]=$this->insertLigne($t_ligne);


                        $compte=$achat->compte;
                        $plan_comptable=PlanComptable::where('compte','=',$compte)->first();
                        $t_ligne=[];
                        $t_ligne["id_forfait"]=$achat->id_forfait;
                        $t_ligne["creancier"]= $id_creancier;
                        $t_ligne["id_employe"]= null;
                        $t_ligne["type"]=  "FACTURE FOURNISSEUR";
                        $t_ligne["piece"]= $achat->id;
                        $t_ligne["date_doc"]= $achat->DateFactureUS;
                        $t_ligne["ref_doc"]= $achat->num_facture;
                        $t_ligne["ref_creancier"]= $id_creancier;
                        $t_ligne["compte"]= $compte;
                        $t_ligne["compte_label"]= ($plan_comptable)?$plan_comptable->libelle:"";
                        $t_ligne["compte_aux"]= null;
                        $t_ligne["compte_aux_label"]= null;
                        $t_ligne["designation"]= $designation;
                        $t_ligne["debit"]= $achat->montant;
                        $t_ligne["crédit"]= 0;
                        $t_ligne["montant"]= $achat->montant;
                        $t_ligne["sens"]= "D";
                        $t_ligne["journal"]= "HA";
                        $t_ligne["journal_label"]= "Journat des achats";
                        $t_id[]=$this->insertLigne($t_ligne);

                        //Mise à jour de l'écriture
                        $num_transaction=GrandLivre::max('transaction')+1;
                        $lignes=GrandLivre::whereIn('id',$t_id)->update(['transaction' => $num_transaction]);

                        $achat->date_transfert=date("Y-m-d h:i:s");
                        $achat->transaction=$num_transaction;
                        $achat->save();
                    }
                }

            }
        }
    }

*/




}



