<?php namespace App\Http\Controllers;
use Illuminate\Support\Facades\Auth;
use Auth\AuthController;
use App\Models\Employeur;
use App\Models\Beneficiaire;
use App\Models\Beneftype;
use App\Models\Benefstatut;
use App\Models\Versement_b;
use App\Models\Parametre;
use App\Models\User;
use App\Models\Role2;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Redirect;
use View;
use DB;

use App\Http\Requests\VersementRequest;
use App\Http\Requests\AutoResponsableRequest;
use Response;
use Illuminate\Http\Request;
use Mail;

class VersementsBrouillonController extends Controller {
    private $menu='versements';
    private $submenu='versements_encours';
    private $menu_home="allocations";

    public function setMenu($type)
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );

        if($type=="ALL") {$this->menu_home="allocations";}
        if($type=="RET") {$this->menu_home="retraites";}
        if($type=="SOC") {$this->menu_home="aides_sociales";$this->menu="versements";}
        if($type=="SAV") {$this->menu_home="aides_sociales";$this->menu="versements_csr";$this->submenu="versements_encours_csr";}
    }

    public function index($type)
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        $this->setMenu($type);

        $versements_b=Versement_b::where('type','=',$type)->get();
        $error_compte=0;
        foreach($versements_b as $versement_b) {
            if(!$versement_b->CompteOK) $error_compte++;
        }

        return View::make('prestations.versements.index_brouillon', [
            'user' => $user,'menu' => $this->menu,'submenu' => $this->submenu,'menu_home' => $this->menu_home,
            'type'=>$type,
            'error_compte'=>$error_compte,
            'versements_b' => $versements_b,
        ]);
    }


    public function store(VersementRequest $request)
    {
        $versement_b = new Versement_b;
        $versement_b->benum = $request->benum;
        $versement_b->montant = $request->montant;
        $date = $request->date;
        $versement_b->date = ($date!="")?date('Y-m-d', strtotime(str_replace('/', '-', $date))):"" ;
        $versement_b->bqcleunik = $request->bqcleunik;
        $versement_b->compte = $request->compte;
        $versement_b->mode_pmt = $request->mode_pmt;
        $versement_b->type = $request->type;
        $versement_b->sonum = $request->sonum;
        $versement_b->montant_c = $request->montant_c;
        $versement_b->montant_r = $request->montant_r;
        $versement_b->num_imp = $request->num_imp;
        $versement_b->ret_type = $request->ret_type;
        $date = $request->ret_date;
        $versement_b->ret_date = ($date!="")?date('Y-m-d', strtotime(str_replace('/', '-', $date))):"" ;
        $versement_b->ret_num = $request->ret_num;
        $versement_b->obs_vers = $request->obs_vers;
        $versement_b->save();
        return Redirect::to('prestations.versements_brouillon.index');
    }

    public function edit($id)
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        $this->setMenu($type);

        $versement_b=Versement_b::find($id);
        $liste_employeur = Employeur::orderBy('nom','ASC')->pluck('nom','id')->toArray();
        $beneficiaire=Beneficiaire::find($versement_b->benum);
        return View::make('prestations.versements.edit_brouillon',
            [
            'liste_employeur' => $liste_employeur,
            'versement_b' => $versement_b,
            'beneficiaire' => $beneficiaire,
            'user'=>$user
            ]);
    }

    public function show($id)
    {
        $versement = Versement::find($id);
        return View::make('prestations.versements.show', [ 'versement'=> $versement]);
    }

    public function show_box($id)
    {
        $versement = Versement::find($id);
        return View::make('prestations.versements.show_box', [ 'versement'=> $versement]);
    }

    public function update($id,VersementBrouillonRequest $request)
    {
        $versement_b = Versement_b::find($id);

        $versement_b->obs_vers=$request->obs_vers;
        $versement_b->montant_r=$request->montant_r;
        $versement_b->montant=$montant+$montant_r;
        /*$versement_b->benum=$beneficiaire->id;
        $versement_b->montant=$montant_c;
        $versement_b->date=date("Y-m-d");
        $versement_b->bqcleunik=$beneficiaire->banque_id;
        $versement_b->compte=$beneficiaire->compte;
        $versement_b->mode_pmt="";
        $versement_b->type=$type;
        $versement_b->sonum="";
        $versement_b->montant_c=$montant_c;
        $versement_b->montant_r=0;
        $versement_b->num_imp=0;
        $versement_b->ret_type="";
        $versement_b->ret_date="";
        $versement_b->ret_num="";
        $versement_b->obs_vers="";
        */
        $versement_b->save();
        return Redirect::to('prestations/versement_brouillon/'.$request->sonum);
    }


     /**
     * Génération des versements
     */
    public function generation($type)
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        $this->setMenu($type);

        $this->submenu="versements_generation";
        if($type=="ALL") {$this->menu_home="allocations";$this->menu="versements";}
        if($type=="RET") {$this->menu_home="retraites";$this->menu="versements";}
        if($type=="SOC") {$this->menu_home="aides_sociales";$this->menu="versements";}
        if($type=="SAV") {$this->menu_home="aides_sociales";$this->menu="versements_csr";$this->submenu="versements_generation_csr";}

        

        return View::make('prestations.versements.generation_brouillon', [
            'user' => $user,'menu' => $this->menu,'submenu' => $this->submenu,'menu_home' => $this->menu_home,
            'type' => $type
        ]);
    }

     /**
     * Génération des versements brouillon
     */
    public function set_generation_brouillon(Request $request,$type) {
        if($type=="ALL") $benef_type="A";
        if($type=="RET") $benef_type="R";
        if($type=="SOC") $benef_type="S"; 
        if($type=="SAV") $benef_type="R";
        
        $filtre=Beneftype::where('ref','=',$benef_type)->value('statuts');
        $t_filtre0=explode(';',$filtre);
        $t_filtre=array();
        foreach($t_filtre0 as $stat) if($stat!="") $t_filtre[]=$stat;
        $beneficiaires_obj = Beneficiaire::whereIn('statut', $t_filtre)
            ->where('statut','not like','%AU%');
        if($type=="SAV") {
            $beneficiaires_obj=Beneficiaire::whereIn('statut',['SAV','SAR','SAA']);
        }
        $beneficiaires=$beneficiaires_obj->orderBy('nom')->orderBy('prenom')->get();
        //$beneficiaires = Beneficiaire::where('id','=','1030')->get();
        $nb_bene=count($beneficiaires);

        DB::table("versem_b")->where('type','=',$type)->delete();

        foreach($beneficiaires as $beneficiaire) {
            $montant_c=0;
            $montant_r=0;
            $ret_type="";
            $ret_date="";
            $ret_num="";
            $verif_ok=true;
            $nb_enfant=0;

            if($type=="ALL") {
                $nb_enfant=$beneficiaire->NbEnfantsAlloc;
                if($nb_enfant==0) $verif_ok=false;
                $montant_all=Parametre::where('ref','=','CAL_MONTANT_ALLOC')->first()->value;
                $montant_c=$montant_all*$nb_enfant;
                $montant_r=$beneficiaire->rappel;
                $obs_vers=$beneficiaire->obs_vers;
            }
            if($type=="SOC") {
                $nb_enfant=$beneficiaire->NbEnfantsSoc;
                if($nb_enfant==0) $verif_ok=false;

                //Calcul sur tableau 2018 si présent dans parame^tres
                $montant_soc_2018=Parametre::where('ref','=','CAL_MONTANT_SOC_2018')->first()->value;
                if(isset($montant_soc_2018) && $montant_soc_2018!="") {
                    $t_montant_soc_2018=explode(";",$montant_soc_2018);
                    //Préparation dutableau de calcul
                    //Dans la BDD sous la forme 1;5000 2;6000 3;8000 4;10000 5;12000 6;15000 7;18000
                    $indemnite_nbenfant=0;
                    $indemnite_montant=0;
                    $t=array();
                    for($i=1;$i<=20;$i++) { //Nb enfant max 20
                        if(isset($t_montant_soc_2018[$i-1])&&($t_montant_soc_2018[$i-1]!="")) {
                            $t_indemnite=$t_montant_soc_2018[$i-1];
                            $indemnite=explode("=",$t_indemnite);
                            $indemnite_nbenfant=$indemnite[0];
                            $indemnite_montant=$indemnite[1];
                        }
                        $t[$i]=$indemnite_montant;
                    }
                    $t_montant_soc_2018=$t;
                    for($i=1;$i<=$nb_enfant;$i++) {
                        $indemnite_montant=$t_montant_soc_2018[$i];
                        $montant_c+=$indemnite_montant;
                    }
                }
                else {
                    $montant_soc=Parametre::where('ref','=','CAL_MONTANT_SOC')->first()->value;
                    $montant_c=$montant_soc*$nb_enfant;
                }
                $obs_vers=$beneficiaire->obs_vers;
                $montant_r=$beneficiaire->rappel;
            }

            if($type=="RET") {
                $nb_enfant=$beneficiaire->NbEnfants;
                $ret_num=$beneficiaire->ret_numdec;
                $montant_c=$beneficiaire->ret_montant;
                $montant_r=$beneficiaire->ret_rappel;
                $ret_type=$beneficiaire->ret_type;
                if(strlen($beneficiaire->ret_dateed)==10) {
                    $ret_date=substr($beneficiaire->ret_dateed,6,4)."-".substr($beneficiaire->ret_dateed,3,2)."-".substr($beneficiaire->ret_dateed,0,2);
                } else $ret_date="";
                $obs_vers=$beneficiaire->obs_vers;

            }

            if($type=="SAV") {
                $ret_num=$beneficiaire->ret_numdec;
                $ret_type=$beneficiaire->ret_type;
                //$montant_c=$beneficiaire->csr_montant;
                $montant_c=Parametre::where('ref','=','CAL_MONTANT_CSR')->first()->value;
                $montant_r=$beneficiaire->csr_rappel;
                $obs_vers=$beneficiaire->obs_vers;
            }

            //if(!$beneficiaire->BanqueId) $verif_ok=false;
            if($verif_ok) {

                $versement_b = new Versement_b;
                $versement_b->benum=$beneficiaire->id;
                $versement_b->montant=$montant_c+$montant_r;
                $versement_b->date=date("Y-m-d");
                $versement_b->bqcleunik=(isset($beneficiaire->BanqueId)&&($beneficiaire->BanqueId!=null))?$beneficiaire->BanqueId:0; //$beneficiaire->banque_id;

                //$versement_b->bqcleunik=$beneficiaire->BanqueId; //$beneficiaire->banque_id;
                //$versement_b->compte=$beneficiaire->compte;
                //Modifi IBAN : 24/10/2019
                $versement_b->compte = $beneficiaire->RIBcomplet;
                //
                $versement_b->mode_pmt="";
                $versement_b->type=$type;
                $versement_b->sonum=$beneficiaire->sonum;
                $versement_b->montant_c=$montant_c;
                $versement_b->montant_r=$montant_r;
                $versement_b->num_imp=0;
                $versement_b->ret_type=$ret_type;
                $versement_b->ret_date=(!$ret_date)?null:$ret_date;
                $versement_b->ret_num=$ret_num;
                $versement_b->obs_vers=$obs_vers;
                $versement_b->nb_enf = $nb_enfant;
                $versement_b->non_verse = "";

                $versement_b->save();
            }
        }

        return Redirect::to('/versements_encours/'.$type);
    }

}

