<?php namespace App\Http\Controllers;

use Auth\AuthController;
use Illuminate\Support\Facades\Auth;

use App\Models\Employeur;
use App\Models\Beneficiaire;
use App\Models\Beneftype;
use App\Models\Benefstatut;
use App\Models\Versement;
use App\Models\Versement_b;
use App\Models\Versement_hg;
use App\Models\Parametre;
use App\Models\User;
use App\Models\Role2;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Redirect;
use View;
use DB;

use App\Http\Requests\VersementRequest;
use App\Http\Requests\AutoResponsableRequest;
use Response;
use Illuminate\Http\Request;


class VersementsController extends Controller {
    private $menu='versements';
    private $submenu='export';
    private $menu_home="allocations";

    public function setMenu($type)
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );

        if($type=="ALL") {$this->menu_home="allocations";}
        if($type=="RET") {$this->menu_home="retraites";}
        if($type=="SOC") {$this->menu_home="aides_sociales";}
        if($type=="SAV") {$this->menu_home="aides_sociales";$this->menu="versements_csr";$this->submenu="versements_generation_csr";}
    }

    /**
     * Liste des versements
     */

    public function index($type,$num_imp="")
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        $this->setMenu($type);
        $this->submenu="export";
        if($type=="SAV") $this->submenu="export_csr";
        $liste_numimp=Versement::where('type','=',$type)->pluck('num_imp','num_imp')->toArray();
        if($num_imp=="") {
            $num_imp=Versement::where('type','=',$type)->max('num_imp');
        }
        $versements = Versement::where('type','=',$type)
            ->where('num_imp','=',$num_imp)
            ->orderBy('date','ASC')
            ->get();

        return View::make('prestations.versements.index_annee', [
            'user' => $user,'menu' => $this->menu,'submenu' => $this->submenu,'menu_home' => $this->menu_home,
            'type'=>$type,
            'versements' => $versements,
            'num_imp' => $num_imp,
            'liste_num_imp' => $liste_numimp,
        ]);
    }


     /**
     * Génération Définitive des versements
     */
    public function generation_definitive($type)
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        $this->setMenu($type);

        $this->submenu="versements_generation_definitive";
        if($type=="SAV") {$this->menu_home="aides_sociales";$this->menu="versements_csr";$this->submenu="versements_generation_definitive_csr";}

        $titre_versement="";
        if($type=="ALL") $titre_versement="Génération définitive du versement des allocations";
        else if($type=="RET") $titre_versement="Génération définitive du versement des retraites";
        else if($type=="SOC") $titre_versement="Génération définitive du versement des aides sociales";
        else if($type=="SAV") $titre_versement="Génération définitive du complément social de retraite";

        $num_imp=Versement_hg::whereIn('type',array('RET','SOC','ALL','SAV'))->max('num_imp');
        $num_imp+=1;

        //vérification compte OK
        $versements_b=Versement_b::where('type','=',$type)->get();
        $error_compte=0;
        foreach($versements_b as $versement_b) {
            if(!$versement_b->CompteOK) $error_compte++;
        }
        $nb_versements=$versements_b->count();
        $errors_before=array();
        if($error_compte>0)
            $errors_before[]="<b>Impossible de faire la génération</b> : ".$error_compte." compte".
                (($error_compte==1)?"":"s")." bancaire".(($error_compte==1)?"":"s")." est en anomalie !";

        //vérification si pas double versement dans le mois
        $date_A=date('Y-m');
        $t_moislib=array("01"=>"de Janvier","02"=>"de Février","03"=>"de Mars","04"=>"d'Avril",
            "05"=>"de Mai","06"=>"de Juin","07"=>"de Juillet","08"=>"d'Août",
            "09"=>"de Septembre","10"=>"d'Octobre","11"=>"de Novembre","12"=>"de Décembre");
        $codemois=date('m');
        $mois=$t_moislib[$codemois];

        $nb_existe=Versement_hg::where('type','=',$type)->where('date','like',$date_A."%")->count();

        if( (count($errors_before)>0) || ($nb_existe>0) )
            return View::make('prestations.versements.generation_error', [
                    'user' => $user,'menu' => $this->menu,'submenu' => $this->submenu,'menu_home' => $this->menu_home,
                    'type' => $type,
                    'titre_versement' => $titre_versement,
                    'errors_before'=>$errors_before,
                    'nb_versements'=>$nb_versements,
                    'nb_existe'=>$nb_existe,"mois"=>$mois
                ]);


        return View::make('prestations.versements.generation_definitive', [
            'user' => $user,'menu' => $this->menu,'submenu' => $this->submenu,'menu_home' => $this->menu_home,
            'type' => $type,
            'num_imp' => $num_imp,
            'titre_versement' => $titre_versement,
            'errors_before'=>$errors_before,
            'nb_versements'=>$nb_versements,
            'nb_existe'=>$nb_existe
        ]);
    }


     /**
     * Génération des versements
     */
    public function set_generation_definitive(Request $request,$type) {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        $this->setMenu($type);

        $this->submenu="versements_generation_definitive";
        $titre_versement="";
        if($type=="ALL") $titre_versement="Génération définitive du versement des allocations";
        else if($type=="RET") $titre_versement="Génération définitive du versement des retraites";
        else if($type=="SOC") $titre_versement="Génération définitive du versement des aides sociales";
        else if($type=="SAV") $titre_versement="Génération définitive du versement du complément social de retraite";

        $num_imp=$request->num_imp;
        $copy_versement=false;
        $copy_versement_hg=false;
        $errors=array();

        if( ($type=='RET')||($type=='ALL')||($type=='SOC')||($type=='SAV') ){
            $versements_b=Versement_b::where('type','=',$type)->get();
            $nb_versements_b=count($versements_b);

            if($nb_versements_b>0) {
                DB::table("versem")->where('type','=',$type)->where('num_imp','=',$num_imp)->delete();
                //Ajout dans Versement
                foreach($versements_b as $versement_b) {
                    $versement = new Versement;
                    $versement->benum = $versement_b->benum;
                    $versement->montant = $versement_b->montant;
                    $versement->date = date('Y-m-d');
                    $versement->bqcleunik = $versement_b->bqcleunik;
                    $versement->compte = $versement_b->compte;
                    $versement->mode_pmt = $versement_b->mode_pmt;
                    $versement->type = $versement_b->type;
                    $versement->sonum = $versement_b->sonum;
                    $versement->montant_c = $versement_b->montant_c;
                    $versement->montant_r = $versement_b->montant_r;
                    $versement->num_imp = $num_imp;
                    if($type=='RET') {
                        $versement->ret_type = $versement_b->ret_type;
                        $date=$versement_b->RetDateUS;
                        $versement->ret_date = ($date=="")?"0000-00-00":$date;
                        $versement->ret_num = $versement_b->ret_num;
                    }
                    if($type=="SAV") {
                        $versement->ret_type = $versement_b->ret_type;
                    }

                    $versement->obs_vers = $versement_b->obs_vers;
                    $versement->nb_enf = $versement_b->nb_enf;
                    $versement->non_verse = "";
                   $versement->save();
                }
                $nb_versement=Versement::where('num_imp','=',$num_imp)->count();
                if($nb_versement==$nb_versements_b) $copy_versement=true;

                DB::table("versem_hg")->where('type','=',$type)->where('num_imp','=',$num_imp)->delete();
                ///Ajout dans Historique
                 foreach($versements_b as $versement_b) {
                    $versement_hg = new Versement_hg;
                    $versement_hg->benum = $versement_b->benum;
                    $versement_hg->montant = $versement_b->montant;
                    $versement_hg->date = date('Y-m-d');
                    $versement_hg->bqcleunik = $versement_b->bqcleunik;
                    $versement_hg->compte = $versement_b->compte;
                    $versement_hg->mode_pmt = $versement_b->mode_pmt;
                    $versement_hg->type = $versement_b->type;
                    $versement_hg->sonum = $versement_b->sonum;
                    $versement_hg->montant_c = $versement_b->montant_c;
                    $versement_hg->montant_r = $versement_b->montant_r;
                    $versement_hg->num_imp = $num_imp;
                    if($type=='RET') {
                        $versement_hg->ret_type = $versement_b->ret_type;
                        $date=$versement_b->RetDateUS;
                        $versement_hg->ret_date = ($date=="")?"0000-00-00":$date;
                        $versement_hg->ret_num = $versement_b->ret_num;
                    }
                    if($type=="SAV") {
                        $versement_hg->ret_type = $versement_b->ret_type;
                    }
                    $versement_hg->obs_vers = $versement_b->obs_vers;
                    $versement_hg->nb_enf = $versement_b->nb_enf;
                    $versement_hg->non_verse = "";
                    $versement_hg->save();
                }
                $nb_versement_hg=Versement_hg::where('num_imp','=',$num_imp)->count();
                if($nb_versement_hg==$nb_versements_b) $copy_versement_hg=true;

                //Suppression du brouillard etd des observations // MODIF 09/2020
                if($copy_versement_hg && $copy_versement) {
                    //Suppression dans le bénéficiaire de l'observation
                    foreach($versements_b as $versement_b) {
                       $beneficiaire=Beneficiaire::find($versement_b->benum);
                       $beneficiaire->obs_vers="";
                       $beneficiaire->save();
                    }
                    //Suppression versement_brouillon
                    DB::table("versem_b")->where('type','=',$type)->delete();

                } else {
                    //Suppression des créations
                    DB::table("versem")->where('type','=',$type)->where('num_imp','=',$num_imp)->delete();
                    DB::table("versem_hg")->where('type','=',$type)->where('num_imp','=',$num_imp)->delete();
                }
               if(!$copy_versement) $errors[]="La copie dans l'historique annuel n'a pas été réalisée (".$nb_versement.'/'.$nb_versements_b.")";
            if(!$copy_versement_hg) $errors[]="La copie dans l'historique général n'a pas été réalisée (".$nb_versement_hg.'/'.$nb_versements_b.")";
            } else {
                $errors[]="Aucune information à transférer, le fichier brouillard de versement est vide";

            }
        }

        $errors=array();
        return View::make('prestations.versements.generation_definitive', [
            'user' => $user,'menu' => $this->menu,'submenu' => $this->submenu,'menu_home' => $this->menu_home,
            'type' => $type,
            'num_imp' => $num_imp,
            'num_def' => $num_imp,
            'nb_versements_b' => $nb_versements_b,
            'errors'  => $errors,
            'titre_versement' => $titre_versement
        ]);
    }


    /**
     * Liste des versements depuis la fiche Employeur
     */
    public function index_employeur($employeur_id="")
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        $this->setMenu($type);

        $liste_employeur=Employeur::distinct()->select('nom','id')->orderBy('nom')->pluck('nom','id')->toArray();
        $liste_employes="";
        $versements = array();
        if($employeur_id) {
            $employeur=Employeur::find($employeur_id);
            $versements = Versement::where('sonum','=',$employeur_id)->orderBy('date','ASC')->get();
        }
        return View::make('prestations.versements.index_employeur', [
            'user' => $user,'menu' => $this->menu,'submenu' => $this->submenu,'menu_home' => $this->menu_home,
            'employeur' => $employeur,
            'versements' => $versements,
        ]);
    }

    public function create($employeur_id="")
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        $this->setMenu($type);

        $liste_employeur = Employeur::orderBy('nom','ASC')->pluck('nom','id')->toArray();

        return View::make('prestations.versements.create',
            [
                'user' => $user,'menu' => $this->menu,'submenu' => $this->submenu,'menu_home' => $this->menu_home,
                'employeur_id' => $employeur_id,
                'liste_employeur' => $liste_employeur,
            ]);
    }

    public function store(VersementRequest $request)
    {
        $versement = new Versement;
        $versement->benum = $request->benum;
        $versement->montant = $request->montant;
        $date = $request->date;
        $versement->date = ($date!="")?date('Y-m-d', strtotime(str_replace('/', '-', $date))):"" ;
        $versement->bqcleunik = $request->bqcleunik;
        $versement->compte = $request->compte;
        $versement->mode_pmt = $request->mode_pmt;
        $versement->type = $request->type;
        $versement->sonum = $request->sonum;
        $versement->montant_c = $request->montant_c;
        $versement->montant_r = $request->montant_r;
        $versement->num_imp = $request->num_imp;
        $versement->ret_type = $request->ret_type;
        $date = $request->ret_date;
        $versement->ret_date = ($date!="")?date('Y-m-d', strtotime(str_replace('/', '-', $date))):"" ;
        $versement->ret_num = $request->ret_num;
        $versement->obs_vers = $request->obs_vers;
        $versement->nb_enf = $request->nb_enfant;
        $versement->non_verse = $request->non_verse;
        $versement->save();
        return Redirect::to('prestations.versements.index');
    }

    public function edit($id)
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        $this->setMenu($type);

        $versement=Versement::find($id);
        $liste_employeur = Employeur::orderBy('nom','ASC')->pluck('nom','id')->toArray();

        return View::make('prestations.versements.edit',
            [
                'user' => $user,'menu' => $this->menu,'submenu' => $this->submenu,'menu_home' => $this->menu_home,
                'liste_employeur' => $liste_employeur,
                'versement' => $versement
            ]);
    }

    public function show($id)
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        $this->setMenu($type);

        $versement = Versement::find($id);
        return View::make('prestations.versements.show', [
            'user' => $user,'menu' => $this->menu,'submenu' => $this->submenu,'menu_home' => $this->menu_home,
            'versement'=> $versement
        ]);
    }

    public function show_box($id)
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        $this->setMenu($type);

        $versement = Versement::find($id);

        return View::make('prestations.versements.show_box', [
            'user' => $user,'menu' => $this->menu,'submenu' => $this->submenu,'menu_home' => $this->menu_home,
            'versement'=> $versement
        ]);
    }



    public function update($id,VersementRequest $request)
    {
        $versement = Versement::find($id);
        $versement->benum = $request->benum;
        $versement->montant = $request->montant;
        $date = $request->date;
        $versement->date = ($date!="")?date('Y-m-d', strtotime(str_replace('/', '-', $date))):"" ;
        $versement->bqcleunik = $request->bqcleunik;
        $versement->compte = $request->compte;
        $versement->mode_pmt = $request->mode_pmt;
        $versement->type = $request->type;
        $versement->sonum = $request->sonum;
        $versement->montant_c = $request->montant_c;
        $versement->montant_r = $request->montant_r;
        $versement->num_imp = $request->num_imp;
        $versement->ret_type = $request->ret_type;
        $date = $request->ret_date;
        $versement->ret_date = ($date!="")?date('Y-m-d', strtotime(str_replace('/', '-', $date))):"" ;
        $versement->ret_num = $request->ret_num;
        $versement->obs_vers = $request->obs_vers;
        $versement->nb_enf = $request->nb_enfant;
        $versement->non_verse = $request->non_verse;
        $versement->save();
        return Redirect::to('prestations/versement_annee/'.$request->sonum);
    }


    public function destroy($id)
    {
        $employeur_id=Versement::find($id)->value('sonum');
        Versement::destroy($id);
        return Redirect::to('prestations/versement_annee/'.$employeur_id);
    }



}
