<?php namespace App\Http\Controllers;

use Illuminate\Support\Facades\Auth;
use Auth\AuthController;
use App\Models\Employeur;
use App\Models\Beneficiaire;
use App\Models\Enfant;
use App\Models\Beneftype;
use App\Models\Benefstatut;
use App\Models\Versement_b;
use App\Models\Parametre;
use App\Models\User;
use App\Models\Role2;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Redirect;
use View;
use DB;

use App\Http\Requests\VersementRequest;
use App\Http\Requests\AutoResponsableRequest;
use Response;
use Illuminate\Http\Request;
use App\Http\Controllers\Logs;

class VersementsRAZController extends Controller {
    private $menu='tiers';
    private $submenu='raz';
    private $menu_home="allocations";


    public function index($benef_type,$nbraz="")
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if($benef_type=="S") $this->menu_home="aides_sociales";
        if($benef_type=="R") $this->menu_home="retraites";

        $libelle_beneficiaire=" bénéficiaires ";
        $titre_versement="Remise à zéro des Rappels pour les ";

        $t_info=$user->getIconeTypeTab($benef_type);
        $titre_versement.= $t_info["titre"];
        $libelle_beneficiaire= $t_info["libelle"];
        $icone=$t_info["icone"];


        //Mode <>"" si message de fin d'opération
        $versements_b=array();
        $type="";
        if($nbraz=="") $versements_b=Versement_b::where('type','like',$benef_type."%")->get();
        return View::make('prestations.versements.raz', [
            'user' => $user,'menu' => $this->menu,'submenu' => $this->submenu,'menu_home' => $this->menu_home,
            'benef_type' => $benef_type,
            'titre_versement' => $titre_versement,
            'nbraz' => $nbraz,
            'versements_b' => $versements_b,
            'icone' => $icone,
            'libelle_beneficiaire' => $libelle_beneficiaire
        ]);
    }


    public function index_certificats_etrangers($type,$nb_modif="")
    {
        return $this->index_certificats($type,$nb_modif,true);
    }

    public function index_certificats($type,$nb_modif="",$etrangers=false)
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );

        if($type=="ALL") $benef_type="A";
        if($type=="RET") {$benef_type="R";$this->menu_home="retraites";}
        if($type=="SOC") {$benef_type="S";$this->menu_home="aides_sociales";}
        $this->menu="certificats";
        $this->submenu="maj_certificats";
        if($etrangers) {$this->submenu="maj_certificats_etrangers";}

        $libelle_beneficiaire=" bénéficiaires ";
        $titre_versement="Remise à zéro des Certificats pour les ";
        if($etrangers) $titre_versement="Remise à zéro des Certificats Etrangers pour les ";
        else $titre_versement="Remise à zéro des Certificats pour les ";

        $t_info=$user->getIconeTypeTab($benef_type);
        $titre_versement.= $t_info["titre"];
        $libelle_beneficiaire.= $t_info["libelle"];
        $icone=$t_info["icone"];

        $filtre=Beneftype::where('ref','=',$benef_type)->value('statuts');
        $t_filtre=explode(';',$filtre);
        
        return View::make('prestations.versements.maj_certificats', [
            'user' => $user,'menu' => $this->menu,'submenu' => $this->submenu,'menu_home' => $this->menu_home,
            'type'=>$type,
            'benef_type' => $benef_type,
            'titre_versement' => $titre_versement,
            'nb_modif' => $nb_modif,
            'icone' => $icone,
            'etrangers' => $etrangers,
            'libelle_beneficiaire' => $libelle_beneficiaire
        ]);
    }


   public function info_certificats($type,$etrangers=false)
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if($type=="ALL") $benef_type="A";
        if($type=="RET") {$benef_type="R";$this->menu_home="retraites";}
        if($type=="SOC") {$benef_type="S";$this->menu_home="aides_sociales";}

        if($etrangers) $this->submenu="maj_certificats_etrangers";
        else $this->submenu="maj_certificats";

        $libelle_beneficiaire=" bénéficiaires ";
        if($etrangers) $titre_versement="Certificats Etrangers à mettre à jour pour les bénéficiaires ";
        else $titre_versement="Certificats à mettre à jour pour les bénéficiaires ";

        $t_info=$user->getIconeTypeTab($benef_type);
        $titre_versement.= $t_info["titre"];
        $libelle_beneficiaire.= $t_info["libelle"];
        $icone=$t_info["icone"];

        //Recherche des enfants
        $filtre=Beneftype::where('ref','=',$benef_type)->value('statuts');
        $t_filtre=explode(';',$filtre);
        $beneficiaires = Beneficiaire::whereIn('statut', $t_filtre)
            ->get();

        $nb_change=0;$t_enfants=array();
        foreach($beneficiaires as $beneficiaire) {
            $enfants = Enfant::
                where('parents1','=',$beneficiaire->id)
                ->orwhere('parents2','=',$beneficiaire->id)
                ->get();
            foreach($enfants as $enfant) {
                //Si pas étrangers
                if(!$etrangers) {
                    foreach($enfants as $enfant) {
                        if( ($enfant->certif!=3)  ) {
                            $t_enfants[]=$enfant->id;
                            $nb_change++;
                        }
                    }
                } else {
                    foreach($enfants as $enfant) {
                        if( ($enfant->certif==3)  ) {
                            $t_enfants[]=$enfant->id;
                            $nb_change++;
                        }
                    }
                }
            }
        }

        $enfants = Enfant::whereIn("id",$t_enfants)
            ->orderby("nom")
            ->orderby("prenom")
            ->get();


        //Mode <>"" si message de fin d'opération
        return View::make('prestations.versements.info_certificats', [
            'user' => $user,'menu' => $this->menu,'submenu' => $this->submenu,'menu_home' => $this->menu_home,
            'type'=>$type,
            'benef_type' => $benef_type,
            'titre_versement' => $titre_versement,
            'enfants' => $enfants,
            'icone' => $icone,
            'etrangers' => $etrangers,
            'libelle_beneficiaire' => $libelle_beneficiaire
        ]);
    }

    public function raz_rappel($benef_type)
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );

        $filtre=Beneftype::where('ref','=',$benef_type)->value('statuts');
        $t_filtre=explode(';',$filtre);

        if($benef_type=="R") $beneficiaires = Beneficiaire::whereIn('statut', $t_filtre)->where('ret_rappel','<>',"0")->get();
        else $beneficiaires = Beneficiaire::whereIn('statut', $t_filtre)->where('rappel','<>',"0")->get();
        $nb=0;
        foreach($beneficiaires as $beneficiaire) {
            $ben=Beneficiaire::find($beneficiaire->id);

            if(($benef_type=="A")||($benef_type=="S")) {
                $old_ret_rappel=$ben->rappel;
                $ben->rappel = 0;
            }
            if($benef_type=="R") {
                $old_ret_rappel=$ben->ret_rappel;
                $ben->ret_rappel = 0;
            }

            $ben->save();
            //LOG de la transaction
            $log_txt="id=>".$ben->id.";ret_rappel_old=>".$old_ret_rappel.";ret_rappel=>0";
            $beneficiaire->log_transaction('','U',$log_txt);
            $nb++;
        }
        return Redirect::to('/raz_rappel/'.$benef_type."/".$nb);
    }

    public function maj_certificats_etrangers($type)
    {
        return $this->maj_certificats($type,true);
    }

    public function maj_certificats($type,$etrangers=false)
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if($type=="ALL") $benef_type="A";
        if($type=="RET") {$benef_type="R";$this->menu_home="retraites";}
        if($type=="SOC") {$benef_type="S";$this->menu_home="aides_sociales";}

        if($etrangers) $this->submenu="maj_certificats_etrangers";
        else $this->submenu="maj_certificats";

        //Recherche des enfants
        $filtre=Beneftype::where('ref','=',$benef_type)->value('statuts');
        $t_filtre=explode(';',$filtre);
        $beneficiaires = Beneficiaire::whereIn('statut', $t_filtre)->get();
        $nb_change=0;
        foreach($beneficiaires as $beneficiaire) {
            $enfants = Enfant::
                where('parents1','=',$beneficiaire->id)
                ->orwhere('parents2','=',$beneficiaire->id)
                ->get();

            //Si pas étrangers
            if(!$etrangers) {
                foreach($enfants as $enfant) {
                    if( ($enfant->certif!=3) && ($enfant->NewCertificat<>$enfant->certif) ) {
                        $old_certif=$enfant->certif;
                        $enfant->certif=$enfant->NewCertificat;
                        $enfant->save();
                        //LOG de la transaction
                        $log_txt="id=>".$enfant->id.";enfant_certif_old=>".$old_certif.";enfant_certif=>".$enfant->certif;
                        $enfant->log_transaction('','U',$log_txt);
                        $nb_change++;
                    }
                }
            } else {
                foreach($enfants as $enfant) {
                    if( ($enfant->certif==3) && ($enfant->NewCertificat<>$enfant->certif) ) {
                        $old_certif=$enfant->certif;
                        $enfant->certif=$enfant->NewCertificat;
                        $enfant->save();
                        //LOG de la transaction
                        $log_txt="id=>".$enfant->id.";enfant_certif_old=>".$old_certif.";enfant_certif=>".$enfant->certif;
                        $enfant->log_transaction('','U',$log_txt);
                        $nb_change++;
                    }
                }
            }
        }

        if(!$etrangers) $url='/maj_certificats/'.$type."/".$nb_change;
        else $url='/maj_certificats_etrangers/'.$type."/".$nb_change;

        return Redirect::to($url);
    }


}
