<?php namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class BeneficiaireRequest extends FormRequest {
    public function rules() {
        return [
            'sonum' => '',
            'n_all' => '',
            'nom' => 'required|max:80',
            'prenom' => 'required|max:80',
            'datenaiss' => 'required',
            'lieunaiss' => 'max:80',
            'civilite' => 'required',
            'adresse' => '',
            'district' => 'max:20',
            'ile' => 'max:1',
            'tel' => 'max:20',
            'fax' => 'max:20',
            'email' => 'max:255',
            'nb_enf' => '',
            'nb_enf_tot' => '',
            'obs' => '',
            //'compte' => 'max:23',
            'IBAN_pays' => '',
            'IBAN_cle' => '',
            'IBAN_banque' => '',
            'IBAN_guichet' => '',
            'IBAN_compte' => '',
            'IBAN_clerib' => '',
            'banque_id' => '',
            'mt_alloc' => '',
            'mt_calc' => '',
            'statut' => 'required|max:6',
            'verrou' => '',
            'ret_dateed' => '',
            'rappel' => '',
            'ret_numdec' => 'max:50',
            'ret_montant' => '',
            'ret_type' => 'max:3',
            'ret_rappel' => '',
            'csr_montant' => '',
            'csr_rappel' => '',
            'conjoint' => '',
            'date_pi' => '',
             'code_postal' => 'max:5',
             'obs_vers' => '',
             //'cle_nompre_dat' => '',
             //'nom_conj' => 'max:80',
             //'prenom_conj' => 'max:80',
             'type_liste' => '',
             'onglet_actif' => '',
        ];
    }

     public function attributes() {
        return [
            'nom' => 'Nom',
            'prenom' => 'Prénom',
            'datenaiss' => 'Date de naissance',
            'lieunaiss' => 'Lieu ed naissance',
            'adresse' => 'Adresse',
            'district' => 'District',
            'ile' => 'Ile',
            'tel' => 'Téléphone',
            'fax' => 'Fax',
            'email' => 'Email',
            'nb_enf' => 'Nombre d\'enfants',
            'nb_enf_tot' => 'Nombre total d\'enfants',
            'obs' => 'Observations',
            //'compte' => 'Compte',
            'IBAN_pays' => 'IBAN/pays',
            'IBAN_cle' => 'IBAN/cle',
            'IBAN_banque' => 'IBAN/banque',
            'IBAN_guichet' => 'IBAN/guichet',
            'IBAN_compte' => 'IBAN/compte',
            'IBAN_clerib' => 'IBAN/clerib',
            'banque_id' => 'Banque',
            'mt_allloc' => 'Montant de l`\'allocation',
            'mt_calc' => 'Montant Calculé',
            'statut' => 'Statut',
            'verrou' => 'Verrou',
            'ret_dateed' => 'Date de retraite',
            'rappel' => 'Rappel',
            'ret_numdec' => 'Numéro de décision de retraite',
            'ret_montant' => 'Montant retraite',
            'ret_type' => 'Type de retraite',
            'ret_rappel' => 'Montant du rappel de retraite',
            'conjoint' => 'Conjoint',
            'date_pi' => 'Date de première immatriculation',
            'civilite' => 'Civilité',
            'code_postal' => 'Code postal',
            'obs_vers' => 'Observations',
             //'cle_nompre_dat' => '',
             'nom_conj' => 'Nom_du conjoint',
             'prenom_conj' => 'Prénom_du conjoint',
        ];
    }



    public function authorize() {
        return true;
    }
}












