<?php namespace App\Http\Requests;
 
use Illuminate\Foundation\Http\FormRequest;
 
class CotisationRequest extends FormRequest {
    public function rules() {
        return [
            'id' => '',
            'sonum' => 'required',
            'type_cotis' => 'required',
            'date' => 'required',
            'assiette' => 'required|numeric',
            'clr' => 'required',
            'ccpf' => 'required',
            'debit' => '',
            'credit' => '',
            'compte' => '',
            'mois' => 'required',
            'nbmois' => 'required',
            'bdx' => '',
            'typepmt' => '',
            'encais_date' => '',
            'encais_compte' => '',
            'type_cotis' => '',
            'observation' => '',
            'exercice' => 'required|max:4',
            'nbsal' => 'required|numeric',
            'bdx_prive' => '',
            'box_clr' => '',
            'box_ccpf' => '',
        ];
    }
 

     public function attributes() {
        return [
            //'id' => '',
            'sonum' => 'Employeur',
            'type_cotis' => 'Type de cotisation',
            'date' => 'Date d\'entrée',
            'assiette' => 'Assiette',
            'clr' => 'CLR',
            'ccpf' => 'CCPF',
            'debit' => 'Débit',
            'credit' => 'Crédit',
            'compte' => 'Compte',
            'mois' => 'Mois',
            'nbmois' => 'Nombre de mois',
            'bdx' => 'Bordereau',
            'typepmt' => 'Type de paiement',
            'encais_date' => 'Date d\'encaissement',
            'encais_compte' => 'Compte',
            'type_cotis' => 'Type de cotisation',
            'observation' => 'Observations',
            'exercice' => 'Exercice',
            'nbsal' => 'Nombre de salariés',
            'bdx_prive' => '',
        ];
    }


    public function authorize() {
        return true;
    }
}










