<?php namespace App\Http\Requests;
 
use Illuminate\Foundation\Http\FormRequest;
 
class EcritureRequest extends FormRequest {
    public function rules() {
        return [
            'transaction' => '',
            'date_doc' => '',
            'ref_doc' => 'max:100',
            'compte' => 'required|max:8',
            'compte_label' => '',
            'compte_aux' => 'max:10',
            'compte_aux_label' => '',
            'designation' => '',
            'debit' => '',
            'credit' => '',
            'montant' => '',
            'sens' => '',
            'lettrage_code' => '',
            'date_lettrage' => '',
            'user_id_create' => '',
            'user_id_modif' => '',
            'journal' => '',
            'journal_label' => '',
            'verrou' => '',
            'date_verrou' => '',
        ];
    }
 

     public function attributes() {
        return [
            'transaction' => 'Numéro de transaction',
            'date_doc' => 'Date du document',
            'ref_doc' => 'Référence',
            'compte' => 'Compte',
            'compte_label' => 'Label du compte',
            'compte_aux' => 'Compte auxiliaire',
            'compte_aux_label' => 'Label du compte auxiliaire',
            'designation' => 'Désignation',
            'debit' => 'Débit',
            'credit' => 'Crédit',
            'montant' => 'Montant',
            'sens' => 'Sens',
            'lettrage_code' => 'Code Lettrage',
            'date_lettrage' => 'Date Lettrage',
            'user_id_create' => 'user_id_create',
            'user_id_modif' => 'user_id_modif',
            'journal' => 'journal',
            'journal_label' => 'label du journal',
            'verrou' => 'verrou',
            'date_verrou' => 'Date du verrou',
        ];
    }


    public function authorize() {
        return true;
    }
}