<?php namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class EmployeurRequest extends FormRequest {
    public function rules() {
        return [
            'sec_id' => 'required',
            'nom' => 'required|max:100',
            'adresse' => '',
            'ile' => 'required|max:1',
            'tel' => 'max:20',
            'fax' => 'max:20',
            'email' => 'max:255',
            'responsable' => 'required|max:100',
            'nbsal' => '',
            'statut' => 'required|max:3',
            'date_deb' => '',
            'date_fin' => '',
            'numrc' => '',
            'verrou' => '',
            'compte' => 'max:23',
            'iban' => 'max:27',
            'banque_id' => '',
            'mode_cotis' => 'required',
            'der_cotis' => '',
            'der_mois' => '',
            'soldei' => '',
            'nom_cont' => '',
            'date_cont' => '',
            'district' => '',
            'cp' => '',
            'date_med' => '',
            'date_maj' => '',
            'observation' => '',
            'contact_tel' => 'max:20',
            'contact_email' => 'max:100',
            'contact_nom' => 'max:100',
            //'date_contr' => '',
        ];
    }

      public function attributes() {
        return [
            'sec_id' => 'SECTEUR',
            'nom' => 'NOM',
            'adresse' => 'ADRESSE',
            'ile' => 'ILE',
            'tel' => 'TELEPHONE RESPONSABLE',
            'fax' => 'FAX',
            'email' => 'EMAIL RESPONSABLE',
            'responsable' => 'NOM RESPONSABLE',
            'nbsal' => 'NOMBRE DE SALARIES',
            'statut' => 'STATUT',
            'date_deb' => 'DATE DEBUT',
            'date_fin' => 'DATE FIN',
            'numrc' => 'NUMERO RC',
            'verrou' => 'VERROU',
            'compte' => 'COMPTE',
            'iban' => 'IBAN',
            'banque_id' => 'BANQUE',
            'mode_cotis' => 'MODE DE COTISATION',
            'der_cotis' => 'DERNIERE COTISATION',
            'der_mois' => 'DERNIER MOIS',
            'soldei' => 'SOLDE',
            'nom_cont' => 'NOM CONTROLE',
            'date_cont' => 'DATE CONTROLE',
            'district' => 'DISTRICT',
            'cp' => 'CODE POSTAL',
            'date_med' => 'DATE MED',
            'date_maj' => 'DATE MAJ',
            'observation' => 'OBSERVATION',
            'contact_tel' => 'TELEPHONE CONTACT2',
            'contact_email' => 'EMAIL CONTACT2',
            'contact_nom' => 'NOM CONTACT2',
            //'date_contr' => '',
        ];
    }

    public function authorize() {
        return true;
    }
}












