<?php namespace App\Http\Requests;
 
use Illuminate\Foundation\Http\FormRequest;
 
class PlanRequest extends FormRequest {
    public function rules() {
        return [
            'numcpt' => 'required|max:6|min:6',
            'nomcpt' => 'required|max:255',
            'categ' => 'required|max:1',
            'poste' => 'max:1',
            'debit' => '',
            'credit' => '',
            'soldei' => '',
            'debit_credit' => '',
            'amortissement' => '',
            'amort' => '',
            'n_classe' => 'max:2',
        ];
    }


     public function attributes() {
        return [
            'numcpt' => 'Numéro de compte',
            'nomcpt' => 'Nom du compte',
            'categ' => 'Catégorie',
            'poste' => 'poste',
            'debit' => 'Débit',
            'credit' => 'Crédit',
            'soldei' => 'Solde',
            'debit_credit' => 'Débit Crédit',
            'amortissement' => 'Amortissement',
            'amort' => 'Compte amortissement',
            'n_classe' => 'Classe', 
        ];
    }


    public function authorize() {
        return true;
    }
}












