<?php namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use DB;
use Zizaco\Entrust\Traits\EntrustUserTrait;

class Controle_benef extends Model {
	
	/**
	 * The database table used by the model.
	 *
	 * @var string
	 */
	protected $table = 'controle_benef';


    /* Dates */
    public function getDates()
    {
            return array('date_naiss','date_embauche','date_debauche');
    }


     public function getDateNaissAttribute($value)
    {
        return ($this->attributes['date_naiss']!="0000-00-00")?date('d/m/Y', strtotime($this->attributes['date_naiss'])):"";
    }

     public function getDateEmbaucheAttribute($value)
    {
        return ($this->attributes['date_embauche']!="0000-00-00")?date('d/m/Y', strtotime($this->attributes['date_embauche'])):"";
    }

     public function getDateDebaucheAttribute($value)
    {
        return ($this->attributes['date_debauche']!="0000-00-00")?date('d/m/Y', strtotime($this->attributes['date_debauche'])):"";
    }

     public function getNomBeneficiaireAttribute($value)
    {
        $beneficiaire=Beneficiaire::find($this->benum);

        return $beneficiaire->nom_complet;
    }


}
