<?php namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use DB;
use Zizaco\Entrust\Traits\EntrustUserTrait;
use App\Http\Controllers\Logs;

class Cotisation extends Model {
    
    /**
     * DATE 
     */
    protected $table = 'cotis';


    /* Dates */
    public function getDates()
    {
            return array('date','mois','encais_date','date_depot');
    }


     public function getDateAttribute()
    {
        return (($this->attributes['date']!="0000-00-00")&&($this->attributes['date']!=null))?date('d/m/Y', strtotime($this->attributes['date'])):"";
    }

    public function getDateUSAttribute()
    {
        return (($this->attributes['date']!="0000-00-00")&&($this->attributes['date']!=null))?date('Y-m-d', strtotime($this->attributes['date'])):"";
    }
    
     public function getMoisAttribute()
    {
        return (($this->attributes['mois']!="0000-00-00")&&($this->attributes['mois']!=null))?date('d/m/Y', strtotime($this->attributes['mois'])):"";
    }

     public function getMoisUSAttribute()
    {
        return $this->attributes['mois'];
    }

     public function getEncaisDateAttribute()
    {
        return (($this->attributes['encais_date']!="0000-00-00")&&($this->attributes['encais_date']!=null))?date('d/m/Y', strtotime($this->attributes['encais_date'])):"";
    }

     public function getEncaisDateUSAttribute()
    {
        return (($this->attributes['encais_date']!="0000-00-00")&&($this->attributes['encais_date']!=null))?date('Y-m-d', strtotime($this->attributes['encais_date'])):"";
    }

     public function getDateDepotAttribute()
    {
        return (($this->attributes['date_depot']!="0000-00-00")&&($this->attributes['date_depot']!=null))?date('d/m/Y', strtotime($this->attributes['date_depot'])):"";
    }


     public function getMoisLettreAttribute()
    {
        $mois_lettre="";
        $t_mois=[1=>"Jan",2=>"Fev",3=>"Mar",4=>"Avr",5=>"Mai",6=>"Jun",7=>"Jui",8=>"Aou",9=>"Sep",10=>"Oct",11=>"Nov",12=>"Dec"];
        $mois=(strlen($this->mois)>5)?substr($this->mois,3,2):"0";

        if(intVal($mois)>0) $mois_lettre=$t_mois[intVal($mois)];
        return $mois_lettre;
    }

    public function getAnneeRatachementAttribute()
    {
        $annee=substr($this->attributes['mois'],0,4);

        return $annee;
    }


    /**
     * COMPTA 
     */
    public function getLibellCompteEncAttribute()
    {
        $compte=$this->encais_compte;
        $plan=PlanComptable::where('compte','=',$compte)->first();
        if(!$plan) return "";
        return $plan->libelle;

    }

    /**
     * EMPLOYEURS 
     */
     public function getNomEmployeurAttribute()
    {
        $employeur=Employeur::find($this->sonum);

        return $employeur->nom;
    }

     public function getCompteAuxEmployeurAttribute()
    {
        $employeur=Employeur::find($this->sonum);
        if(!$employeur) return "";
        return $employeur->compte_aux;
    }

    public function getEmployeurAttribute()
    {
        $nom_employeur="";
        if($this->sonum<>0) $nom_employeur=DB::table('employeurs')->where('id', '=', $this->sonum)->value('nom');
        return $nom_employeur;
    }



    /**
     * TAUX 
     */
    public function getPrcCCPFAttribute()
    {
        if($this->exercice=="") return "";
        $prc="";
        $taux_ccpf=Parametre::where('ref','=','TAUX_CLR_CCPF')->first()->TauxCCPF;
        if( isset($taux_ccpf[$this->exercice]) ) {
            $prc=$taux_ccpf[$this->exercice]."%";
        }
        
        return $prc;
    }

     public function getPrcCLRAttribute()
    {
        if($this->exercice=="") return "";
        $prc="";
        $taux_clr=Parametre::where('ref','=','TAUX_CLR_CCPF')->first()->TauxCLR;
        if( isset($taux_clr[$this->exercice]) ) {
            $prc=$taux_clr[$this->exercice]."%";
        }

        return $prc;
    }

    public function getPrcTotAttribute()
    {
        if($this->exercice=="") return "";
        $prc="";
        $taux_clr=Parametre::where('ref','=','TAUX_CLR_CCPF')->first()->TauxCLR;
        $taux_ccpf=Parametre::where('ref','=','TAUX_CLR_CCPF')->first()->TauxCCPF;
        if( isset($taux_clr[$this->exercice]) && isset($taux_ccpf[$this->exercice]) ) {
            $prc=$taux_clr[$this->exercice]+$taux_ccpf[$this->exercice]."%";
        }
        return $prc;
    } 

    /**
     * Reglement 
     */
    public function getisReglementAttribute()
    {
        $reglement=false;
        if(($this->lettrage!='')&&($this->credit!=0)) $reglement=true;
        return $reglement;
    } 

    public function getReglementsAttribute()
    {
        
        $lettrage=$this->lettrage;
        $fields = explode(',', $lettrage);
        $cotisations=Cotisation::wherein('id',$fields)->orderby('date','DESC')->get();
        return $cotisations;
    } 


    /**
     * COMPTABILITE
     */
    public function getEcritureCompta()
    {
        $ecriture="";
        if($this->transaction<>0) $ecriture=GrandLivre::where('transaction', '=', $this->transaction)->where('compte_aux', '=', $this->CompteAuxEmployeur)->first();
        if(!$ecriture) return "";
        return $ecriture;
    }

    public function getEcritureComptaInfoAttribute()
    {
       $ecriture=$this->getEcritureCompta();
        if(!$ecriture) return "";
        return $ecriture->DateDoc." ".$ecriture->ref_doc;
    }

    public function getIdEcritureAttribute()
    {
       $ecriture=$this->getEcritureCompta();
       if(!$ecriture) return "";
       return $ecriture->id;
    }



    /**
     * LETTRAGE 
     */
    public function getTotalCotisationsAttribute()
    {
        $lettrage=$this->lettrage;
        $fields = explode(',', $lettrage);
        $total=Cotisation::wherein('id',$fields)->sum('debit');
        return $total;
    } 
    public function getListeCotisationsAttribute()
    {
        $liste="";
        $lettrage=$this->lettrage;
        $fields = explode(',', $lettrage);
        $cotisations=Cotisation::wherein('id',$fields)->select('id')->get();
        if($cotisations) foreach($cotisations as $cotisation) $liste.=(($liste=="")?"":",").$cotisation->id;
        return $liste;
    } 

    public function getTotalReglementsAttribute()
    {

        $total=Cotisation::where('lettrage','=',$this->lettrage)->sum('credit');
        return $total;
    } 

    public function getListeReglementsAttribute()
    {
        $liste="";
        $cotisations=Cotisation::where('lettrage','=',$this->lettrage)->select('id')->get();
        foreach($cotisations as $cotisation) $liste.=(($liste=="")?"":",").$cotisation->id;
        return $liste;
    } 


    /**
     * Modes de règelement 
     */
    public function getModeReglementLibelleAttribute()
    {
        $t_modes=[ 'A'=>'Autre'
            ,'B' => 'Banque'
            ,'E' => 'Espèce'
            ,'T' => 'Trésor'
            ,'V' => 'Virement'
            ,'€' => 'Euro'
            ,'N' => 'Nul'];
        $mode=isset($t_modes[$this->typepmt])?$t_modes[$this->typepmt]:"";
        return $mode;
    } 

    public function getTypesPaiement()
    {
        $t_modes=[ ''=>'','A'=>'Autre'
            ,'B' => 'Banque'
            ,'E' => 'Espèce'
            ,'T' => 'Trésor'
            ,'V' => 'Virement'
            ,'€' => 'Euro'
            ,'N' => 'Nul'
            ,'P' => 'Prélèvement automatique'];
        return $t_modes;
    } 


    /**
     * VErroou
     */
    public function getVerrouDebitAttribute()
    {
       
        if( ($this->statut=="DEB") || ($this->statut=="ALL") ) return true;
        return false;
    }

    public function getVerrouCreditAttribute()
    {
        if( ($this->statut=="CRE") || ($this->statut=="ALL") ) return true;
        return false;
    }


    public function getVerrouAttribute()
    {
        return ($this->VerrouDebit && $this->VerrouCredit );
    }





    //LOG
     public function log_transaction($url,$operation) {
        $log=new Logs;
        $values="";
        $t_values=$this->getAttributes();
        foreach($t_values as $nom=>$value) $values.=(($values=="")?"":";").$nom."=>".$value; 
        $log->addlog(['url'=>$url,'table'=>$this->table ,'operation'=>$operation,'values'=>$values]);
    }
}
